---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：47-product-build-linux-cli.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **クロスコンパイルsysroot設定**：アーキテクチャ別の設定確認
  2. **OpenSSLパスマッピング**：arm-linux vs armhfの対応確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/linux/product-build-linux-cli.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-03: `build/azure-pipelines/cli/cli-compile.yml`
- E-04: `build/azure-pipelines/cli/install-rust-posix.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Linux CLI x64/arm64/armhf向けビルド | E-01 L11-12 | ○ |
| C-02 | タイムアウト60分 | E-01 L13 | ○ |
| C-03 | プール: 1es-ubuntu-22.04-x64 | E-01 L14-16 | ○ |
| C-04 | VSCODE_CHECK_ONLYデフォルトfalse | E-01 L4-6 | ○ |
| C-05 | CLIアーティファクト出力（tar.gz） | E-01 L20-28 | ○ |
| C-06 | SBOM生成設定 | E-01 L26-28 | ○ |
| C-07 | CLIパッチ適用テンプレート | E-01 L37 | ○ |
| C-08 | OpenSSLダウンロード（@0.0.11） | E-01 L39-46 | ○ |
| C-09 | OpenSSL展開処理 | E-01 L48-52 | ○ |
| C-10 | NPMレジストリセットアップ | E-01 L54-56 | ○ |
| C-11 | NPM認証設定 | E-01 L57-72 | ○ |
| C-12 | npm ciリトライ5回 | E-01 L74-88 | ○ |
| C-13 | Rustインストールテンプレート | E-01 L95-103 | ○ |
| C-14 | x64ターゲット（x86_64-unknown-linux-gnu） | E-01 L98-99 | ○ |
| C-15 | arm64ターゲット（aarch64-unknown-linux-gnu） | E-01 L100-101 | ○ |
| C-16 | armhfターゲット（armv7-unknown-linux-gnueabihf） | E-01 L102-103 | ○ |
| C-17 | x64 OpenSSLパス | E-01 L113-114 | ○ |
| C-18 | arm64 OpenSSLパス | E-01 L125-126 | ○ |
| C-19 | armhf OpenSSLパス（arm-linux） | E-01 L137-138 | ○ |
| C-20 | SYSROOT_ARCH設定 | E-01 L115, L127, L139 | ○ |
| C-21 | arm-linux vs armhfの命名対応 | **推定** | △ |
| C-22 | 目標処理時間60分以内 | **推定値** | △ |

## 4) 不足情報（Unknown / Missing）
- OpenSSLディレクトリ名（arm-linux）とアーキテクチャ名（armhf）の対応関係
  - 候補：openssl-prebuiltパッケージの構成 / ビルドスクリプト
- タイムアウト60分の根拠（他のCLIビルドは30分）
  - 候補：クロスコンパイル時間の計測結果 / パフォーマンス要件

## 5) リスクフラグ（レビュー観点）
- 0: クロスコンパイル依存 - sysroot設定がアーキテクチャごとに異なる
- 0: npm ciリトライ - ネットワーク不安定時の自動リトライ

## 6) レビュアーチェックリスト（最小）
- [ ] OpenSSL @0.0.11のarm-linuxディレクトリがarmhfに対応しているか確認
- [ ] SYSROOT_ARCH設定が正しいか確認（amd64/arm64/armhf）
- [ ] Rustクロスコンパイルターゲットが最新か確認
- [ ] npm ciのbuildディレクトリ依存関係が十分か確認
