---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：48-product-build-darwin-cli.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **MSRUSTUP_LOGデバッグ設定**：本番環境での影響確認
  2. **AcesSharedプール**：エージェント可用性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/darwin/product-build-darwin-cli.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-03: `build/azure-pipelines/cli/cli-compile.yml`
- E-04: `build/azure-pipelines/cli/install-rust-posix.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macOS CLI x64/arm64向けビルド | E-01 L11-12 | ○ |
| C-02 | タイムアウト60分 | E-01 L13 | ○ |
| C-03 | プール: AcesShared (macOS) | E-01 L14-16 | ○ |
| C-04 | MSRUSTUP_LOG: debug | E-01 L18-19 | ○ |
| C-05 | VSCODE_CHECK_ONLYデフォルトfalse | E-01 L4-6 | ○ |
| C-06 | 未署名CLIアーティファクト出力（zip） | E-01 L21-29 | ○ |
| C-07 | SBOMは無効 | E-01 L28-29 | ○ |
| C-08 | CLIパッチ適用テンプレート | E-01 L38 | ○ |
| C-09 | OpenSSLダウンロード（@0.0.11） | E-01 L40-47 | ○ |
| C-10 | OpenSSL展開処理 | E-01 L49-53 | ○ |
| C-11 | Rustインストールテンプレート | E-01 L55-61 | ○ |
| C-12 | x64ターゲット（x86_64-apple-darwin） | E-01 L58-59 | ○ |
| C-13 | arm64ターゲット（aarch64-apple-darwin） | E-01 L60-61 | ○ |
| C-14 | x64 OpenSSLパス（x64-osx） | E-01 L71-72 | ○ |
| C-15 | arm64 OpenSSLパス（arm64-osx） | E-01 L81-82 | ○ |
| C-16 | cli-compileテンプレート呼び出し | E-01 L63-83 | ○ |
| C-17 | MSRUSTUP_LOGの目的（ビルドフレーク診断） | **コメントから推定** | △ |
| C-18 | 目標処理時間60分以内 | **推定値** | △ |

## 4) 不足情報（Unknown / Missing）
- MSRUSTUP_LOG=debugのパフォーマンス/ストレージへの影響
  - 候補：ログ出力量計測 / ストレージ使用量分析
- AcesSharedプールのエージェント詳細仕様
  - 候補：Azure DevOpsエージェントプール設定 / macOSバージョン情報

## 5) リスクフラグ（レビュー観点）
- 0: デバッグログ有効 - ログサイズが大きくなる可能性
- 0: エージェントプール依存 - AcesSharedの可用性

## 6) レビュアーチェックリスト（最小）
- [ ] AcesSharedプールのmacOSバージョンが要件を満たすか確認
- [ ] MSRUSTUP_LOG=debugが本番ビルドに影響しないか確認
- [ ] OpenSSL @0.0.11のarm64-osx/x64-osxディレクトリが正しいか確認
- [ ] 署名がproduct-build-darwinで行われることを確認
