---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：49-product-build-alpine-cli.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **musl-g++シンボリックリンク**：既存リンク時の挙動確認
  2. **IS_MUSL環境変数**：arm64専用設定の理由確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/alpine/product-build-alpine-cli.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-03: `build/azure-pipelines/cli/cli-compile.yml`
- E-04: `build/azure-pipelines/cli/install-rust-posix.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Alpine CLI x64/arm64向けビルド | E-01 L11-12 | ○ |
| C-02 | タイムアウト60分 | E-01 L13 | ○ |
| C-03 | プール: 1es-ubuntu-22.04-x64 | E-01 L14-16 | ○ |
| C-04 | VSCODE_CHECK_ONLYデフォルトfalse | E-01 L4-6 | ○ |
| C-05 | CLIアーティファクト出力（tar.gz） | E-01 L20-28 | ○ |
| C-06 | SBOM生成設定 | E-01 L26-28 | ○ |
| C-07 | CLIパッチ適用テンプレート | E-01 L37 | ○ |
| C-08 | npm ci実行（build/） | E-01 L39-45 | ○ |
| C-09 | OpenSSLダウンロード（@0.0.11） | E-01 L47-54 | ○ |
| C-10 | OpenSSL展開処理 | E-01 L56-60 | ○ |
| C-11 | muslビルド依存関係インストール | E-01 L63-67 | ○ |
| C-12 | musl-g++シンボリックリンク作成 | E-01 L67 | ○ |
| C-13 | Rustインストールテンプレート | E-01 L70-76 | ○ |
| C-14 | x64ターゲット（x86_64-unknown-linux-musl） | E-01 L73-74 | ○ |
| C-15 | arm64ターゲット（aarch64-unknown-linux-musl） | E-01 L75-76 | ○ |
| C-16 | x64 OpenSSLパス（x64-linux-musl） | E-01 L87-88 | ○ |
| C-17 | arm64 OpenSSLパス（arm64-linux-musl） | E-01 L98-99 | ○ |
| C-18 | OPENSSL_STATIC=1設定 | E-01 L89, L100 | ○ |
| C-19 | arm64 IS_MUSL設定 | E-01 L102 | ○ |
| C-20 | arm64 SYSROOT_ARCH設定 | E-01 L101 | ○ |
| C-21 | IS_MUSLがarm64のみの理由 | **根拠なし** | △ |
| C-22 | 目標処理時間60分以内 | **推定値** | △ |

## 4) 不足情報（Unknown / Missing）
- IS_MUSL=1がarm64にのみ設定されている理由
  - 候補：クロスコンパイル設定 / cli-compile.ymlの条件分岐
- musl-g++シンボリックリンクが既に存在する場合の挙動
  - 候補：「link exists」エラー無視の妥当性確認

## 5) リスクフラグ（レビュー観点）
- 0: シンボリックリンク作成 - 冪等性のためエラー無視
- 0: OPENSSL_STATIC - 静的リンクによるバイナリサイズ増加

## 6) レビュアーチェックリスト（最小）
- [ ] OpenSSL @0.0.11のx64-linux-musl/arm64-linux-muslディレクトリが存在するか確認
- [ ] musl-tools、musl-devのバージョンがRustビルドと互換性があるか確認
- [ ] IS_MUSL、SYSROOT_ARCHがcli-compile.ymlで正しく処理されるか確認
- [ ] musl-g++シンボリックリンク作成のエラー無視が安全か確認
