---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：50-sdl-scan-win32.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **TSA設定ファイル**：tsaoptions.jsonの内容確認
  2. **APIScan認証情報**：サービスプリンシパル設定確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/win32/sdl-scan-win32.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-03: `build/azure-pipelines/config/tsaoptions.json`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SDLセキュリティスキャンパイプライン | E-01 L1-6 | ○ |
| C-02 | VSCODE_ARCHパラメータ | E-01 L2-3 | ○ |
| C-03 | VSCODE_QUALITYパラメータ | E-01 L4-5 | ○ |
| C-04 | Azure Key Vaultシークレット取得 | E-01 L22-27 | ○ |
| C-05 | NPMレジストリセットアップ | E-01 L29-31 | ○ |
| C-06 | include.gypi作成 | E-01 L51-79 | ○ |
| C-07 | /Zi, /FSコンパイラオプション | E-01 L59-62 | ○ |
| C-08 | /profileリンカーオプション | E-01 L65-67 | ○ |
| C-09 | npm ciリトライ5回 | E-01 L92 | ○ |
| C-10 | ディストリビューションミックスイン | E-01 L95-101 | ○ |
| C-11 | TypeScriptコンパイル | E-01 L103-104 | ○ |
| C-12 | vscode-symbols-win32ダウンロード | E-01 L106-109 | ○ |
| C-13 | シンボルファイル一覧表示 | E-01 L111-116 | ○ |
| C-14 | シンボル公開（PublishSymbols） | E-01 L118-127 | ○ |
| C-15 | シンボルサーバー設定（TeamServices） | E-01 L125 | ○ |
| C-16 | API Scan用シンボル収集 | E-01 L129-135 | ○ |
| C-17 | APIScan実行 | E-01 L137-150 | ○ |
| C-18 | APIScan softwareFolder設定 | E-01 L139 | ○ |
| C-19 | APIScan symbolsFolder設定 | E-01 L142 | ○ |
| C-20 | セキュリティ分析ログ公開 | E-01 L152-157 | ○ |
| C-21 | TSAアップロード | E-01 L159-166 | ○ |
| C-22 | TSA continueOnError設定 | E-01 L161 | ○ |
| C-23 | tsaoptions.jsonパス | **外部ファイル参照** | △ |
| C-24 | APIScan認証情報の安全性 | **推定** | △ |

## 4) 不足情報（Unknown / Missing）
- tsaoptions.jsonファイルの詳細内容
  - 候補：build/azure-pipelines/config/tsaoptions.json
- APIScan AzureServicesAuthConnectionStringの管理方法
  - 候補：Azure DevOps変数グループ / Key Vault

## 5) リスクフラグ（レビュー観点）
- 1: 認証情報ハードコード - AzureServicesAuthConnectionStringにAppId等が含まれる
- 0: TSA失敗許容 - continueOnError: trueで失敗してもパイプラインは継続

## 6) レビュアーチェックリスト（最小）
- [ ] APIScanのAzureServicesAuthConnectionStringが適切に管理されているか確認
- [ ] symweb.azurefd.netへのアクセス権が正しく設定されているか確認
- [ ] tsaoptions.jsonの設定がセキュリティ要件を満たすか確認
- [ ] シンボル公開先（TeamServices）が正しく設定されているか確認
