---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-distro-build

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build/azure-pipelines/distro-build.yml` (L1-16)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L7)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 1es-ubuntu-22.04-x64プールで実行 | E-01 L1-3 (pool) | ○ |
| C-02 | Linuxエージェントで実行 | E-01 L3 (os: linux) | ○ |
| C-03 | main/release/*ブランチがトリガー | E-01 L5-7 (trigger) | ○ |
| C-04 | pr: noneでPRトリガー無効 | E-01 L8 (pr: none) | ○ |
| C-05 | Node.jsを.nvmrcからセットアップ | E-01 L11-13 (NodeTool@0) | ○ |
| C-06 | versionFilePath: .nvmrc設定 | E-01 L13 (versionFilePath) | ○ |
| C-07 | download-distro.ymlテンプレート使用 | E-01 L14 (template) | ○ |
| C-08 | stepsは2つのみ | E-01 L10-14 (steps) | ○ |
| C-09 | distro/download-distro.yml@selfを参照 | E-01 L14 (template path) | ○ |
| C-10 | versionSourceはfromFile | E-01 L12 (versionSource) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主要な主張について根拠を確認できました
- download-distro.ymlの詳細な内部処理は別ファイルを参照する必要があります

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての技術仕様がdistro-build.ymlから直接確認可能
- 注意: download-distro.ymlテンプレートの内部処理は本レポートの範囲外

## 6) レビュアーチェックリスト（最小）
- [ ] download-distro.ymlテンプレートの内容が最新か確認
- [ ] microsoft/vscode-distroリポジトリへのアクセス権限が適切に設定されているか確認
