---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-pr.yml

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり - 重点レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/pr.yml` (L1-153)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L8)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ワークフロー名は"Code OSS" | E-01 L1 (name: Code OSS) | ○ |
| C-02 | main/release/*へのPRでトリガー | E-01 L3-7 (on: pull_request) | ○ |
| C-03 | concurrencyでgroup設定 | E-01 L9-11 (concurrency) | ○ |
| C-04 | cancel-in-progress: true | E-01 L11 (cancel-in-progress) | ○ |
| C-05 | permissions: {}で最小権限 | E-01 L13 (permissions: {}) | ○ |
| C-06 | VSCODE_QUALITY: 'oss' | E-01 L16 (env) | ○ |
| C-07 | compileジョブがCompile & Hygiene | E-01 L19-20 (jobs: compile) | ○ |
| C-08 | self-hostedランナー使用 | E-01 L21 (runs-on) | ○ |
| C-09 | 1es-vscode-oss-ubuntu-22.04-x64プール | E-01 L21 (Pool名) | ○ |
| C-10 | npm ciを5回リトライ | E-01 L51-61 (for i in {1..5}) | ○ |
| C-11 | ELECTRON_SKIP_BINARY_DOWNLOAD=1 | E-01 L63-64 (env) | ○ |
| C-12 | npm-run-all2でcore-ci等並列実行 | E-01 L79-80 (npm exec) | ○ |
| C-13 | linux-cli-testsジョブ存在 | E-01 L84-88 (linux-cli-tests) | ○ |
| C-14 | rustup_toolchain: 1.85指定 | E-01 L89 (rustup_toolchain) | ○ |
| C-15 | linux-electron-testsがpr-linux-test.yml呼び出し | E-01 L91-96 (uses: pr-linux-test.yml) | ○ |
| C-16 | electron_tests, browser_tests, remote_testsパラメータ | E-01 L94-110 (with: パラメータ) | ○ |
| C-17 | macOSテストがpr-darwin-test.yml呼び出し | E-01 L112-131 (uses: pr-darwin-test.yml) | ○ |
| C-18 | WindowsテストがPr-win32-test.yml呼び出し | E-01 L133-152 (uses: pr-win32-test.yml) | ○ |
| C-19 | 3プラットフォームx3種類=9テストジョブ | E-01 L91-152 (ジョブ定義) | ○ |
| C-20 | node_modulesキャッシュ使用 | E-01 L34-42 (actions/cache/restore) | ○ |
| C-21 | .build/packagelockhashでキャッシュキー計算 | E-01 L32 (computeNodeModulesCacheKey.ts) | ○ |
| C-22 | build/でtypecheck実行 | E-01 L75-77 (npm run typecheck) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主要な主張について根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての技術仕様がpr.ymlから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] self-hostedランナー（1es-vscode-oss-ubuntu-22.04-x64）の可用性を確認
- [ ] 各プラットフォームテストのタイムアウト設定が適切か確認
- [ ] rustup_toolchainのバージョン（1.85）が最新要件と一致するか確認
