---
generated_at: 2026-01-27 15:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-configuration-editing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **GitHub認証関連（UT-CFE-069〜080）**：実際の認証フローは結合テストでの検証推奨
  2. **プロキシ設定関連（UT-CFE-081〜084）**：環境依存のため実環境テスト推奨
  3. **コンテキストキー補完（UT-CFE-020〜022）**：getContextKeyInfoコマンドのモック必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/extensions/configuration-editing/src/configurationEditingMain.ts` - メインエントリポイント、activate関数、各種補完プロバイダ登録
- E-02: `/extensions/configuration-editing/src/settingsDocumentHelper.ts` - SettingsDocumentクラス、設定補完ロジック
- E-03: `/extensions/configuration-editing/src/extensionsProposals.ts` - provideInstalledExtensionProposals関数
- E-04: `/extensions/configuration-editing/src/importExportProfiles.ts` - GitHubGistProfileContentHandlerクラス
- E-05: `/extensions/configuration-editing/src/node/net.ts` - Node.js用プロキシエージェント取得
- E-06: `/extensions/configuration-editing/src/browser/net.ts` - ブラウザ用エージェント（undefined）
- E-07: `/extensions/configuration-editing/src/test/completion.test.ts` - 既存の統合テスト
- E-08: `/extensions/configuration-editing/package.json` - 拡張機能設定、アクティベーションイベント

## 3) Claims と根拠の対応（レビューの主戦場）

### configurationEditingMain.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CFE-001) | activate関数で全プロバイダ登録 | E-01 (12-30行目) | ○ |
| C-02 (UT-CFE-002) | registerSettingsCompletions登録 | E-01 (32-38行目) | ○ |
| C-03 (UT-CFE-003) | launch.json変数補完登録 | E-01 (20行目) | ○ |
| C-04 (UT-CFE-004) | tasks.json変数補完登録 | E-01 (23行目) | ○ |
| C-05 (UT-CFE-005) | code-workspace変数補完登録 | E-01 (26行目) | ○ |
| C-06 (UT-CFE-006) | 変数補完候補返却 | E-01 (40-82行目) | ○ |
| C-07 (UT-CFE-007) | ${variable}形式 | E-01 (72-77行目) | ○ |
| C-08 (UT-CFE-008) | SnippetString対応 | E-01 (75行目) | ○ |
| C-09 (UT-CFE-009) | プロパティキー位置除外 | E-01 (86-88行目) | ○ |
| C-10 (UT-CFE-010) | code-workspaceスコープ制限 | E-01 (45-47行目) | ○ |
| C-11 (UT-CFE-011) | isCompletingInsidePropertyStringValue正常系 | E-01 (85-95行目) | ○ |
| C-12 (UT-CFE-012) | isCompletingInsidePropertyStringValueキー位置 | E-01 (86-88行目) | ○ |
| C-13 (UT-CFE-013) | previousNode null処理 | E-01 (89-93行目) | ○ |
| C-14 (UT-CFE-014) | isLocationInsideTopLevelProperty正常系 | E-01 (97-99行目) | ○ |
| C-15 (UT-CFE-015) | isLocationInsideTopLevelProperty境界 | E-01 (97-99行目) | ○ |
| C-16 (UT-CFE-016) | extensions.json補完 | E-01 (109-121行目) | ○ |
| C-17 (UT-CFE-017) | code-workspace extensions補完 | E-01 (123-135行目) | ○ |
| C-18 (UT-CFE-018) | getReplaceRange正常系 | E-01 (137-146行目) | ○ |
| C-19 (UT-CFE-019) | getReplaceRange境界値 | E-01 (145行目) | ○ |
| C-20 (UT-CFE-020) | keybindings.json when補完 | E-01 (183-244行目) | ○ |
| C-21 (UT-CFE-021) | package.json contributes.menus補完 | E-01 (190-196行目) | ○ |
| C-22 (UT-CFE-022) | キャンセル処理 | E-01 (228-230行目) | ○ |
| C-23 (UT-CFE-023) | launch.jsonシンボル抽出 | E-01 (148-181行目) | ○ |
| C-24 (UT-CFE-024) | name無し構成除外 | E-01 (172-174行目) | ○ |

### settingsDocumentHelper.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 (UT-CFE-025) | コンストラクタ | E-02 (14行目) | ○ |
| C-26 (UT-CFE-026) | window.title補完 | E-02 (20-22行目, 95-132行目) | ○ |
| C-27 (UT-CFE-027) | files.associations補完 | E-02 (25-27行目, 159-187行目) | ○ |
| C-28 (UT-CFE-028) | files.exclude補完 | E-02 (30-32行目, 189-251行目) | ○ |
| C-29 (UT-CFE-029) | search.exclude補完 | E-02 (30行目) | ○ |
| C-30 (UT-CFE-030) | explorer.autoRevealExclude補完 | E-02 (30行目) | ○ |
| C-31 (UT-CFE-031) | files.defaultLanguage補完 | E-02 (35-37行目, 253-263行目) | ○ |
| C-32 (UT-CFE-032) | workbench.editor.label.patterns補完 | E-02 (40-42行目, 134-157行目) | ○ |
| C-33 (UT-CFE-033) | settingsSync.ignoredExtensions補完 | E-02 (45-52行目) | ○ |
| C-34 (UT-CFE-034) | remote.extensionKind補完 | E-02 (55-62行目) | ○ |
| C-35 (UT-CFE-035) | remote.portsAttributes補完 | E-02 (65-67行目, 321-344行目) | ○ |
| C-36 (UT-CFE-036) | 言語オーバーライド補完 | E-02 (69行目, 277-319行目) | ○ |
| C-37 (UT-CFE-037) | getReplaceRange正常系 | E-02 (72-81行目) | ○ |
| C-38 (UT-CFE-038) | getReplaceRange境界値 | E-02 (80行目) | ○ |
| C-39 (UT-CFE-039) | isCompletingPropertyValue正常系 | E-02 (83-93行目) | ○ |
| C-40 (UT-CFE-040) | isCompletingPropertyValueキー位置 | E-02 (84-86行目) | ○ |
| C-41 (UT-CFE-041) | isCompletingPropertyValue previousNode無し | E-02 (92行目) | ○ |
| C-42 (UT-CFE-042) | provideWindowTitleCompletionItems詳細 | E-02 (113-131行目) | ○ |
| C-43 (UT-CFE-043) | 既存値ありフォーマット | E-02 (109行目) | ○ |
| C-44 (UT-CFE-044) | 新規値フォーマット | E-02 (109行目) | ○ |
| C-45 (UT-CFE-045) | プロパティ値外空配列 | E-02 (98-100行目) | ○ |
| C-46 (UT-CFE-046) | provideEditorLabelCompletionItems | E-02 (152-156行目) | ○ |
| C-47 (UT-CFE-047) | provideFilesAssociationsCompletionItemsキー | E-02 (162-179行目) | ○ |
| C-48 (UT-CFE-048) | provideFilesAssociationsCompletionItems値 | E-02 (180-183行目) | ○ |
| C-49 (UT-CFE-049) | provideExcludeCompletionItemsキー | E-02 (193-237行目) | ○ |
| C-50 (UT-CFE-050) | provideExcludeCompletionItems値 | E-02 (240-248行目) | ○ |
| C-51 (UT-CFE-051) | provideLanguageCompletionItems | E-02 (253-263行目) | ○ |
| C-52 (UT-CFE-052) | activeEditorLanguageオプション | E-02 (258行目) | ○ |
| C-53 (UT-CFE-053) | 条件外空配列 | E-02 (254行目, 262行目) | ○ |
| C-54 (UT-CFE-054) | provideLanguageOverridesCompletionItems | E-02 (277-319行目) | ○ |
| C-55 (UT-CFE-055) | 既存言語除外 | E-02 (290-291行目, 308行目) | ○ |
| C-56 (UT-CFE-056) | 最初の範囲スキップ | E-02 (304行目) | ○ |
| C-57 (UT-CFE-057) | providePortsAttributesCompletionItem | E-02 (321-344行目) | ○ |
| C-58 (UT-CFE-058) | newSimpleCompletionItem | E-02 (346-353行目) | ○ |
| C-59 (UT-CFE-059) | insertTextデフォルト | E-02 (350行目) | ○ |
| C-60 (UT-CFE-060) | newSnippetCompletionItem | E-02 (355-362行目) | ○ |

### extensionsProposals.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 (UT-CFE-061) | インストール済み拡張機能候補 | E-03 (9-32行目) | ○ |
| C-62 (UT-CFE-062) | 既存エントリ除外 | E-03 (12行目) | ○ |
| C-63 (UT-CFE-063) | ビルトイン除外 | E-03 (11行目) | ○ |
| C-64 (UT-CFE-064) | ビルトイン含む | E-03 (11行目) | ○ |
| C-65 (UT-CFE-065) | additionalText連結 | E-03 (16行目) | ○ |
| C-66 (UT-CFE-066) | 空候補フォールバック | E-03 (23-28行目) | ○ |
| C-67 (UT-CFE-067) | 配列チェック | E-03 (10行目) | ○ |

### importExportProfiles.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 (UT-CFE-068) | コンストラクタ name/description | E-04 (13-14行目) | ○ |
| C-69 (UT-CFE-069) | getOctokit認証クライアント | E-04 (17-33行目) | ○ |
| C-70 (UT-CFE-070) | getOctokitキャッシュ | E-04 (18行目) | ○ |
| C-71 (UT-CFE-071) | saveProfile Gist作成 | E-04 (35-50行目) | ○ |
| C-72 (UT-CFE-072) | saveProfile非公開設定 | E-04 (38行目) | ○ |
| C-73 (UT-CFE-073) | saveProfile失敗時null | E-04 (45-49行目) | ○ |
| C-74 (UT-CFE-074) | getPublicOctokit | E-04 (53-61行目) | ○ |
| C-75 (UT-CFE-075) | getPublicOctokitキャッシュ | E-04 (54行目) | ○ |
| C-76 (UT-CFE-076) | readProfile string引数 | E-04 (63-77行目) | ○ |
| C-77 (UT-CFE-077) | readProfile Uri引数 | E-04 (66行目) | ○ |
| C-78 (UT-CFE-078) | readProfile存在しないGist | E-04 (73-75行目) | ○ |
| C-79 (UT-CFE-079) | readProfile空ファイル | E-04 (71行目) | ○ |
| C-80 (UT-CFE-080) | readProfileエラー処理 | E-04 (73-75行目) | ○ |

### node/net.ts, browser/net.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 (UT-CFE-081) | getAgent HTTPS_PROXY未設定 | E-05 (17-19行目) | ○ |
| C-82 (UT-CFE-082) | getAgentプロキシエージェント | E-05 (21-24行目) | ○ |
| C-83 (UT-CFE-083) | 認証付きプロキシ | E-05 (22-23行目) | ○ |
| C-84 (UT-CFE-084) | 不正URL処理 | E-05 (25-27行目) | ○ |
| C-85 (UT-CFE-085) | ブラウザ環境undefined | E-06 (6行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードから直接導出されています

補足事項：
- 既存の統合テスト（E-07）は単体テストではなく統合テストのため、単体テストケース一覧には含めていません
- VS Code API（vscode.languages, vscode.extensions等）のモック戦略については実装時に検討が必要です

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - GitHub API連携部分（UT-CFE-069〜080）は外部依存があり、モック設計が重要
- **1: 中リスク** - プロキシ設定テスト（UT-CFE-081〜084）は環境依存のため、CI/CD環境での挙動確認推奨
- **0: 低リスク** - 補完プロバイダのロジックテストは純粋関数が多く、テスト容易性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 全85件のテストケースがソースコードのメソッド・分岐を網羅しているか確認
- [ ] テストID（UT-CFE-001〜085）の連番に欠けがないか確認
- [ ] GitHub認証関連テスト（UT-CFE-069〜080）のモック戦略が適切か確認
- [ ] プロキシ設定テスト（UT-CFE-081〜084）の環境分離が適切か確認
- [ ] 境界値テスト（null/undefined処理）の網羅性を確認
- [ ] 優先度（高/中/低）の割り当てがビジネス重要度と一致しているか確認
