---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：ext-css-language-features 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから該当する関数・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・分岐を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 98 / 100 = 0.98
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-CSS-067**: ノートブックセル対応の実際の動作確認が必要
  2. **UT-CSS-091**: ワークスペース設定のinspect動作の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/extensions/css-language-features/server/src/languageModelCache.ts` - LanguageModelCache実装
- E-02: `/extensions/css-language-features/server/src/utils/strings.ts` - 文字列ユーティリティ関数
- E-03: `/extensions/css-language-features/server/src/utils/runner.ts` - 非同期実行ヘルパー
- E-04: `/extensions/css-language-features/server/src/utils/documentContext.ts` - ドキュメントコンテキスト
- E-05: `/extensions/css-language-features/server/src/customData.ts` - カスタムデータプロバイダ
- E-06: `/extensions/css-language-features/server/src/requests.ts` - リクエストサービス（サーバー）
- E-07: `/extensions/css-language-features/server/src/utils/validation.ts` - 診断バリデーション
- E-08: `/extensions/css-language-features/server/src/node/nodeFs.ts` - Node.jsファイルシステムサービス
- E-09: `/extensions/css-language-features/client/src/dropOrPaste/uriList.ts` - URIリストパーサー
- E-10: `/extensions/css-language-features/client/src/dropOrPaste/shared.ts` - 共有ユーティリティ
- E-11: `/extensions/css-language-features/client/src/dropOrPaste/dropOrPasteResource.ts` - ドロップ・ペースト機能
- E-12: `/extensions/css-language-features/client/src/cssClient.ts` - CSSクライアントメイン
- E-13: `/extensions/css-language-features/client/src/customData.ts` - カスタムデータソース（クライアント）
- E-14: `/extensions/css-language-features/client/src/requests.ts` - リクエストサービス（クライアント）
- E-15: `/extensions/css-language-features/client/src/node/nodeFs.ts` - Node.jsファイルシステムサービス（クライアント）
- E-16: `/extensions/css-language-features/server/src/cssServer.ts` - CSSサーバーメイン

## 3) Claims と根拠の対応（レビューの主戦場）

### languageModelCache (UT-CSS-001 - UT-CSS-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャッシュが正しく取得できること | E-01: getLanguageModelCache関数 L14-82 | ○ |
| C-02 | 同一ドキュメントでキャッシュ再利用 | E-01: get関数内のversion/languageIdチェック L38-40 | ○ |
| C-03 | バージョン変更で再パース | E-01: version比較ロジック L38 | ○ |
| C-04 | languageId変更で再パース | E-01: languageId比較ロジック L38 | ○ |
| C-05 | maxEntries到達時のLRU削除 | E-01: maxEntries処理 L48-62 | ○ |
| C-06 | onDocumentRemovedでキャッシュ削除 | E-01: onDocumentRemoved L66-71 | ○ |
| C-07 | 存在しないドキュメント削除の安全処理 | E-01: if文での存在チェック L68 | ○ |
| C-08 | disposeでリソース解放 | E-01: dispose関数 L73-80 | ○ |
| C-09 | クリーンアップインターバルの動作 | E-01: setInterval L20-30 | ○ |

### strings (UT-CSS-010 - UT-CSS-017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | startsWith正常系（true） | E-02: startsWith関数 L6-18 | ○ |
| C-11 | startsWith正常系（false） | E-02: 文字比較ロジック L11-14 | ○ |
| C-12 | startsWith境界値（短い文字列） | E-02: length比較 L7-9 | ○ |
| C-13 | startsWith境界値（空文字列） | E-02: forループ条件 L11 | ○ |
| C-14 | endsWith正常系（true） | E-02: endsWith関数 L23-32 | ○ |
| C-15 | endsWith正常系（false） | E-02: lastIndexOf比較 L26 | ○ |
| C-16 | endsWith境界値（同一文字列） | E-02: diff === 0条件 L27 | ○ |
| C-17 | endsWith境界値（長いneedle） | E-02: diff < 0条件 L29 | ○ |

### runner (UT-CSS-018 - UT-CSS-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | formatError Errorオブジェクト処理 | E-03: instanceof Error分岐 L10-12 | ○ |
| C-19 | formatError 文字列処理 | E-03: typeof === 'string'分岐 L13-14 | ○ |
| C-20 | formatError その他オブジェクト処理 | E-03: err.toString()呼び出し L15-16 | ○ |
| C-21 | formatError null/undefined処理 | E-03: 最終return文 L18 | ○ |
| C-22 | runSafeAsync正常完了 | E-03: func().then(result => resolve(result)) L28-34 | ○ |
| C-23 | runSafeAsync エラー時errorVal返却 | E-03: .catch処理 L35-38 | ○ |
| C-24 | runSafeAsync キャンセル済みトークン | E-03: isCancellationRequestedチェック L24-27 | ○ |
| C-25 | runSafeAsync 実行中キャンセル | E-03: 結果返却前のキャンセルチェック L29-31 | ○ |

### documentContext (UT-CSS-026 - UT-CSS-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | getDocumentContext正常系 | E-04: getDocumentContext関数 L11-38 | ○ |
| C-27 | resolveReference相対パス解決 | E-04: Utils.resolvePath L35 | ○ |
| C-28 | resolveReference絶対パス解決 | E-04: ref[0] === '/'分岐 L27-31 | ○ |
| C-29 | ワークスペース外で絶対パス処理 | E-04: folderUri未定義時の処理 L32-35 | ○ |
| C-30 | getRootFolder正常系 | E-04: getRootFolder関数 L12-23 | ○ |
| C-31 | getRootFolder不一致 | E-04: return undefined L22 | ○ |

### customData (UT-CSS-032 - UT-CSS-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | fetchDataProviders正常系 | E-05: fetchDataProviders関数 L9-20 | ○ |
| C-33 | fetchDataProvidersエラー時フォールバック | E-05: catch(e)ブロック L14-15 | ○ |
| C-34 | parseCSSData正常パース | E-05: parseCSSData関数 L22-38 | ○ |
| C-35 | parseCSSData不正JSONフォールバック | E-05: JSON.parse try-catch L25-29 | ○ |
| C-36 | parseCSSData空オブジェクトデフォルト値 | E-05: || []によるデフォルト設定 L33-36 | ○ |

### requests (UT-CSS-037 - UT-CSS-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | getRequestService fileスキームルーティング | E-06: protocol === 'file'分岐 L69-70 | ○ |
| C-38 | getRequestService httpスキームルーティング | E-06: protocol === 'http' || 'https'分岐 L71-72 | ○ |
| C-39 | getRequestService未ハンドルスキームフォールバック | E-06: connection.sendRequest L81, L89, L96 | ○ |
| C-40 | getScheme正常系（file） | E-06: getScheme関数 L101-103 | ○ |
| C-41 | getScheme正常系（https） | E-06: substr + indexOf L102 | ○ |

### validation (UT-CSS-042 - UT-CSS-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | registerDiagnosticsPushSupport変更トリガー | E-07: onDidChangeContent L26-28 | ○ |
| C-43 | クローズ時診断クリア | E-07: onDidClose L31-34 | ○ |
| C-44 | cleanPendingValidation | E-07: cleanPendingValidation関数 L36-42 | ○ |
| C-45 | triggerValidation遅延実行 | E-07: runtime.timer.setTimeout L46 | ○ |
| C-46 | triggerValidationデバウンス | E-07: cleanPendingValidation呼び出し L45 | ○ |
| C-47 | registerDiagnosticsPullSupport診断返却 | E-07: connection.languages.diagnostics.on L86-95 | ○ |
| C-48 | 存在しないドキュメントで空診断 | E-07: newDocumentDiagnosticReport([]) L92 | ○ |
| C-49 | requestRefresh | E-07: connection.languages.diagnostics.refresh L98 | ○ |
| C-50 | dispose | E-07: registration.dispose L104 | ○ |

### nodeFs (UT-CSS-051 - UT-CSS-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | getContent正常系 | E-08: fs.readFile L21-28 | ○ |
| C-52 | getContent非file://エラー | E-08: ensureFileUri L13-15 | ○ |
| C-53 | getContentファイル不在エラー | E-08: fs.readFile err処理 L23-25 | ○ |
| C-54 | stat正常系（ファイル） | E-08: stats.isFile() L44-45 | ○ |
| C-55 | stat正常系（ディレクトリ） | E-08: stats.isDirectory() L46-47 | ○ |
| C-56 | stat正常系（シンボリックリンク） | E-08: stats.isSymbolicLink() L48-49 | ○ |
| C-57 | stat不在ファイル | E-08: ENOENT処理 L36-38 | ○ |
| C-58 | readDirectory正常系 | E-08: fs.readdir L66-81 | ○ |
| C-59 | readDirectory不在ディレクトリ | E-08: err処理 L68-70 | ○ |

### uriList (UT-CSS-060 - UT-CSS-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | UriList.from正常パース | E-09: from関数 L20-29 | ○ |
| C-61 | コメント行除外 | E-09: filter !startsWith('#') L14 | ○ |
| C-62 | 不正URI除外 | E-09: try-catch + coalesce L22-27, L36-38 | ○ |
| C-63 | 空文字列で空entries | E-09: parseUriList + UriList constructor | ○ |

### shared (UT-CSS-064 - UT-CSS-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | getDocumentDir正常系 | E-10: getDocumentDir関数 L21-27 | ○ |
| C-65 | getDocumentDir untitledスキーム | E-10: Schemes.untitled分岐 L23-24 | ○ |
| C-66 | getDocumentDir untitled+ワークスペースなし | E-10: workspaceFolders?.[0]?.uri | ○ |
| C-67 | getParentDocumentUriノートブックセル | E-10: Schemes.notebookCell分岐 L30-38 | △ |
| C-68 | getParentDocumentUri通常URI | E-10: return uri L41 | ○ |

### dropOrPasteResource (UT-CSS-069 - UT-CSS-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | provideDocumentDropEdits正常系 | E-11: provideDocumentDropEdits L15-37 | ○ |
| C-70 | provideDocumentDropEdits空URIリスト | E-11: if (!uriList.entries.length) L22-24 | ○ |
| C-71 | provideDocumentDropEditsキャンセル | E-11: token.isCancellationRequested L22, L27 | ○ |
| C-72 | provideDocumentPasteEdits正常系 | E-11: provideDocumentPasteEdits L39-62 | ○ |
| C-73 | createUriListSnippet単一URI | E-11: createUriListSnippet L82-105 | ○ |
| C-74 | createUriListSnippet複数URI | E-11: forループ L88-96 | ○ |
| C-75 | createUriListSnippet相対パス使用 | E-11: getRelativePath呼び出し L90 | ○ |
| C-76 | createUriListSnippet空URIリスト | E-11: if (!uriList.entries.length) L83-85 | ○ |
| C-77 | getRelativePath正常系 | E-11: getRelativePath関数 L118-132 | ○ |
| C-78 | getRelativePath異なるスキーム | E-11: scheme比較 L119 | ○ |
| C-79 | pasteAsCssUrlByDefaulturl()内 | E-11: pasteAsCssUrlByDefault L107-115 | ○ |
| C-80 | pasteAsCssUrlByDefaulturl()外 | E-11: return true L114 | ○ |

### cssClient (UT-CSS-081 - UT-CSS-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | startClient正常起動 | E-12: startClient関数 L39-213 | ○ |
| C-82 | customDataChanged通知 | E-12: client.sendNotification L105-108 | ○ |
| C-83 | initCompletionProvider#region補完 | E-12: initCompletionProvider L122-148 | ○ |
| C-84 | initCompletionProvider不一致でnull | E-12: return null L145 | ○ |
| C-85 | applyCodeAction正常適用 | E-12: applyCodeAction L152-168 | ○ |
| C-86 | applyCodeActionバージョン不一致 | E-12: documentVersion比較 L155-157 | ○ |
| C-87 | updateFormatterRegistration登録 | E-12: updateFormatterRegistration L170-209 | ○ |
| C-88 | updateFormatterRegistration解除 | E-12: provider.dispose() L173-174 | ○ |
| C-89 | getCustomDataSource結合 | E-13: get uris() L30-32 | ○ |
| C-90 | getCustomDataSource変更検知 | E-13: extensions.onDidChange L15-21 | ○ |
| C-91 | getCustomDataPathsInAllWorkspaces | E-13: getCustomDataPathsInAllWorkspaces L40-75 | △ |
| C-92 | getCustomDataPathsInAllWorkspaces空ワークスペース | E-13: if (!workspaceFolders) L45-47 | ○ |
| C-93 | getCustomDataPathsFromAllExtensions | E-13: getCustomDataPathsFromAllExtensions L77-88 | ○ |
| C-94 | serveFileSystemRequests FsContent | E-14: FsContentRequest.type L22-30 | ○ |
| C-95 | serveFileSystemRequests非fileスキーム | E-14: workspace.fs.readFile L27-29 | ○ |

### cssServer (UT-CSS-096 - UT-CSS-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | startServer起動 | E-16: startServer関数 L37-385 | ○ |
| C-97 | getLanguageService正常系 | E-16: getLanguageService関数 L141-148 | ○ |
| C-98 | getLanguageServiceフォールバック | E-16: service = languageServices['css'] L145-146 | ○ |
| C-99 | onFormat正常系 | E-16: onFormat関数 L359-370 | ○ |
| C-100 | onFormat編集制限 | E-16: formatterMaxNumberOfEdits比較 L363-366 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CSS-067 (C-67)**: ノートブックセルの親ドキュメント取得について、実際のノートブックドキュメントを使用した動作テストが必要。コード上は実装されているが、実行時の具体的なセルID解決の挙動は確認が困難。
  - 候補：実際のノートブック環境でのE2Eテスト / vscode.workspace.notebookDocumentsのモック検証
- **UT-CSS-091 (C-91)**: workspace.getConfiguration.inspectの戻り値構造について、workspaceFolderValue/workspaceValue/globalValueの優先順位と取得方法の詳細確認が必要。
  - 候補：VS Code API仕様書の確認 / 実際の設定ファイルを使った動作検証

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 文字列ユーティリティ関数（strings.ts）- 単純なロジックで副作用なし
- **0 (低リスク)**: URIリストパーサー（uriList.ts）- 純粋なパース処理
- **1 (中リスク)**: ファイルシステムアクセス（nodeFs.ts）- I/O操作だがエラーハンドリングあり
- **1 (中リスク)**: キャッシュ管理（languageModelCache.ts）- メモリ管理に関わるがLRU制限あり
- **1 (中リスク)**: 診断バリデーション（validation.ts）- タイマー処理と非同期処理の組み合わせ
- **2 (高リスク)**: ドロップ・ペースト機能（dropOrPasteResource.ts）- ユーザー入力処理、パス変換ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] UT-CSS-005: LRUキャッシュの最大エントリ数超過時の動作が期待通りか確認
- [ ] UT-CSS-024/025: キャンセルトークンの処理タイミングが正しいか確認
- [ ] UT-CSS-045/046: バリデーションのデバウンス動作（500ms遅延）が適切か確認
- [ ] UT-CSS-067: ノートブックセル対応の実装詳細を確認
- [ ] UT-CSS-077/078: 相対パス計算のWindows/Unix互換性を確認
- [ ] UT-CSS-091: 設定のスコープ（ワークスペース/グローバル）優先順位を確認
- [ ] UT-CSS-100: フォーマッタの編集数制限値（10000）の妥当性を確認
