---
generated_at: 2026-01-27 15:30:00
metrics:
  claims_total: 68
  claims_with_evidence: 68
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-debug-auto-launch単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：68 / 68、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠が存在します

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/debug-auto-launch/src/extension.ts` - メインソースファイル（408行）
- E-02: `extensions/debug-auto-launch/package.json` - パッケージ定義（48行）
- E-03: ソースコード内のState enum定義（11-16行）
- E-04: ソースコード内のTEXT_STATUSBAR_LABEL定義（17-22行）
- E-05: ソースコード内のSETTINGS_CAUSE_REFRESH定義（53-55行）
- E-06: ソースコード内のactivate関数（63-84行）
- E-07: ソースコード内のdeactivate関数（86-88行）
- E-08: ソースコード内のgetDefaultScope関数（95-107行）
- E-09: ソースコード内のtoggleAutoAttachSetting関数（112-190行）
- E-10: ソースコード内のreadCurrentState関数（192-195行）
- E-11: ソースコード内のclearJsDebugAttachState関数（197-203行）
- E-12: ソースコード内のcreateAttachServer関数（209-235行）
- E-13: ソースコード内のcreateServerInner関数（237-246行）
- E-14: ソースコード内のcreateServerInstance関数（248-275行）
- E-15: ソースコード内のdestroyAttachServer関数（280-285行）
- E-16: ソースコード内のtransitions定義（297-313行）
- E-17: ソースコード内のupdateStatusBar関数（318-336行）
- E-18: ソースコード内のupdateAutoAttach関数（341-356行）
- E-19: ソースコード内のgetIpcAddress関数（362-397行）
- E-20: ソースコード内のgetJsDebugSettingKey関数（399-407行）
- E-21: ソースコード内のCachedIpcStateインターフェース（287-291行）

## 3) Claims と根拠の対応（レビューの主戦場）

### activate関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 拡張機能が正常に起動すること | E-06 | ○ |
| C-02 | 設定変更リスナーが登録されること | E-06 (70-81行) | ○ |
| C-03 | 初期状態でupdateAutoAttachが呼ばれること | E-06 (83行) | ○ |

### deactivate関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | 拡張機能終了時にサーバーが破棄されること | E-07 | ○ |
| C-05 | サーバーが存在しない場合も正常終了すること | E-07, E-15 | ○ |

### refreshAutoAttachVars関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | 状態がリフレッシュされること | E-01 (90-93行) | ○ |

### getDefaultScope関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | workspaceFolderValueがある場合WorkspaceFolderが返ること | E-08 (98-99行) | ○ |
| C-08 | workspaceValueがある場合Workspaceが返ること | E-08 (100-101行) | ○ |
| C-09 | globalValueがある場合Globalが返ること | E-08 (102-103行) | ○ |
| C-10 | infoがundefinedの場合Globalが返ること | E-08 (96-97行) | ○ |
| C-11 | すべての値がある場合の優先順位 | E-08 | ○ |

### toggleAutoAttachSetting関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | QuickPickが表示されること | E-09 (117, 148行) | ○ |
| C-13 | Always状態を選択できること | E-09 (120, 174行) | ○ |
| C-14 | Smart状態を選択できること | E-09 (120, 174行) | ○ |
| C-15 | OnlyWithFlag状態を選択できること | E-09 (120, 174行) | ○ |
| C-16 | Disabled状態を選択できること | E-09 (120, 174行) | ○ |
| C-17 | 一時無効化を選択できること | E-09 (127-133, 180-188行) | ○ |
| C-18 | 一時無効化から再有効化できること | E-09 (186行) | ○ |
| C-19 | スコープ切り替えボタンでGlobal/Workspaceが切り替わること | E-09 (153-159, 168-169行) | ○ |
| C-20 | QuickPickがキャンセルされた場合何も変更されないこと | E-09 (152, 164-166行) | ○ |
| C-21 | 現在と同じ状態を選択した場合でも一時無効が解除されること | E-09 (173-177行) | ○ |

### readCurrentState関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | 設定からStateが正しく読み取れること | E-10 | ○ |
| C-23 | 設定が未定義の場合Disabledが返ること | E-10 (194行 nullish coalescing) | ○ |

### clearJsDebugAttachState関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | workspaceStateがクリアされること | E-11 (199行) | ○ |
| C-25 | clearAutoAttachVariablesコマンドが実行されること | E-11 (200行) | ○ |
| C-26 | アタッチサーバーが破棄されること | E-11 (201行) | ○ |
| C-27 | サーバーもIPCも存在しない場合何もしないこと | E-11 (198行の条件) | ○ |

### createAttachServer関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | IPCアドレスでサーバーが作成されること | E-12 | ○ |
| C-29 | IPCアドレスが取得できない場合undefinedが返ること | E-12 (211-213行) | ○ |
| C-30 | サーバー作成エラー時にエラーログが出力されること | E-12 (216行) | ○ |
| C-31 | macOS/Linuxで一時ディレクトリ変更時にリフレッシュされること | E-12 (218-227行) | ○ |

### createServerInner関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | サーバーインスタンスが作成されること | E-13 | ○ |
| C-33 | ファイルリーク時に再試行されること | E-13 (243-244行) | ○ |

### createServerInstance関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | サーバーがlistenを開始すること | E-14 (274行) | ○ |
| C-35 | 接続時にデータが正しく処理されること | E-14 (251-265行) | ○ |
| C-36 | コマンド成功時に0x00が返却されること | E-14 (266行) | ○ |
| C-37 | コマンドエラー時に0x01が返却されること | E-14 (268行) | ○ |
| C-38 | 複数チャンクに分割されたデータが正しく結合されること | E-14 (251-257, 264行) | ○ |
| C-39 | エラー時にrejectが呼ばれること | E-14 (273行) | ○ |

### destroyAttachServer関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | サーバーがcloseされること | E-15 (283行) | ○ |
| C-41 | サーバーがundefinedの場合何もしないこと | E-15 (282行の条件) | ○ |

### updateStatusBar関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | Disabled状態でステータスバーが非表示になること | E-17 (319-321行) | ○ |
| C-43 | ステータスバーアイテムが作成されること | E-17 (324-329行) | ○ |
| C-44 | busy状態でローディングアイコンが表示されること | E-17 (332行) | ○ |
| C-45 | 一時無効化状態で適切なラベルが表示されること | E-17 (333行) | ○ |
| C-46 | 各状態で適切なラベルが表示されること | E-17, E-04 | ○ |

### updateAutoAttach関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | 状態が変更されたとき遷移関数が呼ばれること | E-18 (351行) | ○ |
| C-48 | 状態が同じ場合は何もしないこと | E-18 (343-345行) | ○ |
| C-49 | 遷移後にisTemporarilyDisabledがfalseになること | E-18 (352行) | ○ |
| C-50 | 遷移前後でステータスバーが更新されること | E-18 (348, 353行) | ○ |

### transitions関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | Disabled遷移時にclearJsDebugAttachStateが呼ばれること | E-16 (298-300行) | ○ |
| C-52 | OnlyWithFlag遷移時にサーバーが作成されること | E-16 (302-304行) | ○ |
| C-53 | Smart遷移時にサーバーが作成されること | E-16 (306-308行) | ○ |
| C-54 | Always遷移時にサーバーが作成されること | E-16 (310-312行) | ○ |

### getIpcAddress関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | キャッシュが有効な場合キャッシュされたアドレスが返ること | E-19 (377-379行) | ○ |
| C-56 | キャッシュが無効な場合新しいアドレスが取得されること | E-19 (381-384行) | ○ |
| C-57 | 取得したアドレスがworkspaceStateに保存されること | E-19 (390-394行) | ○ |
| C-58 | コマンドが結果を返さない場合undefinedが返ること | E-19 (385-387行) | ○ |
| C-59 | js-debug-nightlyが優先されること | E-19 (372-374行) | ○ |

### getJsDebugSettingKey関数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | SETTINGS_CAUSE_REFRESHの設定がJSON文字列で返ること | E-20 | ○ |
| C-61 | 設定が空の場合も正しいJSONが返ること | E-20 | ○ |

### onDidChangeConfiguration関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | autoAttachFilter変更時にrefreshAutoAttachVarsが呼ばれること | E-06 (74-78行) | ○ |
| C-63 | autoAttachSmartPattern変更時にrefreshAutoAttachVarsが呼ばれること | E-06 (76行), E-05 | ○ |
| C-64 | 関係ない設定変更時は何もしないこと | E-06 (74-76行の条件) | ○ |

### State enum関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | Disabledの値が'disabled'であること | E-03 (12行) | ○ |
| C-66 | OnlyWithFlagの値が'onlyWithFlag'であること | E-03 (13行) | ○ |
| C-67 | Smartの値が'smart'であること | E-03 (14行) | ○ |
| C-68 | Alwaysの値が'always'であること | E-03 (15行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：すべてのテストケースがソースコードに明確な根拠を持っています
- 注意点：
  - 本モジュールはVS Code拡張機能APIに強く依存しているため、モック実装が必要
  - ファイルシステム操作（fs.access, fs.unlink）のモックが必要
  - netモジュール（createServer）のモックが必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）が適切に設定されているか確認
- [ ] vscode APIモックの実装方針を検討
- [ ] ファイルシステム・ネットワーク操作のモック戦略を確認
- [ ] 状態遷移（State enum）のすべての組み合わせがカバーされているか確認
- [ ] 一時無効化（isTemporarilyDisabled）関連のエッジケースを確認
- [ ] プラットフォーム固有処理（Windows vs Unix/Linux/macOS）のテスト方針を確認
