---
generated_at: 2026-01-27 15:30:00
metrics:
  claims_total: 82
  claims_with_evidence: 82
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-debug-server-ready 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコードの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：82 / 82、根拠なし：0
- 優先レビュー（高）
  1. **killOnServerStop連動停止機能**：非同期処理とイベントリスナーの複雑な連携
  2. **ターミナルデータリスナー**：PIDマッチングと複数detector試行のロジック
  3. **URI生成ロジック**：複数のフォーマットパターンと検証処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/debug-server-ready/src/extension.ts` - メインソースファイル（全394行）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/debug-server-ready/package.json` - パッケージ定義ファイル
- E-03: `extension.ts` 行10 - デフォルトPATTERN定数定義
- E-04: `extension.ts` 行11-13 - URI_PORT_FORMAT, URI_FORMAT, WEB_ROOT定数定義
- E-05: `extension.ts` 行15-23 - ServerReadyActionインターフェース定義
- E-06: `extension.ts` 行25-34 - エスケープシーケンス正規表現定義（CSI, OSC, ESC）
- E-07: `extension.ts` 行39-45 - removeAnsiEscapeCodes関数
- E-08: `extension.ts` 行47-57 - Triggerクラス
- E-09: `extension.ts` 行59-321 - ServerReadyDetectorクラス
- E-10: `extension.ts` 行61-62 - 静的プロパティ（detectors Map, terminalDataListener）
- E-11: `extension.ts` 行71-81 - start静的メソッド
- E-12: `extension.ts` 行83-90 - stop静的メソッド
- E-13: `extension.ts` 行92-97 - rememberShellPid静的メソッド
- E-14: `extension.ts` 行99-121 - startListeningTerminalData静的メソッド
- E-15: `extension.ts` 行123-134 - コンストラクタ
- E-16: `extension.ts` 行136-139 - internalDisposeメソッド
- E-17: `extension.ts` 行141-143 - sessionStoppedメソッド
- E-18: `extension.ts` 行145-155 - detectPatternメソッド
- E-19: `extension.ts` 行157-185 - openExternalWithStringメソッド
- E-20: `extension.ts` 行187-216 - openExternalWithUriメソッド
- E-21: `extension.ts` 行218-248 - debugWithBrowserメソッド
- E-22: `extension.ts` 行250-259 - startBrowserDebugSessionメソッド
- E-23: `extension.ts` 行268-297 - startDebugSessionメソッド
- E-24: `extension.ts` 行299-320 - catchStartedDebugSessionメソッド
- E-25: `extension.ts` 行323-351 - activate関数
- E-26: `extension.ts` 行353-393 - startTrackerForType関数

## 3) Claims と根拠の対応（レビューの主戦場）

### removeAnsiEscapeCodes関数（UT-DSR-001〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSIエスケープシーケンスが除去される | E-06, E-07 | ○ |
| C-02 | OSCエスケープシーケンスが除去される | E-06, E-07 | ○ |
| C-03 | ESCエスケープシーケンスが除去される | E-06, E-07 | ○ |
| C-04 | 複合エスケープシーケンスが除去される | E-06, E-07 | ○ |
| C-05 | 空文字列の処理 | E-07 行40-41 `if (str)` | ○ |
| C-06 | エスケープなし文字列はそのまま | E-07 | ○ |
| C-07 | undefinedの挙動 | E-07 行40 `if (str)` | ○ |

### Triggerクラス（UT-DSR-008〜010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | 初期状態でhasFiredはfalse | E-08 行48 `private _fired = false` | ○ |
| C-09 | fire()でhasFiredがtrue | E-08 行54-56 | ○ |
| C-10 | 複数回fire()の冪等性 | E-08 行54-56（単純代入） | ○ |

### ServerReadyDetector.start（UT-DSR-011〜014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | serverReadyAction設定ありでdetector作成 | E-11 行72-78 | ○ |
| C-12 | 同一セッションで同じdetector返却 | E-11 行73-74 `detectors.get(session)` | ○ |
| C-13 | serverReadyAction設定なしでundefined | E-11 行79-80 | ○ |
| C-14 | 親セッションのtrigger共有 | E-15 行127-131 | ○ |

### ServerReadyDetector.stop（UT-DSR-015〜017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | detectorの削除 | E-12 行86 `detectors.delete(session)` | ○ |
| C-16 | sessionStoppedとdispose呼出 | E-12 行87-88 | ○ |
| C-17 | 存在しないセッションへのstop | E-12 行84-85 `if (detector)` | ○ |

### ServerReadyDetector.rememberShellPid（UT-DSR-018〜019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | shellPid記録 | E-13 行95 | ○ |
| C-19 | 存在しないセッションへの呼出 | E-13 行93-94 `if (detector)` | ○ |

### ServerReadyDetector.startListeningTerminalData（UT-DSR-020〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | リスナー登録 | E-14 行100-101 | ○ |
| C-21 | 重複登録防止 | E-14 行100 `if (!this.terminalDataListener)` | ○ |

### ServerReadyDetector.detectPattern（UT-DSR-022〜027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | デフォルトパターンマッチ | E-03, E-18 | ○ |
| C-23 | カスタムパターンマッチ | E-15 行133, E-18 | ○ |
| C-24 | マッチしない場合false | E-18 行147-154 | ○ |
| C-25 | 大文字小文字無視 | E-15 行133 `'i'` フラグ | ○ |
| C-26 | trigger発火済みでfalse | E-18 行146 `if (!this.trigger.hasFired)` | ○ |
| C-27 | キャプチャなしパターン | E-18 行149 `matches.length > 1 ? matches[1] : ''` | ○ |

### ServerReadyDetector.openExternalWithString（UT-DSR-028〜033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | ポート番号キャプチャ時URI_PORT_FORMAT | E-19 行173 `/^[0-9]+$/.test(captureString)` | ○ |
| C-29 | URLキャプチャ時URI_FORMAT | E-19 行173 | ○ |
| C-30 | カスタムuriFormat使用 | E-19 行173 `args.uriFormat \|\|` | ○ |
| C-31 | キャプチャなしで%sありエラー | E-19 行164-169 | ○ |
| C-32 | 複数%sエラー | E-19 行175-179 `s.length !== 2` | ○ |
| C-33 | キャプチャなしで%sなし | E-19 行161-170 | ○ |

### ServerReadyDetector.openExternalWithUri（UT-DSR-034〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | openExternallyアクション | E-20 行192-193 | ○ |
| C-35 | デフォルトアクション | E-20 行190 `args.action \|\| 'openExternally'` | ○ |
| C-36 | debugWithChromeアクション | E-20 行196-197 | ○ |
| C-37 | debugWithEdgeアクション | E-20 行199-200 | ○ |
| C-38 | startDebuggingでconfig | E-20 行204-206 | ○ |
| C-39 | startDebuggingでname | E-20 行207-208 | ○ |
| C-40 | 未知のaction | E-20 行211-214 `default:` | ○ |

### ServerReadyDetector.debugWithBrowser（UT-DSR-041〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | killOnServerStop=false | E-21 行220-222 | ○ |
| C-42 | killOnServerStop=true連動停止 | E-21 行225-247 | ○ |
| C-43 | デバッグ開始失敗時キャンセル | E-21 行229-232 | ○ |

### ServerReadyDetector.startBrowserDebugSession（UT-DSR-044〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | 正しいデバッグ設定 | E-22 行251-258 | ○ |
| C-45 | カスタムwebRoot | E-22 行256 `serverReadyAction.webRoot \|\| WEB_ROOT` | ○ |
| C-46 | trackerId設定 | E-22 行257 | ○ |

### ServerReadyDetector.startDebugSession（UT-DSR-047〜050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | killOnServerStop=falseで名前指定 | E-23 行270-271 | ○ |
| C-48 | killOnServerStop=falseでconfig指定 | E-23 行271 `config ?? name` | ○ |
| C-49 | killOnServerStop=true連動停止 | E-23 行275-296 | ○ |
| C-50 | デバッグ開始失敗時キャンセル | E-23 行278-281 | ○ |

### ServerReadyDetector.catchStartedDebugSession（UT-DSR-051〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | 条件合致セッション返却 | E-24 行310-313 | ○ |
| C-52 | キャンセル時undefined | E-24 行309 | ○ |
| C-53 | disposables追加 | E-24 行317-318 | ○ |

### その他メソッド（UT-DSR-054〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | sessionStoppedでemitter発火 | E-17 行142 | ○ |
| C-55 | internalDisposeでリソース解放 | E-16 行137-138 | ○ |
| C-56 | カスタムパターンでRegExp作成 | E-15 行133 | ○ |
| C-57 | デフォルトパターン使用 | E-15 行133 `\|\| PATTERN` | ○ |

### activate関数（UT-DSR-058〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | onDidStartDebugSessionハンドラ登録 | E-25 行325-332 | ○ |
| C-59 | onDidTerminateDebugSessionハンドラ登録 | E-25 行334-336 | ○ |
| C-60 | DebugConfigurationProvider登録 | E-25 行340-350 | ○ |
| C-61 | detector開始 | E-25 行327-329 | ○ |
| C-62 | 設定なしスキップ | E-25 行326 `if (session.configuration.serverReadyAction)` | ○ |
| C-63 | セッション終了時stop | E-25 行335 | ○ |
| C-64 | tracker初回開始 | E-25 行343-346 | ○ |
| C-65 | tracker重複防止 | E-25 行343 `if (!trackers.has(debugConfiguration.type))` | ○ |
| C-66 | 設定なしでtracker未登録 | E-25 行342 | ○ |

### startTrackerForType関数（UT-DSR-067〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | TrackerFactory登録 | E-26 行356 | ○ |
| C-68 | tracker作成 | E-26 行358-389 | ○ |
| C-69 | 設定なしでundefined | E-26 行390 `return undefined` | ○ |
| C-70 | console出力検出 | E-26 行365 | ○ |
| C-71 | stderr出力検出 | E-26 行366 | ○ |
| C-72 | stdout出力検出 | E-26 行367 | ○ |
| C-73 | 他カテゴリ無視 | E-26 行370-371 `default: break` | ○ |
| C-74 | runInTerminal request seq記録 | E-26 行376-379 | ○ |
| C-75 | external kind無視 | E-26 行377 `kind === 'integrated'` | ○ |
| C-76 | runInTerminal応答でPID記録 | E-26 行383-385 | ○ |
| C-77 | request_seq不一致無視 | E-26 行383 `runInTerminalRequestSeq === m.request_seq` | ○ |
| C-78 | seq undefined無視 | E-26 行383 `runInTerminalRequestSeq &&` | ○ |
| C-79 | shellPid一致でdetectPattern | E-14 行107-109 | ○ |
| C-80 | shellPid不一致で全detector試行 | E-14 行113-118 | ○ |
| C-81 | ANSIエスケープ除去後検出 | E-14 行105 | ○ |
| C-82 | true返却で早期終了 | E-14 行109, 115-117 `return` | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースはソースコードに直接対応しており、信頼度は高い

### 注意が必要な領域
1. **非同期処理のテスト（UT-DSR-042, 049）**: `killOnServerStop`機能はPromise、CancellationToken、イベントリスナーの複雑な連携を含むため、モックの設計に注意が必要
2. **VS Code APIモック（全般）**: `vscode.debug`, `vscode.env`, `vscode.window`など多数のAPIをモック化する必要がある
3. **正規表現のテスト（UT-DSR-001〜007, 022〜027）**: ANSIエスケープシーケンスは多様なパターンがあるため、追加のエッジケースが存在する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 全82テストケースが対象クラス/メソッドを網羅しているか確認
- [ ] 高優先度（24件）のテストケースが重要なビジネスロジックをカバーしているか
- [ ] 異常系テストケースが適切なエラーハンドリングを検証しているか
- [ ] 境界値テストケースが空値、null、undefined等を適切にカバーしているか
- [ ] VS Code APIのモック戦略が実装可能か検討
- [ ] killOnServerStop連動停止機能の非同期テスト設計が適切か
- [ ] 正規表現関連テストで追加のエッジケースが必要か検討
