---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 133
  claims_with_evidence: 133
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-emmet 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の対応する関数・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要な関数・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：133 / 133、根拠なし：0
- 優先レビュー（高）
  1. **UT-EMT-001〜UT-EMT-008**：abbreviationActionsの主要機能（wrapWithAbbreviation, expandEmmetAbbreviation）
  2. **UT-EMT-119〜UT-EMT-124**：parseDocumentのキャッシュ機能
  3. **UT-EMT-125〜UT-EMT-130**：defaultCompletionProviderの補完機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/emmet/src/abbreviationActions.ts` - 略語展開・ラップ機能
- E-02: `extensions/emmet/src/util.ts` - ユーティリティ関数群
- E-03: `extensions/emmet/src/balance.ts` - バランス展開/縮小機能
- E-04: `extensions/emmet/src/updateTag.ts` - タグ更新機能
- E-05: `extensions/emmet/src/removeTag.ts` - タグ削除機能
- E-06: `extensions/emmet/src/toggleComment.ts` - コメント切替機能
- E-07: `extensions/emmet/src/editPoint.ts` - 編集ポイント移動機能
- E-08: `extensions/emmet/src/selectItem.ts` - 項目選択機能
- E-09: `extensions/emmet/src/selectItemHTML.ts` - HTML項目選択機能
- E-10: `extensions/emmet/src/selectItemStylesheet.ts` - CSS項目選択機能
- E-11: `extensions/emmet/src/matchTag.ts` - タグマッチ機能
- E-12: `extensions/emmet/src/splitJoinTag.ts` - タグ分割/結合機能
- E-13: `extensions/emmet/src/mergeLines.ts` - 行マージ機能
- E-14: `extensions/emmet/src/incrementDecrement.ts` - 数値増減機能
- E-15: `extensions/emmet/src/evaluateMathExpression.ts` - 数式評価機能
- E-16: `extensions/emmet/src/reflectCssValue.ts` - CSS値反映機能
- E-17: `extensions/emmet/src/updateImageSize.ts` - 画像サイズ更新機能
- E-18: `extensions/emmet/src/imageSizeHelper.ts` - 画像サイズ取得ヘルパー
- E-19: `extensions/emmet/src/locateFile.ts` - ファイルパス解決機能
- E-20: `extensions/emmet/src/bufferStream.ts` - ドキュメントストリームリーダー
- E-21: `extensions/emmet/src/parseDocument.ts` - ドキュメントパース・キャッシュ機能
- E-22: `extensions/emmet/src/defaultCompletionProvider.ts` - 補完プロバイダー
- E-23: `extensions/emmet/src/emmetCommon.ts` - 拡張機能エントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）

### abbreviationActions.ts（UT-EMT-001〜UT-EMT-013）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | wrapWithAbbreviationが略語でテキストをラップする | E-01 L32-262 | ○ |
| C-02 | wrapWithAbbreviationが複数選択に対応 | E-01 L50-101 | ○ |
| C-03 | 無効な略語でfalseを返す | E-01 L206-214 | ○ |
| C-04 | アクティブエディタなしでfalseを返す | E-01 L33-35 | ○ |
| C-05 | expandEmmetAbbreviationがEmmet略語を展開 | E-01 L264-418 | ○ |
| C-06 | CSS略語の展開 | E-01 L379-400 | ○ |
| C-07 | スペース前でフォールバック | E-01 L271-285 | ○ |
| C-08 | 行頭でフォールバック | E-01 L275-278 | ○ |
| C-09 | isValidLocationForEmmetAbbreviationの位置検証 | E-01 L436-618 | ○ |
| C-10 | コメント内の除外 | E-01 L438-441 | ○ |
| C-11 | scriptタグ内の処理 | E-01 L526-539 | ○ |
| C-12 | getSyntaxFromArgsのシンタックス取得 | E-01 L702-717 | ○ |
| C-13 | 除外言語の処理 | E-01 L706-709 | ○ |

### util.ts（UT-EMT-014〜UT-EMT-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | isStyleSheetのCSS判定 | E-02 L102-105 | ○ |
| C-15 | isStyleSheetのSCSS判定 | E-02 L103-104 | ○ |
| C-16 | isStyleSheetのHTML判定 | E-02 L102-105 | ○ |
| C-17 | validateのアクティブエディタ確認 | E-02 L107-117 | ○ |
| C-18 | validateのエディタなし処理 | E-02 L109-112 | ○ |
| C-19 | validateのスタイルシート制限 | E-02 L113-115 | ○ |
| C-20 | getEmmetModeのjsx-tags変換 | E-02 L153-155 | ○ |
| C-21 | getEmmetModeのsass-indented変換 | E-02 L164-166 | ○ |
| C-22 | getEmmetModeの除外言語処理 | E-02 L149-151 | ○ |
| C-23 | getMappingForIncludedLanguagesのマッピング | E-02 L119-138 | ○ |
| C-24 | getFlatNodeのノード取得 | E-02 L342-380 | ○ |
| C-25 | getFlatNodeのundefined処理 | E-02 L343-345 | ○ |
| C-26 | getFlatNodeの境界値処理 | E-02 L353-354 | ○ |
| C-27 | getHtmlFlatNodeのHTMLノード取得 | E-02 L388-404 | ○ |
| C-28 | getHtmlFlatNodeのscriptサブツリー | E-02 L393-398 | ○ |
| C-29 | getDeepestFlatNodeの最深ノード取得 | E-02 L468-478 | ○ |
| C-30 | getDeepestFlatNodeのリーフノード処理 | E-02 L469-471 | ○ |
| C-31 | findNextWordの単語検索 | E-02 L480-516 | ○ |
| C-32 | findNextWordの境界値 | E-02 L511-513 | ○ |
| C-33 | findPrevWordの逆方向検索 | E-02 L518-554 | ○ |
| C-34 | getNodesInBetweenの同一ノード | E-02 L556-560 | ○ |
| C-35 | getNodesInBetweenの兄弟ノード | E-02 L585-593 | ○ |
| C-36 | sameNodesの同位置判定 | E-02 L604 | ○ |
| C-37 | sameNodesのundefined判定 | E-02 L597-599 | ○ |
| C-38 | parsePartialStylesheetの部分パース | E-02 L189-337 | ○ |
| C-39 | parsePartialStylesheetの行数制限 | E-02 L291-293 | ○ |
| C-40 | offsetRangeToSelectionの座標変換 | E-02 L453-457 | ○ |
| C-41 | offsetRangeToVsRangeの座標変換 | E-02 L459-463 | ○ |
| C-42 | getEmmetConfigurationの設定取得 | E-02 L607-634 | ○ |
| C-43 | getEmmetConfigurationのjsx設定 | E-02 L612-623 | ○ |
| C-44 | updateEmmetExtensionsPathの拡張パス更新 | E-02 L37-53 | ○ |
| C-45 | migrateEmmetExtensionsPathの移行処理 | E-02 L59-81 | ○ |
| C-46 | getPathBaseNameのパス処理 | E-02 L725-729 | ○ |
| C-47 | getPathBaseNameのWindows対応 | E-02 L727-728 | ○ |
| C-48 | isOffsetInsideOpenOrCloseTagの開始タグ判定 | E-02 L443-451 | ○ |
| C-49 | isOffsetInsideOpenOrCloseTagの終了タグ判定 | E-02 L446 | ○ |
| C-50 | isOffsetInsideOpenOrCloseTagのタグ外判定 | E-02 L450 | ○ |

### balance.ts（UT-EMT-051〜UT-EMT-056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | balanceOutの外側選択 | E-03 L14-16 | ○ |
| C-52 | balanceInの内側選択 | E-03 L18-20 | ○ |
| C-53 | getRangeToBalanceOutの終了タグ処理 | E-03 L71-74 | ○ |
| C-54 | getRangeToBalanceInの内部選択 | E-03 L98-105 | ○ |
| C-55 | areSameSelectionsの同一選択判定 | E-03 L123-133 | ○ |
| C-56 | areSameSelectionsの長さ異常判定 | E-03 L124-126 | ○ |

### updateTag.ts（UT-EMT-057〜UT-EMT-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | updateTagのタグ名更新 | E-04 L16-54 | ○ |
| C-58 | updateTagの複数選択対応 | E-04 L28-31 | ○ |
| C-59 | updateTagのキャンセル処理 | E-04 L44-46 | ○ |
| C-60 | getRangesFromNodeの範囲取得 | E-04 L56-74 | ○ |

### removeTag.ts（UT-EMT-061〜UT-EMT-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | removeTagのタグ削除 | E-05 L11-31 | ○ |
| C-62 | removeTagの空白処理 | E-05 L66-68 | ○ |
| C-63 | removeTagのpre例外 | E-05 L66 | ○ |
| C-64 | calculateIndentAmountToRemoveのインデント計算 | E-05 L130-156 | ○ |

### toggleComment.ts（UT-EMT-065〜UT-EMT-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | toggleCommentのHTMLコメント化 | E-06 L17-53 | ○ |
| C-66 | toggleCommentのアンコメント | E-06 L86-88 | ○ |
| C-67 | toggleCommentStylesheetのCSSコメント化 | E-06 L115-154 | ○ |
| C-68 | setupCommentSpacingのスペース設定 | E-06 L156-169 | ○ |

### editPoint.ts（UT-EMT-069〜UT-EMT-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | fetchEditPointの次移動 | E-07 L9-22 | ○ |
| C-70 | fetchEditPointの前移動 | E-07 L17 | ○ |
| C-71 | findEditPointの空属性検索 | E-07 L56 | ○ |
| C-72 | findEditPointの空タグ検索 | E-07 L57 | ○ |

### selectItem.ts（UT-EMT-073〜UT-EMT-074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | fetchSelectItemの次項目選択 | E-08 L13-43 | ○ |
| C-74 | fetchSelectItemの前項目選択 | E-08 L33 | ○ |

### selectItemHTML.ts（UT-EMT-075〜UT-EMT-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | nextItemHTMLのタグ名選択 | E-09 L21-24 | ○ |
| C-76 | nextItemHTMLの属性選択 | E-09 L27-34 | ○ |
| C-77 | prevItemHTMLの前方選択 | E-09 L59-109 | ○ |

### selectItemStylesheet.ts（UT-EMT-078〜UT-EMT-079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | nextItemStylesheetのプロパティ値選択 | E-10 L21-25 | ○ |
| C-79 | prevItemStylesheetの前方選択 | E-10 L70-74 | ○ |

### matchTag.ts（UT-EMT-080〜UT-EMT-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | matchTagの開始から終了へジャンプ | E-11 L11-34 | ○ |
| C-81 | matchTagの終了から開始へジャンプ | E-11 L51 | ○ |
| C-82 | getUpdatedSelectionsの例外処理 | E-11 L44-48 | ○ |

### splitJoinTag.ts（UT-EMT-083〜UT-EMT-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | splitJoinTagのタグ分割 | E-12 L41-48 | ○ |
| C-84 | splitJoinTagのタグ結合 | E-12 L50-54 | ○ |
| C-85 | getRangesToReplaceのXHTML対応 | E-12 L56-61 | ○ |

### mergeLines.ts（UT-EMT-086〜UT-EMT-088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | mergeLinesの行マージ | E-13 L11-31 | ○ |
| C-87 | mergeLinesの単一行処理 | E-13 L55-57 | ○ |
| C-88 | getRangesToReplaceの複数ノード | E-13 L41-44 | ○ |

### incrementDecrement.ts（UT-EMT-089〜UT-EMT-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | incrementDecrementの数値増加 | E-14 L15-35 | ○ |
| C-90 | incrementDecrementの小数増加 | E-14 L43 | ○ |
| C-91 | incrementDecrementの数値減少 | E-14 L44 | ○ |
| C-92 | updateのパディング保持 | E-14 L46-50 | ○ |
| C-93 | updateの先頭ドット保持 | E-14 L52-55 | ○ |
| C-94 | locateの数値範囲検出 | E-14 L65-107 | ○ |
| C-95 | locateの負数検出 | E-14 L75-77 | ○ |
| C-96 | locateの小数点処理 | E-14 L78-80, L92-94 | ○ |

### evaluateMathExpression.ts（UT-EMT-097〜UT-EMT-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | evaluateMathExpressionの数式計算 | E-15 L11-50 | ○ |
| C-98 | evaluateMathExpressionの自動抽出 | E-15 L30-41 | ○ |
| C-99 | evaluateMathExpressionのエラー処理 | E-15 L43-47 | ○ |

### reflectCssValue.ts（UT-EMT-100〜UT-EMT-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | reflectCssValueのベンダープレフィックス反映 | E-16 L12-25 | ○ |
| C-101 | updateCSSNodeの同名プロパティ更新 | E-16 L27-55 | ○ |

### updateImageSize.ts（UT-EMT-102〜UT-EMT-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | updateImageSizeのimgタグ処理 | E-17 L20-44 | ○ |
| C-103 | updateImageSizeのCSS background-image処理 | E-17 L94-96 | ○ |
| C-104 | updateHTMLTagの属性更新 | E-17 L184-214 | ○ |
| C-105 | updateCSSNodeのプロパティ追加 | E-17 L219-250 | ○ |

### imageSizeHelper.ts（UT-EMT-106〜UT-EMT-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | getImageSizeのローカルファイル処理 | E-18 L27-30 | ○ |
| C-107 | getImageSizeのURL画像処理 | E-18 L29 | ○ |
| C-108 | getImageSizeのデータURL処理 | E-18 L37-47 | ○ |
| C-109 | sizeForFileNameのスケール処理 | E-18 L108-122 | ○ |

### locateFile.ts（UT-EMT-110〜UT-EMT-112）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | locateFileの相対パス解決 | E-19 L40-42 | ○ |
| C-111 | locateFileの絶対パス解決 | E-19 L48-66 | ○ |
| C-112 | locateFileのURL処理 | E-19 L25-28 | ○ |

### bufferStream.ts（UT-EMT-113〜UT-EMT-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | DocumentStreamReaderのSOF判定 | E-20 L31-33 | ○ |
| C-114 | DocumentStreamReaderのEOF判定 | E-20 L38-40 | ○ |
| C-115 | peekの文字コード返却 | E-20 L53-58 | ○ |
| C-116 | nextの次文字進行 | E-20 L64-78 | ○ |
| C-117 | backUpの後退処理 | E-20 L84-90 | ○ |
| C-118 | eatのマッチ消費 | E-20 L121-130 | ○ |

### parseDocument.ts（UT-EMT-119〜UT-EMT-124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | getRootNodeのドキュメントパース | E-21 L20-36 | ○ |
| C-120 | getRootNodeのキャッシュ利用 | E-21 L24-28 | ○ |
| C-121 | getRootNodeのキャッシュ無効化 | E-21 L25-27 | ○ |
| C-122 | addFileToParseCacheのキャッシュ追加 | E-21 L38-41 | ○ |
| C-123 | removeFileFromParseCacheのキャッシュ削除 | E-21 L43-46 | ○ |
| C-124 | clearParseCacheのキャッシュクリア | E-21 L48-50 | ○ |

### defaultCompletionProvider.ts（UT-EMT-125〜UT-EMT-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | provideCompletionItemsの補完候補返却 | E-22 L17-41 | ○ |
| C-126 | provideCompletionItemsの除外言語処理 | E-22 L45-48 | ○ |
| C-127 | provideCompletionItemsのstyleタグ内補完 | E-22 L113-116 | ○ |
| C-128 | provideCompletionItemsのstyle属性内補完 | E-22 L117-122 | ○ |
| C-129 | provideCompletionItemsのコメント除外 | E-22 L70-73 | ○ |
| C-130 | provideCompletionItemsのノイズ防止 | E-22 L169-180 | ○ |

### emmetCommon.ts（UT-EMT-131〜UT-EMT-133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | activateEmmetExtensionの有効化 | E-23 L24-155 | ○ |
| C-132 | refreshCompletionProvidersのプロバイダー登録 | E-23 L163-226 | ○ |
| C-133 | deactivateの無効化 | E-23 L236-239 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコード内の実装に基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全てのテストケースがソースコードに直接対応
- 注意点:
  - vscode APIのモック化が必要なテストが多い
  - 外部ライブラリ（@emmetio/html-matcher, @emmetio/css-parser）に依存する機能あり
  - ファイルシステムアクセスを伴うテスト（locateFile, imageSizeHelper）は統合テスト的な側面も

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-EMT-001〜008, 119〜124, 125〜130）の妥当性確認
- [ ] vscode APIモック化の方針確認
- [ ] 外部ライブラリ依存テストの取り扱い確認
- [ ] ファイルI/Oを伴うテストの実行環境確認
- [ ] テストID命名規則（UT-EMT-XXX）の一貫性確認
