---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 107
  claims_with_evidence: 107
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-extension-editing単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の該当メソッド・機能が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要な機能をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：107 / 107、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/extension-editing/src/extensionEditingMain.ts`（メインエントリポイント、activate関数、プロバイダー登録）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/extension-editing/src/extensionLinter.ts`（ExtensionLinterクラス、診断ロジック、parseUri、parseImplicitActivationEvents、isTrustedSVGSource）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/extension-editing/src/extensionEngineValidation.ts`（isValidVersionStr、parseVersion、normalizeVersion）
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/extension-editing/src/packageDocumentHelper.ts`（PackageDocumentクラス、補完・コードアクション提供）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/extension-editing/src/jsonReconstruct.ts`（JsonStringScannerクラス、オフセット計算）
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/extension-editing/src/constants.ts`（定数定義、エラーメッセージ）
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/extension-editing/package.json`（パッケージ設定、依存関係）

## 3) Claims と根拠の対応（レビューの主戦場）

### ExtensionLinterクラス（UT-EXE-001〜UT-EXE-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExtensionLinter.constructorでイベントリスナーが登録される | E-02 (L73-82) | ○ |
| C-02 | ExtensionLinter.queueがpackage.jsonをキューに追加する | E-02 (L85-92) | ○ |
| C-03 | ExtensionLinter.queueReadmeがREADME/CHANGELOGをキューに追加する | E-02 (L94-100) | ○ |
| C-04 | ExtensionLinter.startTimerがデバウンス処理を行う | E-02 (L102-110) | ○ |
| C-05 | ExtensionLinter.lintが両方のリント処理を並列実行する | E-02 (L112-117) | ○ |
| C-06 | ExtensionLinter.lintPackageJsonがpackage.jsonを検証する | E-02 (L119-201) | ○ |
| C-07 | lintPackageJsonがiconフィールドを検証する | E-02 (L132-135) | ○ |
| C-08 | lintPackageJsonがbadgesフィールドを検証する | E-02 (L137-142) | ○ |
| C-09 | lintPackageJsonがenabledApiProposalsを検証する | E-02 (L144-160) | ○ |
| C-10 | lintPackageJsonがactivationEventsを検証する | E-02 (L161-194) | ○ |
| C-11 | lintWhenClausesがwhen/enablement句を検証する | E-02 (L204-270) | ○ |
| C-12 | lintReadmeがREADME内の画像URLを検証する | E-02 (L272-373) | ○ |
| C-13 | locateTokenがトークン位置を特定する | E-02 (L376-392) | ○ |
| C-14 | readPackageJsonInfoがpackage.json情報を読み取る | E-02 (L394-415) | ○ |
| C-15 | loadPackageJsonがファイルを読み込みパースする | E-02 (L417-428) | ○ |
| C-16 | packageJsonChangedがキャッシュをクリアする | E-02 (L430-435) | ○ |
| C-17 | getUriFolderがURIの親ディレクトリを取得する | E-02 (L437-439) | ○ |
| C-18 | addDiagnosticsが診断を追加する | E-02 (L441-474) | ○ |
| C-19 | clearが診断とキューをクリアする | E-02 (L476-479) | ○ |
| C-20 | disposeがリソースを解放する | E-02 (L481-484) | ○ |

### ユーティリティ関数（UT-EXE-041〜UT-EXE-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | parseUriがURLをパースする | E-02 (L487-498) | ○ |
| C-22 | parseImplicitActivationEventsがイベントを抽出する | E-02 (L500-598) | ○ |
| C-23 | isTrustedSVGSourceが信頼性を判定する | E-02 (L25-27) | ○ |

### バージョン検証関数（UT-EXE-058〜UT-EXE-074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | isValidVersionStrがバージョン文字列を検証する | E-03 (L34-37) | ○ |
| C-25 | parseVersionがバージョンをパースする | E-03 (L39-75) | ○ |
| C-26 | normalizeVersionがバージョンを正規化する | E-03 (L77-117) | ○ |

### JsonStringScannerクラス（UT-EXE-075〜UT-EXE-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | JsonStringScanner.constructorが初期化する | E-05 (L11-22) | ○ |
| C-28 | getOffsetInEncodedがエンコード済みオフセットを計算する | E-05 (L25-66) | ○ |
| C-29 | scanHexDigitsが16進数をスキャンする | E-05 (L68-92) | ○ |

### PackageDocumentクラス（UT-EXE-086〜UT-EXE-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | PackageDocument.constructorがドキュメントを設定する | E-04 (L11-13) | ○ |
| C-31 | provideCompletionItemsが補完アイテムを提供する | E-04 (L15-23) | ○ |
| C-32 | provideLanguageOverridesCompletionItemsが言語補完を提供する | E-04 (L43-83) | ○ |
| C-33 | provideCodeActionsがコードアクションを提供する | E-04 (L25-41) | ○ |
| C-34 | getReplaceRangeが置換範囲を計算する | E-04 (L85-94) | ○ |
| C-35 | newSimpleCompletionItemが補完アイテムを作成する | E-04 (L96-103) | ○ |
| C-36 | newSnippetCompletionItemがスニペット補完を作成する | E-04 (L105-112) | ○ |

### アクティベーション関数（UT-EXE-103〜UT-EXE-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | activateがプロバイダーを登録する | E-01 (L10-19) | ○ |
| C-38 | registerPackageDocumentCompletionsが補完プロバイダーを登録する | E-01 (L21-27) | ○ |
| C-39 | registerCodeActionsProviderがコードアクションプロバイダーを登録する | E-01 (L29-35) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのテストケースはソースコードの実装に基づいて生成されており、根拠が存在します。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - すべてのテストケースが実際のソースコードに基づいており、信頼度は高い
  - テストケースの入力値・期待結果は実装ロジックから導出されている

### 追加考慮事項
- **依存関係のモック**: ExtensionLinterはVS Code API（workspace、languages、commands）に依存しているため、テスト時にはこれらのモックが必要
- **非同期処理**: lintReadmeやlintPackageJsonは非同期処理を含むため、テストでは適切なawait処理が必要
- **外部ファイル読み込み**: product.jsonの読み込みがあるため、テスト環境での設定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ExtensionLinterの診断ロジック（UT-EXE-009〜UT-EXE-022）が実際のVS Code拡張機能の要件を反映しているか確認
- [ ] バージョン検証関数（UT-EXE-058〜UT-EXE-074）のテストケースがsemverの仕様に準拠しているか確認
- [ ] JsonStringScannerのエスケープ処理（UT-EXE-076〜UT-EXE-085）がJSON仕様に準拠しているか確認
- [ ] PackageDocumentの補完ロジック（UT-EXE-087〜UT-EXE-092）がVS Codeの補完API仕様に準拠しているか確認
- [ ] when/enablement句の検証（UT-EXE-016〜UT-EXE-018）がVS Codeの条件構文仕様に準拠しているか確認
