---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 128
  claims_with_evidence: 125
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：ext-git 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：125 / 128、根拠なし：3
- 優先レビュー（高）
  1. **UT-GIT-091 fromNow関数のl10n対応**：多言語対応の実装詳細を確認する必要あり
  2. **UT-GIT-092 getCommitShortHash設定値**：設定値のデフォルト値に関する確認が必要
  3. **UT-GIT-124 blameテンプレートトークン**：全トークンの網羅性を確認する必要あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/git/src/git.ts` - Gitクラス、GitError、GitStatusParser、GitConfigParser、パーサー関数群
- E-02: `extensions/git/src/repository.ts` - Repositoryクラス、Resourceクラス、ProgressManager、FileEventLogger
- E-03: `extensions/git/src/util.ts` - ユーティリティ関数群（dispose, filterEvent, isDescendant, pathEquals等）
- E-04: `extensions/git/src/uri.ts` - URI変換関数群（isGitUri, fromGitUri, toGitUri, toMergeUris）
- E-05: `extensions/git/src/model.ts` - Modelクラス、ClosedRepositoriesManager、UnsafeRepositoriesManager
- E-06: `extensions/git/src/staging.ts` - ステージング関連関数（applyLineChanges, toLineRanges等）
- E-07: `extensions/git/src/cache.ts` - LinkedMap、LRUCacheクラス
- E-08: `extensions/git/src/decorators.ts` - デコレータ（memoize, throttle, sequentialize, debounce）
- E-09: `extensions/git/src/operation.ts` - OperationKind列挙型、Operation型、OperationManager
- E-10: `extensions/git/src/historyProvider.ts` - GitHistoryProviderクラス
- E-11: `extensions/git/src/repositoryCache.ts` - RepositoryCacheクラス
- E-12: `extensions/git/src/blame.ts` - GitBlameController、blameフォーマット関数群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parseVersionがgit versionプレフィックスを除去する | E-01 (line 75-77) | ○ |
| C-02 | findSpecificGitがパス検証とバージョン取得を行う | E-01 (line 79-91) | ○ |
| C-03 | findSpecificGitが無効パスでエラーをスローする | E-01 (line 81-82) | ○ |
| C-04 | compareGitVersionToがVersions.compareを使用する | E-01 (line 416-418) | ○ |
| C-05 | initがgit initコマンドを実行する | E-01 (line 424-432) | ○ |
| C-06 | initがGit 2.28.0以上で-bオプションをサポートする | E-01 (line 427-429) | ○ |
| C-07 | cloneが進捗報告とキャンセルをサポートする | E-01 (line 434-498) | ○ |
| C-08 | cloneがrecursiveオプションをサポートする | E-01 (line 477-478) | ○ |
| C-09 | cloneがエラー時にstderrを整形する | E-01 (line 488-494) | ○ |
| C-10 | getRepositoryRootがrev-parseを使用する | E-01 (line 500-554) | ○ |
| C-11 | getRepositoryRootが非リポジトリでエラーをスローする | E-01 (line 328-334) | ○ |
| C-12 | getRepositoryDotGitがdotGit情報を返す | E-01 (line 556-589) | ○ |
| C-13 | execがSpawnOptionsをサポートする | E-01 (line 591-594) | ○ |
| C-14 | execがGitErrorをスローする | E-01 (line 657-667) | ○ |
| C-15 | execがCancellationTokenをサポートする | E-01 (line 247-261) | ○ |
| C-16 | spawnがChildProcessを返す | E-01 (line 672-699) | ○ |
| C-17 | spawnがパス未設定でエラーをスローする | E-01 (line 673-675) | ○ |
| C-18 | mergeFileがファイルをマージする | E-01 (line 718-737) | ○ |
| C-19 | mergeFileがコンフリクト時も結果を返す | E-01 (line 729-736) | ○ |
| C-20 | addSafeDirectoryがgit configを更新する | E-01 (line 739-742) | ○ |
| C-21 | GitErrorがIGitErrorDataでプロパティを設定する | E-01 (line 282-302) | ○ |
| C-22 | GitError.toStringがJSON形式で出力する | E-01 (line 304-318) | ○ |
| C-23 | GitStatusParserがステータスをパースする | E-01 (line 811-875) | ○ |
| C-24 | GitStatusParserがリネームを検出する | E-01 (line 849-858) | ○ |
| C-25 | GitStatusParserが空入力で空配列を返す | E-01 (line 833-836) | ○ |
| C-26 | GitConfigParserが設定をパースする | E-01 (line 773-808) | ○ |
| C-27 | GitConfigParserがサブセクションをパースする | E-01 (line 790-795) | ○ |
| C-28 | parseGitmodulesがサブモジュールをパースする | E-01 (line 883-897) | ○ |
| C-29 | parseGitRemotesがリモートをパースする | E-01 (line 899-914) | ○ |
| C-30 | parseGitCommitsがコミットをパースする | E-01 (line 918-959) | ○ |
| C-31 | parseGitCommitsがshortStatをパースする | E-01 (line 954-955) | ○ |
| C-32 | parseLsTreeがツリー出力をパースする | E-01 (line 982-988) | ○ |
| C-33 | parseLsFilesがファイル一覧をパースする | E-01 (line 997-1001) | ○ |
| C-34 | getGitErrorCodeが認証エラーを検出する | E-01 (line 331-332) | ○ |
| C-35 | getGitErrorCodeがロックエラーを検出する | E-01 (line 329-330) | ○ |
| C-36 | getGitErrorCodeが未知エラーでundefinedを返す | E-01 (line 362) | ○ |
| C-37 | Resource.getStatusLetterがステータス文字を返す | E-02 (line 54-87) | ○ |
| C-38 | Resource.getStatusLetterがコンフリクトで!を返す | E-02 (line 76-83) | ○ |
| C-39 | Resource.getStatusTextがステータステキストを返す | E-02 (line 89-112) | ○ |
| C-40 | Resource.getStatusColorがThemeColorを返す | E-02 (line 114-147) | ○ |
| C-41 | Resource.resourceUriがURIを返す | E-02 (line 149-156) | ○ |
| C-42 | Resource.cloneがリソースを複製する | E-02 (line 340-342) | ○ |
| C-43 | Repository.statusがリポジトリ状態を更新する | E-02 (line 699-859) | ○ |
| C-44 | Repository.HEADがBranchを返す | E-02 (line 749-752) | ○ |
| C-45 | Repository.headShortNameがブランチ名を返す | E-02 (line 759-771) | ○ |
| C-46 | Repository.headShortNameがdetached HEADでハッシュを返す | E-02 (line 770) | ○ |
| C-47 | rebaseCommit設定時にinputBoxが更新される | E-02 (line 790-803) | ○ |
| C-48 | mergeInProgressがコンテキストを設定する | E-02 (line 809-818) | ○ |
| C-49 | cherryPickInProgressがコンテキストを設定する | E-02 (line 824-833) | ○ |
| C-50 | Model.openRepositoryがリポジトリを開く | E-05 (line 574-681) | ○ |
| C-51 | Model.openRepositoryが重複を防止する | E-05 (line 577-580) | ○ |
| C-52 | Model.openRepositoryが無効パスで開かない | E-05 (line 583-588) | ○ |
| C-53 | Model.getRepositoryがURIからリポジトリを取得する | E-05 (line 186-201) | ○ |
| C-54 | Model.getRepositoryがリポジトリ外でundefinedを返す | E-05 (line 186-201) | ○ |
| C-55 | ClosedRepositoriesManager.addRepositoryがリポジトリを追加する | E-05 (line 76-79) | ○ |
| C-56 | ClosedRepositoriesManager.isRepositoryClosedが検出する | E-05 (line 90-92) | ○ |
| C-57 | UnsafeRepositoriesManager.addRepositoryがリポジトリを追加する | E-05 (line 159-162) | ○ |
| C-58 | UnsafeRepositoriesManager.hasRepositoryが検出する | E-05 (line 177-179) | ○ |
| C-59 | isGitUriがgit URIを判定する | E-04 (line 15-17) | ○ |
| C-60 | isGitUriが非git URIでfalseを返す | E-04 (line 15-17) | ○ |
| C-61 | fromGitUriがパラメータを抽出する | E-04 (line 19-21) | ○ |
| C-62 | toGitUriがURIを変換する | E-04 (line 32-51) | ○ |
| C-63 | toGitUriがreplaceFileExtensionをサポートする | E-04 (line 44-45) | ○ |
| C-64 | toMergeUrisがマージ用URIを生成する | E-04 (line 56-62) | ○ |
| C-65 | toMultiFileDiffEditorUrisがdiff URIを生成する | E-04 (line 64-87) | ○ |
| C-66 | disposeがDisposable配列を破棄する | E-03 (line 31-34) | ○ |
| C-67 | toDisposableが関数からDisposableを作成する | E-03 (line 36-38) | ○ |
| C-68 | filterEventがイベントをフィルタリングする | E-03 (line 50-52) | ○ |
| C-69 | debounceEventがイベントをデバウンスする | E-03 (line 86-94) | ○ |
| C-70 | onceEventがイベントを1回だけ発火する | E-03 (line 75-84) | ○ |
| C-71 | eventToPromiseがイベントをPromiseに変換する | E-03 (line 96-98) | ○ |
| C-72 | assignがオブジェクトをマージする | E-03 (line 112-119) | ○ |
| C-73 | uniqByが配列を一意化する | E-03 (line 121-134) | ○ |
| C-74 | groupByが配列をグループ化する | E-03 (line 136-142) | ○ |
| C-75 | mkdirpがディレクトリを再帰的に作成する | E-03 (line 148-184) | ○ |
| C-76 | mkdirpが既存ディレクトリで成功する | E-03 (line 153-158) | ○ |
| C-77 | isDescendantが子孫パスを判定する | E-03 (line 325-340) | ○ |
| C-78 | isDescendantが非子孫パスでfalseを返す | E-03 (line 325-340) | ○ |
| C-79 | pathEqualsがパスの同一性を判定する | E-03 (line 342-344) | ○ |
| C-80 | relativePathが相対パスを取得する | E-03 (line 352-354) | ○ |
| C-81 | splitInChunksが配列をチャンクに分割する | E-03 (line 372-392) | ○ |
| C-82 | detectUnicodeEncodingがUTF-8 BOMを検出する | E-03 (line 289-296) | ○ |
| C-83 | detectUnicodeEncodingがUTF-16 LEを検出する | E-03 (line 280-282) | ○ |
| C-84 | detectUnicodeEncodingが短いバッファでnullを返す | E-03 (line 271-273) | ○ |
| C-85 | Versions.compareがバージョンを比較する | E-03 (line 506-531) | ○ |
| C-86 | Versions.fromStringがバージョン文字列をパースする | E-03 (line 542-547) | ○ |
| C-87 | Limiter.queueが並列実行数を制限する | E-03 (line 433-458) | ○ |
| C-88 | PromiseSource.resolveがPromiseを解決する | E-03 (line 481-485) | ○ |
| C-89 | PromiseSource.rejectがPromiseを拒否する | E-03 (line 487-492) | ○ |
| C-90 | deltaHistoryItemRefsが差分を計算する | E-03 (line 549-602) | ○ |
| C-91 | fromNowが相対時刻を返す | E-03 (line 620-796) | △ |
| C-92 | getCommitShortHashが短いハッシュを取得する | E-03 (line 798-802) | △ |
| C-93 | applyLineChangesが行変更を適用する | E-06 (line 16-58) | ○ |
| C-94 | toLineRangesが選択範囲を行範囲に変換する | E-06 (line 60-93) | ○ |
| C-95 | getModifiedRangeが変更範囲を取得する | E-06 (line 95-107) | ○ |
| C-96 | intersectDiffWithRangeが差分と範囲の交差を取得する | E-06 (line 109-143) | ○ |
| C-97 | invertLineChangeが行変更を反転する | E-06 (line 145-152) | ○ |
| C-98 | LinkedMap.setが要素を追加する | E-07 (line 77-104) | ○ |
| C-99 | LinkedMap.getが要素を取得する | E-07 (line 66-75) | ○ |
| C-100 | LinkedMap.deleteが要素を削除する | E-07 (line 106-108) | ○ |
| C-101 | LinkedMap.shiftが先頭要素を取り出す | E-07 (line 121-133) | ○ |
| C-102 | LinkedMap.clearが全要素を削除する | E-07 (line 38-44) | ○ |
| C-103 | LRUCache.setがlimit超過時に古い要素を削除する | E-07 (line 470-485) | ○ |
| C-104 | LRUCache.getがrecencyを更新する | E-07 (line 448-450) | ○ |
| C-105 | memoizeが関数結果をキャッシュする | E-08 (line 17-32) | ○ |
| C-106 | throttleが連続呼び出しをスロットルする | E-08 (line 36-63) | ○ |
| C-107 | sequentializeが呼び出しを順序化する | E-08 (line 67-76) | ○ |
| C-108 | debounceが呼び出しをデバウンスする | E-08 (line 80-89) | ○ |
| C-109 | OperationManager.startがオペレーションを開始する | E-09 (line 215-223) | ○ |
| C-110 | OperationManager.endがオペレーションを終了する | E-09 (line 225-235) | ○ |
| C-111 | OperationManager.isRunningが実行中を検出する | E-09 (line 256-258) | ○ |
| C-112 | OperationManager.isIdleがアイドル状態を検出する | E-09 (line 242-254) | ○ |
| C-113 | OperationManager.shouldDisableCommandsがブロッキングを検出する | E-09 (line 260-272) | ○ |
| C-114 | OperationManager.shouldShowProgressが進捗表示を検出する | E-09 (line 274-286) | ○ |
| C-115 | GitHistoryProvider.provideHistoryItemRefsが履歴参照を提供する | E-10 (line 224-246) | ○ |
| C-116 | GitHistoryProvider.provideHistoryItemsが履歴アイテムを提供する | E-10 (line 248-335) | ○ |
| C-117 | GitHistoryProvider.provideHistoryItemChangesが変更を提供する | E-10 (line 337-367) | ○ |
| C-118 | GitHistoryProvider.resolveHistoryItemが履歴アイテムを解決する | E-10 (line 369-421) | ○ |
| C-119 | GitHistoryProvider.provideFileDecorationがデコレーションを提供する | E-10 (line 485-487) | ○ |
| C-120 | RepositoryCache.setがキャッシュを設定する | E-11 (line 61-77) | ○ |
| C-121 | RepositoryCache.getがキャッシュを取得する | E-11 (line 126-130) | ○ |
| C-122 | RepositoryCache.deleteがキャッシュを削除する | E-11 (line 132-148) | ○ |
| C-123 | RepositoryCache.normalizeRepoUrlがURLを正規化する | E-11 (line 29-36) | ○ |
| C-124 | GitBlameController.formatBlameInformationMessageがフォーマットする | E-12 (line 191-207) | △ |
| C-125 | mapModifiedLineNumberToOriginalLineNumberが行番号をマップする | E-12 (line 28-60) | ○ |
| C-126 | mapModifiedLineNumberToOriginalLineNumberが追加行で減少する | E-12 (line 40-43) | ○ |
| C-127 | mapModifiedLineNumberToOriginalLineNumberが削除行で増加する | E-12 (line 43-46) | ○ |
| C-128 | lineRangesContainLineが行範囲を判定する | E-12 (line 20-22) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-91 (fromNow)**: l10n（多言語化）の詳細な動作について、実際の翻訳ファイルの確認が必要
  - 候補：extensions/git/l10n/*.json / VSCode l10n ドキュメント
- **C-92 (getCommitShortHash)**: デフォルト値7の根拠と設定可能な範囲の確認が必要
  - 候補：settings.json スキーマ / package.json contributes
- **C-124 (formatBlameInformationMessage)**: テンプレートトークンの完全なリストと各トークンの動作確認
  - 候補：BlameInformationTemplateTokens型定義の網羅性確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- **1: 中リスク** - Git外部プロセスに依存するテスト（UT-GIT-007〜009等）は環境依存性がある
- **1: 中リスク** - 非同期処理のテスト（throttle, debounce, sequentialize）はタイミング依存性がある
- **0: 低リスク** - パーサー系テストは入出力が明確で、モックなしでテスト可能

## 6) レビュアーチェックリスト（最小）
- [ ] Git操作関連テスト（UT-GIT-001〜020）のモック戦略は適切か
- [ ] ファイルシステム操作（mkdirp等）のモック方針を確認
- [ ] 非同期処理テストのタイムアウト設定を確認
- [ ] エラーハンドリングテストのエッジケースカバレッジを確認
- [ ] LRUCache等のデータ構造テストの境界値テストを確認
- [ ] l10n依存テストのロケール設定方針を確認
