---
generated_at: 2026-01-27 15:30:00
metrics:
  claims_total: 128
  claims_with_evidence: 128
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-github 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが実在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：128 / 128、根拠なし：0
- 優先レビュー（高）
  1. **UT-GH-041〜UT-GH-047（認証関連）**：外部依存（GitHub API）のモック戦略を要確認
  2. **UT-GH-074〜UT-GH-078（プッシュエラーハンドラ）**：複雑なエラー処理フローの網羅性確認
  3. **UT-GH-101〜UT-GH-105（アバター取得）**：キャッシュ・認証・GraphQLの統合テスト考慮

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/github/src/util.ts` - DisposableStore, getRepositoryFromUrl, getRepositoryFromQuery, repositoryHasGitHubRemote, getRepositoryDefaultRemoteUrl, getRepositoryDefaultRemote, groupBy, sequentialize
- E-02: `extensions/github/src/links.ts` - rangeString, notebookCellRangeString, encodeURIComponentExceptSlashes, isFileInRepo, getRepositoryForFile, getVscodeDevHost, getAvatarLink, getBranchLink, getCommitLink, getLink, ensurePublished
- E-03: `extensions/github/src/auth.ts` - getAgent, getSession, getOctokit, AuthenticationError, OctokitService
- E-04: `extensions/github/src/credentialProvider.ts` - GitHubCredentialProvider, GithubCredentialProviderManager
- E-05: `extensions/github/src/publish.ts` - sanitizeRepositoryName, getPick, publishRepository
- E-06: `extensions/github/src/remoteSourceProvider.ts` - asRemoteSource, GithubRemoteSourceProvider
- E-07: `extensions/github/src/remoteSourcePublisher.ts` - GithubRemoteSourcePublisher
- E-08: `extensions/github/src/pushErrorHandler.ts` - isInCodespaces, findPullRequestTemplates, pickPullRequestTemplate, GithubPushErrorHandler, CommandErrorOutputTextDocumentContentProvider
- E-09: `extensions/github/src/branchProtection.ts` - GitHubBranchProtectionProviderManager, GitHubBranchProtectionProvider
- E-10: `extensions/github/src/canonicalUriProvider.ts` - GitHubCanonicalUriProvider, toHttpsGitHubRemote
- E-11: `extensions/github/src/shareProviders.ts` - VscodeDevShareProvider, getRangeSegment
- E-12: `extensions/github/src/historyItemDetailsProvider.ts` - GitHubSourceControlHistoryItemDetailsProvider, getUserIdFromNoReplyEmail, compareAvatarQuery
- E-13: `extensions/github/src/commands.ts` - copyVscodeDevLink, openVscodeDevLink, openOnGitHub, registerCommands
- E-14: `extensions/github/src/extension.ts` - activate, initializeGitBaseExtension, initializeGitExtension, setGitHubContext

## 3) Claims と根拠の対応（レビューの主戦場）

### util.ts関連（UT-GH-001〜UT-GH-017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DisposableStore.addでDisposableが追加される | E-01 (L13-15) | ○ |
| C-02 | DisposableStore.disposeで全Disposableが破棄される | E-01 (L17-23) | ○ |
| C-03 | DisposableStore.dispose空でもエラーなし | E-01 (L17-23) | ○ |
| C-04 | getRepositoryFromUrlでHTTPS URL解析 | E-01 (L62-66) | ○ |
| C-05 | getRepositoryFromUrlでSSH URL解析 | E-01 (L63-64) | ○ |
| C-06 | getRepositoryFromUrl .gitなしでも動作 | E-01 (L63) | ○ |
| C-07 | getRepositoryFromUrl不正URLでundefined | E-01 (L65) | ○ |
| C-08 | getRepositoryFromUrl空文字でundefined | E-01 (L63-65) | ○ |
| C-09 | getRepositoryFromQuery正常解析 | E-01 (L68-71) | ○ |
| C-10 | getRepositoryFromQuery不正形式でundefined | E-01 (L69-70) | ○ |
| C-11 | repositoryHasGitHubRemoteでtrue | E-01 (L73-75) | ○ |
| C-12 | repositoryHasGitHubRemoteでfalse | E-01 (L74) | ○ |
| C-13 | getRepositoryDefaultRemoteUrl順序取得 | E-01 (L77-96) | ○ |
| C-14 | getRepositoryDefaultRemoteUrlフォールバック | E-01 (L94-95) | ○ |
| C-15 | getRepositoryDefaultRemoteUrlリモートなし | E-01 (L81-83) | ○ |
| C-16 | groupBy正常グループ化 | E-01 (L48-60) | ○ |
| C-17 | groupBy空配列 | E-01 (L48-60) | ○ |

### links.ts関連（UT-GH-018〜UT-GH-037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | rangeString単一行 | E-02 (L95-104) | ○ |
| C-19 | rangeString複数行 | E-02 (L100-103) | ○ |
| C-20 | rangeString undefined | E-02 (L96-98) | ○ |
| C-21 | notebookCellRangeStringインデックスのみ | E-02 (L106-120) | ○ |
| C-22 | notebookCellRangeString両方 | E-02 (L115-118) | ○ |
| C-23 | notebookCellRangeString indexがundefined | E-02 (L107-109) | ○ |
| C-24 | encodeURIComponentExceptSlashesスラッシュ保持 | E-02 (L122-130) | ○ |
| C-25 | encodeURIComponentExceptSlashes特殊文字エンコード | E-02 (L129) | ○ |
| C-26 | isFileInRepo内部ファイル | E-02 (L10-14) | ○ |
| C-27 | isFileInRepo外部ファイル | E-02 (L11-13) | ○ |
| C-28 | getRepositoryForFile取得成功 | E-02 (L16-23) | ○ |
| C-29 | getRepositoryForFile取得失敗 | E-02 (L22) | ○ |
| C-30 | getVscodeDevHost通常版 | E-02 (L202-204) | ○ |
| C-31 | getVscodeDevHost Insiders版 | E-02 (L203) | ○ |
| C-32 | getAvatarLink生成 | E-02 (L179-181) | ○ |
| C-33 | getBranchLink生成 | E-02 (L183-191) | ○ |
| C-34 | getBranchLink特殊文字 | E-02 (L189) | ○ |
| C-35 | getBranchLink不正URL | E-02 (L185-187) | ○ |
| C-36 | getCommitLink生成 | E-02 (L193-200) | ○ |
| C-37 | getCommitLink不正URL | E-02 (L195-197) | ○ |

### auth.ts関連（UT-GH-038〜UT-GH-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | getAgent HTTPS_PROXY未設定 | E-03 (L16-19) | ○ |
| C-39 | getAgent HTTPS_PROXY設定あり | E-03 (L21-24) | ○ |
| C-40 | getAgent不正プロキシURL | E-03 (L25-28) | ○ |
| C-41 | getSession認証セッション取得 | E-03 (L33-35) | ○ |
| C-42 | getOctokit取得 | E-03 (L39-59) | ○ |
| C-43 | getOctokitキャッシュ再利用 | E-03 (L40) | ○ |
| C-44 | AuthenticationErrorコンストラクタ | E-03 (L14) | ○ |
| C-45 | OctokitService.getOctokitGraphql取得 | E-03 (L80-109) | ○ |
| C-46 | OctokitService.getOctokitGraphqlキャッシュ | E-03 (L81, L107-108) | ○ |
| C-47 | OctokitService.getOctokitGraphql未認証エラー | E-03 (L85-87) | ○ |
| C-48 | OctokitService.onDidChangeSessions | E-03 (L71-76) | ○ |
| C-49 | OctokitService.dispose | E-03 (L111-114) | ○ |

### credentialProvider.ts関連（UT-GH-050〜UT-GH-056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | GitHubCredentialProvider github.com | E-04 (L14-21) | ○ |
| C-51 | GitHubCredentialProvider github.com以外 | E-04 (L15-17) | ○ |
| C-52 | GithubCredentialProviderManagerコンストラクタ | E-04 (L44-52) | ○ |
| C-53 | GithubCredentialProviderManager enabled有効化 | E-04 (L37-38) | ○ |
| C-54 | GithubCredentialProviderManager enabled無効化 | E-04 (L39-40) | ○ |
| C-55 | GithubCredentialProviderManager refresh | E-04 (L54-58) | ○ |
| C-56 | GithubCredentialProviderManager dispose | E-04 (L60-63) | ○ |

### publish.ts関連（UT-GH-057〜UT-GH-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | sanitizeRepositoryName置換 | E-05 (L14-16) | ○ |
| C-58 | sanitizeRepositoryName空白除去 | E-05 (L15) | ○ |
| C-59 | publishRepositoryワークスペースなし | E-05 (L26-28) | ○ |
| C-60 | publishRepositoryリポジトリ指定 | E-05 (L32-33) | ○ |

### remoteSourceProvider.ts関連（UT-GH-061〜UT-GH-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | getRemoteSourcesクエリなし | E-06 (L40-66) | ○ |
| C-62 | getRemoteSources GitHub URL | E-06 (L43-49) | ○ |
| C-63 | getRemoteSources検索クエリ | E-06 (L52-55) | ○ |
| C-64 | getBranches取得 | E-06 (L96-123) | ○ |
| C-65 | getBranches不正URL | E-06 (L99-101) | ○ |
| C-66 | getRemoteSourceActionsアクション返却 | E-06 (L125-146) | ○ |
| C-67 | getRemoteSourceActions不正URL | E-06 (L127-129) | ○ |

### remoteSourcePublisher.ts関連（UT-GH-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | publishRepository呼び出し | E-07 (L15-17) | ○ |

### pushErrorHandler.ts関連（UT-GH-069〜UT-GH-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | isInCodespaces Codespaces | E-08 (L17-19) | ○ |
| C-70 | isInCodespaces非Codespaces | E-08 (L18) | ○ |
| C-71 | findPullRequestTemplatesルート | E-08 (L56-63) | ○ |
| C-72 | findPullRequestTemplates .github | E-08 (L58-59) | ○ |
| C-73 | findPullRequestTemplatesなし | E-08 (L62) | ○ |
| C-74 | handlePushError PermissionDenied | E-08 (L130-141) | ○ |
| C-75 | handlePushError PushProtection | E-08 (L145-156) | ○ |
| C-76 | handlePushError対象外 | E-08 (L110-111, L167) | ○ |
| C-77 | handlePushError GitHub以外 | E-08 (L119-122) | ○ |
| C-78 | handlePushError削除refspec | E-08 (L124-126) | ○ |

### branchProtection.ts関連（UT-GH-079〜UT-GH-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | GitHubBranchProtectionProviderManagerコンストラクタ | E-09 (L79-84) | ○ |
| C-80 | enabled setter有効化 | E-09 (L62-65) | ○ |
| C-81 | enabled setter無効化 | E-09 (L66-68) | ○ |
| C-82 | updateEnablement | E-09 (L95-98) | ○ |
| C-83 | provideBranchProtection | E-09 (L138-140) | ○ |
| C-84 | getRepositoryDetails | E-09 (L142-147) | ○ |
| C-85 | getRepositoryRulesets | E-09 (L149-170) | ○ |
| C-86 | getRepositoryRulesetsページネーション | E-09 (L155-167) | ○ |
| C-87 | parseRulesetRefName refs/heads/ | E-09 (L239-241) | ○ |
| C-88 | parseRulesetRefName ~ALL | E-09 (L244-245) | ○ |
| C-89 | parseRulesetRefName ~DEFAULT_BRANCH | E-09 (L246-247) | ○ |
| C-90 | updateRepositoryBranchProtection AuthenticationError | E-09 (L224-233) | ○ |

### canonicalUriProvider.ts関連（UT-GH-091〜UT-GH-094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | provideCanonicalUri ssh→https | E-10 (L40-43) | ○ |
| C-92 | provideCanonicalUri httpsそのまま | E-10 (L45-46) | ○ |
| C-93 | provideCanonicalUri targetScheme非https | E-10 (L21-23) | ○ |
| C-94 | toHttpsGitHubRemote .git除去 | E-10 (L42) | ○ |

### shareProviders.ts関連（UT-GH-095〜UT-GH-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | provideShareリンク生成 | E-11 (L66-97) | ○ |
| C-96 | provideShareリポジトリなし | E-11 (L67-69) | ○ |
| C-97 | hasGitHubRepositories setter true | E-11 (L55-59) | ○ |
| C-98 | hasGitHubRepositories setter false | E-11 (L60-63) | ○ |
| C-99 | getVscodeDevHost通常版 | E-11 (L99-101) | ○ |
| C-100 | getVscodeDevHost Insiders | E-11 (L100) | ○ |

### historyItemDetailsProvider.ts関連（UT-GH-101〜UT-GH-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | provideAvatarアバター取得 | E-12 (L106-207) | ○ |
| C-102 | provideAvatarキャッシュ | E-12 (L146-154) | ○ |
| C-103 | provideAvatar no-replyメール | E-12 (L165-170) | ○ |
| C-104 | provideAvatar showAvatar=false | E-12 (L112-114) | ○ |
| C-105 | provideAvatar AuthenticationError | E-12 (L197-206) | ○ |
| C-106 | provideHoverCommands | E-12 (L209-222) | ○ |
| C-107 | provideHoverCommandsリモートなし | E-12 (L211-214) | ○ |
| C-108 | provideMessageLinks #123形式 | E-12 (L224-247) | ○ |
| C-109 | provideMessageLinks owner/repo#形式 | E-12 (L233, L238-239) | ○ |
| C-110 | provideMessageLinks GH-形式 | E-12 (L13) ISSUE_EXPRESSION | ○ |
| C-111 | _loadAssignableUsersキャッシュ保存 | E-12 (L265-297) | ○ |
| C-112 | _loadAssignableUsersキャッシュ済みスキップ | E-12 (L266-268) | ○ |
| C-113 | _getCommitAuthor取得 | E-12 (L299-328) | ○ |
| C-114 | _getCommitAuthor不完全情報 | E-12 (L307-311) | ○ |
| C-115 | _onDidCloseRepositoryキャッシュクリア | E-12 (L249-262) | ○ |

### commands.ts関連（UT-GH-116〜UT-GH-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | registerCommandsコマンド登録 | E-13 (L60-119) | ○ |
| C-117 | copyVscodeDevLinkコピー | E-13 (L12-23) | ○ |
| C-118 | copyVscodeDevLink CancellationError | E-13 (L19-21) | ○ |
| C-119 | openVscodeDevLink | E-13 (L25-35) | ○ |
| C-120 | openOnGitHub成功 | E-13 (L37-58) | ○ |
| C-121 | openOnGitHubリモートなし | E-13 (L46-48) | ○ |

### extension.ts関連（UT-GH-122〜UT-GH-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | activate | E-14 (L22-44) | ○ |
| C-123 | initializeGitBaseExtension有効 | E-14 (L49-54) | ○ |
| C-124 | initializeGitBaseExtension無効化 | E-14 (L62-63) | ○ |
| C-125 | initializeGitExtension有効 | E-14 (L96-121) | ○ |
| C-126 | initializeGitExtension後から有効 | E-14 (L127-134) | ○ |
| C-127 | setGitHubContextリポジトリあり | E-14 (L77-78) | ○ |
| C-128 | setGitHubContextリポジトリなし | E-14 (L80-88) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースに対応するソースコードが存在するため、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: 外部API依存（GitHub GraphQL API, REST API）のモック戦略が必要
- **1（中リスク）**: 認証フロー（OctokitService）のテスト時にモック/スタブ設計が重要
- **0（低リスク）**: ユーティリティ関数（util.ts, links.ts）は純粋関数が多く、テストしやすい

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（認証、エラーハンドリング）のモック戦略を確認
- [ ] GitHub API呼び出しのレート制限考慮がテスト設計に含まれているか確認
- [ ] 正規表現パターン（URL解析、Issue参照）のエッジケースが十分か確認
- [ ] Codespaces環境固有の分岐（isInCodespaces）のテスト方針確認
- [ ] VScodeのモック（vscode.window, vscode.commands等）戦略の確認
