---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 69
  claims_with_evidence: 69
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-grunt.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：69 / 69、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/grunt/src/main.ts` - メインソースファイル（365行）
- E-02: `extensions/grunt/package.json` - 拡張機能定義ファイル
- E-03: `extensions/grunt/package.nls.json` - 国際化文字列定義
- E-04: `extensions/grunt/README.md` - 拡張機能説明ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

### ユーティリティ関数（exists, exec）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exists関数がファイル存在確認を行う | E-01 (L13-19) | ○ |
| C-02 | exists関数がPromise<boolean>を返却 | E-01 (L13) | ○ |
| C-03 | exec関数がコマンドを実行する | E-01 (L21-30) | ○ |
| C-04 | exec関数がstdout/stderrを返却 | E-01 (L22) | ○ |
| C-05 | exec関数がエラー時にrejectする | E-01 (L24-26) | ○ |

### タスク判定関数（isBuildTask, isTestTask）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | buildNames配列に'build', 'compile', 'watch'が含まれる | E-01 (L32) | ○ |
| C-07 | isBuildTask関数がビルド関連タスクを判定 | E-01 (L33-40) | ○ |
| C-08 | testNames配列に'test'が含まれる | E-01 (L42) | ○ |
| C-09 | isTestTask関数がテスト関連タスクを判定 | E-01 (L43-50) | ○ |
| C-10 | indexOf()による部分一致判定 | E-01 (L35, L45) | ○ |

### 出力チャンネル関連（getOutputChannel, showError）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | getOutputChannel関数がシングルトンパターンで動作 | E-01 (L52-58) | ○ |
| C-12 | OutputChannelの名前が'Grunt Auto Detection' | E-01 (L55) | ○ |
| C-13 | showError関数が警告メッセージを表示 | E-01 (L60-65) | ○ |
| C-14 | showError関数がローカライズ対応 | E-01 (L61-62) | ○ |

### GruntTaskDefinitionインターフェース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | GruntTaskDefinitionがvscode.TaskDefinitionを拡張 | E-01 (L66) | ○ |
| C-16 | taskプロパティが必須 | E-01 (L67), E-02 (L55-56) | ○ |
| C-17 | argsプロパティがオプション | E-01 (L68), E-02 (L61-64) | ○ |
| C-18 | fileプロパティがオプション | E-01 (L69), E-02 (L65-68) | ○ |

### findGruntCommand関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | Windows環境でgrunt.cmdを検索 | E-01 (L75-76) | ○ |
| C-20 | Linux/Darwin環境でgruntを検索 | E-01 (L77-78) | ○ |
| C-21 | ローカルにない場合グローバル'grunt'を返却 | E-01 (L79-80) | ○ |
| C-22 | node_modules/.bin配下を検索 | E-01 (L75, L77) | ○ |

### FolderDetectorクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | FolderDetectorがワークスペースフォルダを保持 | E-01 (L91) | ○ |
| C-24 | workspaceFolderゲッターが存在 | E-01 (L95-97) | ○ |
| C-25 | isEnabled()がgrunt.autoDetect設定を参照 | E-01 (L99-101) | ○ |
| C-26 | start()でFileSystemWatcherを作成 | E-01 (L103-109) | ○ |
| C-27 | 監視対象パターンが{node_modules,[Gg]runtfile.js} | E-01 (L104) | ○ |
| C-28 | ファイル変更時にpromiseをリセット | E-01 (L106-108) | ○ |
| C-29 | getTasks()がisEnabled()をチェック | E-01 (L111-120) | ○ |
| C-30 | getTasks()がキャッシュを使用 | E-01 (L113-115) | ○ |
| C-31 | getTask()がタスク定義からTaskを生成 | E-01 (L122-134) | ○ |
| C-32 | スペース含むタスク名をダブルクォート囲み | E-01 (L128-130) | ○ |
| C-33 | computeTasks()がrootPathを検証 | E-01 (L137-141) | ○ |
| C-34 | computeTasks()がgruntfile.js/Gruntfile.jsを検索 | E-01 (L142-144) | ○ |
| C-35 | computeTasks()がgrunt --helpを実行 | E-01 (L146-148) | ○ |
| C-36 | 'Available tasks'行からタスク解析を開始 | E-01 (L175-177) | ○ |
| C-37 | 'Tasks run in the order specified'で解析終了 | E-01 (L179) | ○ |
| C-38 | 正規表現でタスク名を抽出 | E-01 (L182-185) | ○ |
| C-39 | ビルドタスクにTaskGroup.Buildを設定 | E-01 (L197-198) | ○ |
| C-40 | テストタスクにTaskGroup.Testを設定 | E-01 (L199-200) | ○ |
| C-41 | エラー時にOutputChannelにログ出力 | E-01 (L209-216) | ○ |
| C-42 | dispose()でFileSystemWatcherを破棄 | E-01 (L222-227) | ○ |

### TaskDetectorクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | TaskDetectorがdetectorsをMapで管理 | E-01 (L233) | ○ |
| C-44 | start()でワークスペースフォルダを処理 | E-01 (L238-241) | ○ |
| C-45 | onDidChangeWorkspaceFoldersイベント登録 | E-01 (L243) | ○ |
| C-46 | onDidChangeConfigurationイベント登録 | E-01 (L244) | ○ |
| C-47 | dispose()でtaskProviderを破棄 | E-01 (L247-253) | ○ |
| C-48 | updateWorkspaceFolders()で削除フォルダ処理 | E-01 (L256-261) | ○ |
| C-49 | updateWorkspaceFolders()で追加フォルダ処理 | E-01 (L263-270) | ○ |
| C-50 | 有効なdetectorのみstart()呼び出し | E-01 (L266-268) | ○ |
| C-51 | updateConfiguration()で全detector再作成 | E-01 (L273-291) | ○ |
| C-52 | updateProvider()でtaskProvider登録 | E-01 (L293-308) | ○ |
| C-53 | registerTaskProvider()でgruntタイプ登録 | E-01 (L296) | ○ |
| C-54 | computeTasks()が0 detectorで空配列返却 | E-01 (L316-317) | ○ |
| C-55 | computeTasks()が1 detectorで直接返却 | E-01 (L318-319) | ○ |
| C-56 | computeTasks()が複数detectorでマージ | E-01 (L320-334) | ○ |
| C-57 | getTask()がスコープに応じてdetector選択 | E-01 (L337-353) | ○ |
| C-58 | Workspace/Globalスコープでundefined返却 | E-01 (L343-344) | ○ |

### 拡張機能ライフサイクル（activate, deactivate）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | activate()でTaskDetector作成・開始 | E-01 (L357-360) | ○ |
| C-60 | deactivate()でTaskDetector破棄 | E-01 (L362-364) | ○ |

### 設定関連（package.json）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | grunt.autoDetect設定がon/offの列挙型 | E-02 (L42-45) | ○ |
| C-62 | デフォルト値がoff | E-02 (L46) | ○ |
| C-63 | activationEventsがonTaskType:grunt | E-02 (L25-27) | ○ |
| C-64 | taskDefinitionsでgruntタイプ定義 | E-02 (L52-74) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全テストケースはソースコードに基づいて生成されている。
- 注意点：
  - 一部のテストケース（タイムアウト処理など）は、実行環境に依存するため、実際のテスト実装時に調整が必要な可能性がある
  - vscode APIのモック実装が必要

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全テストケースがソースコードの実装に基づいており、根拠が明確
- 注意事項：
  - exec関数のタイムアウトテストは実行環境に依存
  - ファイルシステム操作のテストはモック化が必要
  - vscode API（window, workspace, tasks）のモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全関数/メソッドをカバーしているか確認
- [ ] 正常系・異常系・境界値の観点が適切にバランスされているか確認
- [ ] 優先度（高/中/低）の設定が妥当か確認
- [ ] テストケースID（UT-GRN-XXX）が重複していないか確認
- [ ] 入力値と期待結果の整合性を確認
- [ ] vscode APIモックの必要性を考慮した前提条件か確認
