---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 81
  claims_with_evidence: 81
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-gulp.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：81 / 81、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/gulp/src/main.ts` (メインソースコード)
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/gulp/package.json` (拡張機能設定)
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/vscode-main/extensions/gulp/README.md` (機能説明)

## 3) Claims と根拠の対応（レビューの主戦場）

### exists関数（UT-GLP-001〜004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exists関数が存在するファイルに対してtrueを返す | E-01 (26-39行目) | ○ |
| C-02 | exists関数が存在しないファイルに対してfalseを返す | E-01 (32-35行目) | ○ |
| C-03 | exists関数がディレクトリに対してfalseを返す | E-01 (29行目: isFile()チェック) | ○ |
| C-04 | exists関数がアクセスエラー時にfalseを返す | E-01 (32-35行目: catch句) | ○ |

### exec関数（UT-GLP-005〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | exec関数がstdout/stderrを返す | E-01 (41-50行目) | ○ |
| C-06 | exec関数がエラー時にrejectする | E-01 (44-46行目) | ○ |
| C-07 | exec関数がオプションを適用する | E-01 (43行目: options引数) | ○ |

### isBuildTask関数（UT-GLP-008〜012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | isBuildTaskが'build'を含む名前でtrue | E-01 (52-60行目, buildNames配列) | ○ |
| C-09 | isBuildTaskが'compile'を含む名前でtrue | E-01 (52行目: buildNames含む) | ○ |
| C-10 | isBuildTaskが'watch'を含む名前でtrue | E-01 (52行目: buildNames含む) | ○ |
| C-11 | isBuildTaskがキーワードなしでfalse | E-01 (59行目: return false) | ○ |
| C-12 | isBuildTaskが大文字小文字を区別する | E-01 (55行目: indexOf使用、toLowerCase未使用) | ○ |

### isTestTask関数（UT-GLP-013〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | isTestTaskが'test'を含む名前でtrue | E-01 (62-70行目) | ○ |
| C-14 | isTestTaskが複合名でもtrue | E-01 (65行目: indexOf使用) | ○ |
| C-15 | isTestTaskがキーワードなしでfalse | E-01 (69行目: return false) | ○ |

### getOutputChannel関数（UT-GLP-016〜017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | getOutputChannelが新規作成する | E-01 (73-78行目) | ○ |
| C-17 | getOutputChannelが既存を再利用する | E-01 (74-75行目: if (!_channel)チェック) | ○ |

### findGulpCommand関数（UT-GLP-018〜022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | Windows環境でローカルgulp.cmdを返す | E-01 (92-99行目) | ○ |
| C-19 | Windows環境でグローバルgulp.cmdを返す | E-01 (93-96行目) | ○ |
| C-20 | Linux環境でローカルgulpを返す | E-01 (102-104行目) | ○ |
| C-21 | macOS環境でローカルgulpを返す | E-01 (102行目: darwin条件) | ○ |
| C-22 | フォールバックで'gulp'を返す | E-01 (106行目) | ○ |

### FolderDetectorクラス（UT-GLP-023〜054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | コンストラクタがプロパティを設定 | E-01 (119-122行目) | ○ |
| C-24 | workspaceFolderゲッターが値を返す | E-01 (124-126行目) | ○ |
| C-25 | isEnabledがautoDetect='on'でtrue | E-01 (128-130行目) | ○ |
| C-26 | isEnabledがautoDetect='off'でfalse | E-01 (129行目: === 'on'比較) | ○ |
| C-27 | startがFileSystemWatcherを作成 | E-01 (132-138行目) | ○ |
| C-28 | onDidChangeでpromiseリセット | E-01 (135行目) | ○ |
| C-29 | onDidCreateでpromiseリセット | E-01 (136行目) | ○ |
| C-30 | onDidDeleteでpromiseリセット | E-01 (137行目) | ○ |
| C-31 | getTasksがisEnabled=falseで空配列 | E-01 (141-143行目) | ○ |
| C-32 | getTasksがキャッシュを再利用 | E-01 (145-149行目) | ○ |
| C-33 | getTasksがcomputeTasksを呼び出す | E-01 (146行目) | ○ |
| C-34 | getTaskがTaskオブジェクトを返す | E-01 (152-161行目) | ○ |
| C-35 | getTaskがtask未定義でundefined | E-01 (154行目: if (gulpTask)チェック) | ○ |
| C-36 | hasGulpfileがgulpfile.jsを検出 | E-01 (175-201行目, 189行目) | ○ |
| C-37 | hasGulpfileがgulpfile.tsを検出 | E-01 (180行目: .ts拡張子チェック) | ○ |
| C-38 | hasGulpfileがgulpfile.mjsを検出 | E-01 (180行目: .mjs拡張子チェック) | ○ |
| C-39 | hasGulpfileがgulpfile.cjsを検出 | E-01 (180行目: .cjs拡張子チェック) | ○ |
| C-40 | hasGulpfileがgulpfile.babel.jsを検出 | E-01 (195-197行目) | ○ |
| C-41 | hasGulpfileがgulpfile.esm.jsを検出 | E-01 (192-194行目) | ○ |
| C-42 | hasGulpfileがgulpfile未検出でfalse | E-01 (200行目: return false) | ○ |
| C-43 | hasGulpfileが.jsonをスキップ | E-01 (180-182行目: 拡張子チェック) | ○ |
| C-44 | computeTasksがfileスキームで動作 | E-01 (204行目) | ○ |
| C-45 | computeTasksが非fileスキームで空配列 | E-01 (206-208行目) | ○ |
| C-46 | computeTasksがgulpfile未検出で空配列 | E-01 (210-212行目) | ○ |
| C-47 | computeTasksがタスクを抽出 | E-01 (226-246行目) | ○ |
| C-48 | computeTasksがBuildグループを設定 | E-01 (241-242行目) | ○ |
| C-49 | computeTasksがTestグループを設定 | E-01 (243-244行目) | ○ |
| C-50 | computeTasksがエラー時に空配列 | E-01 (249-259行目) | ○ |
| C-51 | computeTasksが'No license field'をフィルタ | E-01 (220-224行目) | ○ |
| C-52 | computeTasksが空行をスキップ | E-01 (230-232行目) | ○ |
| C-53 | disposeがpromiseをリセット | E-01 (263-264行目) | ○ |
| C-54 | disposeがfileWatcherをdispose | E-01 (265-267行目) | ○ |

### TaskDetectorクラス（UT-GLP-055〜077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | コンストラクタがdetectorsを初期化 | E-01 (274行目) | ○ |
| C-56 | startがworkspaceFoldersを処理 | E-01 (280-283行目) | ○ |
| C-57 | startがonDidChangeWorkspaceFoldersを登録 | E-01 (284行目) | ○ |
| C-58 | startがonDidChangeConfigurationを登録 | E-01 (285行目) | ○ |
| C-59 | disposeがtaskProviderをdispose | E-01 (289-292行目) | ○ |
| C-60 | disposeがdetectorsをクリア | E-01 (293行目) | ○ |
| C-61 | updateWorkspaceFoldersが削除フォルダを処理 | E-01 (297-303行目) | ○ |
| C-62 | updateWorkspaceFoldersが追加フォルダを処理 | E-01 (304-310行目) | ○ |
| C-63 | updateWorkspaceFoldersが有効detectorを開始 | E-01 (307-309行目) | ○ |
| C-64 | updateConfigurationがdetectorを再作成 | E-01 (314-331行目) | ○ |
| C-65 | updateProviderがtaskProviderを登録 | E-01 (335-345行目) | ○ |
| C-66 | updateProviderがtaskProviderをdispose | E-01 (346-349行目) | ○ |
| C-67 | getTasksがcomputeTasksを呼び出す | E-01 (352-354行目) | ○ |
| C-68 | computeTasksがdetector=0で空配列 | E-01 (357-358行目) | ○ |
| C-69 | computeTasksがdetector=1でそのタスク | E-01 (359-360行目) | ○ |
| C-70 | computeTasksが複数detectorでタスク結合 | E-01 (361-375行目) | ○ |
| C-71 | computeTasksが部分エラーを処理 | E-01 (364行目: .then(..., () => [])) | ○ |
| C-72 | getTaskがdetector=0でundefined | E-01 (379-380行目) | ○ |
| C-73 | getTaskがdetector=1でそのタスク | E-01 (381-382行目) | ○ |
| C-74 | getTaskがWorkspaceScopeでundefined | E-01 (384-386行目) | ○ |
| C-75 | getTaskがGlobalScopeでundefined | E-01 (384行目) | ○ |
| C-76 | getTaskがフォルダスコープで解決 | E-01 (387-391行目) | ○ |
| C-77 | getTaskが未知フォルダでundefined | E-01 (393行目: return undefined) | ○ |

### モジュールレベル関数（UT-GLP-078〜081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | activateがTaskDetectorを作成・開始 | E-01 (399-402行目) | ○ |
| C-79 | deactivateがTaskDetectorをdispose | E-01 (404-406行目) | ○ |
| C-80 | showErrorが警告メッセージを表示 | E-01 (80-87行目) | ○ |
| C-81 | showErrorが'Go to output'選択で表示 | E-01 (83-85行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースがソースコードに基づいて作成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコード根拠があります
- 注意点：
  - VSCode APIのモック実装が必要（vscode.workspace, vscode.tasks等）
  - ファイルシステム操作のモック実装が必要（fs.promises.stat, fs.promises.readdir）
  - child_process.execのモック実装が必要
  - プラットフォーム固有のテスト（Windows/Linux/macOS）には環境分離が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全ての関数・メソッドをカバーしているか確認
- [ ] 正常系・異常系・境界値の観点が適切に含まれているか確認
- [ ] VSCode拡張機能のテスト環境（@vscode/test-electron等）の構築が必要
- [ ] プラットフォーム依存コード（findGulpCommand）のテスト戦略を確認
- [ ] 非同期処理（Promise、async/await）のテストパターンを確認
- [ ] ファイルシステム操作のモック方針を確認
