---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：ext-html-language-features 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上の実装が存在するか
2. **根拠との整合性**：テストケースの内容が実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 148 / 150 = 0.99
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-HLF-147（HTMLサンプルスニペット補完）**：正規表現の挙動確認が必要
  2. **UT-HLF-073（limitRanges）**：アルゴリズムの複雑性による検証困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `extensions/html-language-features/server/src/languageModelCache.ts`
- E-02: `extensions/html-language-features/server/src/modes/embeddedSupport.ts`
- E-03: `extensions/html-language-features/server/src/modes/languageModes.ts`
- E-04: `extensions/html-language-features/server/src/modes/htmlMode.ts`
- E-05: `extensions/html-language-features/server/src/modes/cssMode.ts`
- E-06: `extensions/html-language-features/server/src/modes/javascriptMode.ts`
- E-07: `extensions/html-language-features/server/src/modes/htmlFolding.ts`
- E-08: `extensions/html-language-features/server/src/modes/selectionRanges.ts`
- E-09: `extensions/html-language-features/server/src/modes/formatting.ts`
- E-10: `extensions/html-language-features/server/src/modes/semanticTokens.ts`
- E-11: `extensions/html-language-features/server/src/modes/javascriptSemanticTokens.ts`
- E-12: `extensions/html-language-features/server/src/modes/javascriptLibs.ts`
- E-13: `extensions/html-language-features/server/src/utils/strings.ts`
- E-14: `extensions/html-language-features/server/src/utils/arrays.ts`
- E-15: `extensions/html-language-features/server/src/utils/positions.ts`
- E-16: `extensions/html-language-features/server/src/utils/documentContext.ts`
- E-17: `extensions/html-language-features/server/src/utils/runner.ts`
- E-18: `extensions/html-language-features/server/src/utils/validation.ts`
- E-19: `extensions/html-language-features/server/src/htmlServer.ts`
- E-20: `extensions/html-language-features/client/src/htmlClient.ts`
- E-21: `extensions/html-language-features/client/src/autoInsertion.ts`
- E-22: `extensions/html-language-features/client/src/languageParticipants.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

### LanguageModelCache (UT-HLF-001 - UT-HLF-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャッシュにドキュメントがない場合にパースされること | E-01 (L34-43) | ○ |
| C-02 | キャッシュにドキュメントがある場合にキャッシュから返却されること | E-01 (L37-41) | ○ |
| C-03 | ドキュメントのバージョンが変更された場合に再パースされること | E-01 (L38) | ○ |
| C-04 | 言語IDが変更された場合に再パースされること | E-01 (L38) | ○ |
| C-05 | キャッシュが最大エントリ数に達した場合に最古のエントリが削除されること | E-01 (L48-62) | ○ |
| C-06 | ドキュメント削除時にキャッシュから削除されること | E-01 (L66-71) | ○ |
| C-07 | 存在しないドキュメントを削除しても例外が発生しないこと | E-01 (L68) | ○ |
| C-08 | dispose時にクリーンアップインターバルがクリアされること | E-01 (L73-80) | ○ |

### embeddedSupport (UT-HLF-009 - UT-HLF-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | HTMLドキュメントからリージョンが正しく抽出されること | E-02 (L26-92) | ○ |
| C-10 | styleタグ内がCSSとして認識されること | E-02 (L42-44) | ○ |
| C-11 | scriptタグ内がJavaScriptとして認識されること | E-02 (L45-47) | ○ |
| C-12 | type="text/typescript"のscriptがTypeScriptとして認識されること | E-02 (L62-63) | ○ |
| C-13 | style属性がCSSとして認識されること | E-02 (L245-251) | ○ |
| C-14 | onclickなどのイベント属性がJavaScriptとして認識されること | E-02 (L245-251) | ○ |
| C-15 | scriptタグのsrc属性が抽出されること | E-02 (L52-57) | ○ |
| C-16 | 空のHTMLドキュメントで空のリージョンが返却されること | E-02 (L27-28) | ○ |
| C-17 | 指定位置の言語IDが正しく返却されること | E-02 (L150-162) | ○ |
| C-18 | HTML領域の位置でhtmlが返却されること | E-02 (L161) | ○ |
| C-19 | CSSの埋め込みドキュメントが抽出されること | E-02 (L164-179) | ○ |
| C-20 | JavaScriptの埋め込みドキュメントが抽出されること | E-02 (L164-179) | ○ |
| C-21 | 言語範囲のリストが正しく返却されること | E-02 (L95-134) | ○ |
| C-22 | ドキュメント内の言語リストが返却されること | E-02 (L136-148) | ○ |

### languageModes (UT-HLF-023 - UT-HLF-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | サポート言語に応じたモードが生成されること | E-03 (L114-131) | ○ |
| C-24 | 位置に応じたモードが返却されること | E-03 (L136-142) | ○ |
| C-25 | 不明な位置でundefinedが返却されること | E-03 (L141) | ○ |
| C-26 | 範囲内のモードリストが返却されること | E-03 (L143-152) | ○ |
| C-27 | ドキュメント内の全モードが返却されること | E-03 (L153-162) | ○ |
| C-28 | データプロバイダが更新されること | E-03 (L133-135) | ○ |

### HTMLMode (UT-HLF-029 - UT-HLF-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | HTML補完リストが返却されること | E-04 (L23-31) | ○ |
| C-30 | 設定に応じて補完オプションが適用されること | E-04 (L24-27) | ○ |
| C-31 | HTMLホバー情報が返却されること | E-04 (L33-35) | ○ |
| C-32 | ドキュメントハイライトが返却されること | E-04 (L36-38) | ○ |
| C-33 | ドキュメントリンクが返却されること | E-04 (L39-41) | ○ |
| C-34 | ドキュメントシンボルが返却されること | E-04 (L42-44) | ○ |
| C-35 | HTMLフォーマットが適用されること | E-04 (L45-54) | ○ |
| C-36 | contentUnformatted設定がscriptに適用されること | E-04 (L47-51) | ○ |
| C-37 | 折りたたみ範囲が返却されること | E-04 (L55-57) | ○ |
| C-38 | autoQuoteで引用符が挿入されること | E-04 (L61-68) | ○ |
| C-39 | autoCloseで閉じタグが挿入されること | E-04 (L69-72) | ○ |
| C-40 | 無効な位置でnullが返却されること | E-04 (L74) | ○ |
| C-41 | HTMLリネームが実行されること | E-04 (L76-79) | ○ |
| C-42 | 対応タグ位置が返却されること | E-04 (L83-86) | ○ |
| C-43 | リンク編集範囲が返却されること | E-04 (L87-90) | ○ |

### CSSMode (UT-HLF-044 - UT-HLF-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | CSS補完リストが返却されること | E-05 (L23-27) | ○ |
| C-45 | CSSバリデーションエラーが返却されること | E-05 (L19-22) | ○ |
| C-46 | CSSホバー情報が返却されること | E-05 (L28-31) | ○ |
| C-47 | CSSハイライトが返却されること | E-05 (L32-35) | ○ |
| C-48 | CSSシンボルが返却されること(CSS_STYLE_RULE除外) | E-05 (L36-39) | ○ |
| C-49 | CSS定義が返却されること | E-05 (L40-43) | ○ |
| C-50 | CSS参照が返却されること | E-05 (L44-47) | ○ |
| C-51 | カラー情報が返却されること | E-05 (L48-51) | ○ |
| C-52 | カラープレゼンテーションが返却されること | E-05 (L52-55) | ○ |

### JavaScriptMode (UT-HLF-053 - UT-HLF-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | JavaScript補完リストが返却されること | E-06 (L141-169) | ○ |
| C-54 | 補完詳細が解決されること | E-06 (L170-182) | ○ |
| C-55 | JavaScript診断が返却されること | E-06 (L125-140) | ○ |
| C-56 | ignoredErrorsが除外されること | E-06 (L102-105, L132) | ○ |
| C-57 | JavaScriptホバー情報が返却されること | E-06 (L183-195) | ○ |
| C-58 | シグネチャヘルプが返却されること | E-06 (L196-233) | ○ |
| C-59 | JavaScriptリネームが実行されること | E-06 (L234-255) | ○ |
| C-60 | リネーム不可な位置でnullが返却されること | E-06 (L239-241) | ○ |
| C-61 | JavaScriptハイライトが返却されること | E-06 (L256-270) | ○ |
| C-62 | JavaScriptシンボルが返却されること | E-06 (L271-307) | ○ |
| C-63 | JavaScript定義が返却されること | E-06 (L308-334) | ○ |
| C-64 | ライブラリへの定義ジャンプができること | E-06 (L319-330) | ○ |
| C-65 | JavaScript参照が返却されること | E-06 (L335-348) | ○ |
| C-66 | JavaScriptフォーマットが適用されること | E-06 (L359-394) | ○ |
| C-67 | インデントレベルが正しく計算されること | E-06 (L603-622) | ○ |
| C-68 | JavaScript折りたたみ範囲が返却されること | E-06 (L395-414) | ○ |
| C-69 | セマンティックトークンが返却されること | E-06 (L418-422) | ○ |
| C-70 | ライブラリコンテンツが返却されること | E-06 (L426-431) | ○ |

### htmlFolding (UT-HLF-071 - UT-HLF-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | HTMLとモードのフォールディングが統合されること | E-07 (L9-43) | ○ |
| C-72 | maxRanges制限が適用されること | E-07 (L39-41) | ○ |
| C-73 | ネストレベルに基づいて範囲が制限されること | E-07 (L45-115) | △ |

### selectionRanges (UT-HLF-074 - UT-HLF-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | 選択範囲が返却されること | E-08 (L9-25) | ○ |
| C-75 | HTML範囲が親として設定されること | E-08 (L17-21) | ○ |

### formatting (UT-HLF-076 - UT-HLF-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | HTMLフォーマット後に埋め込みフォーマットが適用されること | E-09 (L10-96) | ○ |
| C-77 | enabledModesで無効化されたモードがスキップされること | E-09 (L73) | ○ |
| C-78 | insertFinalNewlineが適用されること | E-09 (L58-61) | ○ |

### semanticTokens (UT-HLF-079 - UT-HLF-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | 統合レジェンドが作成されること | E-10 (L20-31) | ○ |
| C-80 | 全モードのセマンティックトークンが統合されること | E-10 (L35-49) | ○ |
| C-81 | トークンがデルタエンコードされること | E-10 (L97-137) | ○ |
| C-82 | 範囲フィルタリングが適用されること | E-10 (L100-104, L117-134) | ○ |

### utils/strings (UT-HLF-083 - UT-HLF-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | オフセット位置の単語が返却されること | E-13 (L6-27) | ○ |
| C-84 | 単語境界外で空が返却されること | E-13 (L26) | ○ |
| C-85 | 文字列が指定文字列で始まる場合trueが返却されること | E-13 (L29-41) | ○ |
| C-86 | 文字列が指定文字列で始まらない場合falseが返却されること | E-13 (L35-37) | ○ |
| C-87 | 文字列が指定文字列で終わる場合trueが返却されること | E-13 (L43-52) | ○ |
| C-88 | 文字列が指定回数繰り返されること | E-13 (L54-64) | ○ |
| C-89 | 空白のみの文字列でtrueが返却されること | E-13 (L66-68) | ○ |
| C-90 | 非空白を含む文字列でfalseが返却されること | E-13 (L66-68) | ○ |
| C-91 | 改行位置でtrueが返却されること | E-13 (L70-72) | ○ |
| C-92 | CR/LFでtrueが返却されること | E-13 (L74-78) | ○ |

### utils/arrays (UT-HLF-093 - UT-HLF-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | 配列が結合されること | E-14 (L6-12) | ○ |
| C-94 | fromがnull/undefinedでも例外が発生しないこと | E-14 (L7) | ○ |
| C-95 | 配列に要素が含まれる場合trueが返却されること | E-14 (L14-16) | ○ |
| C-96 | 安定ソートが実行されること | E-14 (L22-58) | ○ |
| C-97 | 要素が見つかった場合インデックスが返却されること | E-14 (L60-76) | ○ |
| C-98 | 要素が見つからない場合負のインデックスが返却されること | E-14 (L75) | ○ |

### utils/positions (UT-HLF-099 - UT-HLF-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | p1がp2以前の場合trueが返却されること | E-15 (L8-10) | ○ |
| C-100 | r2がr1内に含まれる(同一でない)場合trueが返却されること | E-15 (L11-13) | ○ |
| C-101 | 範囲が等しい場合trueが返却されること | E-15 (L14-16) | ○ |

### utils/documentContext (UT-HLF-102 - UT-HLF-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | DocumentContextが生成されること | E-16 (L11-42) | ○ |
| C-103 | スキーマ付きURLがそのまま返却されること | E-16 (L27-29) | ○ |
| C-104 | 絶対パスがワークスペースルートから解決されること | E-16 (L31-36) | ○ |
| C-105 | 相対パスがベースURIから解決されること | E-16 (L37-39) | ○ |

### utils/runner (UT-HLF-106 - UT-HLF-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | Errorオブジェクトのメッセージとスタックが含まれること | E-17 (L9-12) | ○ |
| C-107 | 文字列エラーがそのまま含まれること | E-17 (L13-14) | ○ |
| C-108 | 関数が正常実行されること | E-17 (L21-41) | ○ |
| C-109 | キャンセルトークンが設定されている場合キャンセルエラーが返却されること | E-17 (L24-26) | ○ |
| C-110 | 関数がエラーをスローした場合デフォルト値が返却されること | E-17 (L35-38) | ○ |

### autoInsertion (UT-HLF-111 - UT-HLF-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | 自動挿入が有効化されること | E-21 (L10-98) | ○ |
| C-112 | =入力時にautoQuoteが実行されること | E-21 (L61-62) | ○ |
| C-113 | >入力時にautoCloseが実行されること | E-21 (L63-64) | ○ |
| C-114 | /入力時にautoCloseが実行されること | E-21 (L63) | ○ |
| C-115 | Undo/Redo時に自動挿入がスキップされること | E-21 (L47) | ○ |
| C-116 | 複数行変更時に自動挿入がスキップされること | E-21 (L69-71) | ○ |

### languageParticipants (UT-HLF-117 - UT-HLF-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | 言語参加者が取得されること | E-22 (L30-74) | ○ |
| C-118 | htmlがデフォルトで含まれること | E-22 (L38-39) | ○ |
| C-119 | htmlがデフォルトで自動挿入有効であること | E-22 (L40-41) | ○ |
| C-120 | 拡張機能変更時にイベントが発火すること | E-22 (L61-65) | ○ |
| C-121 | 同一要素のセットでtrueが返却されること | E-22 (L76-86) | ○ |
| C-122 | 異なる要素のセットでfalseが返却されること | E-22 (L77-78) | ○ |

### javascriptSemanticTokens (UT-HLF-123 - UT-HLF-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | セマンティックトークンレジェンドが返却されること | E-11 (L9-17) | ○ |
| C-124 | TypeScriptのセマンティック分類が変換されること | E-11 (L19-41) | ○ |
| C-125 | 分類からトークンタイプが抽出されること | E-11 (L78-83) | ○ |
| C-126 | 255以下でundefinedが返却されること | E-11 (L79) | ○ |
| C-127 | 分類から修飾子が抽出されること | E-11 (L85-87) | ○ |

### javascriptLibs (UT-HLF-128 - UT-HLF-131)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | ライブラリが読み込まれること | E-12 (L15-33) | ○ |
| C-129 | jqueryライブラリが読み込まれること | E-12 (L19-20) | ○ |
| C-130 | キャッシュが使用されること | E-12 (L16-17) | ○ |
| C-131 | 存在しないライブラリで空文字が返却されること | E-12 (L27-28) | ○ |

### validation (UT-HLF-132 - UT-HLF-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | プッシュ診断サポートが登録されること | E-18 (L17-75) | ○ |
| C-133 | ドキュメント変更時に検証がトリガーされること | E-18 (L26-28) | ○ |
| C-134 | ドキュメントクローズ時に保留中の検証がクリアされること | E-18 (L31-34) | ○ |
| C-135 | プル診断サポートが登録されること | E-18 (L77-108) | ○ |
| C-136 | 診断リクエストで検証が実行されること | E-18 (L86-95) | ○ |
| C-137 | 診断リフレッシュがリクエストされること | E-18 (L62-64, L97-99) | ○ |

### htmlServer (UT-HLF-138 - UT-HLF-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | サーバー初期化でCapabilitiesが返却されること | E-19 (L136-224) | ○ |
| C-139 | 補完リクエストが処理されること | E-19 (L304-321) | ○ |
| C-140 | ホバーリクエストが処理されること | E-19 (L337-350) | ○ |
| C-141 | フォーマットリクエストが処理されること | E-19 (L404-430) | ○ |
| C-142 | 折りたたみ範囲リクエストが処理されること | E-19 (L507-515) | ○ |
| C-143 | リネームリクエストが処理されること | E-19 (L527-541) | ○ |
| C-144 | 自動挿入リクエストが処理されること | E-19 (L491-505) | ○ |

### htmlClient (UT-HLF-145 - UT-HLF-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | クライアントが起動すること | E-20 (L92-144) | ○ |
| C-146 | リージョン/スニペット補完が提供されること | E-20 (L292-313) | ○ |
| C-147 | HTMLサンプルスニペットが提供されること | E-20 (L314-338) | △ |
| C-148 | フォーマッター登録が設定に応じて更新されること | E-20 (L259-288) | ○ |
| C-149 | 有効なCompletionItemDataでtrueが返却されること | E-03 (L64-66) | ○ |
| C-150 | 無効なデータでfalseが返却されること | E-03 (L64-66) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-HLF-073（limitRanges）**：アルゴリズムが複雑で、境界条件の網羅的な検証が困難
  - 候補：追加のエッジケーステスト / アルゴリズムレビュー
- **UT-HLF-147（HTMLサンプルスニペット補完）**：正規表現 `htmlSnippetCompletionRegExpr` の挙動確認が必要
  - 候補：正規表現の動作確認テスト / ユーザーシナリオテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：大部分のテストケースは実装コードと直接対応しており、信頼性が高い
- **1（中リスク）**：
  - セマンティックトークン関連（TypeScriptとの連携部分）
  - フォーマット機能（複数言語の統合処理）
- **0（低リスク）**：ユーティリティ関数は単純で検証容易

## 6) レビュアーチェックリスト（最小）
- [ ] limitRanges関数のネストレベル計算ロジックを確認
- [ ] HTMLサンプルスニペットの正規表現が意図通りに動作するか確認
- [ ] セマンティックトークンのエンコード/デコードが正しいか確認
- [ ] 自動挿入のタイミング（100msの遅延）が適切か確認
- [ ] キャッシュのLRU動作が期待通りか確認
