---
generated_at: 2026-01-27 14:15:00
metrics:
  claims_total: 108
  claims_with_evidence: 102
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：ext-ipynb 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：102 / 108、根拠なし：6
- 優先レビュー（高）
  1. **UT-IPN-023/024**: Python/.NET拡張機能の検出ロジックの実際の動作確認が必要
  2. **UT-IPN-038/041**: Worker処理のモック/スタブ戦略の検討が必要
  3. **UT-IPN-092**: 保存前同期の非同期動作の検証方法の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/ipynb/src/serializers.ts` - セルのシリアライズロジック
- E-02: `extensions/ipynb/src/deserializers.ts` - セルのデシリアライズロジック
- E-03: `extensions/ipynb/src/notebookSerializer.ts` - ベースシリアライザークラス
- E-04: `extensions/ipynb/src/notebookSerializer.node.ts` - Node.js用シリアライザー
- E-05: `extensions/ipynb/src/notebookSerializer.web.ts` - Web用シリアライザー
- E-06: `extensions/ipynb/src/helper.ts` - ヘルパー関数群
- E-07: `extensions/ipynb/src/common.ts` - 共通型定義・ユーティリティ
- E-08: `extensions/ipynb/src/constants.ts` - 定数定義
- E-09: `extensions/ipynb/src/notebookAttachmentCleaner.ts` - 添付ファイルクリーナー
- E-10: `extensions/ipynb/src/notebookImagePaste.ts` - 画像ペースト機能
- E-11: `extensions/ipynb/src/notebookModelStoreSync.ts` - モデル同期処理
- E-12: `extensions/ipynb/src/ipynbMain.ts` - 拡張機能エントリーポイント
- E-13: `extensions/ipynb/notebook-src/cellAttachmentRenderer.ts` - セル添付ファイルレンダラー
- E-14: `extensions/ipynb/src/test/serializers.test.ts` - 既存テストファイル（参照用）
- E-15: `extensions/ipynb/src/test/notebookModelStoreSync.test.ts` - 既存テストファイル（参照用）
- E-16: `extensions/ipynb/src/test/clearOutputs.test.ts` - 既存テストファイル（参照用）

## 3) Claims と根拠の対応（レビューの主戦場）

### serializers.ts関連（UT-IPN-001 〜 UT-IPN-021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createJupyterCellFromNotebookCellはセル種別によって異なるセル型を返す | E-01 L13-26 | ○ |
| C-02 | sortObjectPropertiesRecursivelyはオブジェクトをアルファベット順にソートする | E-01 L34-49 | ○ |
| C-03 | getCellMetadataはセルメタデータを抽出する | E-01 L51-72 | ○ |
| C-04 | Markupセルではexecution_countが削除される | E-01 L59-61 | ○ |
| C-05 | getVSCodeCellLanguageIdはメタデータから言語IDを取得する | E-01 L74-76 | ○ |
| C-06 | setVSCodeCellLanguageIdはメタデータに言語IDを設定する | E-01 L77-80 | ○ |
| C-07 | removeVSCodeCellLanguageIdはvscodeプロパティを削除する | E-01 L81-85 | ○ |
| C-08 | createMarkdownCellFromNotebookCellはMarkdownセルを作成する | E-01 L376-390 | ○ |
| C-09 | pruneCellは不要なプロパティを削除する | E-01 L392-409 | ○ |
| C-10 | serializeNotebookToStringはNotebookDataをJSON文字列に変換する | E-01 L462-476 | ○ |
| C-11 | getNotebookMetadataはノートブックメタデータを取得する | E-01 L484-492 | ○ |

### deserializers.ts関連（UT-IPN-022 〜 UT-IPN-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | getPreferredLanguageはメタデータから優先言語を取得する | E-02 L20-33 | ○ |
| C-13 | Python拡張機能がインストールされていればデフォルトはpython | E-02 L26-29 | △ |
| C-14 | .NET拡張機能のみの場合デフォルトはcsharp | E-02 L26-29 | △ |
| C-15 | jupyterCellOutputToCellOutputは出力を変換する | E-02 L264-296 | ○ |
| C-16 | display_data出力が正しく変換される | E-02 L258, L206-235 | ○ |
| C-17 | error出力が正しく変換される | E-02 L261, L237-249 | ○ |
| C-18 | stream出力が正しく変換される | E-02 L262, L251-255 | ○ |
| C-19 | jupyterNotebookModelToNotebookDataはノートブックを変換する | E-02 L357-373 | ○ |
| C-20 | cellsがない場合エラーがスローされる | E-02 L362-364 | ○ |

### NotebookSerializerBase関連（UT-IPN-031 〜 UT-IPN-037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | deserializeNotebookはバイト配列からNotebookDataを生成する | E-03 L24-77 | ○ |
| C-22 | nbformat < 4の場合エラーがスローされる | E-03 L49-51 | ○ |
| C-23 | インデント量が検出される | E-03 L54 | ○ |
| C-24 | バックアップファイルから復元できる | E-03 L33-47 | ○ |
| C-25 | serializeNotebookはNotebookDataをバイト配列に変換する | E-03 L79-86 | ○ |
| C-26 | disposed後は空の配列が返却される | E-03 L80-82 | ○ |

### NotebookSerializer (node/web)関連（UT-IPN-038 〜 UT-IPN-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | Node.jsでWorkerスレッドでシリアライズが実行される | E-04 L33-43, L75-84 | ○ |
| C-28 | startWorkerはWorkerインスタンスを返す | E-04 L45-74 | ○ |
| C-29 | dispose後に呼び出された場合エラーがスローされる | E-04 L46-48 | ○ |
| C-30 | Web WorkerでシリアライズがReview実行される | E-05 L33-43, L75-84 | ○ |

### helper.ts関連（UT-IPN-042 〜 UT-IPN-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | deepCloneはオブジェクトを深くコピーする | E-06 L8-29 | ○ |
| C-32 | RegExpはそのまま返却される | E-06 L12-14 | ○ |
| C-33 | objectEqualsは同一オブジェクトでtrueを返す | E-06 L32-84 | ○ |
| C-34 | Delayerはタスクをデバウンスする | E-06 L90-144 | ○ |
| C-35 | generateUuidはUUID形式の文字列を生成する | E-06 L154-203 | ○ |
| C-36 | DeferredPromiseはPromiseの解決/拒否を制御できる | E-06 L216-266 | ○ |

### common.ts関連（UT-IPN-059 〜 UT-IPN-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | hasKeyは指定キーの存在を確認する型ガード | E-07 L93-100 | ○ |

### AttachmentCleaner関連（UT-IPN-061 〜 UT-IPN-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | AttachmentCleanerは初期化時にイベントリスナーを登録する | E-09 L37-142 | ○ |
| C-39 | cleanNotebookAttachmentsは未使用添付ファイルをキャッシュに移動する | E-09 L174-240 | ○ |
| C-40 | getAttachmentNamesはMarkdownから添付ファイル名を抽出する | E-09 L365-384 | ○ |
| C-41 | provideCodeActionsはQuickFixを提供する | E-09 L144-167 | ○ |
| C-42 | analyzeMissingAttachmentsは欠落した添付ファイルを診断する | E-09 L242-280 | ○ |

### notebookImagePaste関連（UT-IPN-070 〜 UT-IPN-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | provideDocumentPasteEditsは画像ペースト時にEditを返す | E-10 L53-74 | ○ |
| C-44 | 設定が無効な場合undefinedが返却される | E-10 L60-63 | ○ |
| C-45 | provideDocumentDropEditsは画像ドロップ時にEditを返す | E-10 L76-92 | ○ |
| C-46 | getDroppedImageDataは画像データを抽出する | E-10 L136-189 | ○ |
| C-47 | buildAttachmentは添付ファイルを構築する | E-10 L256-297 | ○ |
| C-48 | encodeBase64はバイナリをBase64エンコードする | E-10 L211-247 | ○ |
| C-49 | getCellFromCellDocumentはセルを検索する | E-10 L195-206 | ○ |

### notebookModelStoreSync関連（UT-IPN-081 〜 UT-IPN-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | activateはイベントリスナーを登録する | E-11 L26-29 | ○ |
| C-51 | onDidChangeNotebookCellsはセル変更時にメタデータを更新する | E-11 L127-225 | ○ |
| C-52 | セル言語変更時にvscode.languageIdが設定される | E-11 L177-186 | ○ |
| C-53 | 実行カウント変更時にexecution_countが更新される | E-11 L150-175 | ○ |
| C-54 | 新規セルにIDが生成される | E-11 L195-219 | ○ |
| C-55 | isCellIdRequiredはnbformatバージョンをチェックする | E-11 L231-239 | ○ |
| C-56 | generateCellIdはユニークな8文字IDを生成する | E-11 L241-262 | ○ |
| C-57 | debounceOnDidChangeNotebookDocumentはイベントをデバウンスする | E-11 L47-78 | ○ |
| C-58 | waitForPendingModelUpdatesは保留中の更新を待機する | E-11 L84-95 | △ |

### ipynbMain関連（UT-IPN-093 〜 UT-IPN-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | activateはシリアライザーを登録する | E-12 L35-67 | ○ |
| C-60 | jupyter-notebookシリアライザーが登録される | E-12 L53 | ○ |
| C-61 | interactiveシリアライザーが登録される | E-12 L67 | ○ |
| C-62 | CodeLensProviderが登録される | E-12 L69-81 | ○ |
| C-63 | newUntitledIpynbは新規ノートブックを作成する | E-12 L83-95 | ○ |
| C-64 | openIpynbInNotebookEditorはipynbを開く | E-12 L97-103 | ○ |
| C-65 | setNotebookMetadataはメタデータを更新する | E-12 L120-135 | ○ |
| C-66 | ドキュメントが見つからない場合falseが返却される | E-12 L121-124 | ○ |
| C-67 | exportNotebookはJSON文字列を返す | E-12 L117-119 | ○ |

### cellAttachmentRenderer関連（UT-IPN-102 〜 UT-IPN-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | activateはmarkdown-it-rendererを拡張する | E-13 L14-47 | ○ |
| C-69 | rendererが取得できない場合エラーがスローされる | E-13 L16-18 | ○ |
| C-70 | attachment:プレフィックスの画像がBase64に変換される | E-13 L22-38 | ○ |
| C-71 | tryDecodeURIComponentはURIをデコードする | E-13 L49-55 | ○ |

### constants関連（UT-IPN-107 〜 UT-IPN-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | defaultNotebookFormatは{ major: 4, minor: 5 } | E-08 L8 | ○ |
| C-73 | CellOutputMimeTypesが定義されている | E-08 L18-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-IPN-023/024（C-13/C-14）**: Python/.NET拡張機能の検出は`extensions.getExtension()`に依存しており、実際の拡張機能インストール状態に応じた動作の確認が必要
  - 候補：モックによる拡張機能検出のシミュレーション / 統合テストでの確認
- **UT-IPN-038/041（C-27/C-30）**: Workerスレッドの動作確認にはWorkerのモック化または実際のWorker環境が必要
  - 候補：jest-mock-worker / テスト用Worker実装
- **UT-IPN-092（C-58）**: 非同期の保存前同期処理の完了確認方法
  - 候補：Promiseチェーンの追跡 / テスト用フック

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: constants.ts、helper.tsの純粋関数テスト
- **1（中リスク）**: serializers.ts、deserializers.tsのデータ変換テスト - エッジケースの網羅性を確認
- **2（高リスク）**:
  - Worker関連テスト（UT-IPN-038〜041）- 非同期処理のテストが複雑
  - 拡張機能検出テスト（UT-IPN-023〜024）- 環境依存のテスト
  - 保存前同期テスト（UT-IPN-092）- タイミング依存の非同期処理

## 6) レビュアーチェックリスト（最小）
- [ ] 全108件のテストケースがCSVに正しく記載されているか確認
- [ ] テストIDのプレフィックス「UT-IPN-」が一貫しているか確認
- [ ] 優先度「高」のテストケースがビジネスクリティカルな機能をカバーしているか確認
- [ ] 境界値テストが数値・文字列の限界値を適切にカバーしているか確認
- [ ] 異常系テストがエラーハンドリングを網羅しているか確認
- [ ] 既存テストファイル（E-14〜E-16）との整合性を確認
- [ ] Worker関連テストのモック戦略を検討
- [ ] 拡張機能検出テストの実行環境を検討
