---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 112
  claims_with_evidence: 112
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-json-language-features 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：112 / 112、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/json-language-features/server/src/languageModelCache.ts`（83行）
- E-02: `extensions/json-language-features/server/src/jsonServer.ts`（564行）
- E-03: `extensions/json-language-features/server/src/utils/validation.ts`（109行）
- E-04: `extensions/json-language-features/server/src/utils/strings.ts`（23行）
- E-05: `extensions/json-language-features/server/src/utils/runner.ts`（71行）
- E-06: `extensions/json-language-features/client/src/languageParticipants.ts`（91行）
- E-07: `extensions/json-language-features/client/src/utils/urlMatch.ts`（108行）
- E-08: `extensions/json-language-features/client/src/utils/hash.ts`（59行）
- E-09: `extensions/json-language-features/client/src/jsonClient.ts`（932行）
- E-10: `extensions/json-language-features/client/src/languageStatus.ts`（365行）
- E-11: `extensions/json-language-features/client/src/node/schemaCache.ts`（148行）

## 3) Claims と根拠の対応（レビューの主戦場）

### LanguageModelCache（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャッシュミス時に新規パースが実行されること | E-01 L34-45 get()メソッド | ○ |
| C-02 | キャッシュヒット時にキャッシュから返却されること | E-01 L38-41 version/languageIdチェック | ○ |
| C-03 | バージョン変更時に再パースされること | E-01 L38 version比較 | ○ |
| C-04 | languageId変更時に再パースされること | E-01 L38 languageId比較 | ○ |
| C-05 | maxEntries到達時に最古エントリが削除されること | E-01 L48-62 LRU削除ロジック | ○ |
| C-06 | ドキュメント削除時にキャッシュから削除されること | E-01 L66-71 onDocumentRemoved() | ○ |
| C-07 | 存在しないドキュメント削除時にエラーにならないこと | E-01 L68 存在チェック | ○ |
| C-08 | dispose時にクリーンアップインターバルがクリアされること | E-01 L73-80 dispose() | ○ |
| C-09 | cleanupIntervalTimeInSec経過後に古いエントリが削除されること | E-01 L20-30 クリーンアップロジック | ○ |
| C-10 | cleanupIntervalTimeInSecが0の場合はインターバルが設定されないこと | E-01 L19 条件分岐 | ○ |

### strings（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | 文字列が指定した接尾辞で終わる場合trueを返すこと | E-04 L9-18 endsWith() | ○ |
| C-12 | 文字列が指定した接尾辞で終わらない場合falseを返すこと | E-04 L16 return false | ○ |
| C-13 | haystackとneedleが同一の場合trueを返すこと | E-04 L13-14 diff === 0 | ○ |
| C-14 | needleがhaystackより長い場合falseを返すこと | E-04 L15-16 else | ○ |
| C-15 | 特殊文字がエスケープされること | E-04 L20-22 convertSimple2RegExpPattern() | ○ |
| C-16 | ワイルドカード*が.*に変換されること | E-04 L21 replace(/[\*]/g, '.*') | ○ |

### runner（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Errorオブジェクトのメッセージとスタックが整形されること | E-05 L9-18 formatError() | ○ |
| C-18 | 文字列エラーがそのまま整形されること | E-05 L14 typeof err === 'string' | ○ |
| C-19 | errがnull/undefinedの場合messageのみ返すこと | E-05 L18 return message | ○ |
| C-20 | 正常完了時に結果が返却されること | E-05 L21-41 runSafeAsync() | ○ |
| C-21 | キャンセルトークン発火時にキャンセル応答が返却されること | E-05 L24-26 isCancellationRequested | ○ |
| C-22 | 例外発生時にerrorValが返却されること | E-05 L35-38 catch | ○ |
| C-23 | 同期関数が正常完了すること | E-05 L43-65 runSafe() | ○ |
| C-24 | 実行後キャンセル時にキャンセル応答が返却されること | E-05 L51-53 | ○ |
| C-25 | 例外発生時にerrorValが返却されること | E-05 L58-60 catch | ○ |

### validation（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | ドキュメント変更時にvalidationがトリガーされること | E-03 L26-28 onDidChangeContent | ○ |
| C-27 | ドキュメントクローズ時に診断がクリアされること | E-03 L31-34 onDidClose | ○ |
| C-28 | requestRefresh時に全ドキュメントが再検証されること | E-03 L62-63 requestRefresh | ○ |
| C-29 | dispose時にリソースがクリーンアップされること | E-03 L65-73 dispose | ○ |
| C-30 | 診断リクエスト時にvalidateが呼ばれること | E-03 L86-95 diagnostics.on | ○ |
| C-31 | ドキュメントが存在しない場合空の診断が返却されること | E-03 L92 空レポート | ○ |
| C-32 | requestRefresh時にdiagnostics.refreshが呼ばれること | E-03 L97-99 | ○ |

### languageParticipants（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | 初期状態でjson/jsonc/snippetsが含まれること | E-06 L40-45 update() | ○ |
| C-34 | 登録済み言語に対してtrueを返すこと | E-06 L74 hasLanguage() | ○ |
| C-35 | 未登録言語に対してfalseを返すこと | E-06 L74 Set.has() | ○ |
| C-36 | jsoncに対してtrueを返すこと | E-06 L44-45 comments.add() | ○ |
| C-37 | jsonに対してfalseを返すこと | E-06 L75 useComments() | ○ |
| C-38 | 登録言語のリストが返却されること | E-06 L73 documentSelector | ○ |
| C-39 | 拡張機能変更時に言語セットが更新されること | E-06 L65-69 onDidChange | ○ |
| C-40 | 同一セットに対してtrueを返すこと | E-06 L80-90 isEqualSet() | ○ |
| C-41 | 異なるセットに対してfalseを返すこと | E-06 L81-88 | ○ |

### urlMatch（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | localhost URLに対してtrueを返すこと | E-07 L21-23 isLocalhostAuthority | ○ |
| C-43 | 127.0.0.1に対してtrueを返すこと | E-07 L102 r127正規表現 | ○ |
| C-44 | [::1]に対してtrueを返すこと | E-07 L103 rIPv6Localhost | ○ |
| C-45 | ワイルドカード*にマッチすること | E-07 L31-33 | ○ |
| C-46 | 完全一致ドメインにマッチすること | E-07 L44-46 matchesAuthority | ○ |
| C-47 | サブドメインワイルドカードにマッチすること | E-07 L71-75 | ○ |
| C-48 | パスプレフィックスにマッチすること | E-07 L92-97 matchesPath | ○ |
| C-49 | スキームが異なる場合falseを返すこと | E-07 L39-41 | ○ |
| C-50 | 空パターンがスキップされること | E-07 L26-28 | ○ |
| C-51 | 完全一致authorityがマッチすること | E-07 L67-69 | ○ |
| C-52 | 大文字小文字を区別しないこと | E-07 L64-65 toLowerCase | ○ |
| C-53 | 空パスパターンが全てにマッチすること | E-07 L82-84 | ○ |
| C-54 | ルートパスパターンが全てにマッチすること | E-07 L82-84 | ○ |
| C-55 | localhost:ポートがマッチすること | E-07 L101 rLocalhost | ○ |
| C-56 | sub.localhostがマッチすること | E-07 L101 (.+\.)?localhost | ○ |

### hash（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | null値に対して固定ハッシュを返すこと | E-08 L13 numberHash(349) | ○ |
| C-58 | 配列に対して一貫したハッシュを返すこと | E-08 L47-49 arrayHash | ○ |
| C-59 | オブジェクトに対して一貫したハッシュを返すこと | E-08 L52-58 objectHash | ○ |
| C-60 | 文字列に対してハッシュを返すこと | E-08 L39-45 stringHash | ○ |
| C-61 | 数値に対してハッシュを返すこと | E-08 L23 numberHash | ○ |
| C-62 | boolean値に対してハッシュを返すこと | E-08 L35-37 booleanHash | ○ |
| C-63 | undefined値に対して固定ハッシュを返すこと | E-08 L25 937 * 31 | ○ |
| C-64 | キー順序に依存しないハッシュを返すこと | E-08 L54 Object.keys().sort() | ○ |

### JSONSchemaCache（E-11）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | Mementoから有効なキャッシュ情報を読み込むこと | E-11 L26-36 constructor | ○ |
| C-66 | 不正なキャッシュ情報がフィルタリングされること | E-11 L30-33 型チェック | ○ |
| C-67 | キャッシュ済みスキーマのETagが返却されること | E-11 L38-40 getETag | ○ |
| C-68 | 未キャッシュスキーマに対してundefinedを返すこと | E-11 L39 オプショナルチェーン | ○ |
| C-69 | 最終更新からの経過時間が正しく計算されること | E-11 L42-48 getLastUpdatedInHours | ○ |
| C-70 | 未キャッシュスキーマに対してundefinedを返すこと | E-11 L47 return undefined | ○ |
| C-71 | スキーマがファイルに保存されること | E-11 L50-61 putSchema | ○ |
| C-72 | ファイル書き込み失敗時にキャッシュエントリが削除されること | E-11 L56-58 catch | ○ |
| C-73 | 有効期限内の場合スキーマが返却されること | E-11 L63-69 getSchemaIfUpdatedSince | ○ |
| C-74 | 有効期限切れの場合undefinedを返すこと | E-11 L65 条件分岐 | ○ |
| C-75 | ETag一致時にキャッシュからスキーマが返却されること | E-11 L71-81 getSchema | ○ |
| C-76 | ETag不一致時にキャッシュファイルが削除されること | E-11 L77-78 deleteSchemaFile | ○ |
| C-77 | 全キャッシュファイルが削除されること | E-11 L124-143 clearCache | ○ |
| C-78 | URIからSHA256ハッシュベースのファイル名が生成されること | E-11 L145-147 getCacheFileName | ○ |

### jsonServer（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | 初期化時にサーバー能力が正しく設定されること | E-02 L146-209 onInitialize | ○ |
| C-80 | fileプロトコルがruntime.fileで処理されること | E-02 L91-99 getSchemaRequestService | ○ |
| C-81 | httpプロトコルがruntime.httpで処理されること | E-02 L96-98 | ○ |
| C-82 | 未処理プロトコルがVSCodeContentRequestで処理されること | E-02 L107-111 | ○ |
| C-83 | 空ドキュメントに対して空の診断配列を返すこと | E-02 L387-389 validateTextDocument | ○ |
| C-84 | JSON言語設定でコメントがエラーになること | E-02 L391 comments: 'error' | ○ |
| C-85 | JSONC言語設定でコメントが無視されること | E-02 L391 comments: 'ignore' | ○ |
| C-86 | スキーマ設定が正しくマージされること | E-02 L346-384 updateConfiguration | ○ |
| C-87 | フォーマット結果が返却されること | E-02 L472-485 onFormat | ○ |
| C-88 | 編集数上限超過時に全体置換されること | E-02 L478-480 | ○ |
| C-89 | ドキュメント全体のRangeが返却されること | E-02 L557-559 getFullRange | ○ |
| C-90 | 相対パスが絶対パスに解決されること | E-02 L66-71 workspaceContext | ○ |

### jsonClient（E-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | クライアントが正常に起動すること | E-09 L182-211 startClient | ○ |
| C-92 | languageParticipants変更時に再起動されること | E-09 L189-203 | ○ |
| C-93 | 非HTTP/HTTPSスキームがtrueを返すこと | E-09 L659-662 isTrusted | ○ |
| C-94 | trustedDomainsにマッチするURIがtrueを返すこと | E-09 L666-668 | ○ |
| C-95 | knownAssociationsに含まれるURIがtrueを返すこと | E-09 L670-675 | ○ |
| C-96 | キャッシュ有効時にキャッシュが返却されること | E-09 L643-648 getSettings | ○ |
| C-97 | forceRefresh時に再計算されること | E-09 L644-645 | ○ |
| C-98 | HTTP設定が正しく取得されること | E-09 L837-841 computeSettings | ○ |
| C-99 | resultLimitが正規化されること | E-09 L824-826 normalizeLimit | ○ |
| C-100 | URL指定時にそのまま返却されること | E-09 L899-909 getSchemaId | ○ |
| C-101 | 相対パスが解決されること | E-09 L905-906 | ○ |
| C-102 | インラインスキーマにIDが生成されること | E-09 L902-903 | ○ |
| C-103 | スキーマ解決エラーに対してtrueを返すこと | E-09 L927-929 isSchemaResolveError | ○ |
| C-104 | 通常の診断に対してfalseを返すこと | E-09 L928 | ○ |

### languageStatus（E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | ステータスアイテムが作成されること | E-10 L166-217 createLanguageStatusItem | ○ |
| C-106 | スキーマなし時に適切なテキストが設定されること | E-10 L187-189 | ○ |
| C-107 | 単一スキーマ時に適切なテキストが設定されること | E-10 L190-192 | ○ |
| C-108 | 制限到達時にステータスが表示されること | E-10 L246-254 update | ○ |
| C-109 | 制限解除時にステータスがクリアされること | E-10 L240-245 | ○ |
| C-110 | スキーマ読み込みエラー時にステータスが表示されること | E-10 L312-321 | ○ |
| C-111 | 信頼されていないワークスペースで適切な詳細が表示されること | E-10 L343-345 | ○ |
| C-112 | ダウンロード無効時に適切な詳細が表示されること | E-10 L346-348 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全テストケースにソースコード根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接抽出されており、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] LanguageModelCacheのLRU動作が正しく検証されているか確認
- [ ] URLマッチングのセキュリティ関連テストケースが網羅されているか確認
- [ ] JSONSchemaCacheのファイルI/Oエラーハンドリングが適切にテストされているか確認
- [ ] キャンセルトークン処理のタイミング問題がカバーされているか確認
- [ ] 境界値テスト（空配列、最大値など）の網羅性を確認
