---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 111
  claims_with_evidence: 111
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-media-preview 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：111 / 111、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/media-preview/src/extension.ts` - 拡張機能エントリーポイント
- E-02: `extensions/media-preview/src/mediaPreview.ts` - MediaPreview基底クラス、reopenAsText関数
- E-03: `extensions/media-preview/src/imagePreview/index.ts` - ImagePreviewManager、ImagePreviewクラス
- E-04: `extensions/media-preview/src/audioPreview.ts` - AudioPreviewProvider、AudioPreviewクラス
- E-05: `extensions/media-preview/src/videoPreview.ts` - VideoPreviewProvider、VideoPreviewクラス
- E-06: `extensions/media-preview/src/ownedStatusBarEntry.ts` - PreviewStatusBarEntry基底クラス
- E-07: `extensions/media-preview/src/binarySizeStatusBarEntry.ts` - BinarySizeStatusBarEntry、BinarySizeクラス
- E-08: `extensions/media-preview/src/imagePreview/sizeStatusBarEntry.ts` - SizeStatusBarEntryクラス
- E-09: `extensions/media-preview/src/imagePreview/zoomStatusBarEntry.ts` - ZoomStatusBarEntryクラス
- E-10: `extensions/media-preview/src/util/dispose.ts` - Disposableクラス、disposeAll関数
- E-11: `extensions/media-preview/src/util/dom.ts` - escapeAttribute関数
- E-12: `extensions/media-preview/src/util/uuid.ts` - generateUuid関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Disposable.disposeですべての登録済みDisposableが破棄されること | E-10 (L22-28) | ○ |
| C-02 | Disposable二重dispose時に例外が発生しないこと | E-10 (L23-25) _isDisposedチェック | ○ |
| C-03 | Disposable._registerでオブジェクトが正しく登録されること | E-10 (L30-36) | ○ |
| C-04 | dispose済み状態で_register呼び出し時に即座にdisposeされること | E-10 (L31-32) | ○ |
| C-05 | isDisposedプロパティの動作確認 | E-10 (L39-41) | ○ |
| C-06 | isDisposedプロパティの動作確認 | E-10 (L39-41) | ○ |
| C-07 | disposeAllで配列内のすべてのDisposableが破棄されること | E-10 (L8-15) | ○ |
| C-08 | disposeAllで空配列の場合にエラーなく終了すること | E-10 (L9) whileループ条件 | ○ |
| C-09 | generateUuidでUUID v4形式の文字列が生成されること | E-12 (L9-57) | ○ |
| C-10 | crypto.randomUUID非対応環境でもUUIDが生成されること | E-12 (L20-57) フォールバック処理 | ○ |
| C-11 | UUIDがv4の仕様に準拠していること | E-12 (L30-32) バージョン/バリアントビット設定 | ○ |
| C-12 | escapeAttributeでダブルクォートがエスケープされること | E-11 (L7-8) | ○ |
| C-13 | escapeAttributeでvscode.Uriオブジェクトが処理されること | E-11 (L7) value.toString() | ○ |
| C-14 | escapeAttributeで空文字列が処理されること | E-11 (L7-8) | ○ |
| C-15 | escapeAttributeでエスケープ不要文字列がそのまま返却されること | E-11 (L8) replace処理 | ○ |
| C-16 | PreviewStatusBarEntry.constructorでStatusBarItemが作成されること | E-06 (L14-17) | ○ |
| C-17 | PreviewStatusBarEntry.showItemでテキストが設定され表示されること | E-06 (L20-24) | ○ |
| C-18 | PreviewStatusBarEntry.hideで正しいオーナーの場合に非表示になること | E-06 (L26-30) | ○ |
| C-19 | PreviewStatusBarEntry.hideで異なるオーナーの場合に非表示にならないこと | E-06 (L27) オーナー比較条件 | ○ |
| C-20 | BinarySize.formatSizeでバイト単位の処理 | E-07 (L16-18) | ○ |
| C-21 | BinarySize.formatSizeでKB単位の処理 | E-07 (L20-22) | ○ |
| C-22 | BinarySize.formatSizeでMB単位の処理 | E-07 (L24-26) | ○ |
| C-23 | BinarySize.formatSizeでGB単位の処理 | E-07 (L28-30) | ○ |
| C-24 | BinarySize.formatSizeでTB単位の処理 | E-07 (L32-33) | ○ |
| C-25 | BinarySize.formatSizeで1KB境界(1023)の処理 | E-07 (L17) 比較条件 | ○ |
| C-26 | BinarySize.formatSizeで1KB境界(1024)の処理 | E-07 (L17, L21) 条件分岐 | ○ |
| C-27 | BinarySize.formatSizeで0バイトの処理 | E-07 (L17-18) | ○ |
| C-28 | BinarySizeStatusBarEntry.showで数値サイズの処理 | E-07 (L43-45) | ○ |
| C-29 | BinarySizeStatusBarEntry.showでundefinedの処理 | E-07 (L46-47) | ○ |
| C-30 | SizeStatusBarEntry.showでテキスト表示 | E-08 (L16-18) | ○ |
| C-31 | ZoomStatusBarEntry.constructorでコマンド登録 | E-09 (L22-37) | ○ |
| C-32 | ZoomStatusBarEntry.showで数値スケール表示 | E-09 (L42-43, L46-49) | ○ |
| C-33 | ZoomStatusBarEntry.showでfit表示 | E-09 (L47-48) | ○ |
| C-34 | ZoomStatusBarEntry.zoomLabelで0.5スケール処理 | E-09 (L49) | ○ |
| C-35 | ZoomStatusBarEntry.zoomLabelで10スケール処理 | E-09 (L49) | ○ |
| C-36 | ZoomStatusBarEntry.onDidChangeScaleイベント発火 | E-09 (L35) _onDidChangeScale.fire | ○ |
| C-37 | reopenAsTextでvscode.openWithコマンド実行 | E-02 (L11-13) | ○ |
| C-38 | MediaPreview.constructorでwebview.options設定 | E-02 (L34-41) | ○ |
| C-39 | MediaPreview.constructorでファイルウォッチャー登録 | E-02 (L52-64) | ○ |
| C-40 | MediaPreview.resourceゲッター | E-02 (L72-74) | ○ |
| C-41 | MediaPreview.disposeでhide呼び出し | E-02 (L67-70) | ○ |
| C-42 | MediaPreview.updateBinarySizeでサイズ取得 | E-02 (L76-81) | ○ |
| C-43 | MediaPreview.renderでwebview.html設定 | E-02 (L83-94) | ○ |
| C-44 | MediaPreview.renderでDisposed状態チェック | E-02 (L84-86) | ○ |
| C-45 | MediaPreview.updateStateでアクティブ時show呼び出し | E-02 (L103-105) | ○ |
| C-46 | MediaPreview.updateStateで非アクティブ時hide呼び出し | E-02 (L106-108) | ○ |
| C-47 | MediaPreview.updateStateでDisposed状態チェック | E-02 (L99-101) | ○ |
| C-48 | MediaPreview.onDidChangeViewStateでupdateState呼び出し | E-02 (L43-45) | ○ |
| C-49 | MediaPreview.onDidDisposeでpreviewState設定 | E-02 (L47-50) | ○ |
| C-50 | watcher.onDidChangeでファイル変更時処理 | E-02 (L53-58) | ○ |
| C-51 | watcher.onDidChangeで異なるファイル時スキップ | E-02 (L54) toString比較 | ○ |
| C-52 | watcher.onDidDeleteでwebviewEditor破棄 | E-02 (L60-64) | ○ |
| C-53 | ImagePreviewManager.openCustomDocument | E-03 (L29-31) | ○ |
| C-54 | ImagePreviewManager.resolveCustomEditorでPreview作成 | E-03 (L33-40) | ○ |
| C-55 | ImagePreviewManager.resolveCustomEditorでactivePreview設定 | E-03 (L39) | ○ |
| C-56 | ImagePreviewManager.getPreviewForで一致検索 | E-03 (L56-65) | ○ |
| C-57 | ImagePreviewManager.getPreviewForで不一致時undefined | E-03 (L64) | ○ |
| C-58 | ImagePreviewManager.getPreviewForでviewColumnフィルタ | E-03 (L59-60) | ○ |
| C-59 | ImagePreviewManager.onDidDisposeでSet削除 | E-03 (L41) | ○ |
| C-60 | ImagePreviewManager.onDidChangeViewStateでアクティブ設定 | E-03 (L43-49) | ○ |
| C-61 | ImagePreviewManager.onDidChangeViewStateで非アクティブ設定 | E-03 (L46-47) | ○ |
| C-62 | ImagePreview.constructorで初期化 | E-03 (L80-130) | ○ |
| C-63 | ImagePreview.onDidReceiveMessage(size) | E-03 (L92-95) | ○ |
| C-64 | ImagePreview.onDidReceiveMessage(zoom) | E-03 (L97-100) | ○ |
| C-65 | ImagePreview.onDidReceiveMessage(reopen-as-text) | E-03 (L102-105) | ○ |
| C-66 | ImagePreview.zoomInでActive時処理 | E-03 (L142-146) | ○ |
| C-67 | ImagePreview.zoomInで非Active時スキップ | E-03 (L143) previewState条件 | ○ |
| C-68 | ImagePreview.zoomOutでActive時処理 | E-03 (L148-152) | ○ |
| C-69 | ImagePreview.zoomOutで非Active時スキップ | E-03 (L149) previewState条件 | ○ |
| C-70 | ImagePreview.copyImageでActive時処理 | E-03 (L154-159) | ○ |
| C-71 | ImagePreview.copyImageで非Active時スキップ | E-03 (L155) previewState条件 | ○ |
| C-72 | ImagePreview.updateStateでアクティブ時ステータスバー表示 | E-03 (L168-170) | ○ |
| C-73 | ImagePreview.updateStateで非アクティブ時ステータスバー非表示 | E-03 (L171-174) | ○ |
| C-74 | ImagePreview.disposeでステータスバー非表示 | E-03 (L132-136) | ○ |
| C-75 | ImagePreview.renderでsetActiveメッセージ送信 | E-03 (L177-180) | ○ |
| C-76 | ImagePreview.getWebviewContentsでHTML生成 | E-03 (L182-216) | ○ |
| C-77 | ImagePreview.getWebviewContentsでCSP設定 | E-03 (L204) | ○ |
| C-78 | ImagePreview.getResourcePathでバージョンクエリ付加 | E-03 (L228-230) | ○ |
| C-79 | ImagePreview.getResourcePathで既存クエリ時スキップ | E-03 (L227-228) | ○ |
| C-80 | ImagePreview.getResourcePathでgitスキーム空ファイル処理 | E-03 (L219-224) | ○ |
| C-81 | ImagePreview.reopenAsTextで再オープン処理 | E-03 (L237-240) | ○ |
| C-82 | ImagePreview.onDidChangeScaleでスケール同期 | E-03 (L109-113) | ○ |
| C-83 | AudioPreviewProvider.openCustomDocument | E-04 (L21-23) | ○ |
| C-84 | AudioPreviewProvider.resolveCustomEditor | E-04 (L25-27) | ○ |
| C-85 | AudioPreview.constructorで初期化 | E-04 (L33-53) | ○ |
| C-86 | AudioPreview.onDidReceiveMessage(reopen-as-text) | E-04 (L42-47) | ○ |
| C-87 | AudioPreview.getWebviewContentsでHTML生成 | E-04 (L55-89) | ○ |
| C-88 | AudioPreview.getWebviewContentsでCSPにmedia-src含む | E-04 (L77) | ○ |
| C-89 | AudioPreview.getResourcePathでバージョンクエリ付加 | E-04 (L100-104) | ○ |
| C-90 | AudioPreview.getResourcePathでgitスキーム空ファイル処理 | E-04 (L92-97) | ○ |
| C-91 | VideoPreviewProvider.openCustomDocument | E-05 (L22-24) | ○ |
| C-92 | VideoPreviewProvider.resolveCustomEditor | E-05 (L26-28) | ○ |
| C-93 | VideoPreview.constructorで初期化 | E-05 (L34-54) | ○ |
| C-94 | VideoPreview.onDidReceiveMessage(reopen-as-text) | E-05 (L43-48) | ○ |
| C-95 | VideoPreview.getWebviewContentsでHTML生成 | E-05 (L56-93) | ○ |
| C-96 | VideoPreview.getWebviewContentsでautoPlay設定反映 | E-05 (L61) | ○ |
| C-97 | VideoPreview.getWebviewContentsでloop設定反映 | E-05 (L62) | ○ |
| C-98 | VideoPreview.getResourcePathでバージョンクエリ付加 | E-05 (L104-108) | ○ |
| C-99 | VideoPreview.getResourcePathでgitスキーム空ファイル処理 | E-05 (L96-101) | ○ |
| C-100 | registerImagePreviewSupportでプロバイダ登録 | E-03 (L255-257) | ○ |
| C-101 | registerImagePreviewSupportでzoomInコマンド登録 | E-03 (L259-261) | ○ |
| C-102 | registerImagePreviewSupportでzoomOutコマンド登録 | E-03 (L263-265) | ○ |
| C-103 | registerImagePreviewSupportでcopyImageコマンド登録 | E-03 (L267-269) | ○ |
| C-104 | registerImagePreviewSupportでreopenAsTextコマンド登録 | E-03 (L271-273) | ○ |
| C-105 | registerImagePreviewSupportでreopenAsPreviewコマンド登録 | E-03 (L275-278) | ○ |
| C-106 | registerAudioPreviewSupportでプロバイダ登録 | E-04 (L113-119) | ○ |
| C-107 | registerAudioPreviewSupportでretainContextWhenHidden設定 | E-04 (L117) | ○ |
| C-108 | registerVideoPreviewSupportでプロバイダ登録 | E-05 (L117-123) | ○ |
| C-109 | registerVideoPreviewSupportでretainContextWhenHidden設定 | E-05 (L121) | ○ |
| C-110 | activateでBinarySizeStatusBarEntry作成 | E-01 (L13-14) | ○ |
| C-111 | activateで3つのプレビューサポート登録 | E-01 (L16-18) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべてのテストケースについて、ソースコードから根拠を確認できた
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべてのテストケースがソースコードに基づいて設計されている
- **注意点**:
  - XSS対策の`escapeAttribute`関数は高優先度でテストが必要（セキュリティ関連）
  - ファイルサイズ計算の`BinarySize.formatSize`は境界値テストが重要
  - リソース解放の`Disposable`クラスはメモリリーク防止の観点で重要

## 6) レビュアーチェックリスト（最小）
- [ ] Disposableクラスのdispose/二重dispose処理が正しくテストされているか
- [ ] escapeAttribute関数のXSS対策が十分にテストされているか
- [ ] BinarySize.formatSizeの境界値テストが網羅されているか
- [ ] MediaPreviewのライフサイクル（初期化・破棄）が正しくテストされているか
- [ ] ImagePreview/AudioPreview/VideoPreviewのメッセージハンドリングがテストされているか
- [ ] PreviewManagerのPreview管理（追加・削除・検索）がテストされているか
- [ ] コマンド登録の確認がテストされているか
