---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 108
  claims_with_evidence: 108
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-merge-conflict 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：108 / 108、根拠なし：0
- 優先レビュー（高）
  1. **UT-EMC-002〜005**: コンフリクト解決のcommitEdit機能（ビジネスクリティカル）
  2. **UT-EMC-012〜018**: MergeConflictParserのscanDocument機能（パーサーコア機能）
  3. **UT-EMC-050〜074**: CommandHandlerのコマンド処理（ユーザー操作の主要エントリポイント）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/extensions/merge-conflict/src/documentMergeConflict.ts` (行1-104)
- E-02: `/extensions/merge-conflict/src/mergeConflictParser.ts` (行1-170)
- E-03: `/extensions/merge-conflict/src/delayer.ts` (行1-80)
- E-04: `/extensions/merge-conflict/src/documentTracker.ts` (行1-156)
- E-05: `/extensions/merge-conflict/src/commandHandler.ts` (行1-370)
- E-06: `/extensions/merge-conflict/src/codelensProvider.ts` (行1-109)
- E-07: `/extensions/merge-conflict/src/mergeDecorator.ts` (行1-252)
- E-08: `/extensions/merge-conflict/src/contentProvider.ts` (行1-54)
- E-09: `/extensions/merge-conflict/src/services.ts` (行1-72)
- E-10: `/extensions/merge-conflict/src/interfaces.ts` (行1-49)

## 3) Claims と根拠の対応（レビューの主戦場）

### DocumentMergeConflict クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | constructorで正しく初期化されること | E-01 (行18-24) | ○ |
| C-02 | CommitType.Currentで置換されること | E-01 (行71-74) | ○ |
| C-03 | CommitType.Incomingで置換されること | E-01 (行76-78) | ○ |
| C-04 | CommitType.Bothで両方結合されること | E-01 (行80-87) | ○ |
| C-05 | テレメトリが送信されること | E-01 (行38-45) | ○ |
| C-06 | applied=trueで二重適用防止 | E-01 (行57-60) | ○ |
| C-07 | 改行のみのコンテンツは空文字で置換 | E-01 (行90-94) | ○ |
| C-08 | CRLF対応 | E-01 (行100-102) | ○ |
| C-09 | isNewlineOnlyでLF判定 | E-01 (行100-102) | ○ |
| C-10 | isNewlineOnlyでCRLF判定 | E-01 (行100-102) | ○ |
| C-11 | isNewlineOnlyで通常テキスト判定 | E-01 (行100-102) | ○ |

### MergeConflictParser クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | 単一コンフリクト検出 | E-02 (行24-86) | ○ |
| C-13 | 複数コンフリクト検出 | E-02 (行24-86) | ○ |
| C-14 | commonAncestorsマーカー検出 | E-02 (行57-59) | ○ |
| C-15 | 不完全なコンフリクトスキップ | E-02 (行88-92) | ○ |
| C-16 | ネストしたマーカーで解析停止 | E-02 (行45-51) | ○ |
| C-17 | 空ドキュメントで空配列 | E-02 (行35-41) | ○ |
| C-18 | 空行スキップ | E-02 (行38-41) | ○ |
| C-19 | containsConflictでtrue | E-02 (行145-152) | ○ |
| C-20 | containsConflictでfalse | E-02 (行145-152) | ○ |
| C-21 | nullドキュメント対応 | E-02 (行146-148) | ○ |
| C-22 | 部分マーカー対応 | E-02 (行150-151) | ○ |
| C-23 | shiftBackOneCharacter通常 | E-02 (行154-168) | ○ |
| C-24 | shiftBackOneCharacter行頭 | E-02 (行162-165) | ○ |
| C-25 | shiftBackOneCharacter同一位置 | E-02 (行155-157) | ○ |

### Delayer クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | constructor初期化 | E-03 (行18-24) | ○ |
| C-27 | trigger遅延実行 | E-03 (行26-52) | ○ |
| C-28 | trigger debounce動作 | E-03 (行26-52) | ○ |
| C-29 | 負値delayでdefaultDelay使用 | E-03 (行44-48) | ○ |
| C-30 | forceDelivery即座実行 | E-03 (行54-62) | ○ |
| C-31 | forceDelivery待機なしでnull | E-03 (行55-57) | ○ |
| C-32 | isTriggered待機中でtrue | E-03 (行64-66) | ○ |
| C-33 | isTriggered待機なしでfalse | E-03 (行64-66) | ○ |
| C-34 | cancelでタスクキャンセル | E-03 (行68-71) | ○ |

### DocumentMergeConflictTracker クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | getConflicts取得 | E-04 (行53-79) | ○ |
| C-36 | キャッシュ使用 | E-04 (行63-70) | ○ |
| C-37 | URI無しドキュメント対応 | E-04 (行58-61) | ○ |
| C-38 | isPending待機中true | E-04 (行81-97) | ○ |
| C-39 | isPending待機なしfalse | E-04 (行81-97) | ○ |
| C-40 | isPending nullドキュメント | E-04 (行82-84) | ○ |
| C-41 | forgetでキャッシュクリア | E-04 (行103-109) | ○ |
| C-42 | createTrackerファクトリ | E-04 (行99-101) | ○ |
| C-43 | disposeでキャッシュ全クリア | E-04 (行111-113) | ○ |
| C-44 | テレメトリ初回送信 | E-04 (行129-141) | ○ |
| C-45 | テレメトリ重複防止 | E-04 (行128-130) | ○ |

### ScanTask クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | constructor初期化 | E-04 (行16-19) | ○ |
| C-47 | addOrigin追加 | E-04 (行21-23) | ○ |
| C-48 | hasOrigin存在true | E-04 (行25-27) | ○ |
| C-49 | hasOrigin存在false | E-04 (行25-27) | ○ |

### CommandHandler クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | acceptCurrent | E-05 (行53-55) | ○ |
| C-51 | acceptIncoming | E-05 (行57-59) | ○ |
| C-52 | acceptBoth | E-05 (行61-63) | ○ |
| C-53 | acceptSelectionでCurrent | E-05 (行178-179) | ○ |
| C-54 | acceptSelectionでIncoming | E-05 (行181-183) | ○ |
| C-55 | splitter上で警告 | E-05 (行188-190) | ○ |
| C-56 | commonAncestors上で警告 | E-05 (行184-186) | ○ |
| C-57 | acceptAllCurrent | E-05 (行65-67) | ○ |
| C-58 | acceptAllIncoming | E-05 (行69-71) | ○ |
| C-59 | acceptAllBoth | E-05 (行81-83) | ○ |
| C-60 | acceptAllResources | E-05 (行275-294) | ○ |
| C-61 | navigateNext | E-05 (行150-151) | ○ |
| C-62 | navigatePrevious | E-05 (行154-156) | ○ |
| C-63 | navigateNextラップアラウンド | E-05 (行363-367) | ○ |
| C-64 | navigatePreviousラップアラウンド | E-05 (行346-349) | ○ |
| C-65 | navigateコンフリクトなし警告 | E-05 (行205-212) | ○ |
| C-66 | 単一コンフリクト内移動不可 | E-05 (行325-329) | ○ |
| C-67 | compare実行 | E-05 (行85-148) | ○ |
| C-68 | compareコンフリクトなし警告 | E-05 (行92-95) | ○ |
| C-69 | diffViewPositionBeside | E-05 (行137-140) | ○ |
| C-70 | diffViewPositionBelow | E-05 (行143-145) | ○ |
| C-71 | autoNavigateNextConflict | E-05 (行251-254) | ○ |
| C-72 | findConflictContainingSelection検出 | E-05 (行296-313) | ○ |
| C-73 | findConflictContainingSelectionカーソル外 | E-05 (行306-310) | ○ |
| C-74 | findConflictContainingSelectionコンフリクトなし | E-05 (行302-304) | ○ |
| C-75 | dispose | E-05 (行197-200) | ○ |

### MergeConflictCodeLensProvider クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | provideCodeLenses提供 | E-06 (行47-98) | ○ |
| C-77 | mergeConflictsCountコンテキスト | E-06 (行55) | ○ |
| C-78 | CodeLens無効時null | E-06 (行49-51) | ○ |
| C-79 | コンフリクトなしでnull | E-06 (行57-59) | ○ |
| C-80 | configurationUpdated有効化 | E-06 (行32-34) | ○ |
| C-81 | configurationUpdated無効化 | E-06 (行28-31) | ○ |
| C-82 | dispose | E-06 (行40-45) | ○ |

### MergeDecorator クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | beginイベント登録 | E-07 (行30-42) | ○ |
| C-84 | begin既存エディタデコレーション | E-07 (行28) | ○ |
| C-85 | configurationUpdated再適用 | E-07 (行44-53) | ○ |
| C-86 | registerDecorationTypes登録 | E-07 (行67-124) | ○ |
| C-87 | registerDecorationTypes無効時 | E-07 (行62-64) | ○ |
| C-88 | applyDecorations適用 | E-07 (行163-236) | ○ |
| C-89 | applyDecorationsエディタnull | E-07 (行164) | ○ |
| C-90 | applyDecorations config未設定 | E-07 (行166-168) | ○ |
| C-91 | applyDecorations更新中フラグ | E-07 (行171-173) | ○ |
| C-92 | applyDecorations commonAncestors | E-07 (行206-210) | ○ |
| C-93 | removeDecorations削除 | E-07 (行238-250) | ○ |
| C-94 | dispose解放 | E-07 (行127-135) | ○ |

### MergeConflictContentProvider クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | provideTextDocumentContent提供 | E-08 (行24-53) | ○ |
| C-96 | 複数range結合 | E-08 (行34-42) | ○ |
| C-97 | 例外時null | E-08 (行49-52) | ○ |
| C-98 | 例外時エラーメッセージ | E-08 (行50) | ○ |
| C-99 | begin登録 | E-08 (行15-19) | ○ |

### ServiceWrapper クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | begin全サービス初期化 | E-09 (行27-44) | ○ |
| C-101 | begin設定変更リスナー | E-09 (行46-52) | ○ |
| C-102 | createExtensionConfiguration読み込み | E-09 (行55-65) | ○ |
| C-103 | codeLens.enabledデフォルト | E-09 (行57) | ○ |
| C-104 | decorators.enabledデフォルト | E-09 (行58) | ○ |
| C-105 | dispose解放 | E-09 (行67-70) | ○ |

### OriginDocumentMergeConflictTracker クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | getConflicts委譲 | E-04 (行34-36) | ○ |
| C-107 | isPending委譲 | E-04 (行38-40) | ○ |
| C-108 | forget委譲 | E-04 (行42-44) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコード解析に基づいており、実装との整合性が高い
- 注意点：
  - VS Code APIのモック方法が複雑になる可能性あり（vscode.window, vscode.workspace等）
  - TelemetryReporterのモック設計が必要
  - 非同期処理（Promise, async/await）のテストタイミング制御

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがクラス/メソッドの主要ロジックを網羅しているか
- [ ] 境界値テストが適切に設計されているか
- [ ] 異常系（null、空、不正値）のテストケースが存在するか
- [ ] VS Code APIのモック戦略が適切か
- [ ] 非同期処理のテストが適切に設計されているか
- [ ] テレメトリ関連のテストでプライバシーに配慮した設計か
