---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-mermaid-chat-features 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：40 / 40、根拠なし：0
- 優先レビュー（高）
  1. **UT-MCF-004～006**：renderMermaidDiagram.invoke のツール実行結果（proposed API使用のため実装詳細要確認）
  2. **UT-MCF-010～011**：Content-Security-Policy とXSS対策（セキュリティ関連）
  3. **UT-MCF-020～025**：UUID生成のフォールバック実装（crypto API依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `extensions/mermaid-chat-features/src/extension.ts`（メイン拡張機能実装）
- E-02: `extensions/mermaid-chat-features/src/uuid.ts`（UUID生成ユーティリティ）
- E-03: `extensions/mermaid-chat-features/chat-webview-src/index.ts`（Webview側スクリプト）
- E-04: `extensions/mermaid-chat-features/package.json`（拡張機能マニフェスト）

## 3) Claims と根拠の対応（レビューの主戦場）

### extension.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | activate 関数で subscriptions に2つのリソースが登録される | E-01 (L18-69) | ○ |
| C-02 | renderMermaidDiagram ツールが vscode.lm.registerTool で登録される | E-01 (L21-28) | ○ |
| C-03 | chatOutputRenderer が viewType='vscode.chatMermaidDiagram' で登録される | E-01 (L33-69), E-04 (L43-49) | ○ |
| C-04 | invoke で LanguageModelToolResult が返却される | E-01 (L23-26, L73-88) | ○ |
| C-05 | toolResultDetails2.mime が 'text/vnd.mermaid' | E-01 (L16, L84) | ○ |
| C-06 | ソースコードが TextEncoder でエンコードされる | E-01 (L85) | ○ |
| C-07 | 空入力時も LanguageModelToolResult が返却される | E-01 (L73-88) | ○ |
| C-08 | renderChatOutput で webview.html が設定される | E-01 (L49-67) | ○ |
| C-09 | webview.options で enableScripts=true が設定される | E-01 (L40-43) | ○ |
| C-10 | CSP に nonce と cspSource が含まれる | E-01 (L57) | ○ |
| C-11 | escapeHtmlText でXSSが防止される | E-01 (L62, L91-98) | ○ |
| C-12 | writeMermaidToolOutput が LanguageModelTextPart を含む結果を返す | E-01 (L73-77) | ○ |
| C-13～19 | escapeHtmlText の各特殊文字エスケープ | E-01 (L91-98) | ○ |
| C-38 | TextDecoder でバイナリがデコードされる | E-01 (L36) | ○ |
| C-39 | generateUuid() で nonce が生成される | E-01 (L46) | ○ |
| C-40 | webview.asWebviewUri で URI 変換される | E-01 (L65) | ○ |

### uuid.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | crypto.randomUUID が利用可能な場合に使用される | E-02 (L10-18) | ○ |
| C-21 | フォールバック実装で UUID が生成される | E-02 (L20-57) | ○ |
| C-22 | バージョン4のビット設定（_data[6]） | E-02 (L31) | ○ |
| C-23 | バリアントビット設定（_data[8]） | E-02 (L32) | ○ |
| C-24 | 複数回呼び出しで異なる UUID | E-02 (L28 crypto.getRandomValues) | ○ |
| C-25 | 8-4-4-4-12 フォーマット | E-02 (L35-56) | ○ |

### chat-webview-src/index.ts 関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | vscode-dark クラスで 'dark' が返却される | E-03 (L7-11) | ○ |
| C-27 | vscode-high-contrast クラスで 'dark' が返却される | E-03 (L8) | ○ |
| C-28 | それ以外で 'default' が返却される | E-03 (L10) | ○ |
| C-29 | init で mermaid.initialize が呼ばれる | E-03 (L36) | ○ |
| C-30 | .mermaid 要素がない場合に早期リターン | E-03 (L22-24) | ○ |
| C-31 | state が正しく初期化される | E-03 (L26-30) | ○ |
| C-32 | tryUpdate でテーマ変更時に再レンダリング | E-03 (L59-64) | ○ |
| C-33 | テーマ同一時は再レンダリングされない | E-03 (L40-43) | ○ |
| C-34 | diagramNode がない場合に早期リターン | E-03 (L45-48) | ○ |
| C-35 | data-processed 属性が削除される | E-03 (L57) | ○ |
| C-36 | MutationObserver で class 変更を監視 | E-03 (L68-70) | ○ |
| C-37 | textContent が null の場合に空文字列 | E-03 (L28) nullish coalescing | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコードから直接導出されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードに直接対応しており、推測や補間が含まれていません。

### 注意点
1. **Proposed API使用**: `toolResultDetails2` は proposed API (`chatOutputRenderer`) を使用しているため、API仕様の変更に注意が必要です（E-04 L16-18）
2. **セキュリティ関連**: CSP と HTML エスケープのテストは特に重要です。XSS脆弱性の回避を検証してください。
3. **ブラウザ互換性**: `crypto.randomUUID` のフォールバック実装は、古いブラウザ環境での動作確認が必要です。

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テストケース（UT-MCF-010, 011, 018）の妥当性確認
- [ ] UUID生成テストケース（UT-MCF-020～025）のフォーマット検証基準確認
- [ ] proposed API (`chatOutputRenderer`, `toolResultDetails2`) の仕様変更有無確認
- [ ] Webviewテーマ切替テストケース（UT-MCF-032～036）のDOM操作検証方法確認
- [ ] 境界値テストケース（UT-MCF-007, 019, 037）の網羅性確認
