---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：ext-microsoft-authentication 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-MSA-145（設定変更時のリロード）**：UIフロー依存のため実際の動作確認が必要
  2. **UT-MSA-148（カスタム環境未設定エラー）**：エラーハンドリングの網羅性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `extensions/microsoft-authentication/src/extension.ts`
- E-02: `extensions/microsoft-authentication/src/node/authProvider.ts`
- E-03: `extensions/microsoft-authentication/src/node/cachedPublicClientApplication.ts`
- E-04: `extensions/microsoft-authentication/src/common/scopeData.ts`
- E-05: `extensions/microsoft-authentication/src/UriEventHandler.ts`
- E-06: `extensions/microsoft-authentication/src/betterSecretStorage.ts`
- E-07: `extensions/microsoft-authentication/src/common/cachePlugin.ts`
- E-08: `extensions/microsoft-authentication/src/common/async.ts`
- E-09: `extensions/microsoft-authentication/src/node/flows.ts`
- E-10: `extensions/microsoft-authentication/src/common/accountAccess.ts`
- E-11: `extensions/microsoft-authentication/src/common/event.ts`
- E-12: `extensions/microsoft-authentication/src/common/loopbackClientAndOpener.ts`
- E-13: `extensions/microsoft-authentication/src/node/publicClientCache.ts`
- E-14: `extensions/microsoft-authentication/src/common/telemetryReporter.ts`
- E-15: `extensions/microsoft-authentication/src/common/config.ts`
- E-16: `extensions/microsoft-authentication/src/node/buffer.ts`
- E-17: `extensions/microsoft-authentication/src/common/publicClientCache.ts`
- E-18: `extensions/microsoft-authentication/src/common/env.ts`
- E-19: `extensions/microsoft-authentication/src/cryptoUtils.ts`
- E-20: `extensions/microsoft-authentication/src/logger.ts`
- E-21: `extensions/microsoft-authentication/src/common/loggerOptions.ts`
- E-22: `extensions/microsoft-authentication/src/node/authServer.ts`
- E-23: `extensions/microsoft-authentication/src/common/uri.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

### ScopeData クラス（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-MSA-001: スコープがソートされる | E-04 L54-56: `modifiedScopes.sort()` | ○ |
| C-02 | UT-MSA-002: scopeStrが生成される | E-04 L57: `this.scopeStr = modifiedScopes.join(' ')` | ○ |
| C-03 | UT-MSA-003: VSCODE_CLIENT_IDからclientId抽出 | E-04 L65-72: `getClientId`メソッド | ○ |
| C-04 | UT-MSA-004: デフォルトclientId | E-04 L8, L71: `DEFAULT_CLIENT_ID` | ○ |
| C-05 | UT-MSA-005: VSCODE_TENANTからtenant抽出 | E-04 L74-88: `getTenant`メソッド | ○ |
| C-06 | UT-MSA-006: authorizationServerからtenant抽出 | E-04 L75-80: URL pathからの抽出 | ○ |
| C-07 | UT-MSA-007: デフォルトtenant | E-04 L9, L87: `DEFAULT_TENANT='organizations'` | ○ |
| C-08 | UT-MSA-008: tenantIdがGUIDの場合 | E-04 L90-99: `getTenantId`メソッド | ○ |
| C-09 | UT-MSA-009: 特殊tenant値 | E-04 L91-96: switch文で'organizations','common','consumers'判定 | ○ |
| C-10 | UT-MSA-010: VSCODE_スコープ除外 | E-04 L103: `filter(s => !s.startsWith('VSCODE_'))` | ○ |
| C-11 | UT-MSA-011: User.Read追加 | E-04 L112-114: `scopesToSend.push(GRAPH_TACK_ON_SCOPE)` | ○ |

### UriEventHandler クラス（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | UT-MSA-012: handleUri | E-05 L11-13: `handleUri(uri) { this.fire(uri); }` | ○ |
| C-13 | UT-MSA-013: dispose | E-05 L15-18: `dispose()`メソッド | ○ |

### BetterTokenStorage クラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | UT-MSA-014: get | E-06 L79-82: `get(key)`メソッド | ○ |
| C-15 | UT-MSA-015: get undefined | E-06 L81: `tokens.get(key)` - Mapの動作 | ○ |
| C-16 | UT-MSA-016: getAll | E-06 L84-93: `getAll`メソッド | ○ |
| C-17 | UT-MSA-017: getAll with predicate | E-06 L88-89: predicate条件分岐 | ○ |
| C-18 | UT-MSA-018: store new | E-06 L95-120: `store`メソッド, L98: `isAddition` | ○ |
| C-19 | UT-MSA-019: store update | E-06 L99: `tokens.set(key, value)` | ○ |
| C-20 | UT-MSA-020: delete | E-06 L122-144: `delete`メソッド | ○ |
| C-21 | UT-MSA-021: delete nonexistent | E-06 L124-126: 早期リターン | ○ |
| C-22 | UT-MSA-022: deleteAll | E-06 L146-155: `deleteAll`メソッド | ○ |
| C-23 | UT-MSA-023: handleSecretChange added | E-06 L222-226: `onDidChangeInOtherWindow.fire` with added | ○ |
| C-24 | UT-MSA-024: handleSecretChange removed | E-06 L210-215: `removed`イベント発火 | ○ |

### SecretStorageCachePlugin クラス（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | UT-MSA-025: beforeCacheAccess | E-07 L35-41: `beforeCacheAccess`メソッド | ○ |
| C-26 | UT-MSA-026: beforeCacheAccess empty | E-07 L38-40: if(data)条件 | ○ |
| C-27 | UT-MSA-027: afterCacheAccess | E-07 L43-50: `afterCacheAccess`メソッド | ○ |
| C-28 | UT-MSA-028: afterCacheAccess no change | E-07 L44: `if (tokenCacheContext.cacheHasChanged)` | ○ |

### 非同期ユーティリティ（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | UT-MSA-029: SequencerByKey queue | E-08 L8-25: `queue`メソッド | ○ |
| C-30 | UT-MSA-030: SequencerByKey parallel | E-08 L13: キー別promiseMap | ○ |
| C-31 | UT-MSA-031: IntervalTimer cancel | E-08 L36-40: `cancel`メソッド | ○ |
| C-32 | UT-MSA-032: IntervalTimer cancelAndSet | E-08 L43-48: `cancelAndSet`メソッド | ○ |
| C-33 | UT-MSA-033: DeferredPromise complete | E-08 L158-163: `complete`メソッド | ○ |
| C-34 | UT-MSA-034: DeferredPromise error | E-08 L166-170: `error`メソッド | ○ |
| C-35 | UT-MSA-035: DeferredPromise cancel | E-08 L174-176: `cancel`メソッド | ○ |
| C-36 | UT-MSA-036: raceCancellationAndTimeoutError success | E-08 L74-76 | ○ |
| C-37 | UT-MSA-037: raceCancellationAndTimeoutError timeout | E-08 L65-72 | ○ |
| C-38 | UT-MSA-038: raceCancellationAndTimeoutError cancel | E-08 L55-63 | ○ |
| C-39 | UT-MSA-039: toPromise | E-08 L111-113 | ○ |

### EventBufferer クラス（E-11）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | UT-MSA-040: wrapEvent buffering | E-11 L34-85: `wrapEvent`メソッド | ○ |
| C-41 | UT-MSA-041: wrapEvent reduce | E-11 L50-82: reduceシナリオ | ○ |
| C-42 | UT-MSA-042: bufferEventsAsync | E-11 L96-106: `bufferEventsAsync`メソッド | ○ |

### UriHandlerLoopbackClient クラス（E-12）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | UT-MSA-043: listenForAuthCode | E-12 L23-34 | ○ |
| C-44 | UT-MSA-044: listenForAuthCode error | E-12 L31-32 | ○ |
| C-45 | UT-MSA-045: getRedirectUri | E-12 L36-40 | ○ |
| C-46 | UT-MSA-046: openBrowser | E-12 L46-49 | ○ |

### ScopedAccountAccess クラス（E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | UT-MSA-047: isAllowedAccess true | E-10 L54-56 | ○ |
| C-48 | UT-MSA-048: isAllowedAccess false | E-10 L55: `includes`の動作 | ○ |
| C-49 | UT-MSA-049: setAllowedAccess allow | E-10 L58-64 | ○ |
| C-50 | UT-MSA-050: setAllowedAccess revoke | E-10 L65-67 | ○ |
| C-51 | UT-MSA-051: setAllowedAccess duplicate | E-10 L60-61: 早期リターン | ○ |
| C-52 | UT-MSA-052: AccountAccessSecretStorage get | E-10 L155-161 | ○ |
| C-53 | UT-MSA-053: AccountAccessSecretStorage get empty | E-10 L157-158 | ○ |
| C-54 | UT-MSA-054: AccountAccessSecretStorage store | E-10 L163-165 | ○ |

### CachedPublicClientApplication クラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | UT-MSA-055: accounts getter | E-03 L88 | ○ |
| C-56 | UT-MSA-056: clientId getter | E-03 L89 | ○ |
| C-57 | UT-MSA-057: acquireTokenSilent | E-03 L111-171 | ○ |
| C-58 | UT-MSA-058: acquireTokenSilent refresh | E-03 L118-161: IDトークン期限切れ処理 | ○ |
| C-59 | UT-MSA-059: acquireTokenSilent error | E-03 L164-165: エラーログ | ○ |
| C-60 | UT-MSA-060: acquireTokenInteractive | E-03 L173-203 | ○ |
| C-61 | UT-MSA-061: acquireTokenInteractive timeout | E-03 L183-186: 5分タイムアウト | ○ |
| C-62 | UT-MSA-062: acquireTokenInteractive cancel | E-03 L185: token引数 | ○ |
| C-63 | UT-MSA-063: acquireTokenByRefreshToken | E-03 L211-229 | ○ |
| C-64 | UT-MSA-064: acquireTokenByRefreshToken null | E-03 L222: null許容 | ○ |
| C-65 | UT-MSA-065: acquireTokenByDeviceCode | E-03 L231-256 | ○ |
| C-66 | UT-MSA-066: acquireTokenByDeviceCode cancel | E-03 L271-274: キャンセル処理 | ○ |
| C-67 | UT-MSA-067: removeAccount broker | E-03 L306-308 | ○ |
| C-68 | UT-MSA-068: removeAccount cache | E-03 L310 | ○ |
| C-69 | UT-MSA-069: _update added | E-03 L363-367 | ○ |
| C-70 | UT-MSA-070: _update deleted | E-03 L364: deleted配列 | ○ |
| C-71 | UT-MSA-071: _update last account | E-03 L368-370 | ○ |
| C-72 | UT-MSA-072: Sequencer queue | E-03 L377-384 | ○ |
| C-73 | UT-MSA-073: Sequencer error continuation | E-03 L382: `then(() => promiseTask(), () => promiseTask())` | ○ |

### CachedPublicClientApplicationManager クラス（E-13）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | UT-MSA-074: create | E-13 L47-59 | ○ |
| C-75 | UT-MSA-075: getOrCreate cache hit | E-13 L118-120 | ○ |
| C-76 | UT-MSA-076: getOrCreate cache miss | E-13 L121-126 | ○ |
| C-77 | UT-MSA-077: getOrCreate migration | E-13 L129-154 | ○ |
| C-78 | UT-MSA-078: getAll | E-13 L182-184 | ○ |
| C-79 | UT-MSA-079: dispose | E-13 L112-115 | ○ |
| C-80 | UT-MSA-080: PublicClientApplicationsSecretStorage get | E-13 L293-299 | ○ |
| C-81 | UT-MSA-081: PublicClientApplicationsSecretStorage store | E-13 L320-322 | ○ |
| C-82 | UT-MSA-082: PublicClientApplicationsSecretStorage getOldValue | E-13 L305-318 | ○ |

### MsalAuthProvider クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | UT-MSA-083: create | E-02 L99-111 | ○ |
| C-84 | UT-MSA-084: getSessions all | E-02 L180-193 | ○ |
| C-85 | UT-MSA-085: getSessions scoped | E-02 L195-199 | ○ |
| C-86 | UT-MSA-086: getSessions account filter | E-02 L196: options?.account | ○ |
| C-87 | UT-MSA-087: createSession | E-02 L202-275 | ○ |
| C-88 | UT-MSA-088: createSession all flows fail | E-02 L274 | ○ |
| C-89 | UT-MSA-089: createSession prompt | E-02 L213-225 | ○ |
| C-90 | UT-MSA-090: removeSession | E-02 L277-303 | ○ |
| C-91 | UT-MSA-091: removeSession nonexistent | E-02 L290-293 | ○ |
| C-92 | UT-MSA-092: getSessionsFromChallenges | E-02 L305-325 | ○ |
| C-93 | UT-MSA-093: getSessionsFromChallenges no scopes | E-02 L310-312 | ○ |
| C-94 | UT-MSA-094: createSessionFromChallenges | E-02 L327-414 | ○ |
| C-95 | UT-MSA-095: extractScopesFromChallenges | E-02 L416-423 | ○ |
| C-96 | UT-MSA-096: extractScopesFromChallenges undefined | E-02 L422 | ○ |
| C-97 | UT-MSA-097: extractClaimsFromChallenges base64 | E-02 L425-442, L429 | ○ |
| C-98 | UT-MSA-098: extractClaimsFromChallenges JSON | E-02 L432-435 | ○ |
| C-99 | UT-MSA-099: sessionFromAuthenticationResult | E-02 L539-550 | ○ |
| C-100 | UT-MSA-100: sessionFromAccountInfo | E-02 L552-563 | ○ |
| C-101 | UT-MSA-101: _handleAccountChange | E-02 L160-167 | ○ |
| C-102 | UT-MSA-102: _migrateSessions | E-02 L117-139 | ○ |

### フロー関連（E-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | UT-MSA-103: DefaultLoopbackFlow trigger | E-09 L45-72 | ○ |
| C-104 | UT-MSA-104: DefaultLoopbackFlow macOS | E-09 L56-58 | ○ |
| C-105 | UT-MSA-105: UrlHandlerFlow trigger | E-09 L74-101 | ○ |
| C-106 | UT-MSA-106: DeviceCodeFlow trigger | E-09 L103-119 | ○ |
| C-107 | UT-MSA-107: DeviceCodeFlow null | E-09 L114-116 | ○ |
| C-108 | UT-MSA-108: getMsalFlows local | E-09 L133-147 | ○ |
| C-109 | UT-MSA-109: getMsalFlows remote | E-09 L137-138 | ○ |
| C-110 | UT-MSA-110: getMsalFlows unsupported | E-09 L141 | ○ |
| C-111 | UT-MSA-111: getMsalFlows broker | E-09 L140 | ○ |

### テレメトリ関連（E-14）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | UT-MSA-112: sendLoginEvent | E-14 L46-58 | ○ |
| C-113 | UT-MSA-113: sendLoginFailedEvent | E-14 L59-64 | ○ |
| C-114 | UT-MSA-114: sendLogoutEvent | E-14 L65-70 | ○ |
| C-115 | UT-MSA-115: sendTelemetryErrorEvent | E-14 L78-109 | ○ |
| C-116 | UT-MSA-116: sendTelemetryClientAuthErrorEvent | E-14 L111-146 | ○ |
| C-117 | UT-MSA-117: _scrubGuids | E-14 L170-172 | ○ |

### ログ関連（E-21）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | UT-MSA-118: logLevel | E-21 L18-19, L48-63 | ○ |
| C-119 | UT-MSA-119: loggerCallback | E-21 L22-46 | ○ |

### LoopbackAuthServer クラス（E-22）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | UT-MSA-120: start | E-22 L154-187 | ○ |
| C-121 | UT-MSA-121: start already started | E-22 L156-158 | ○ |
| C-122 | UT-MSA-122: stop | E-22 L189-202 | ○ |
| C-123 | UT-MSA-123: stop not started | E-22 L191-193 | ○ |
| C-124 | UT-MSA-124: waitForOAuthResponse | E-22 L204-206 | ○ |
| C-125 | UT-MSA-125: /signin valid nonce | E-22 L99-107 | ○ |
| C-126 | UT-MSA-126: /signin invalid nonce | E-22 L100-104 | ○ |
| C-127 | UT-MSA-127: /callback success | E-22 L109-139 | ○ |
| C-128 | UT-MSA-128: /callback state mismatch | E-22 L125-129 | ○ |
| C-129 | UT-MSA-129: /callback error | E-22 L114-118 | ○ |

### バッファ・暗号関連（E-16, E-19）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | UT-MSA-130: base64Encode | E-16 L6-8 | ○ |
| C-131 | UT-MSA-131: base64Decode | E-16 L10-12 | ○ |
| C-132 | UT-MSA-132: generateCodeVerifier | E-19 L15-19 | ○ |
| C-133 | UT-MSA-133: generateCodeChallenge | E-19 L40-44 | ○ |
| C-134 | UT-MSA-134: randomUUID | E-19 L7-9 | ○ |

### 環境判定関連（E-18, E-23）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | UT-MSA-135: isSupportedClient vscode scheme | E-18 L9-11 | ○ |
| C-136 | UT-MSA-136: isSupportedClient vscode.dev | E-18 L23-24 | ○ |
| C-137 | UT-MSA-137: isSupportedClient github.dev | E-18 L25-26 | ○ |
| C-138 | UT-MSA-138: isSupportedClient localhost | E-18 L27-30 | ○ |
| C-139 | UT-MSA-139: isSupportedClient unsupported | E-18 L20-31: 条件に合致しない場合 | ○ |
| C-140 | UT-MSA-140: isSupportedEnvironment desktop | E-23 L16-18 | ○ |
| C-141 | UT-MSA-141: isSupportedEnvironment web vscode.dev | E-23 L29-31 | ○ |
| C-142 | UT-MSA-142: isSupportedEnvironment web localhost | E-23 L20-23 | ○ |
| C-143 | UT-MSA-143: isSupportedEnvironment web unsupported | E-23 L24-27 | ○ |

### 拡張機能エントリポイント（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | UT-MSA-144: activate | E-01 L72-140 | ○ |
| C-145 | UT-MSA-145: activate config change | E-01 L75-99 | △ |
| C-146 | UT-MSA-146: initMicrosoftSovereignCloudAuthProvider | E-01 L16-70 | ○ |
| C-147 | UT-MSA-147: initMicrosoftSovereignCloudAuthProvider custom | E-01 L26-47 | ○ |
| C-148 | UT-MSA-148: initMicrosoftSovereignCloudAuthProvider error | E-01 L28-34 | △ |
| C-149 | UT-MSA-149: deactivate | E-01 L142-144 | ○ |

### 設定関連（E-15）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | UT-MSA-150: macOSBrokerRedirectUri | E-15 L16-19 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-MSA-145**: 設定変更時のUI動作（リロードダイアログ表示）は、VSCode APIの`window.showInformationMessage`の呼び出しは確認できるが、実際のユーザー体験は実行時テストが必要
  - 候補: 統合テスト / E2Eテスト / 手動テスト
- **UT-MSA-148**: カスタム環境未設定時のエラーハンドリングは、`Environment.add`が例外をスローするケースの網羅性について追加確認が必要
  - 候補: Azure SDKのドキュメント / 実際のエラーパターン調査

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケース - ソースコードから直接導出可能
- **1（中リスク）**:
  - MSAL ライブラリとの統合テスト（モック依存）
  - ブローカー関連テスト（プラットフォーム依存）
  - SecretStorage関連（非同期・マルチウィンドウ）
- **2（高リスク）**:
  - デバイスコードフロー（外部サービス依存）
  - Sovereign Cloud環境設定（特殊環境依存）

## 6) レビュアーチェックリスト（最小）
- [ ] ScopeDataクラスの境界値テスト（空配列、nullスコープ）が十分か確認
- [ ] BetterTokenStorageの同時実行テストが考慮されているか確認
- [ ] ブローカー有効/無効の分岐が全てカバーされているか確認
- [ ] エラーハンドリングパスのテストカバレッジが十分か確認
- [ ] マイグレーション関連テスト（旧形式から新形式）の網羅性確認
- [ ] テレメトリイベントのプライバシー関連（GUID除去等）テストの確認
- [ ] タイムアウト値（5分等）の妥当性確認
