---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 180
  claims_with_evidence: 180
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-npm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：180 / 180、根拠なし：0
- 優先レビュー（高）
  1. **パッケージマネージャ検出ロジック**：複数PMの優先順位に関するテストケースの網羅性確認
  2. **NPM Registry API連携**：外部API呼び出しのモック方法とエラーハンドリング
  3. **タスク実行フロー**：VSCode Tasks APIとの統合テストの範囲確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/npm/src/preferred-pm.ts` - パッケージマネージャ検出ロジック
- E-02: `extensions/npm/src/readScripts.ts` - package.jsonスクリプト解析
- E-03: `extensions/npm/src/features/date.ts` - 相対日時フォーマット
- E-04: `extensions/npm/src/npmScriptLens.ts` - CodeLensプロバイダ実装
- E-05: `extensions/npm/src/features/jsonContributions.ts` - JSON補完・ホバープロバイダ
- E-06: `extensions/npm/src/features/packageJSONContribution.ts` - package.json補完機能
- E-07: `extensions/npm/src/npmView.ts` - ツリービュープロバイダ
- E-08: `extensions/npm/src/scriptHover.ts` - スクリプトホバープロバイダ
- E-09: `extensions/npm/src/tasks.ts` - タスク定義・実行ロジック
- E-10: `extensions/npm/src/commands.ts` - コマンド実装
- E-11: `extensions/npm/src/npmMain.ts` - 拡張機能エントリポイント
- E-12: `extensions/npm/src/npmBrowserMain.ts` - ブラウザ版エントリポイント

## 3) Claims と根拠の対応（レビューの主戦場）

### preferred-pm.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pathExistsがファイル存在時にtrueを返却 | E-01: L17-24 | ○ |
| C-02 | pathExistsがファイル非存在時にfalseを返却 | E-01: L17-24 try-catch | ○ |
| C-03 | isBunPreferredがbun.lockb検出時にtrue | E-01: L26-36 | ○ |
| C-04 | isBunPreferredがbun.lock検出時にtrue | E-01: L31-33 | ○ |
| C-05 | isBunPreferredがロックファイルなしでfalse | E-01: L35 | ○ |
| C-06 | isPNPMPreferredがpnpm-lock.yaml検出時にtrue | E-01: L38-49 | ○ |
| C-07 | isPNPMPreferredがshrinkwrap.yaml検出時にtrue | E-01: L42-44 | ○ |
| C-08 | isPNPMPreferredが親ディレクトリ検索でtrue | E-01: L45-47 findUp使用 | ○ |
| C-09 | isYarnPreferredがyarn.lock検出時にtrue | E-01: L52-64 | ○ |
| C-10 | isYarnPreferredがワークスペースルート検出時にtrue | E-01: L57-60 findWorkspaceRoot使用 | ○ |
| C-11 | isNPMPreferredがpackage-lock.json検出時にtrue | E-01: L66-69 | ○ |
| C-12 | isNPMPreferredがロックファイルなしでfalse | E-01: L67-68 | ○ |
| C-13 | findPreferredPMが単一PM検出時に名前を返却 | E-01: L71-113 | ○ |
| C-14 | findPreferredPMが複数ロックファイル検出時に警告フラグ | E-01: L106-111 | ○ |
| C-15 | findPreferredPMがPM未検出時にnpmをデフォルト返却 | E-01: L109-110 | ○ |

### readScripts.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | readScriptsがscriptsセクションをパース | E-02: L21-73 | ○ |
| C-17 | readScriptsが各スクリプトの名前と値を取得 | E-02: L43-51 | ○ |
| C-18 | readScriptsがnameRangeを正しく設定 | E-02: L58-61 | ○ |
| C-19 | readScriptsがvalueRangeを正しく設定 | E-02: L48 | ○ |
| C-20 | readScriptsがscriptsなしでundefinedを返却 | E-02: L68-69 | ○ |
| C-21 | readScriptsが空scriptsで空配列を返却 | E-02: L28, L72 | ○ |
| C-22 | readScriptsが不正JSONでエラーハンドリング | E-02: L30-32 onError | ○ |

### date.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | fromNowが30秒未満で「now」を返却 | E-03: L35-37 | ○ |
| C-24 | fromNowがdisallowNow=trueで秒数を返却 | E-03: L35 条件 | ○ |
| C-25 | fromNowが負の差分で「in X」形式を返却 | E-03: L31-33 | ○ |
| C-26 | fromNowが1分以上1時間未満で分単位を返却 | E-03: L66-88 | ○ |
| C-27 | fromNowが1時間以上1日未満で時間単位を返却 | E-03: L91-114 | ○ |
| C-28 | fromNowが1日以上1週間未満で日単位を返却 | E-03: L116-127 | ○ |
| C-29 | fromNowが1週間以上1ヶ月未満で週単位を返却 | E-03: L129-152 | ○ |
| C-30 | fromNowが1ヶ月以上1年未満で月単位を返却 | E-03: L154-177 | ○ |
| C-31 | fromNowが1年以上で年単位を返却 | E-03: L179-200 | ○ |
| C-32 | fromNowがuseFullTimeWordsで完全単語使用 | E-03: 各条件分岐内 | ○ |
| C-33 | fromNowがappendAgoLabel=falseで「ago」なし | E-03: 各条件分岐内 | ○ |
| C-34 | fromNowが値1で単数形を使用 | E-03: value===1条件 | ○ |

### NpmScriptLensProvider 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | constructorでCodeLensプロバイダが登録される | E-04: L43-58 | ○ |
| C-36 | provideCodeLensesがneverで空配列を返却 | E-04: L65-67 | ○ |
| C-37 | provideCodeLensesがtopで1つのCodeLensを返却 | E-04: L76-87 | ○ |
| C-38 | provideCodeLensesがallで各スクリプトにCodeLensを返却 | E-04: L89-104 | ○ |
| C-39 | provideCodeLensesがscriptsなしで空配列を返却 | E-04: L69-72 | ○ |
| C-40 | disposeでサブスクリプションが解除される | E-04: L112-114 | ○ |

### JSONHoverProvider・JSONCompletionItemProvider 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | provideHoverが有効位置でホバー情報を返却 | E-05: L47-68 | ○ |
| C-42 | provideHoverがpreviousNodeなしでnullを返却 | E-05: L50-52 | ○ |
| C-43 | provideHoverがノード範囲外でnullを返却 | E-05: L54 条件 | ○ |
| C-44 | provideCompletionItemsがプロパティキーで補完候補を返却 | E-05: L127-131 | ○ |
| C-45 | provideCompletionItemsが値で補完候補を返却 | E-05: L136 | ○ |
| C-46 | resolveCompletionItemが詳細情報を解決 | E-05: L78-86 | ○ |
| C-47 | getCurrentWordがカーソル位置の単語を取得 | E-05: L150-157 | ○ |
| C-48 | isLastが最後のプロパティを判定 | E-05: L159-166 | ○ |
| C-49 | hasColonAfterがコロン有無を判定 | E-05: L167-170 | ○ |

### PackageJSONContribution 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | getDocumentSelectorがpackage.jsonセレクタを返却 | E-06: L30-32 | ○ |
| C-51 | collectDefaultSuggestionsがデフォルトテンプレートを提案 | E-06: L37-51 | ○ |
| C-52 | collectPropertySuggestionsがパッケージ名候補を提案 | E-06: L61-145 | ○ |
| C-53 | collectPropertySuggestionsが@スコープ補完を提案 | E-06: L76-93 | ○ |
| C-54 | collectPropertySuggestionsが空入力でmostDependedOnを提案 | E-06: L124-141 | ○ |
| C-55 | collectPropertySuggestionsがisEnabled()=falseでnull | E-06: L69-71 | ○ |
| C-56 | collectValueSuggestionsがバージョンを提案 | E-06: L182-217 | ○ |
| C-57 | collectValueSuggestionsがisEnabled()=falseでnull | E-06: L183-185 | ○ |
| C-58 | isValidNPMNameが有効名でtrue | E-06: L254-270 | ○ |
| C-59 | isValidNPMNameが空文字列でfalse | E-06: L257 | ○ |
| C-60 | isValidNPMNameが214文字超でfalse | E-06: L257 | ○ |
| C-61 | isValidNPMNameが先頭不正文字でfalse | E-06: L257 match | ○ |
| C-62 | isValidNPMNameがスコープ付きでtrue | E-06: L260-268 | ○ |
| C-63 | fetchPackageInfoが有効なパッケージ情報を取得 | E-06: L272-284 | ○ |
| C-64 | fetchPackageInfoが無効名でundefined | E-06: L273-274 | ○ |
| C-65 | npmViewがnpm viewコマンドで情報取得 | E-06: L286-321 | ○ |
| C-66 | npmViewがエラー時undefined | E-06: L302-318 | ○ |
| C-67 | npmjsViewがAPIで情報取得 | E-06: L323-343 | ○ |
| C-68 | npmjsViewがAPIエラー時undefined | E-06: L339-342 | ○ |
| C-69 | getInfoContributionがホバー情報を取得 | E-06: L345-361 | ○ |
| C-70 | getInfoContributionがisEnabled()=falseでnull | E-06: L346-348 | ○ |
| C-71 | getDocumentationがMarkdownを生成 | E-06: L219-233 | ○ |
| C-72 | resolveSuggestionがドキュメントを追加 | E-06: L235-252 | ○ |
| C-73 | resolveSuggestionが既存ドキュメントでnull | E-06: L236 条件 | ○ |

### NpmScriptsTreeDataProvider 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | constructorでコマンドが登録される | E-07: L147-151 | ○ |
| C-75 | refreshでタスクツリーがリフレッシュ | E-07: L204-207 | ○ |
| C-76 | getChildrenがルートでフォルダ/パッケージを返却 | E-07: L229-262 | ○ |
| C-77 | getChildrenがFolderでPackageJSONを返却 | E-07: L244-245 | ○ |
| C-78 | getChildrenがPackageJSONでNpmScriptを返却 | E-07: L247-248 | ○ |
| C-79 | getChildrenがスクリプトなしでNoScriptsを返却 | E-07: L235-241 | ○ |
| C-80 | getParentがFolderでnullを返却 | E-07: L213-215 | ○ |
| C-81 | getParentがPackageJSONでFolderを返却 | E-07: L216-218 | ○ |
| C-82 | getParentがNpmScriptでPackageJSONを返却 | E-07: L219-221 | ○ |
| C-83 | buildTaskTreeがツリー構造を構築 | E-07: L289-333 | ○ |
| C-84 | buildTaskTreeが単一WSでPackageJSON[]を返却 | E-07: L329-330 | ○ |
| C-85 | buildTaskTreeが複数WSでFolder[]を返却 | E-07: L331-332 | ○ |
| C-86 | runScriptがタスクを実行 | E-07: L153-157 | ○ |
| C-87 | debugScriptがデバッグモードで実行 | E-07: L159-161 | ○ |
| C-88 | openScriptがエディタで開く | E-07: L189-202 | ○ |
| C-89 | runInstallがインストールタスクを実行 | E-07: L177-187 | ○ |

### NpmScriptHoverProvider 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | provideHoverがスクリプト名上でホバー情報を返却 | E-08: L52-74 | ○ |
| C-91 | provideHoverがenabled=falseでundefined | E-08: L53-55 | ○ |
| C-92 | provideHoverがスクリプト範囲外でundefined | E-08: L65 contains条件 | ○ |
| C-93 | runScriptFromHoverがスクリプトを実行 | E-08: L112-119 | ○ |
| C-94 | debugScriptFromHoverがデバッグを開始 | E-08: L122-129 | ○ |
| C-95 | invalidateHoverScriptsCacheがドキュメントなしで全クリア | E-08: L23-27 | ○ |
| C-96 | invalidateHoverScriptsCacheが一致ドキュメントでクリア | E-08: L28-30 | ○ |

### tasks.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | provideTasksがnpmスクリプトタスク一覧を提供 | E-09: L55-58 | ○ |
| C-98 | resolveTaskがタスク定義を解決 | E-09: L60-86 | ○ |
| C-99 | resolveTaskがグローバルスコープでundefined | E-09: L65-68 | ○ |
| C-100 | resolveTaskがINSTALLスクリプトでインストールタスク | E-09: L75-76 | ○ |
| C-101 | isBuildTaskがbuildを含む名前でtrue | E-09: L94-101 | ○ |
| C-102 | isBuildTaskがcompileを含む名前でtrue | E-09: L93-101 | ○ |
| C-103 | isBuildTaskがwatchを含む名前でtrue | E-09: L93-101 | ○ |
| C-104 | isBuildTaskがビルド関連でない名前でfalse | E-09: L100 | ○ |
| C-105 | isTestTaskがtestでtrue | E-09: L104-111 | ○ |
| C-106 | isTestTaskがtest以外でfalse | E-09: L105-110 完全一致 | ○ |
| C-107 | canHavePrePostScriptがpreScriptsでtrue | E-09: L122-124 | ○ |
| C-108 | canHavePrePostScriptがpostScriptsでtrue | E-09: L122-124 | ○ |
| C-109 | isWorkspaceFolderがWorkspaceFolderでtrue | E-09: L126-128 | ○ |
| C-110 | isWorkspaceFolderが数値でfalse | E-09: L127 typeof !== 'number' | ○ |
| C-111 | getScriptRunnerが設定値を返却 | E-09: L130-138 | ○ |
| C-112 | getScriptRunnerがautoでdetectPackageManagerを呼出 | E-09: L133-135 | ○ |
| C-113 | getPackageManagerが設定値を返却 | E-09: L140-148 | ○ |
| C-114 | getPackageManagerがautoでdetectPackageManagerを呼出 | E-09: L143-145 | ○ |
| C-115 | detectPackageManagerが複数ロックファイルで警告表示 | E-09: L150-166 | ○ |
| C-116 | detectPackageManagerがneverShow設定で警告なし | E-09: L153 条件 | ○ |
| C-117 | hasNpmScriptsがpackage.json存在でtrue | E-09: L168-183 | ○ |
| C-118 | hasNpmScriptsがワークスペースなしでfalse | E-09: L169-172 | ○ |
| C-119 | isAutoDetectionEnabledがonでtrue | E-09: L241-243 | ○ |
| C-120 | isAutoDetectionEnabledがoffでfalse | E-09: L241-243 | ○ |
| C-121 | isExcludedが除外パターン一致でtrue | E-09: L245-265 | ○ |
| C-122 | isExcludedが除外パターン不一致でfalse | E-09: L245-265 | ○ |
| C-123 | isDebugScriptが--inspectフラグでtrue | E-09: L267-270 | ○ |
| C-124 | isDebugScriptが--debug-brkフラグでtrue | E-09: L268 | ○ |
| C-125 | isDebugScriptがデバッグフラグなしでfalse | E-09: L269 | ○ |
| C-126 | getTaskNameが相対パスなしでスクリプト名を返却 | E-09: L297-302 | ○ |
| C-127 | getTaskNameが相対パスありでパス付き名を返却 | E-09: L298-299 | ○ |
| C-128 | createScriptRunnerTaskがタスクを作成 | E-09: L334-360 | ○ |
| C-129 | createScriptRunnerTaskがビルドスクリプトでTaskGroup.Build | E-09: L349-350 | ○ |
| C-130 | createScriptRunnerTaskがテストスクリプトでTaskGroup.Test | E-09: L351-352 | ○ |
| C-131 | createInstallationTaskがタスクを作成 | E-09: L371-387 | ○ |
| C-132 | createInstallationTaskがTaskGroup.Cleanを設定 | E-09: L384 | ○ |
| C-133 | getPackageJsonUriFromTaskがURIを取得 | E-09: L390-399 | ○ |
| C-134 | getPackageJsonUriFromTaskがパス付きで正しいURI | E-09: L392-393 | ○ |
| C-135 | getPackageJsonUriFromTaskが非WSスコープでnull | E-09: L391 条件 | ○ |
| C-136 | hasPackageJsonがルートpackage.jsonでtrue | E-09: L401-412 | ○ |
| C-137 | hasPackageJsonがサブディレクトリでtrue | E-09: L408-410 | ○ |
| C-138 | hasPackageJsonがタイムアウトでfalse | E-09: L407-408 | ○ |
| C-139 | runScriptがタスクを実行 | E-09: L438-445 | ○ |
| C-140 | runScriptがフォルダなしで何も実行しない | E-09: L441 条件 | ○ |
| C-141 | startDebuggingがデバッグターミナルを作成 | E-09: L447-456 | ○ |
| C-142 | findScriptAtPositionが位置のスクリプト名を返却 | E-09: L461-474 | ○ |
| C-143 | findScriptAtPositionが位置外でundefined | E-09: L468 条件 | ○ |
| C-144 | getScriptsがスクリプト情報を取得 | E-09: L476-493 | ○ |
| C-145 | getScriptsが非fileスキームでundefined | E-09: L477-479 | ○ |
| C-146 | getScriptsがファイルなしでundefined | E-09: L482-484 | ○ |
| C-147 | getRunScriptCommandがnpmでnpm runを返却 | E-09: L319-332 | ○ |
| C-148 | getRunScriptCommandがnodeでnode --runを返却 | E-09: L322-323 | ○ |
| C-149 | getRunScriptCommandがrunSilentで--silentを追加 | E-09: L326-328 | ○ |

### commands.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | runSelectedScriptが選択位置のスクリプトを実行 | E-10: L16-30 | ○ |
| C-151 | runSelectedScriptがエディタなしで何も実行しない | E-10: L17-19 | ○ |
| C-152 | runSelectedScriptがスクリプト未検出でエラー表示 | E-10: L26-29 | ○ |
| C-153 | selectAndRunScriptFromFolderがスクリプトを選択・実行 | E-10: L32-67 | ○ |
| C-154 | selectAndRunScriptFromFolderがフォルダ空で何も実行しない | E-10: L33-35 | ○ |
| C-155 | selectAndRunScriptFromFolderがスクリプトなしで情報表示 | E-10: L64-66 | ○ |

### npmMain.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-156 | activateで拡張機能がアクティベート | E-11: L26-103 | ○ |
| C-157 | getNPMCommandPathが信頼WSでnpmパスを返却 | E-11: L105-114 | ○ |
| C-158 | getNPMCommandPathが非信頼WSでundefined | E-11: L106 条件 | ○ |
| C-159 | canRunNpmInCurrentWorkspaceがfileスキームでtrue | E-11: L116-121 | ○ |
| C-160 | canRunNpmInCurrentWorkspaceがfileスキームなしでfalse | E-11: L120 | ○ |
| C-161 | invalidateScriptCachesで全キャッシュ無効化 | E-11: L18-24 | ○ |
| C-162 | registerTaskProviderでタスクプロバイダ登録 | E-11: L124-141 | ○ |
| C-163 | registerTaskProviderでファイルウォッチャー設定 | E-11: L126-130 | ○ |
| C-164 | registerExplorerでツリービュー登録 | E-11: L143-151 | ○ |
| C-165 | registerHoverProviderでホバープロバイダ登録 | E-11: L153-165 | ○ |
| C-166 | configureHttpRequestでHTTPリクエスト設定 | E-11: L167-170 | ○ |
| C-167 | provideTerminalQuickFixesがnpmエラーからquick fixを提供 | E-11: L80-101 | ○ |
| C-168 | provideTerminalQuickFixesがマッチなしでundefined | E-11: L82-84 | ○ |

### npmBrowserMain.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-169 | activateでブラウザ環境がアクティベート | E-12: L10-12 | ○ |

### ビューモデルクラス関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-170 | Folder.constructorがインスタンスを正しく作成 | E-07: L25-35 | ○ |
| C-171 | Folder.addPackageがパッケージを追加 | E-07: L37-39 | ○ |
| C-172 | PackageJSON.getLabelが相対パスなしでpackage.json | E-07: L49-54 | ○ |
| C-173 | PackageJSON.getLabelが相対パスありでパス付き | E-07: L51 | ○ |
| C-174 | PackageJSON.addScriptがスクリプトを追加 | E-07: L69-71 | ○ |
| C-175 | NpmScript.constructorがインスタンスを正しく作成 | E-07: L81-122 | ○ |
| C-176 | NpmScript.constructorがinstallでrunコマンド設定 | E-07: L87 条件 | ○ |
| C-177 | NpmScript.getFolderがWorkspaceFolderを取得 | E-07: L124-126 | ○ |
| C-178 | NoScripts.constructorがインスタンスを正しく作成 | E-07: L129-133 | ○ |

### jsonContributions.ts 関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-179 | addJSONProvidersがJSONプロバイダを登録 | E-05: L31-40 | ○ |
| C-180 | xhrDisabledが拒否されたPromiseを返却 | E-05: L174 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースがソースコードに基づいて生成されています）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードから直接抽出されており、根拠が明確です

## 6) レビュアーチェックリスト（最小）
- [ ] パッケージマネージャ検出（preferred-pm.ts）のテストケースが全てのPM（npm, yarn, pnpm, bun）をカバーしているか確認
- [ ] 外部API連携（npmjs.org）のモック方法が適切に定義されているか確認
- [ ] VSCode API（tasks, languages, workspace等）のモック戦略が明確か確認
- [ ] エラーハンドリングのテストケースが十分に網羅されているか確認
- [ ] 境界値テスト（空配列、null、undefined）が適切にカバーされているか確認
- [ ] 非同期処理（Promise、async/await）のテストケースが適切か確認
