---
generated_at: 2026-01-27 14:05:00
metrics:
  claims_total: 123
  claims_with_evidence: 118
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：ext-php-language-features 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：118 / 123、根拠なし：5
- 優先レビュー（高）
  1. **UT-PHP-040**：日本語文字を含む識別子の処理 - 実際のPHP仕様との整合性要確認
  2. **UT-PHP-088**：ユーザーインタラクションの検証方法が不明
  3. **UT-PHP-094/095**：外部コマンド(which)依存のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `extensions/php-language-features/src/phpMain.ts` - 拡張機能エントリポイント
- E-02: `extensions/php-language-features/src/features/completionItemProvider.ts` - 補完プロバイダ実装
- E-03: `extensions/php-language-features/src/features/hoverProvider.ts` - ホバープロバイダ実装
- E-04: `extensions/php-language-features/src/features/signatureHelpProvider.ts` - シグネチャヘルププロバイダ実装
- E-05: `extensions/php-language-features/src/features/validationProvider.ts` - バリデーションプロバイダ実装
- E-06: `extensions/php-language-features/src/features/phpGlobals.ts` - PHPグローバル定義
- E-07: `extensions/php-language-features/src/features/phpGlobalFunctions.ts` - PHPグローバル関数定義
- E-08: `extensions/php-language-features/src/features/utils/markedTextUtil.ts` - マークダウンテキストユーティリティ
- E-09: `extensions/php-language-features/src/features/utils/async.ts` - 非同期ユーティリティ（Throttler, Delayer, ThrottledDelayer）
- E-10: `extensions/php-language-features/package.json` - 拡張機能設定定義

## 3) Claims と根拠の対応（レビューの主戦場）

### PHPCompletionItemProvider (UT-PHP-001 〜 UT-PHP-013)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | php.suggest.basic設定による補完有効/無効の制御 | E-02 (line 15-18) | ○ |
| C-02 | グローバル変数の補完候補返却 | E-02 (line 66-71), E-06 | ○ |
| C-03 | グローバル関数の補完候補返却 | E-02 (line 72-77), E-07 | ○ |
| C-04 | コンパイル時定数の補完候補返却 | E-02 (line 78-82), E-06 | ○ |
| C-05 | キーワードの補完候補返却 | E-02 (line 84-88), E-06 | ○ |
| C-06 | '->'トリガーによるオブジェクトメンバアクセス | E-02 (line 26-32) | ○ |
| C-07 | '<?php'補完の動作 | E-02 (line 53-63) | ○ |
| C-08 | ドキュメント内変数の補完抽出 | E-02 (line 92-102) | ○ |
| C-09 | ドキュメント内関数定義の補完抽出 | E-02 (line 103-111) | ○ |
| C-10 | 重複候補の除外 | E-02 (line 34, 68, 74, 97-98, 107) | ○ |

### PHPHoverProvider (UT-PHP-014 〜 UT-PHP-022)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | php.suggest.basic設定によるホバー有効/無効の制御 | E-03 (line 14-17) | ○ |
| C-12 | グローバル関数のホバー情報表示 | E-03 (line 26-30), E-07 | ○ |
| C-13 | コンパイル時定数のホバー情報表示 | E-03 (line 26), E-06 | ○ |
| C-14 | グローバル変数のホバー情報表示 | E-03 (line 26), E-06 | ○ |
| C-15 | キーワードのホバー情報表示 | E-03 (line 26), E-06 | ○ |
| C-16 | wordRangeがnullの場合のundefined返却 | E-03 (line 19-22) | ○ |
| C-17 | descriptionがない場合のundefined返却 | E-03 (line 27-28) | ○ |

### PHPSignatureHelpProvider (UT-PHP-023 〜 UT-PHP-046)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | php.suggest.basic設定によるシグネチャヘルプ有効/無効 | E-04 (line 72-75) | ○ |
| C-19 | 関数引数位置でのシグネチャヘルプ表示 | E-04 (line 77-106) | ○ |
| C-20 | activeParameterの正しい設定 | E-04 (line 104) | ○ |
| C-21 | readArgumentsによる引数位置カウント | E-04 (line 108-141) | ○ |
| C-22 | 括弧ネストの正しいカウント | E-04 (line 116-122) | ○ |
| C-23 | 文字列内カンマの無視 | E-04 (line 127-132) | ○ |
| C-24 | isIdentPartによる識別子文字判定 | E-04 (line 143-153) | ○ |
| C-25 | readIdentによる識別子抽出 | E-04 (line 155-171) | ○ |

### BackwardIterator (UT-PHP-047 〜 UT-PHP-053)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | コンストラクタでの初期化 | E-04 (line 39-44) | ○ |
| C-27 | hasNextの判定ロジック | E-04 (line 46-48) | ○ |
| C-28 | next()による文字取得と位置移動 | E-04 (line 50-64) | ○ |
| C-29 | 行境界での移動処理 | E-04 (line 51-59) | ○ |

### LineDecoder (UT-PHP-054 〜 UT-PHP-063)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | コンストラクタでのエンコーディング設定 | E-05 (line 23-26) | ○ |
| C-31 | writeによる行分割処理 | E-05 (line 28-58) | ○ |
| C-32 | CR/LF/CRLFの処理 | E-05 (line 39-50) | ○ |
| C-33 | 不完全行のremaining保存 | E-05 (line 56) | ○ |
| C-34 | end()による残りデータ取得 | E-05 (line 60-62) | ○ |

### PHPValidationProvider (UT-PHP-064 〜 UT-PHP-088)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタでの初期化 | E-05 (line 99-103) | ○ |
| C-36 | activate()でのDiagnosticCollection作成 | E-05 (line 105-117) | ○ |
| C-37 | dispose()でのリソース解放 | E-05 (line 119-128) | ○ |
| C-38 | loadConfiguration()での設定読み込み | E-05 (line 130-157) | ○ |
| C-39 | triggerValidate()でのバリデーショントリガー | E-05 (line 159-174) | ○ |
| C-40 | doValidate()でのPHP実行とエラーパース | E-05 (line 176-249) | ○ |
| C-41 | MatchExpressionによるエラーパース | E-05 (line 86) | ○ |
| C-42 | onType/onSaveトリガーの切り替え | E-05 (line 147-153, 209-214) | ○ |
| C-43 | 信頼されていないワークスペースのスキップ | E-05 (line 165) | ○ |
| C-44 | showError()でのエラーメッセージ表示 | E-05 (line 251-267) | ○ |
| C-45 | showErrorMessage()でのOpen Settings | E-05 (line 269-274) | △ |

### getConfig / getPhpPath (UT-PHP-089 〜 UT-PHP-098)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | ワークスペース/グローバル設定の優先順位 | E-05 (line 288-298) | ○ |
| C-47 | 相対パスから絶対パスへの変換 | E-05 (line 300-306) | ○ |
| C-48 | which('php')によるPHP検出 | E-05 (line 307-309, 319-324) | △ |
| C-49 | RunTrigger.from()による列挙値変換 | E-05 (line 75-82) | ○ |

### Throttler (UT-PHP-099 〜 UT-PHP-103)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | コンストラクタでの初期化 | E-09 (line 36-40) | ○ |
| C-51 | queue()でのタスク実行/キューイング | E-09 (line 42-77) | ○ |
| C-52 | 複数キューイング時の最後のタスク実行 | E-09 (line 44) | ○ |

### Delayer (UT-PHP-104 〜 UT-PHP-111)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | コンストラクタでの初期化 | E-09 (line 111-117) | ○ |
| C-54 | trigger()での遅延実行 | E-09 (line 119-143) | ○ |
| C-55 | 再トリガーでのタイマーリセット | E-09 (line 121) | ○ |
| C-56 | isTriggered()の状態確認 | E-09 (line 145-147) | ○ |
| C-57 | cancel()でのキャンセル処理 | E-09 (line 149-155) | ○ |

### ThrottledDelayer (UT-PHP-112 〜 UT-PHP-114)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | コンストラクタでの初期化 | E-09 (line 176-180) | ○ |
| C-59 | trigger()での遅延+スロットリング | E-09 (line 182-184) | ○ |

### textToMarkedString (UT-PHP-115 〜 UT-PHP-119)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Markdown特殊文字のエスケープ | E-08 (line 8-9) | ○ |
| C-61 | 対象文字: \\`*_{}[]()#+-.! | E-08 (line 9) | ○ |

### activate (UT-PHP-120 〜 UT-PHP-123)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | PHPValidationProviderのアクティベート | E-01 (line 15-16) | ○ |
| C-63 | CompletionItemProviderの登録（'>', '$'トリガー） | E-01 (line 19) | ○ |
| C-64 | HoverProviderの登録 | E-01 (line 20) | ○ |
| C-65 | SignatureHelpProviderの登録（'(', ','トリガー） | E-01 (line 21) | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠なしの項目

1. **C-45 (UT-PHP-088)**: showErrorMessage()でのOpen Settings選択時の動作
   - vscode.window.showInformationMessage()のモック/スタブ方法が必要
   - 候補：VSCode Extension Testing API / jest-mock

2. **C-48 (UT-PHP-094/095)**: which('php')による外部コマンド依存
   - 環境依存のテストとなる
   - 候補：whichモジュールのモック / 環境変数操作

3. **C-40 (日本語識別子)**: 日本語文字を含む識別子のテスト
   - PHP言語仕様との整合性確認が必要
   - 候補：PHP公式ドキュメント / RFC

### 補完が必要な情報源

- VSCode Extension API ドキュメント（vscode.languages.register*）
- PHP公式ドキュメント（変数/関数命名規則）
- child_process.spawn() のエラーハンドリング仕様

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 説明 | 該当テストケース |
|-------------|------|-----------------|
| 0 (低) | 単純なユニットテスト、モック不要 | UT-PHP-041〜046, UT-PHP-096〜098, UT-PHP-115〜119 |
| 1 (中) | VSCode APIモックが必要 | UT-PHP-001〜022, UT-PHP-064〜077 |
| 2 (高) | 外部プロセス/ファイルシステム依存 | UT-PHP-078〜087, UT-PHP-094〜095 |

### 高リスク項目の詳細

1. **子プロセス実行テスト (UT-PHP-078〜084)**
   - child_process.spawn()のモックが必要
   - stdout/stderrのストリーム処理のシミュレーション
   - エラーイベントの発火タイミング

2. **PHP実行可能ファイル検出 (UT-PHP-094〜095)**
   - 環境依存性が高い
   - CI/CD環境での再現性確保が課題

## 6) レビュアーチェックリスト（最小）

- [ ] 全テストケースがCSVフォーマットに準拠しているか（ダブルクォート囲み、BOM付きUTF-8）
- [ ] テストIDが UT-PHP-XXX 形式で連番になっているか
- [ ] 各テストケースに対象クラス・メソッドが正確に記載されているか
- [ ] テスト観点（正常系/異常系/境界値）が適切に分類されているか
- [ ] 高優先度テストケース（設定制御、エラーハンドリング、子プロセス実行）が網羅されているか
- [ ] PHPValidationProviderの主要機能（バリデーション実行、エラーパース）がテストされているか
- [ ] 非同期ユーティリティ（Throttler, Delayer, ThrottledDelayer）のテストが含まれているか
- [ ] VSCode API依存部分のモック戦略が明確か
- [ ] 外部コマンド依存（which, php）のテスト方針が明確か
