---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 193
  claims_with_evidence: 193
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-references-view 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：193 / 193、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `extensions/references-view/src/extension.ts` - 拡張機能エントリーポイント
- E-02: `extensions/references-view/src/tree.ts` - SymbolsTree、TreeDataProviderDelegate、TreeDndDelegate、TreeInputHistory、HistoryItem
- E-03: `extensions/references-view/src/navigation.ts` - Navigation クラス
- E-04: `extensions/references-view/src/utils.ts` - ユーティリティ関数群（del、tail、asResourceUrl、isValidRequestPosition、getPreviewChunks、ContextKey、WordAnchor、getThemeIcon）
- E-05: `extensions/references-view/src/highlights.ts` - EditorHighlights クラス
- E-06: `extensions/references-view/src/references/model.ts` - ReferencesTreeInput、ReferencesModel、ReferencesTreeDataProvider、FileItem、ReferenceItem
- E-07: `extensions/references-view/src/references/index.ts` - 参照検索コマンド登録、copyCommand、copyAllCommand、copyPathCommand、removeReferenceItem
- E-08: `extensions/references-view/src/calls/model.ts` - CallsTreeInput、CallItem、CallsModel、CallItemDataProvider
- E-09: `extensions/references-view/src/calls/index.ts` - 呼び出し階層コマンド登録、RichCallsDirection
- E-10: `extensions/references-view/src/types/model.ts` - TypesTreeInput、TypeItem、TypesModel、TypeItemDataProvider
- E-11: `extensions/references-view/src/types/index.ts` - 型階層コマンド登録、RichTypesDirection
- E-12: `extensions/references-view/src/references-view.d.ts` - TypeScriptインターフェース定義（SymbolTree、SymbolTreeInput、SymbolTreeModel、SymbolItemNavigation、SymbolItemEditorHighlights、SymbolItemDragAndDrop）

## 3) Claims と根拠の対応（レビューの主戦場）

### SymbolsTree クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TreeViewが正しく初期化される（UT-REF-001） | E-02: L30-37 constructor | ○ |
| C-02 | リソースが正しく解放される（UT-REF-002） | E-02: L39-43 dispose() | ○ |
| C-03 | 現在の入力が取得できる（UT-REF-003, 004） | E-02: L45-47 getInput() | ○ |
| C-04 | 有効な入力でツリーが更新される（UT-REF-005） | E-02: L49-117 setInput() | ○ |
| C-05 | 無効な位置の場合clearInputが呼ばれる（UT-REF-006） | E-02: L51-54 isValidRequestPosition チェック | ○ |
| C-06 | モデルがnullの場合clearInputが呼ばれる（UT-REF-007） | E-02: L79-82 nullチェック | ○ |
| C-07 | 入力がクリアされる（UT-REF-008, 009, 010） | E-02: L119-129 clearInput() | ○ |

### TreeDataProviderDelegate クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | プロバイダーが更新される（UT-REF-011, 012） | E-02: L147-164 update() | ○ |
| C-09 | TreeItemが取得できる（UT-REF-013, 014） | E-02: L166-169 getTreeItem() | ○ |
| C-10 | 子要素が取得できる（UT-REF-015, 016） | E-02: L171-174 getChildren() | ○ |
| C-11 | 親要素が取得できる（UT-REF-017, 018） | E-02: L176-180 getParent() | ○ |

### TreeDndDelegate クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | デリゲートが更新される（UT-REF-019） | E-02: L199-202 update() | ○ |
| C-13 | ドラッグ処理が動作する（UT-REF-020, 021, 022） | E-02: L204-217 handleDrag() | ○ |
| C-14 | ドロップは未実装（UT-REF-023） | E-02: L219-221 handleDrop() | ○ |

### TreeInputHistory クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | 履歴に入力が追加される（UT-REF-025, 026） | E-02: L309-322 add() | ○ |
| C-16 | 履歴がクリアされる（UT-REF-027） | E-02: L324-328 clear() | ○ |
| C-17 | サイズが取得できる（UT-REF-028） | E-02: L330-332 size getter | ○ |
| C-18 | TreeItemが生成される（UT-REF-029） | E-02: L336-343 getTreeItem() | ○ |
| C-19 | 子要素が逆順で取得される（UT-REF-030） | E-02: L345-347 getChildren() | ○ |

### Navigation クラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | ナビゲーションコマンドが登録される（UT-REF-032） | E-03: L17-22 constructor | ○ |
| C-21 | デリゲートが設定される（UT-REF-033, 034） | E-03: L28-31 update() | ○ |
| C-22 | 次へ移動できる（UT-REF-035, 036, 037） | E-03: L70-84 next() | ○ |
| C-23 | 前へ移動できる（UT-REF-038, 039） | E-03: L54-68 previous() | ○ |

### ユーティリティ関数（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | del関数で要素が削除される（UT-REF-040, 041） | E-04: L8-13 del() | ○ |
| C-25 | tail関数で最後の要素が返される（UT-REF-042, 043） | E-04: L15-17 tail() | ○ |
| C-26 | asResourceUrlでフラグメント付きURIが生成される（UT-REF-044） | E-04: L19-21 asResourceUrl() | ○ |
| C-27 | isValidRequestPositionで位置が検証される（UT-REF-045, 046） | E-04: L23-30 isValidRequestPosition() | ○ |
| C-28 | getPreviewChunksでプレビューが取得される（UT-REF-047, 048, 049） | E-04: L32-44 getPreviewChunks() | ○ |
| C-29 | ContextKeyが設定/リセットされる（UT-REF-050, 051） | E-04: L46-57 ContextKey class | ○ |
| C-30 | WordAnchorで位置が追跡される（UT-REF-052-057） | E-04: L59-122 WordAnchor class | ○ |
| C-31 | getThemeIconでアイコンが取得される（UT-REF-058, 059） | E-04: L124-136 getThemeIcon() | ○ |

### EditorHighlights クラス（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | EditorHighlightsが初期化される（UT-REF-060） | E-05: L9-33 constructor | ○ |
| C-33 | リソースが解放される（UT-REF-061） | E-05: L35-40 dispose() | ○ |
| C-34 | ハイライトが更新される（UT-REF-062） | E-05: L66-69 update() | ○ |
| C-35 | ハイライトが表示される（UT-REF-063-067） | E-05: L42-58 _show() | ○ |
| C-36 | ハイライトが削除される（UT-REF-068） | E-05: L60-64 _hide() | ○ |

### ReferencesTreeInput クラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | ReferencesTreeInputが初期化される（UT-REF-069） | E-06: L10-22 constructor | ○ |
| C-38 | モデルが解決される（UT-REF-070, 071, 072） | E-06: L23-48 resolve() | ○ |
| C-39 | 新しい位置で生成される（UT-REF-073） | E-06: L50-52 with() | ○ |

### ReferencesModel クラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | モデルが構築される（UT-REF-074, 075, 076） | E-06: L55-75 constructor | ○ |
| C-41 | メッセージが生成される（UT-REF-077, 078, 079） | E-06: L110-125 message getter | ○ |
| C-42 | 位置が取得できる（UT-REF-080, 081, 082） | E-06: L127-131 location() | ○ |
| C-43 | 最近傍が検索できる（UT-REF-083-086） | E-06: L133-175 nearest() | ○ |
| C-44 | next/previousで移動できる（UT-REF-087-091） | E-06: L185-220 next(), previous(), _move() | ○ |
| C-45 | ハイライト範囲が取得できる（UT-REF-092, 093） | E-06: L222-225 getEditorHighlights() | ○ |
| C-46 | アイテムが削除できる（UT-REF-094, 095, 096） | E-06: L227-240 remove() | ○ |
| C-47 | コピーテキストが生成される（UT-REF-097） | E-06: L242-248 asCopyText() | ○ |
| C-48 | ドラッグURIが取得できる（UT-REF-098, 099） | E-06: L250-256 getDragUri() | ○ |

### ReferencesTreeDataProvider クラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | TreeItemが生成される（UT-REF-100, 101） | E-06: L275-308 getTreeItem() | ○ |
| C-50 | 子要素が取得できる（UT-REF-102, 103, 104） | E-06: L311-319 getChildren() | ○ |
| C-51 | 親が取得できる（UT-REF-105, 106） | E-06: L321-323 getParent() | ○ |

### FileItem / ReferenceItem クラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | FileItemが削除/コピーできる（UT-REF-107, 108） | E-06: L326-346 FileItem class | ○ |
| C-53 | ReferenceItemのドキュメント取得（UT-REF-109, 110, 111） | E-06: L349-372 getDocument() | ○ |
| C-54 | ReferenceItemが削除/コピーできる（UT-REF-112, 113） | E-06: L374-384 remove(), asCopyText() | ○ |

### references/index.ts（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | コマンドが登録される（UT-REF-114） | E-07: L10-28 register() | ○ |
| C-56 | findLocationsが動作する（UT-REF-115, 116） | E-07: L12-17 findLocations() | ○ |
| C-57 | copyCommand系が動作する（UT-REF-117-121） | E-07: L56-95 copyCommand(), copyPathCommand() | ○ |
| C-58 | removeReferenceItemが動作する（UT-REF-122, 123） | E-07: L64-70 removeReferenceItem() | ○ |
| C-59 | updateShowReferencesが動作する（UT-REF-124, 125） | E-07: L31-53 updateShowReferences() | ○ |

### CallsTreeInput / CallsModel（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | CallsTreeInputが初期化される（UT-REF-126） | E-08: L10-22 constructor | ○ |
| C-61 | モデルが解決される（UT-REF-127, 128） | E-08: L24-44 resolve() | ○ |
| C-62 | CallItem.removeが動作する（UT-REF-130） | E-08: L70-72 remove() | ○ |
| C-63 | CallsModelが構築される（UT-REF-131） | E-08: L75-84 constructor | ○ |
| C-64 | 呼び出し子要素が取得できる（UT-REF-132-134） | E-08: L86-101 _resolveCalls(), getCallChildren() | ○ |
| C-65 | ナビゲーションが動作する（UT-REF-135-139） | E-08: L105-131 location(), nearest(), next(), previous() | ○ |
| C-66 | ハイライト/ドラッグ/削除が動作する（UT-REF-140-145） | E-08: L133-157 getDragUri(), getEditorHighlights(), remove() | ○ |

### CallItemDataProvider（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | TreeItemが生成される（UT-REF-146-148） | E-08: L176-214 getTreeItem() | ○ |
| C-68 | 子/親が取得できる（UT-REF-149-151） | E-08: L216-224 getChildren(), getParent() | ○ |

### calls/index.ts（E-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | コマンドが登録される（UT-REF-152） | E-09: L11-43 register() | ○ |
| C-70 | showCallHierarchyが動作する（UT-REF-153） | E-09: L15-20 showCallHierarchy() | ○ |
| C-71 | setCallsDirectionが動作する（UT-REF-154） | E-09: L22-35 setCallsDirection() | ○ |
| C-72 | removeCallItemが動作する（UT-REF-155） | E-09: L45-49 removeCallItem() | ○ |
| C-73 | RichCallsDirectionが動作する（UT-REF-156-158） | E-09: L51-78 RichCallsDirection class | ○ |

### TypesTreeInput / TypesModel（E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | TypesTreeInputが初期化される（UT-REF-159） | E-10: L10-22 constructor | ○ |
| C-75 | モデルが解決される（UT-REF-160, 161） | E-10: L24-44 resolve() | ○ |
| C-76 | TypeItem.removeが動作する（UT-REF-163） | E-10: L68-70 remove() | ○ |
| C-77 | TypesModelが構築される（UT-REF-164） | E-10: L73-82 constructor | ○ |
| C-78 | 型子要素が取得できる（UT-REF-165-167） | E-10: L84-99 _resolveTypes(), getTypeChildren() | ○ |
| C-79 | ナビゲーションが動作する（UT-REF-168-173） | E-10: L101-135 getDragUri(), location(), nearest(), next(), previous() | ○ |
| C-80 | ハイライト/削除が動作する（UT-REF-174-177） | E-10: L139-150 getEditorHighlights(), remove() | ○ |

### TypeItemDataProvider（E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | TreeItemが生成される（UT-REF-178） | E-10: L169-185 getTreeItem() | ○ |
| C-82 | 子/親が取得できる（UT-REF-179-181） | E-10: L187-195 getChildren(), getParent() | ○ |

### types/index.ts（E-11）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | コマンドが登録される（UT-REF-182） | E-11: L11-45 register() | ○ |
| C-84 | showTypeHierarchyが動作する（UT-REF-183） | E-11: L15-20 showTypeHierarchy() | ○ |
| C-85 | setTypeHierarchyDirectionが動作する（UT-REF-184-186） | E-11: L22-38 setTypeHierarchyDirection() | ○ |
| C-86 | removeTypeItemが動作する（UT-REF-187） | E-11: L47-51 removeTypeItem() | ○ |
| C-87 | RichTypesDirectionが動作する（UT-REF-188-190） | E-11: L53-80 RichTypesDirection class | ○ |

### extension.ts（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | 拡張機能がアクティベートされる（UT-REF-191） | E-01: L13-30 activate() | ○ |
| C-89 | setInput/getInputが動作する（UT-REF-192, 193） | E-01: L21-28 setInput(), getInput() | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのテストケースにソースコード根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいている
- モジュールはVS Code拡張機能として完全に自己完結しており、外部依存が少ない

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高）が適切に設定されているか確認
- [ ] 境界値テストケースが十分にカバーされているか確認
- [ ] エラーハンドリングのテストケースが網羅されているか確認
- [ ] VS Code APIのモック戦略を確認（vscode.commands、vscode.window、vscode.workspace等）
- [ ] 非同期処理のテストケースで適切なawait/Promise処理が考慮されているか確認
