---
generated_at: 2026-01-27 14:05:00
metrics:
  claims_total: 68
  claims_with_evidence: 68
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-search-result 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：68 / 68、根拠なし：0
- 優先レビュー（高）
  1. **UT-SRE-001 〜 UT-SRE-006**：activate関数のテストケース - エントリーポイントのため重要
  2. **UT-SRE-030 〜 UT-SRE-038**：relativePathToUri関数 - パス解決の複雑なロジック
  3. **UT-SRE-039 〜 UT-SRE-056**：parseSearchResults関数 - コア機能のパース処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/search-result/src/extension.ts` - 拡張機能のメインソースファイル（全278行）
- E-02: `extensions/search-result/package.json` - 拡張機能のマニフェスト
- E-03: `extensions/search-result/syntaxes/searchResult.tmLanguage.json` - 文法定義
- E-04: `docs/code-to-docs/単体テストケース一覧/plan.md` - テストケース生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### activate関数（UT-SRE-001 〜 UT-SRE-009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | activate関数で4つのプロバイダーが登録される | E-01 L39-106 | ○ |
| C-02 | contextLineDecorationsとmatchLineDecorationsが作成される | E-01 L22-23 | ○ |
| C-03 | アクティブエディタがsearch-resultの場合デコレーションが適用される | E-01 L33-35 | ○ |
| C-04 | エディタ変更時にcachedLastParseがクリアされる | E-01 L112 | ○ |
| C-05 | ドキュメント変更時にdecorate関数が呼ばれる | E-01 L115-118 | ○ |
| C-06 | dispose時にキャッシュとリスナーがクリアされる | E-01 L125 | ○ |
| C-07 | decorate関数がコンテキスト行とマッチ行を区別する | E-01 L25-31 | ○ |

### DocumentSymbolProvider（UT-SRE-010 〜 UT-SRE-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | provideDocumentSymbolsがファイル行からDocumentSymbolを生成する | E-01 L39-52 | ○ |
| C-09 | シンボルのrangeがallLocationsのunionになる | E-01 L47 | ○ |
| C-10 | ファイル行がない場合空配列が返る | E-01 L41-42 filter(isFileLine) | ○ |
| C-11 | キャンセルトークンがparseSearchResultsに渡される | E-01 L41 | ○ |

### CompletionItemProvider（UT-SRE-015 〜 UT-SRE-021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | 行頭でDIRECTIVES候補が返る | E-01 L60-66 | ○ |
| C-13 | 既存のDIRECTIVEが候補から除外される | E-01 L64 filter | ○ |
| C-14 | Flags行でFLAGS候補が返る | E-01 L68-72 | ○ |
| C-15 | 既存のFLAGが候補から除外される | E-01 L70 filter | ○ |
| C-16 | 4行目以降で空配列が返る | E-01 L59 | ○ |

### DefinitionProvider（UT-SRE-022 〜 UT-SRE-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | ファイル行からDefinitionLinkが返る | E-01 L80-81 | ○ |
| C-18 | 結果行の位置からDefinitionLinkが返る | E-01 L83-96 | ○ |
| C-19 | ターゲット位置がオフセット込みで計算される | E-01 L89-92 | ○ |
| C-20 | 該当行がない場合空配列が返る | E-01 L79 | ○ |
| C-21 | locationが見つからない場合空配列が返る | E-01 L85-86 | ○ |

### DocumentLinkProvider（UT-SRE-027 〜 UT-SRE-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | ファイル行からDocumentLinkが生成される | E-01 L100-105 | ○ |
| C-23 | 複数ファイルから複数リンクが生成される | E-01 L102-104 map | ○ |

### relativePathToUri関数（UT-SRE-030 〜 UT-SRE-038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Settings接頭辞付きパスがvscode-userdataスキームに変換される | E-01 L132-135 | ○ |
| C-25 | 絶対パスがfile URIに変換される | E-01 L137-141 | ○ |
| C-26 | Untitledパスがuntitledスキームに変換される | E-01 L138-139 | ○ |
| C-27 | ホームディレクトリ相対パスが展開される | E-01 L144-147 | ○ |
| C-28 | マルチルート形式パスが正しく解決される | E-01 L153-160 | ○ |
| C-29 | 単一ワークスペースで相対パスが解決される | E-01 L161-162 | ○ |
| C-30 | 保存済み検索結果からワークスペースが推定される | E-01 L163-169 | ○ |
| C-31 | 解決できないパスでundefinedが返る | E-01 L173-174 | ○ |

### parseSearchResults関数（UT-SRE-039 〜 UT-SRE-056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | ファイル行が正しくパースされる | E-01 L201-217 | ○ |
| C-33 | 結果行が正しくパースされる | E-01 L221-267 | ○ |
| C-34 | コンテキスト行が識別される（separator=' '） | E-01 L266 | ○ |
| C-35 | 省略文字が正しく処理される | E-01 L232-243 | ○ |
| C-36 | キャッシュが有効な場合キャッシュが返る | E-01 L186-188 | ○ |
| C-37 | パース結果がキャッシュに保存される | E-01 L270-274 | ○ |
| C-38 | キャンセルトークンで処理が中断される | E-01 L198 | ○ |
| C-39 | prefixRangeが正しく計算される | E-01 L266 | ○ |
| C-40 | targetRangeが前後3行を含む | E-01 L226 | ○ |
| C-41 | convenienceLocationが追加される | E-01 L259-265 | ○ |
| C-42 | マッチ行のみがallLocationsに追加される | E-01 L254-256 | ○ |

### 型ガード関数（UT-SRE-057 〜 UT-SRE-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | isFileLineがtype='file'を判定する | E-01 L180 | ○ |
| C-44 | isResultLineがtype='result'を判定する | E-01 L181 | ○ |

### 正規表現（UT-SRE-061 〜 UT-SRE-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | FILE_LINE_REGEXがファイルパス行をマッチする | E-01 L9 | ○ |
| C-46 | RESULT_LINE_REGEXが結果行をマッチする | E-01 L10 | ○ |
| C-47 | ELISION_REGEXが省略文字をマッチする | E-01 L11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードから直接導出されています
- モジュールは単一ファイル（extension.ts）のみで構成されており、網羅性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] relativePathToUri関数のパス解決ロジックが実際の使用パターンを網羅しているか
- [ ] parseSearchResults関数のELISION_REGEX処理が正しくテストされているか
- [ ] 各プロバイダー（DocumentSymbol、Completion、Definition、DocumentLink）のエッジケースが網羅されているか
- [ ] キャッシュ機構のテストケースが適切か（version/uri比較、無効化タイミング）
- [ ] 正規表現のテストケースが境界条件を適切にカバーしているか
