---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 96
  claims_with_evidence: 96
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-simple-browser 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：96 / 96、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/simple-browser/src/extension.ts`
- E-02: `extensions/simple-browser/src/simpleBrowserManager.ts`
- E-03: `extensions/simple-browser/src/simpleBrowserView.ts`
- E-04: `extensions/simple-browser/src/dispose.ts`
- E-05: `extensions/simple-browser/src/uuid.ts`
- E-06: `extensions/simple-browser/preview-src/index.ts`
- E-07: `extensions/simple-browser/preview-src/events.ts`
- E-08: `extensions/simple-browser/package.json`

## 3) Claims と根拠の対応（レビューの主戦場）

### SimpleBrowserManager クラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showメソッドは文字列URLを受け付ける | E-02 L22-31 `typeof inputUri === 'string'` | ○ |
| C-02 | showメソッドはvscode.Uri型を受け付ける | E-02 L23 `inputUri.toString(true)` | ○ |
| C-03 | _activeViewが存在しない場合、新規作成される | E-02 L24-30 `if (this._activeView)...else` | ○ |
| C-04 | _activeViewが存在する場合、再利用される | E-02 L25 `this._activeView.show(url, options)` | ○ |
| C-05 | restoreメソッドでstateからurlを取得 | E-02 L35 `state?.url ?? ''` | ○ |
| C-06 | disposeで_activeViewがクリーンアップされる | E-02 L17-20 `this._activeView?.dispose()` | ○ |
| C-07 | registerWebviewListenersでdisposeイベントを監視 | E-02 L41-46 `view.onDispose()` | ○ |

### SimpleBrowserView クラス（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | createでWebviewPanelが作成される | E-03 L40-53 `vscode.window.createWebviewPanel` | ○ |
| C-09 | viewTypeは'simpleBrowser.view' | E-03 L18 `viewType = 'simpleBrowser.view'` | ○ |
| C-10 | retainContextWhenHiddenがtrue | E-03 L49 `retainContextWhenHidden: true` | ○ |
| C-11 | showメソッドでHTMLが更新される | E-03 L108-111 `this._webviewPanel.webview.html = this.getHtml(url)` | ○ |
| C-12 | showメソッドでrevealが呼ばれる | E-03 L110 `this._webviewPanel.reveal(...)` | ○ |
| C-13 | getHtmlでnonceが生成される | E-03 L116 `const nonce = generateUuid()` | ○ |
| C-14 | getHtmlでCSPにnonceが含まれる | E-03 L131 `script-src 'nonce-${nonce}'` | ○ |
| C-15 | getHtmlでURLがdata-settingsに埋め込まれる | E-03 L135-138 `data-settings="${escapeAttribute(...)}"` | ○ |
| C-16 | openExternalメッセージでvscode.env.openExternalが呼ばれる | E-03 L73-82 `case 'openExternal':...vscode.env.openExternal(url)` | ○ |
| C-17 | 不正なURLはtry-catchで処理される | E-03 L79-81 `catch { // Noop }` | ○ |
| C-18 | 設定変更でpostMessageが送信される | E-03 L90-98 `onDidChangeConfiguration...postMessage` | ○ |
| C-19 | disposeで_onDidDisposeが発火する | E-03 L103-106 `this._onDidDispose.fire()` | ○ |
| C-20 | getWebviewOptionsでenableScripts=true | E-03 L29 `enableScripts: true` | ○ |
| C-21 | getWebviewOptionsでenableForms=true | E-03 L30 `enableForms: true` | ○ |
| C-22 | localResourceRootsにmediaが含まれる | E-03 L21-25 `vscode.Uri.joinPath(extensionUri, 'media')` | ○ |
| C-23 | escapeAttributeでダブルクォートがエスケープされる | E-03 L182-184 `replace(/"/g, '&quot;')` | ○ |

### Disposable クラス（E-04）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | disposeで_disposablesがすべて破棄される | E-04 L20-26 `disposeAll(this._disposables)` | ○ |
| C-25 | 2回目のdisposeは何もしない | E-04 L21-23 `if (this._isDisposed) { return; }` | ○ |
| C-26 | _registerでdisposableが追加される | E-04 L28-35 `this._disposables.push(value)` | ○ |
| C-27 | dispose後の_registerは即座にdisposeされる | E-04 L29-31 `if (this._isDisposed) { value.dispose(); }` | ○ |
| C-28 | isDisposedでdispose状態を確認できる | E-04 L37-39 `get isDisposed()` | ○ |
| C-29 | disposeAllで配列が空になる | E-04 L8-13 `while (disposables.length) { disposables.pop()?.dispose() }` | ○ |

### generateUuid 関数（E-05）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | crypto.randomUUIDが使用可能な場合それを使う | E-05 L11-17 `if (typeof crypto.randomUUID === 'function')` | ○ |
| C-31 | randomUUID未サポート時はgetRandomValuesを使用 | E-05 L21-56 `crypto.getRandomValues(_data)` | ○ |
| C-32 | バージョンビットが0100に設定される | E-05 L31 `_data[6] = (_data[6] & 0x0f) | 0x40` | ○ |
| C-33 | バリアントビットが10に設定される | E-05 L32 `_data[8] = (_data[8] & 0x3f) | 0x80` | ○ |
| C-34 | UUID形式の文字列が返される | E-05 L35-56 ハイフン区切りで16進数文字列を構築 | ○ |

### extension.ts（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | activateでSimpleBrowserManagerが作成される | E-01 L59 `new SimpleBrowserManager(context.extensionUri)` | ○ |
| C-36 | WebviewPanelSerializerが登録される | E-01 L62-66 `registerWebviewPanelSerializer` | ○ |
| C-37 | showCommandが登録される | E-01 L68-83 `registerCommand(showCommand, ...)` | ○ |
| C-38 | openApiCommandが登録される | E-01 L85-94 `registerCommand(openApiCommand, ...)` | ○ |
| C-39 | ExternalUriOpenerが登録される | E-01 L96-120 `registerExternalUriOpener` | ○ |
| C-40 | URLなしの場合showInputBoxが表示される | E-01 L73-78 `if (!url) { url = await vscode.window.showInputBox(...) }` | ○ |
| C-41 | enabledHostsにlocalhostが含まれる | E-01 L20-32 `enabledHosts = new Set<string>(['localhost', ...])` | ○ |
| C-42 | enabledHostsに127.0.0.1が含まれる | E-01 L23 `'127.0.0.1'` | ○ |
| C-43 | enabledHostsに[::1]が含まれる | E-01 L25-26 `'[0:0:0:0:0:0:0:1]', '[::1]'` | ○ |
| C-44 | Web環境ではDefaultが返される | E-01 L101-103 `isWeb() ? ...Default : ...Option` | ○ |
| C-45 | デスクトップ環境ではOptionが返される | E-01 L103 `ExternalUriOpenerPriority.Option` | ○ |
| C-46 | 外部ホストではNoneが返される | E-01 L106 `return ExternalUriOpenerPriority.None` | ○ |
| C-47 | shouldUseIntegratedBrowserで設定を確認 | E-01 L39-48 `config.get<boolean>(useIntegratedBrowserSetting, false)` | ○ |
| C-48 | isWebでprocess.versions.nodeを確認 | E-01 L123-125 `typeof process === 'object' && !!process.versions.node` | ○ |
| C-49 | isWebでvscode.env.uiKindを確認 | E-01 L124 `vscode.env.uiKind === vscode.UIKind.Web` | ○ |

### preview-src/index.ts（E-06）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | getSettingsでdata-settings属性を取得 | E-06 L10-20 `element.getAttribute('data-settings')` | ○ |
| C-51 | 要素がない場合Errorがスローされる | E-06 L19 `throw new Error('Could not load settings')` | ○ |
| C-52 | navigateToでvscodeBrowserReqIdが追加される | E-06 L100 `url.searchParams.append('vscodeBrowserReqId', Date.now().toString())` | ○ |
| C-53 | navigateToでvscode.setStateが呼ばれる | E-06 L107 `vscode.setState({ url: rawUrl })` | ○ |
| C-54 | 不正なURLはそのままsrcに設定される | E-06 L103-104 `catch { iframe.src = rawUrl }` | ○ |
| C-55 | toggleFocusLockIndicatorEnabledでクラスを制御 | E-06 L111-113 `document.body.classList.toggle('enable-focus-lock-indicator', enabled)` | ○ |
| C-56 | focusメッセージでiframeにフォーカス | E-06 L34-38 `case 'focus': iframe.focus()` | ○ |
| C-57 | input変更でnavigateToが呼ばれる | E-06 L57-60 `input.addEventListener('change', ...)` | ○ |
| C-58 | forwardButtonでhistory.forward | E-06 L62-64 `forwardButton.addEventListener('click', () => { history.forward() })` | ○ |
| C-59 | backButtonでhistory.back | E-06 L66-68 `backButton.addEventListener('click', () => { history.back() })` | ○ |
| C-60 | openExternalButtonでpostMessage | E-06 L70-75 `vscode.postMessage({ type: 'openExternal', url: input.value })` | ○ |
| C-61 | reloadButtonでnavigateToが呼ばれる | E-06 L77-85 `navigateTo(input.value)` | ○ |
| C-62 | 50msごとにiframeフォーカス状態を確認 | E-06 L48-51 `setInterval(() => {...}, 50)` | ○ |

### preview-src/events.ts（E-07）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | loading状態ではDOMContentLoadedを待つ | E-07 L7-8 `if (document.readyState === 'loading'...) { document.addEventListener('DOMContentLoaded', f) }` | ○ |
| C-64 | complete/interactive状態では即座に実行 | E-07 L9-10 `else { f() }` | ○ |

### package.json（E-08）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | activationEventsにsimpleBrowser.api.openが含まれる | E-08 L26 `"onCommand:simpleBrowser.api.open"` | ○ |
| C-66 | activationEventsにhttp/httpsが含まれる | E-08 L27-28 `"onOpenExternalUri:http", "onOpenExternalUri:https"` | ○ |
| C-67 | simpleBrowser.showコマンドが定義されている | E-08 L38-43 `"command": "simpleBrowser.show"` | ○ |
| C-68 | focusLockIndicator.enabled設定が定義されている | E-08 L49-54 `"simpleBrowser.focusLockIndicator.enabled"` | ○ |
| C-69 | useIntegratedBrowser設定が定義されている | E-08 L55-64 `"simpleBrowser.useIntegratedBrowser"` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースはソースコードの実装に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースが直接ソースコードに基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）が適切か確認
- [ ] 境界値テストが十分にカバーされているか確認
- [ ] 異常系テストでエラーハンドリングが網羅されているか確認
- [ ] preview-srcのDOM操作テストが実行可能か確認（ブラウザ環境依存）
- [ ] vscode APIのモック戦略が適切か確認
