---
generated_at: 2026-01-27 14:30:00
metrics:
  claims_total: 114
  claims_with_evidence: 114
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-terminal-suggest 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの関数・メソッドが実際に存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・関数が適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：114 / 114、根拠なし：0
- 優先レビュー（高）
  1. **パーサー関連のテストケース（UT-TRS-088〜096）**：複雑なロジックのため手動検証推奨
  2. **キャッシュ関連のテストケース（UT-TRS-003〜012）**：非同期処理のためエッジケース確認推奨
  3. **シェル固有テストケース（UT-TRS-049〜060）**：プラットフォーム依存性の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/terminal-suggest/src/terminalSuggestMain.ts` - メインエントリポイント、キャッシュ管理、補完ロジック
- E-02: `extensions/terminal-suggest/src/tokens.ts` - トークンタイプ定義とトークン識別ロジック
- E-03: `extensions/terminal-suggest/src/env/pathExecutableCache.ts` - PATH実行可能ファイルキャッシュ
- E-04: `extensions/terminal-suggest/src/shell/common.ts` - 共通シェルヘルパー関数
- E-05: `extensions/terminal-suggest/src/shell/bash.ts` - Bash固有のグローバル取得
- E-06: `extensions/terminal-suggest/src/shell/zsh.ts` - Zsh固有のグローバル取得
- E-07: `extensions/terminal-suggest/src/shell/pwsh.ts` - PowerShell固有のグローバル取得
- E-08: `extensions/terminal-suggest/src/fig/execute.ts` - Figコマンド実行ラッパー
- E-09: `extensions/terminal-suggest/src/fig/figInterface.ts` - Fig補完インターフェース
- E-10: `extensions/terminal-suggest/src/fig/shared/utils.ts` - 共有ユーティリティ関数
- E-11: `extensions/terminal-suggest/src/fig/shell-parser/parser.ts` - シェルコマンドパーサー
- E-12: `extensions/terminal-suggest/src/fig/shell-parser/command.ts` - コマンド解析とエイリアス展開
- E-13: `extensions/terminal-suggest/src/fig/autocomplete-parser/parseArguments.ts` - 引数パーサー
- E-14: `extensions/terminal-suggest/src/helpers/completionItem.ts` - 補完アイテム生成
- E-15: `extensions/terminal-suggest/src/helpers/executable.ts` - 実行可能ファイル判定
- E-16: `extensions/terminal-suggest/src/helpers/os.ts` - OS判定ユーティリティ
- E-17: `extensions/terminal-suggest/src/helpers/promise.ts` - Promise ユーティリティ
- E-18: `extensions/terminal-suggest/src/helpers/uri.ts` - URIヘルパー
- E-19: `extensions/terminal-suggest/src/types.ts` - 型定義

## 3) Claims と根拠の対応（レビューの主戦場）

### terminalSuggestMain モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getCacheKeyがキャッシュキーを生成する | E-01 (Line 61-63) | ○ |
| C-02 | remoteAuthorityがundefinedの場合にlocalが使用される | E-01 (Line 62) | ○ |
| C-03 | getShellGlobalsがキャッシュを返却する | E-01 (Line 95-135) | ○ |
| C-04 | machineIdがない場合にフォールバック動作する | E-01 (Line 101-104) | ○ |
| C-05 | キャッシュが古い場合に更新される | E-01 (Line 112-114) | ○ |
| C-06 | fetchAndCacheShellGlobalsがシェルグローバルを取得する | E-01 (Line 137-194) | ○ |
| C-07 | エラー時にundefinedが返却される | E-01 (Line 179-183) | ○ |
| C-08 | 重複リクエストが統合される | E-01 (Line 153-157) | ○ |
| C-09 | writeGlobalsCacheがファイルに書き込む | E-01 (Line 197-222) | ○ |
| C-10 | globalStorageUriがない場合に早期リターン | E-01 (Line 198-200) | ○ |
| C-11 | readGlobalsCacheがファイルから読み込む | E-01 (Line 225-247) | ○ |
| C-12 | ファイルが存在しない場合にエラーなく終了 | E-01 (Line 241-244) | ○ |
| C-13 | resolveCwdFromCurrentCommandStringがURIを解決する | E-01 (Line 393-436) | ○ |
| C-14 | cwdがundefinedの場合にundefinedが返却される | E-01 (Line 396-398) | ○ |
| C-15 | ..セグメントでundefinedが返却される | E-01 (Line 419-421) | ○ |
| C-16 | 存在しないパスでundefinedが返却される | E-01 (Line 430-432) | ○ |
| C-17 | getCurrentCommandAndArgsがコマンドを抽出する | E-01 (Line 440-470) | ○ |
| C-18 | 空のコマンドラインで空文字が返却される | E-01 (Line 443-445) | ○ |
| C-19 | カーソルが途中にある場合に空文字が返却される | E-01 (Line 448-450) | ○ |
| C-20 | パイプ後のコマンドが抽出される | E-01 (Line 455-467) | ○ |
| C-21 | asArrayが単一値を配列に変換する | E-01 (Line 472-476) | ○ |
| C-22 | asArrayが配列をそのまま返却する | E-01 (Line 472-476) | ○ |
| C-23 | getCompletionItemsFromSpecsが補完アイテムを取得する | E-01 (Line 478-574) | ○ |
| C-24 | TokenType.Commandの場合にファイルとディレクトリが有効化される | E-01 (Line 561-562) | ○ |
| C-25 | sanitizeProcessEnvironmentがELECTRON_を削除する | E-01 (Line 606-628) | ○ |
| C-26 | preserveで指定した変数が保持される | E-01 (Line 607-610) | ○ |
| C-27 | createFileGlobPatternが単一拡張子パターンを生成する | E-01 (Line 630-639) | ○ |
| C-28 | createFileGlobPatternが複数拡張子パターンを生成する | E-01 (Line 637-638) | ○ |
| C-29 | 空配列の場合にundefinedが返却される | E-01 (Line 632-634) | ○ |

### tokens モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | getTokenTypeがコマンドトークンを識別する | E-02 (Line 22-50) | ○ |
| C-31 | getTokenTypeが引数トークンを識別する | E-02 (Line 49) | ○ |
| C-32 | リセット文字後にコマンドトークンが識別される | E-02 (Line 33-38) | ○ |
| C-33 | PowerShell固有のリセット文字が認識される | E-02 (Line 17, 34) | ○ |

### PathExecutableCache クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | getExecutablesInPathがPATH内の実行可能ファイルを取得する | E-03 (Line 60-80) | ○ |
| C-35 | PATHがundefinedの場合にundefinedが返却される | E-03 (Line 97-99) | ○ |
| C-36 | 重複リクエストが統合される | E-03 (Line 61-66) | ○ |
| C-37 | refreshが指定ディレクトリのキャッシュをクリアする | E-03 (Line 52-58) | ○ |
| C-38 | refreshが全キャッシュをクリアする | E-03 (Line 55-56) | ○ |
| C-39 | _getExecutablesInSinglePathがディレクトリ内ファイルを取得する | E-03 (Line 153-219) | ○ |
| C-40 | 存在しないディレクトリでundefinedが返却される | E-03 (Line 155-158) | ○ |
| C-41 | シンボリックリンクが正しく処理される | E-03 (Line 176-188) | ○ |

### shell/common モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | spawnHelperがコマンドを実行し出力を取得する | E-04 (Line 10-29) | ○ |
| C-43 | 終了コードが0以外の場合にエラーがスローされる | E-04 (Line 21-24) | ○ |
| C-44 | spawnHelper2がstdout/stderr/exitCodeを取得する | E-04 (Line 36-56) | ○ |
| C-45 | execHelperがシェルコマンドを実行する | E-04 (Line 58-68) | ○ |
| C-46 | エラー時にrejectされる | E-04 (Line 61-63) | ○ |
| C-47 | getAliasesHelperがエイリアスをパースする | E-04 (Line 70-96) | ○ |
| C-48 | 空の出力で空配列が返却される | E-04 (Line 76-78) | ○ |

### shell/bash モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | getBashGlobalsがBashグローバルを取得する | E-05 (Line 11-16) | ○ |
| C-50 | getBuiltinsがビルトインコマンドを取得する | E-05 (Line 23-68) | ○ |
| C-51 | 既存コマンドがフィルタされる | E-05 (Line 29) | ○ |
| C-52 | generateDetailAndDocsが詳細を生成する | E-05 (Line 70-79) | ○ |

### shell/zsh モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | getZshGlobalsがZshグローバルを取得する | E-06 (Line 14-19) | ○ |
| C-54 | getCommandDescriptionがコマンド説明を取得する | E-06 (Line 68-86) | ○ |
| C-55 | キャッシュがない場合にundefinedが返却される | E-06 (Line 69-71) | ○ |

### shell/pwsh モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | getPwshGlobalsがPowerShellグローバルを取得する | E-07 (Line 11-16) | ○ |
| C-57 | isPwshGetCommandEntryが有効なエントリを検証する | E-07 (Line 148-158) | ○ |
| C-58 | 無効なエントリが拒否される | E-07 (Line 150-157) | ○ |
| C-59 | isObjectがオブジェクトを判定する | E-07 (Line 164-173) | ○ |
| C-60 | 配列がオブジェクトとして判定されない | E-07 (Line 170) | ○ |

### fig/execute モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | cleanOutputが出力をクリーンアップする | E-08 (Line 10-15) | ○ |
| C-62 | カーソル文字が削除される | E-08 (Line 13) | ○ |
| C-63 | executeCommandTimeoutがタイムアウト内に実行される | E-08 (Line 17-54) | ○ |
| C-64 | 終了コードが0以外の場合にstderrがログされる | E-08 (Line 40-44) | ○ |

### fig/figInterface モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | getFigSuggestionsがFig補完候補を取得する | E-09 (Line 30-119) | ○ |
| C-66 | TokenType.Commandの場合に補完アイテムが追加される | E-09 (Line 74-88) | ○ |
| C-67 | キャンセルされた場合に処理が中断される | E-09 (Line 69) | ○ |
| C-68 | getFigSuggestionLabelが文字列スペックからラベルを取得する | E-09 (Line 361-372) | ○ |
| C-69 | オブジェクトスペックからラベルが取得される | E-09 (Line 365-366) | ○ |
| C-70 | 配列nameからラベルが取得される | E-09 (Line 368-371) | ○ |
| C-71 | nameがundefinedの場合にundefinedが返却される | E-09 (Line 368-370) | ○ |
| C-72 | getFixSuggestionDescriptionが説明を取得する | E-09 (Line 354-359) | ○ |
| C-73 | descriptionがない場合に空文字が返却される | E-09 (Line 358) | ○ |
| C-74 | collectCompletionItemResultが補完結果を収集する | E-09 (Line 172-348) | ○ |
| C-75 | convertIconToKindがSCMアイコンを変換する | E-09 (Line 374-385) | ○ |
| C-76 | 不明なアイコンでundefinedが返却される | E-09 (Line 383) | ○ |

### fig/shared/utils モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | withTimeoutがタイムアウト内にPromiseを解決する | E-10 (Line 65-80) | ○ |
| C-78 | タイムアウト時にTimeoutErrorがスローされる | E-10 (Line 72-75) | ○ |
| C-79 | makeArrayが単一値を配列に変換する | E-10 (Line 34-36) | ○ |
| C-80 | makeArrayが配列をそのまま返却する | E-10 (Line 35) | ○ |
| C-81 | longestCommonPrefixが共通プレフィックスを取得する | E-10 (Line 82-95) | ○ |
| C-82 | 共通部分がない場合に空文字が返却される | E-10 (Line 93-94) | ○ |
| C-83 | memoizeOneが結果をキャッシュする | E-10 (Line 141-158) | ○ |
| C-84 | 引数が変わると再計算される | E-10 (Line 150-156) | ○ |
| C-85 | splitPathがパスを分割する | E-10 (Line 197-200) | ○ |
| C-86 | ensureTrailingSlashが末尾スラッシュを追加する | E-10 (Line 202-203) | ○ |
| C-87 | 既存の末尾スラッシュが保持される | E-10 (Line 202) | ○ |

### fig/shell-parser/parser モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | parseがコマンドラインをパースする | E-11 (Line 730-735) | ○ |
| C-89 | パイプラインがパースされる | E-11 (Line 685-708) | ○ |
| C-90 | クォートされた文字列がパースされる | E-11 (Line 260-275) | ○ |

### fig/shell-parser/command モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | getCommandがコマンドを取得する | E-12 (Line 194-207) | ○ |
| C-92 | コマンドノードがない場合にnullが返却される | E-12 (Line 202-203) | ○ |
| C-93 | substituteAliasがエイリアスを置換する | E-12 (Line 105-161) | ○ |
| C-94 | トークンがコマンドにない場合にエラーがスローされる | E-12 (Line 110-112) | ○ |

### fig/autocomplete-parser/parseArguments モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | parseArgumentsが引数をパースする | E-13 (Line 1132-1188) | ○ |
| C-96 | トークンが空の場合にエラーがスローされる | E-13 (Line 1142-1144) | ○ |
| C-97 | createArgStateが引数状態を作成する | E-13 (Line 106-141) | ○ |
| C-98 | 引数がない場合にnullのargsを持つ状態が返却される | E-13 (Line 137-140) | ○ |
| C-99 | updateArgStateが引数状態を更新する | E-13 (Line 170-183) | ○ |
| C-100 | 可変長引数でカウントが更新される | E-13 (Line 174-175) | ○ |

### helpers モジュール群
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | createCompletionItemが補完アイテムを作成する | E-14 (Line 9-19) | ○ |
| C-102 | replacementRangeが正しく計算される | E-14 (Line 16) | ○ |
| C-103 | スペースで終わる場合にlastWordが空になる | E-14 (Line 11) | ○ |
| C-104 | isExecutableがUnix実行可能ファイルを判定する | E-15 (Line 9-15) | ○ |
| C-105 | Windows拡張子で判定される | E-15 (Line 11-12) | ○ |
| C-106 | isExecutableUnixが実行ビットを確認する | E-15 (Line 17-26) | ○ |
| C-107 | 存在しないファイルでfalseが返却される | E-15 (Line 23-25) | ○ |
| C-108 | WindowsExecutableExtensionsCacheが拡張子を取得する | E-15 (Line 52-71) | ○ |
| C-109 | 更新後に新しい拡張子が反映される | E-15 (Line 60-63) | ○ |
| C-110 | osIsWindowsがWindowsを判定する | E-16 (Line 8-10) | ○ |
| C-111 | 非WindowsがFalseになる | E-16 (Line 9) | ○ |
| C-112 | createTimeoutPromiseが指定時間後にデフォルト値を返却する | E-17 (Line 6-8) | ○ |
| C-113 | getFriendlyResourcePathがフォルダパスに末尾スラッシュを追加する | E-18 (Line 8-20) | ○ |
| C-114 | Windowsでドライブが大文字化される | E-18 (Line 11-13) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースはソースコード内の実際の関数・メソッドに基づいています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいており、実装との整合性が確認されています
- ただし以下の点は手動確認を推奨：
  - パーサー関連（複雑なステートマシン）
  - 非同期キャッシュ処理（競合状態の可能性）
  - プラットフォーム固有コード（Windows/Unix差異）

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）が適切か確認
- [ ] 各シェル（Bash/Zsh/PowerShell/Fish）の固有テストが網羅されているか確認
- [ ] エラーハンドリングのテストケースが十分か確認
- [ ] 境界値テスト（空入力、null、undefined）が網羅されているか確認
- [ ] 非同期処理のタイムアウト・キャンセル処理のテストが含まれているか確認
- [ ] Windows/Unix両環境のプラットフォーム固有テストが含まれているか確認
