---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 73
  claims_with_evidence: 73
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-tunnel-forwarding 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：73 / 73、根拠なし：0
- 優先レビュー（高）
  1. **TunnelProvider.provideTunnel**: 複雑な状態遷移ロジック（UT-TFW-017〜025）
  2. **TunnelProvider.setupPortForwardingProcess**: 外部プロセス連携（UT-TFW-034〜038）
  3. **StreamSplitter._transform**: バッファ処理ロジック（UT-TFW-046〜050）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/tunnel-forwarding/src/extension.ts` (メインモジュール、344行)
- E-02: `extensions/tunnel-forwarding/src/split.ts` (ストリーム分割、52行)
- E-03: `extensions/tunnel-forwarding/src/deferredPromise.ts` (Deferred Promise実装、63行)
- E-04: `extensions/tunnel-forwarding/package.json` (パッケージ定義、60行)

## 3) Claims と根拠の対応（レビューの主戦場）

### Tunnel クラス（UT-TFW-001〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TunnelコンストラクタでremoteAddress, privacy, protocolが設定される | E-01 L44-53 | ○ |
| C-02 | setPortFormatで{port}がポート番号に置換される | E-01 L55-57 | ○ |
| C-03 | dispose()でdisposeEmitterがfireされる | E-01 L59-61 | ○ |
| C-04 | onDidDisposeイベントが公開されている | E-01 L46 | ○ |

### Logger クラス（UT-TFW-008〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | Loggerコンストラクタでlabelが設定される | E-01 L114 | ○ |
| C-06 | log()で初めてOutputChannelが作成される（遅延初期化） | E-01 L129-131 | ○ |
| C-07 | log()は複数のログレベル（trace/debug/info/warn/error）をサポート | E-01 L124-134 | ○ |
| C-08 | show()はOutputChannelが存在する場合のみ表示する | E-01 L116-118 | ○ |
| C-09 | clear()はOutputChannelが存在する場合のみクリアする | E-01 L120-122 | ○ |

### TunnelProvider クラス（UT-TFW-016〜044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | TunnelProviderの初期状態はState.Inactive | E-01 L142 | ○ |
| C-11 | provideTunnel()でパブリックポートの場合は確認ダイアログを表示 | E-01 L159-163 | ○ |
| C-12 | consentPublicPort()はglobalState.didWarnPublicをチェック | E-01 L210-233 | ○ |
| C-13 | provideTunnel()はError/Inactive状態からsetupPortForwardingProcess()を呼ぶ | E-01 L178-181 | ○ |
| C-14 | Starting状態ではActive遷移を待機する | E-01 L182-195 | ○ |
| C-15 | Active状態では即座にTunnelを返す | E-01 L196-199 | ○ |
| C-16 | トンネルdispose時にtunnelsセットから削除される | E-01 L172-175 | ○ |
| C-17 | restart()は既存プロセスを終了し再起動する | E-01 L203-208 | ○ |
| C-18 | updateActivePortsIfRunning()でポート情報をstdinに書き込む | E-01 L255-256 | ○ |
| C-19 | ポート数が0になるとCLEANUP_TIMEOUT後にプロセス終了 | E-01 L258-259, L22 | ○ |
| C-20 | killRunningProcess()でプロセスをkillし状態をInactiveにする | E-01 L242-248 | ○ |
| C-21 | setupPortForwardingProcess()でGitHub認証を取得 | E-01 L267-269 | ○ |
| C-22 | CLIプロセスを--verbose tunnel forward-internal --provider githubで起動 | E-01 L271-280 | ○ |
| C-23 | stderrからport_formatを受信するとActive状態に遷移 | E-01 L319-331 | ○ |
| C-24 | プロセスerrorイベントでError状態に遷移 | E-01 L306-312 | ○ |
| C-25 | プロセスexitイベントでError状態に遷移 | E-01 L297-304 | ○ |
| C-26 | state setterでstateChangeイベントが発火される | E-01 L148-151 | ○ |

### StreamSplitter クラス（UT-TFW-045〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | StreamSplitterコンストラクタでsplitterが設定される | E-02 L18-19 | ○ |
| C-28 | _transform()でバッファを分割文字で分割してpush | E-02 L22-41 | ○ |
| C-29 | 分割文字がない場合はバッファに蓄積 | E-02 L29-33, L40 | ○ |
| C-30 | 複数回のtransformでバッファが連結される | E-02 L23-27 | ○ |
| C-31 | _flush()で残りのバッファをpush | E-02 L44-50 | ○ |
| C-32 | splitNewLines()は改行文字(10)で分割するSplitterを返す | E-02 L8 | ○ |

### DeferredPromise クラス（UT-TFW-054〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | DeferredPromiseコンストラクタでPromiseを作成 | E-03 L40-44 | ○ |
| C-34 | complete()でPromiseを解決しisResolved=trueにする | E-03 L47-53 | ○ |
| C-35 | error()でPromiseを拒否しisRejected=trueにする | E-03 L55-61 | ○ |
| C-36 | isSettledはoutcomeの有無で判定 | E-03 L30-32 | ○ |
| C-37 | valueは解決済みの場合のみ値を返す | E-03 L34-36 | ○ |
| C-38 | isResolvedはoutcome.outcomeがResolvedの場合true | E-03 L26-28 | ○ |
| C-39 | isRejectedはoutcome.outcomeがRejectedの場合true | E-03 L22-24 | ○ |

### activate関数・cliPath（UT-TFW-064〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | activate()はremoteAuthority存在時は早期リターン | E-01 L78-79 | ○ |
| C-41 | activate()でshowLogコマンドを登録 | E-01 L86 | ○ |
| C-42 | activate()でrestartコマンドを登録 | E-01 L87 | ○ |
| C-43 | activate()で状態変更リスナーを登録しコンテキストを更新 | E-01 L89-91 | ○ |
| C-44 | cliPathはプラットフォームによって異なるパスを設定 | E-01 L26-42 | ○ |
| C-45 | darwinではbinPath='bin' | E-01 L31 | ○ |
| C-46 | win32では.exe拡張子を付与 | E-01 L39, L41 | ○ |
| C-47 | 開発環境ではcli/target/debug/codeを使用 | E-01 L27 | ○ |
| C-48 | stableではcode-tunnel、それ以外ではcode-tunnel-insiders | E-01 L38 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードから直接確認できる根拠に基づいている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されている
- 注意事項:
  - TunnelProviderの状態遷移テストは実際のCLIプロセスとの連携が必要なため、モック化が必要
  - GitHub認証のモック化が必要
  - vscode APIのモック化が必要（vscode.window, vscode.commands, vscode.authentication等）

## 6) レビュアーチェックリスト（最小）
- [ ] テストIDの命名規則が一貫しているか（UT-TFW-XXX形式）
- [ ] 優先度「高」のテストケースが重要な機能をカバーしているか
- [ ] TunnelProviderの状態遷移（Inactive→Starting→Active→Error）が網羅されているか
- [ ] StreamSplitterのバッファ境界条件が適切にテストされているか
- [ ] DeferredPromiseの解決/拒否の両パターンがカバーされているか
- [ ] 外部依存（GitHub認証、CLIプロセス、vscode API）のモック方針が明確か
