---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：ext-typescript-language-features 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-TSL-094 (BufferSynchronizer.close 最適化)**：内部実装の詳細確認が必要
  2. **UT-TSL-115 (shouldTrigger トリガー制御)**：private メソッドの動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/typescript-language-features/src/tsServer/api.ts` - API クラス定義
- E-02: `extensions/typescript-language-features/src/tsServer/requestQueue.ts` - RequestQueue クラス定義
- E-03: `extensions/typescript-language-features/src/tsServer/cachedResponse.ts` - CachedResponse クラス定義
- E-04: `extensions/typescript-language-features/src/utils/resourceMap.ts` - ResourceMap クラス定義
- E-05: `extensions/typescript-language-features/src/utils/lazy.ts` - Lazy クラス定義
- E-06: `extensions/typescript-language-features/src/utils/dispose.ts` - Disposable, disposeAll 定義
- E-07: `extensions/typescript-language-features/src/utils/async.ts` - Delayer, Throttler, raceTimeout 定義
- E-08: `extensions/typescript-language-features/src/configuration/configuration.ts` - TsServerLogLevel, ImplicitProjectConfiguration 定義
- E-09: `extensions/typescript-language-features/src/tsServer/serverError.ts` - TypeScriptServerError クラス定義
- E-10: `extensions/typescript-language-features/src/tsServer/callbackMap.ts` - CallbackMap クラス定義
- E-11: `extensions/typescript-language-features/src/languageFeatures/diagnostics.ts` - DiagnosticsManager, FileDiagnostics 定義
- E-12: `extensions/typescript-language-features/src/tsServer/bufferSyncSupport.ts` - BufferSyncSupport, BufferSynchronizer 定義
- E-13: `extensions/typescript-language-features/src/languageFeatures/util/snippetForFunctionCall.ts` - snippetForFunctionCall 関数定義
- E-14: `extensions/typescript-language-features/src/typeConverters.ts` - Range, Position, TextEdit, WorkspaceEdit, SymbolKind 変換関数
- E-15: `extensions/typescript-language-features/src/languageFeatures/completions.ts` - TypeScriptCompletionItemProvider, MyCompletionItem 定義
- E-16: `extensions/typescript-language-features/src/typescriptServiceClient.ts` - TypeScriptServiceClient クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### API クラス (UT-TSL-001 ~ UT-TSL-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-001 | fromSimpleString が API インスタンスを生成 | E-01 (11-13行目) | ○ |
| UT-TSL-002 | fromVersionString が有効なバージョンを解析 | E-01 (35-47行目) | ○ |
| UT-TSL-003 | プレリリースタグが除去される | E-01 (42-45行目) | ○ |
| UT-TSL-004 | 無効なバージョンでデフォルト値 | E-01 (36-38行目) | ○ |
| UT-TSL-005 | eq メソッドで同一バージョン比較 | E-01 (66-68行目) | ○ |
| UT-TSL-006 | eq メソッドで異なるバージョン比較 | E-01 (66-68行目) | ○ |
| UT-TSL-007 | gte メソッドで大きいバージョン比較 | E-01 (70-72行目) | ○ |
| UT-TSL-008 | gte メソッドで同じバージョン比較 | E-01 (70-72行目) | ○ |
| UT-TSL-009 | gte メソッドで小さいバージョン比較 | E-01 (70-72行目) | ○ |
| UT-TSL-010 | lt メソッドの動作 | E-01 (74-76行目) | ○ |
| UT-TSL-011 | isYarnPnp で -sdk 検出 | E-01 (78-80行目) | ○ |
| UT-TSL-012 | isYarnPnp で通常バージョン | E-01 (78-80行目) | ○ |

### RequestQueue クラス (UT-TSL-013 ~ UT-TSL-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-013 | length プロパティ | E-02 (39-41行目) | ○ |
| UT-TSL-014 | Normal リクエストの挿入位置 | E-02 (43-57行目) | ○ |
| UT-TSL-015 | LowPriority リクエストの追加 | E-02 (53-56行目) | ○ |
| UT-TSL-016 | Fence リクエストの追加 | E-02 (53-56行目) | ○ |
| UT-TSL-017 | dequeue の動作 | E-02 (59-61行目) | ○ |
| UT-TSL-018 | 空キューでの dequeue | E-02 (59-61行目) | ○ |
| UT-TSL-019 | tryDeletePendingRequest 成功 | E-02 (79-87行目) | ○ |
| UT-TSL-020 | tryDeletePendingRequest 失敗 | E-02 (79-87行目) | ○ |
| UT-TSL-021 | シーケンス番号のインクリメント | E-02 (89-96行目) | ○ |
| UT-TSL-022 | createRequest の生成 | E-02 (89-96行目) | ○ |
| UT-TSL-023 | getQueuedCommands の取得 | E-02 (63-77行目) | ○ |
| UT-TSL-024 | getQueuedCommands の最大5件制限 | E-02 (72-73行目) | ○ |

### CachedResponse クラス (UT-TSL-025 ~ UT-TSL-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-025 | キャッシュなしで resolve 実行 | E-03 (25-34行目) | ○ |
| UT-TSL-026 | キャッシュヒット時 | E-03 (29-31行目) | ○ |
| UT-TSL-027 | バージョン変更でキャッシュ無効化 | E-03 (36-38行目) | ○ |
| UT-TSL-028 | URI 変更でキャッシュ無効化 | E-03 (36-38行目) | ○ |
| UT-TSL-029 | キャンセル時のフォールバック | E-03 (31行目) | ○ |

### ResourceMap クラス (UT-TSL-030 ~ UT-TSL-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-030 | has で存在確認 true | E-04 (38-41行目) | ○ |
| UT-TSL-031 | has で存在確認 false | E-04 (38-41行目) | ○ |
| UT-TSL-032 | get で値取得 | E-04 (43-50行目) | ○ |
| UT-TSL-033 | get で undefined | E-04 (43-50行目) | ○ |
| UT-TSL-034 | set で新規追加 | E-04 (52-63行目) | ○ |
| UT-TSL-035 | set で更新 | E-04 (52-63行目) | ○ |
| UT-TSL-036 | delete で削除 | E-04 (65-70行目) | ○ |
| UT-TSL-037 | size プロパティ | E-04 (34-36行目) | ○ |
| UT-TSL-038 | Windows パスの正規化 | E-04 (84-97行目) | ○ |
| UT-TSL-039 | Unix パスの処理 | E-04 (84-97行目) | ○ |

### Lazy クラス (UT-TSL-040 ~ UT-TSL-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-040 | 初回アクセスで計算 | E-05 (27-41行目) | ○ |
| UT-TSL-041 | 2回目以降はキャッシュ | E-05 (28-35行目) | ○ |
| UT-TSL-042 | エラーの再スロー | E-05 (37-39行目) | ○ |
| UT-TSL-043 | hasValue 未評価時 | E-05 (19行目) | ○ |
| UT-TSL-044 | hasValue 評価済み時 | E-05 (19行目) | ○ |
| UT-TSL-045 | rawValue 未評価時 | E-05 (46行目) | ○ |
| UT-TSL-046 | map メソッド | E-05 (48-50行目) | ○ |

### Disposable/disposeAll (UT-TSL-047 ~ UT-TSL-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-047 | dispose ですべて破棄 | E-06 (36-42行目) | ○ |
| UT-TSL-048 | 2回目の dispose は無視 | E-06 (37-39行目) | ○ |
| UT-TSL-049 | _register で登録 | E-06 (44-51行目) | ○ |
| UT-TSL-050 | dispose 後の登録 | E-06 (45-47行目) | ○ |
| UT-TSL-051 | disposeAll ですべて破棄 | E-06 (9-25行目) | ○ |
| UT-TSL-052 | エラー時も継続 | E-06 (14-17行目) | ○ |
| UT-TSL-053 | AggregateError | E-06 (22-24行目) | ○ |

### Delayer/Throttler/raceTimeout (UT-TSL-054 ~ UT-TSL-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-054 | Delayer.trigger の遅延実行 | E-07 (28-54行目) | ○ |
| UT-TSL-055 | 連続呼び出しで最後のみ実行 | E-07 (29-32行目) | ○ |
| UT-TSL-056 | Promise 共有 | E-07 (34-44行目) | ○ |
| UT-TSL-057 | Throttler.queue の即時実行 | E-07 (115-157行目) | ○ |
| UT-TSL-058 | キュー中のタスク実行 | E-07 (120-145行目) | ○ |
| UT-TSL-059 | 最新タスクのみ保持 | E-07 (121行目) | ○ |
| UT-TSL-060 | dispose 後のエラー | E-07 (116-118行目) | ○ |
| UT-TSL-061 | raceTimeout 早期解決 | E-07 (165-177行目) | ○ |
| UT-TSL-062 | raceTimeout タイムアウト | E-07 (168-170行目) | ○ |
| UT-TSL-063 | raceTimeout コールバック | E-07 (170行目) | ○ |

### Configuration (UT-TSL-064 ~ UT-TSL-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-064 | TsServerLogLevel.fromString normal | E-08 (20-33行目) | ○ |
| UT-TSL-065 | TsServerLogLevel.fromString verbose | E-08 (20-33行目) | ○ |
| UT-TSL-066 | TsServerLogLevel.fromString unknown | E-08 (29-31行目) | ○ |
| UT-TSL-067 | TsServerLogLevel.toString | E-08 (35-49行目) | ○ |
| UT-TSL-068 | ImplicitProjectConfiguration.isEqualTo 同一 | E-08 (79-81行目) | ○ |
| UT-TSL-069 | ImplicitProjectConfiguration.isEqualTo 異なる | E-08 (79-81行目) | ○ |

### TypeScriptServerError (UT-TSL-070 ~ UT-TSL-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-070 | create メソッド | E-09 (11-18行目) | ○ |
| UT-TSL-071 | serverErrorText プロパティ | E-09 (35行目) | ○ |
| UT-TSL-072 | telemetry プロパティ | E-09 (39-56行目) | ○ |
| UT-TSL-073 | sanitizeStack メソッド | E-09 (86-101行目) | ○ |

### CallbackMap (UT-TSL-074 ~ UT-TSL-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-074 | add 同期コールバック | E-10 (34-39行目) | ○ |
| UT-TSL-075 | add 非同期コールバック | E-10 (34-39行目) | ○ |
| UT-TSL-076 | fetch で取得・削除 | E-10 (42-46行目) | ○ |
| UT-TSL-077 | fetch で undefined | E-10 (42-46行目) | ○ |
| UT-TSL-078 | peek で参照のみ | E-10 (48-50行目) | ○ |
| UT-TSL-079 | destroy でキャンセル | E-10 (22-32行目) | ○ |

### DiagnosticsManager/FileDiagnostics (UT-TSL-080 ~ UT-TSL-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-080 | updateDiagnostics | E-11 (339-360行目) | ○ |
| UT-TSL-081 | deleteAllDiagnosticsInFile | E-11 (369-372行目) | ○ |
| UT-TSL-082 | setValidate | E-11 (325-330行目) | ○ |
| UT-TSL-083 | getDiagnostics | E-11 (382-384行目) | ○ |
| UT-TSL-084 | FileDiagnostics.updateDiagnostics | E-11 (50-72行目) | ○ |
| UT-TSL-085 | RegionSemantic マージ | E-11 (95-107行目) | ○ |
| UT-TSL-086 | getAllDiagnostics | E-11 (74-84行目) | ○ |

### BufferSyncSupport/BufferSynchronizer (UT-TSL-087 ~ UT-TSL-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-087 | openTextDocument 対応言語 | E-12 (593-612行目) | ○ |
| UT-TSL-088 | openTextDocument 非対応言語 | E-12 (594-596行目) | ○ |
| UT-TSL-089 | closeResource | E-12 (614-628行目) | ○ |
| UT-TSL-090 | ensureHasBuffer | E-12 (549-560行目) | ○ |
| UT-TSL-091 | reset | E-12 (580-584行目) | ○ |
| UT-TSL-092 | BufferSynchronizer.open | E-12 (80-82行目) | ○ |
| UT-TSL-093 | BufferSynchronizer.close | E-12 (87-89行目) | ○ |
| UT-TSL-094 | close 直後の open キャンセル | **根拠不足** | △ |
| UT-TSL-095 | BufferSynchronizer.change | E-12 (91-104行目) | ○ |
| UT-TSL-096 | flush の動作 | E-12 (118-133行目) | ○ |

### snippetForFunctionCall (UT-TSL-097 ~ UT-TSL-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-097 | スニペット生成 | E-13 (10-28行目) | ○ |
| UT-TSL-098 | オプショナルパラメータ | E-13 (22-24行目) | ○ |
| UT-TSL-099 | 既存 SnippetString 維持 | E-13 (14-16行目) | ○ |
| UT-TSL-100 | パラメータ名抽出 | E-13 (49-118行目) | ○ |
| UT-TSL-101 | this パラメータスキップ | E-13 (78, 90行目) | ○ |
| UT-TSL-102 | rest parameter 処理 | E-13 (105-108行目) | ○ |

### typeConverters (UT-TSL-103 ~ UT-TSL-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-103 | Range.fromTextSpan | E-14 (16-17行目) | ○ |
| UT-TSL-104 | Range.toTextSpan | E-14 (19-22行目) | ○ |
| UT-TSL-105 | Position.fromLocation | E-14 (56-57行目) | ○ |
| UT-TSL-106 | Position.toLocation | E-14 (59-62行目) | ○ |
| UT-TSL-107 | Position.toFileLocationRequestArgs | E-14 (64-68行目) | ○ |
| UT-TSL-108 | TextEdit.fromCodeEdit | E-14 (77-80行目) | ○ |
| UT-TSL-109 | WorkspaceEdit.fromFileCodeEdits | E-14 (84-106行目) | ○ |
| UT-TSL-110 | SymbolKind.fromProtocolScriptElementKind class | E-14 (110-137行目) | ○ |
| UT-TSL-111 | SymbolKind.fromProtocolScriptElementKind unknown | E-14 (134行目) | ○ |

### TypeScriptCompletionItemProvider/MyCompletionItem (UT-TSL-112 ~ UT-TSL-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSL-112 | provideCompletionItems | E-15 (700-827行目) | ○ |
| UT-TSL-113 | suggest.enabled=false | E-15 (706-708行目) | ○ |
| UT-TSL-114 | shouldTrigger import 文 | E-15 (900-914行目) | ○ |
| UT-TSL-115 | shouldTrigger 通常行 | **根拠不足** | △ |
| UT-TSL-116 | resolveCompletionItem | E-15 (153-241行目) | ○ |
| UT-TSL-117 | getFilterText プライベートフィールド | E-15 (391-425行目) | ○ |
| UT-TSL-118 | convertKind | E-15 (441-502行目) | ○ |
| UT-TSL-119 | getCommitCharacters | E-15 (504-534行目) | ○ |
| UT-TSL-120 | shouldExcludeCompletionEntry | E-15 (917-927行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-TSL-094**: BufferSynchronizer の open 直後の close でキャンセルされる動作は updatePending メソッド内部で行われているが、テストケースの前提条件と期待結果の整合性を直接確認するコードパスが複雑
  - 候補：E-12 の updatePending メソッド（135-156行目）の詳細レビュー

- **UT-TSL-115**: shouldTrigger メソッドは private であり、通常行での動作は context.triggerCharacter が ' ' の場合の分岐のみ記載されている
  - 候補：E-15 の shouldTrigger メソッド（900-914行目）の default return 確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: API, RequestQueue, CachedResponse, ResourceMap, Lazy - 単純なデータ構造とユーティリティ
- **0 (低リスク)**: Disposable, Delayer, Throttler - 標準的なパターン実装
- **1 (中リスク)**: DiagnosticsManager, BufferSyncSupport - 非同期処理と状態管理が複雑
- **1 (中リスク)**: TypeScriptCompletionItemProvider - 外部依存（VS Code API、TS Server）が多い
- **0 (低リスク)**: typeConverters - 純粋な型変換関数

## 6) レビュアーチェックリスト（最小）
- [ ] API クラスのバージョン比較ロジック（gte, lt）が semver 準拠であることを確認
- [ ] RequestQueue の優先度制御が Normal > LowPriority の順序を保証していることを確認
- [ ] CachedResponse のキャッシュ無効化条件（version, uri 変更）が適切であることを確認
- [ ] ResourceMap の大文字小文字処理が Windows/Unix で正しく動作することを確認
- [ ] BufferSyncSupport の非同期バッファ同期が競合状態を起こさないことを確認
- [ ] DiagnosticsManager の RegionSemantic 診断マージロジックが正しいことを確認
- [ ] TypeScriptCompletionItemProvider の補完トリガー条件が仕様通りであることを確認
