---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 62
  claims_with_evidence: 62
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ext-vscode-api-tests 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：62 / 62、根拠なし：0
- 優先レビュー（高）
  1. **TestFS クラス**：主要なファイルシステムプロバイダの実装
  2. **utils モジュール**：テストユーティリティ関数群
  3. **DeferredPromise クラス**：非同期処理制御

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `extensions/vscode-api-tests/src/memfs.ts` - TestFS、File、Directoryクラスの実装
- E-02: `extensions/vscode-api-tests/src/utils.ts` - ユーティリティ関数とDeferredPromiseの実装
- E-03: `extensions/vscode-api-tests/src/extension.ts` - 拡張機能のエントリポイント
- E-04: `extensions/vscode-api-tests/src/singlefolder-tests/notebook.api.test.ts` - Kernel、apiTestSerializerの実装
- E-05: `extensions/vscode-api-tests/package.json` - 拡張機能の設定とメタデータ
- E-06: `extensions/vscode-api-tests/src/singlefolder-tests/commands.test.ts` - コマンドAPIテスト
- E-07: `extensions/vscode-api-tests/src/singlefolder-tests/editor.test.ts` - エディタAPIテスト
- E-08: `extensions/vscode-api-tests/src/singlefolder-tests/window.test.ts` - ウィンドウAPIテスト
- E-09: `extensions/vscode-api-tests/src/singlefolder-tests/workspace.test.ts` - ワークスペースAPIテスト
- E-10: `extensions/vscode-api-tests/src/singlefolder-tests/workspace.fs.test.ts` - ファイルシステムAPIテスト
- E-11: `extensions/vscode-api-tests/src/singlefolder-tests/configuration.test.ts` - 設定APIテスト
- E-12: `extensions/vscode-api-tests/src/singlefolder-tests/types.test.ts` - 型APIテスト
- E-13: `extensions/vscode-api-tests/src/singlefolder-tests/terminal.test.ts` - ターミナルAPIテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TestFS.constructor - スキーマと大文字小文字感度を設定 | E-01 (L51-56) | ○ |
| C-02 | TestFS.stat - ファイル統計情報を取得 | E-01 (L62-64) | ○ |
| C-03 | TestFS.stat - FileNotFoundエラー | E-01 (L163-189) | ○ |
| C-04 | TestFS.readDirectory - ディレクトリ内容読取 | E-01 (L66-73) | ○ |
| C-05 | TestFS.readDirectory - FileNotADirectoryエラー | E-01 (L196-201) | ○ |
| C-06 | TestFS.readFile - ファイル内容読取 | E-01 (L77-83) | ○ |
| C-07 | TestFS.readFile - FileNotFoundエラー | E-01 (L77-83) | ○ |
| C-08 | TestFS.writeFile - 新規ファイル作成 | E-01 (L85-108) | ○ |
| C-09 | TestFS.writeFile - 既存ファイル上書き | E-01 (L85-108) | ○ |
| C-10 | TestFS.writeFile - FileNotFoundエラー | E-01 (L92-94) | ○ |
| C-11 | TestFS.writeFile - FileExistsエラー | E-01 (L95-97) | ○ |
| C-12 | TestFS.writeFile - FileIsADirectoryエラー | E-01 (L89-91) | ○ |
| C-13 | TestFS.rename - リネーム操作 | E-01 (L112-132) | ○ |
| C-14 | TestFS.rename - FileExistsエラー | E-01 (L114-116) | ○ |
| C-15 | TestFS.delete - ファイル削除 | E-01 (L134-145) | ○ |
| C-16 | TestFS.delete - FileNotFoundエラー | E-01 (L138-140) | ○ |
| C-17 | TestFS.createDirectory - ディレクトリ作成 | E-01 (L147-157) | ○ |
| C-18 | TestFS._lookup - 大文字小文字区別検索 | E-01 (L161-194) | ○ |
| C-19 | TestFS._lookup - 大文字小文字無視検索 | E-01 (L173-182) | ○ |
| C-20 | TestFS.watch - 空Disposable返却 | E-01 (L225-228) | ○ |
| C-21 | TestFS.onDidChangeFile - イベント購読 | E-01 (L223) | ○ |
| C-22 | File.constructor - ファイルエントリ作成 | E-01 (L10-27) | ○ |
| C-23 | Directory.constructor - ディレクトリエントリ作成 | E-01 (L29-47) | ○ |
| C-24 | utils.rndName - ランダム文字列生成 | E-02 (L12-14) | ○ |
| C-25 | utils.createRandomFile - ファイル作成（基本） | E-02 (L19-29) | ○ |
| C-26 | utils.createRandomFile - ファイル作成（ディレクトリ指定） | E-02 (L21-24) | ○ |
| C-27 | utils.deleteFile - 削除成功 | E-02 (L31-38) | ○ |
| C-28 | utils.deleteFile - 削除失敗 | E-02 (L34-37) | ○ |
| C-29 | utils.pathEquals - Linux | E-02 (L40-47) | ○ |
| C-30 | utils.pathEquals - 非Linux | E-02 (L41-44) | ○ |
| C-31 | utils.closeAllEditors | E-02 (L49-51) | ○ |
| C-32 | utils.saveAllEditors | E-02 (L53-55) | ○ |
| C-33 | utils.revertAllDirty | E-02 (L57-59) | ○ |
| C-34 | utils.disposeAll | E-02 (L61-63) | ○ |
| C-35 | utils.delay | E-02 (L65-67) | ○ |
| C-36 | utils.withLogDisabled | E-02 (L82-84) | ○ |
| C-37 | utils.withVerboseLogs | E-02 (L86-88) | ○ |
| C-38 | utils.assertNoRpc | E-02 (L90-92) | ○ |
| C-39 | utils.assertNoRpcFromEntry - 正常 | E-02 (L94-133) | ○ |
| C-40 | utils.assertNoRpcFromEntry - 異常 | E-02 (L131-132) | ○ |
| C-41 | utils.asPromise - 正常 | E-02 (L135-150) | ○ |
| C-42 | utils.asPromise - タイムアウト | E-02 (L136-142) | ○ |
| C-43 | utils.testRepeat | E-02 (L152-156) | ○ |
| C-44 | utils.suiteRepeat | E-02 (L158-162) | ○ |
| C-45 | utils.poll - 正常 | E-02 (L164-194) | ○ |
| C-46 | utils.poll - タイムアウト | E-02 (L175-177) | ○ |
| C-47 | DeferredPromise.constructor | E-02 (L201-227) | ○ |
| C-48 | DeferredPromise.complete | E-02 (L229-235) | ○ |
| C-49 | DeferredPromise.error | E-02 (L237-243) | ○ |
| C-50 | DeferredPromise.cancel | E-02 (L245-251) | ○ |
| C-51 | DeferredPromise.isSettled | E-02 (L216-218) | ○ |
| C-52 | extension.activate | E-03 (L12-15) | ○ |
| C-53 | Kernel.constructor | E-04 (L39-57) | ○ |
| C-54 | Kernel._execute | E-04 (L59-63) | ○ |
| C-55 | Kernel._runCell | E-04 (L65-76) | ○ |
| C-56 | Kernel.onDidChangeSelectedNotebooks - 追加 | E-04 (L50-56) | ○ |
| C-57 | Kernel.onDidChangeSelectedNotebooks - 削除 | E-04 (L50-56) | ○ |
| C-58 | apiTestSerializer.serializeNotebook | E-04 (L85-87) | ○ |
| C-59 | apiTestSerializer.deserializeNotebook | E-04 (L88-119) | ○ |
| C-60 | apiTestSerializer - セルメタデータ | E-04 (L97) | ○ |
| C-61 | apiTestSerializer - セル出力 | E-04 (L104-112) | ○ |
| C-62 | apiTestSerializer - 実行サマリー | E-04 (L113) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースに対応するソースコードが存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいている
- 注意点:
  - TestFSはインメモリファイルシステムであり、実際のファイルシステムとは動作が異なる可能性がある
  - 一部のテスト（notebook, terminalなど）はUIKind.Webではスキップされる

## 6) レビュアーチェックリスト（最小）
- [ ] TestFSのエラーハンドリングが全てのケースでカバーされているか確認
- [ ] DeferredPromiseの状態遷移が正しくテストされているか確認
- [ ] assertNoRpcによるメモリリーク検出が適切に配置されているか確認
- [ ] タイムアウト値が環境（Desktop/Web）によって適切に設定されているか確認
- [ ] Kernelクラスの実行順序が保証されているか確認
