---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 145
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：vs-base 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：145 / 150、根拠なし：5
- 優先レビュー（高）
  1. **UT-BAS-135 ThrottledWorker.work チャンク処理**：内部実装の詳細確認が必要
  2. **UT-BAS-136 ThrottledWorker.work バッファ上限**：maxBufferedWorkの挙動確認が必要
  3. **UT-BAS-143 EventBufferer.bufferEvents**：バッファ動作の詳細確認が必要
  4. **UT-BAS-142 EventMultiplexer.add**：マルチプレクサの動作確認が必要
  5. **UT-BAS-140 Relay.input setter**：リレー動作の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/base/common/uri.ts` - URIクラスの実装（isUri, parse, file, from, joinPath, with, fsPath, toString, revive）
- E-02: `src/vs/base/common/lifecycle.ts` - Disposable関連クラスの実装（Disposable, DisposableStore, MutableDisposable, DisposableMap, RefCountedDisposable, toDisposable, dispose, combinedDisposable, isDisposable）
- E-03: `src/vs/base/common/event.ts` - イベント関連クラスの実装（Emitter, Event, PauseableEmitter, AsyncEmitter, Relay, EventMultiplexer, EventBufferer, ValueWithChangeEvent）
- E-04: `src/vs/base/common/cancellation.ts` - キャンセレーション関連クラスの実装（CancellationToken, CancellationTokenSource, MutableToken, CancellationTokenPool）
- E-05: `src/vs/base/common/async.ts` - 非同期ユーティリティの実装（Throttler, Delayer, Barrier, Limiter, Queue, DeferredPromise, createCancelablePromise, timeout, retry, Sequencer, RunOnceScheduler, TimeoutTimer, IntervalTimer, ThrottledWorker, AsyncIterableObject, StatefulPromise, IntervalCounter）
- E-06: `src/vs/base/common/arrays.ts` - 配列ユーティリティの実装（equals, tail, binarySearch, coalesce, distinct, range, shuffle, top, quickSelect, ArrayQueue）

## 3) Claims と根拠の対応（レビューの主戦場）

### URIクラス関連 (C-01 〜 C-28)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URI.isUri: URIインスタンス判定 | E-01 | ○ |
| C-02 | URI.isUri: URIライクオブジェクト判定 | E-01 | ○ |
| C-03 | URI.isUri: null拒否 | E-01 | ○ |
| C-04 | URI.isUri: undefined拒否 | E-01 | ○ |
| C-05 | URI.isUri: プリミティブ拒否 | E-01 | ○ |
| C-06 | URI.parse: HTTP URL | E-01 | ○ |
| C-07 | URI.parse: file URL | E-01 | ○ |
| C-08 | URI.parse: パーセントエンコード | E-01 | ○ |
| C-09 | URI.parse: 空文字列 | E-01 | ○ |
| C-10 | URI.parse: 不正スキーム | E-01 | ○ |
| C-11 | URI.file: Unixパス | E-01 | ○ |
| C-12 | URI.file: UNCパス | E-01 | ○ |
| C-13 | URI.file: 特殊文字 | E-01 | ○ |
| C-14 | URI.from: UriComponents | E-01 | ○ |
| C-15 | URI.from: strictモード | E-01 | ○ |
| C-16 | URI.joinPath: パス結合 | E-01 | ○ |
| C-17 | URI.joinPath: 正規化 | E-01 | ○ |
| C-18 | URI.joinPath: パスなしエラー | E-01 | ○ |
| C-19 | URI.with: 同一インスタンス | E-01 | ○ |
| C-20 | URI.with: scheme変更 | E-01 | ○ |
| C-21 | URI.with: nullクリア | E-01 | ○ |
| C-22 | URI.fsPath: Unix | E-01 | ○ |
| C-23 | URI.fsPath: UNC | E-01 | ○ |
| C-24 | URI.toString: 変換 | E-01 | ○ |
| C-25 | URI.toString: skipEncoding | E-01 | ○ |
| C-26 | URI.revive: 復元 | E-01 | ○ |
| C-27 | URI.revive: null透過 | E-01 | ○ |
| C-28 | URI.revive: インスタンス透過 | E-01 | ○ |

### Disposable関連 (C-29 〜 C-50)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Disposable.dispose | E-02 | ○ |
| C-30 | Disposable._register | E-02 | ○ |
| C-31 | Disposable._register: 自己登録エラー | E-02 | ○ |
| C-32 | DisposableStore.add | E-02 | ○ |
| C-33 | DisposableStore.add: None無視 | E-02 | ○ |
| C-34 | DisposableStore.add: 破棄済み警告 | E-02 | ○ |
| C-35 | DisposableStore.add: 自己追加エラー | E-02 | ○ |
| C-36 | DisposableStore.dispose | E-02 | ○ |
| C-37 | DisposableStore.dispose: 冪等性 | E-02 | ○ |
| C-38 | DisposableStore.clear | E-02 | ○ |
| C-39 | DisposableStore.delete | E-02 | ○ |
| C-40 | DisposableStore.isDisposed | E-02 | ○ |
| C-41 | MutableDisposable.value setter | E-02 | ○ |
| C-42 | MutableDisposable: 前値破棄 | E-02 | ○ |
| C-43 | MutableDisposable: 同一値最適化 | E-02 | ○ |
| C-44 | MutableDisposable: 破棄後アクセス | E-02 | ○ |
| C-45 | MutableDisposable.clear | E-02 | ○ |
| C-46 | MutableDisposable.clearAndLeak | E-02 | ○ |
| C-47 | DisposableMap.set | E-02 | ○ |
| C-48 | DisposableMap.set: 上書き破棄 | E-02 | ○ |
| C-49 | DisposableMap.deleteAndDispose | E-02 | ○ |
| C-50 | DisposableMap.deleteAndLeak | E-02 | ○ |

### Emitter/Event関連 (C-51 〜 C-68)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | Emitter.fire: 単一通知 | E-03 | ○ |
| C-52 | Emitter.fire: 複数通知 | E-03 | ○ |
| C-53 | Emitter.event: 登録 | E-03 | ○ |
| C-54 | Emitter.event: 登録解除 | E-03 | ○ |
| C-55 | Emitter.dispose: fire無視 | E-03 | ○ |
| C-56 | Emitter.dispose: 登録無視 | E-03 | ○ |
| C-57 | Emitter.hasListeners: true | E-03 | ○ |
| C-58 | Emitter.hasListeners: false | E-03 | ○ |
| C-59 | Event.once | E-03 | ○ |
| C-60 | Event.map | E-03 | ○ |
| C-61 | Event.filter | E-03 | ○ |
| C-62 | Event.debounce | E-03 | ○ |
| C-63 | Event.buffer | E-03 | ○ |
| C-64 | Event.any | E-03 | ○ |
| C-65 | PauseableEmitter.pause/resume | E-03 | ○ |
| C-66 | PauseableEmitter.merge | E-03 | ○ |
| C-67 | AsyncEmitter.fireAsync | E-03 | ○ |
| C-68 | AsyncEmitter.waitUntil | E-03 | ○ |

### CancellationToken関連 (C-69 〜 C-74)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | CancellationToken.isCancellationRequested: false | E-04 | ○ |
| C-70 | CancellationToken.isCancellationRequested: true | E-04 | ○ |
| C-71 | CancellationToken.onCancellationRequested | E-04 | ○ |
| C-72 | CancellationToken: 遅延登録 | E-04 | ○ |
| C-73 | CancellationTokenSource.dispose: 親リスナー解除 | E-04 | ○ |
| C-74 | CancellationTokenSource.dispose(true) | E-04 | ○ |

### 非同期ユーティリティ関連 (C-75 〜 C-96)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | Throttler.queue: 順次実行 | E-05 | ○ |
| C-76 | Throttler.queue: 最新のみ実行 | E-05 | ○ |
| C-77 | Throttler.dispose: 破棄後拒否 | E-05 | ○ |
| C-78 | Delayer.trigger: 遅延実行 | E-05 | ○ |
| C-79 | Delayer.trigger: デバウンス | E-05 | ○ |
| C-80 | Delayer.cancel | E-05 | ○ |
| C-81 | Delayer.isTriggered | E-05 | ○ |
| C-82 | Barrier.open/wait | E-05 | ○ |
| C-83 | Barrier.isOpen | E-05 | ○ |
| C-84 | Limiter.queue: 並列度制限 | E-05 | ○ |
| C-85 | Limiter.onDrained | E-05 | ○ |
| C-86 | Limiter.size | E-05 | ○ |
| C-87 | Queue.queue | E-05 | ○ |
| C-88 | DeferredPromise.complete | E-05 | ○ |
| C-89 | DeferredPromise.error | E-05 | ○ |
| C-90 | DeferredPromise.isSettled: false | E-05 | ○ |
| C-91 | DeferredPromise.isSettled: true | E-05 | ○ |
| C-92 | createCancelablePromise.cancel | E-05 | ○ |
| C-93 | timeout: 解決 | E-05 | ○ |
| C-94 | timeout: キャンセル | E-05 | ○ |
| C-95 | retry: 成功 | E-05 | ○ |
| C-96 | retry: 上限 | E-05 | ○ |

### 配列ユーティリティ関連 (C-97 〜 C-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | arrays.equals: true | E-06 | ○ |
| C-98 | arrays.equals: false | E-06 | ○ |
| C-99 | arrays.equals: 空配列 | E-06 | ○ |
| C-100 | arrays.equals: undefined | E-06 | ○ |
| C-101 | arrays.tail: 正常 | E-06 | ○ |
| C-102 | arrays.tail: 空配列エラー | E-06 | ○ |
| C-103 | arrays.binarySearch: 存在 | E-06 | ○ |
| C-104 | arrays.binarySearch: 非存在 | E-06 | ○ |
| C-105 | arrays.coalesce | E-06 | ○ |
| C-106 | arrays.distinct | E-06 | ○ |
| C-107 | arrays.distinct: keyFn | E-06 | ○ |
| C-108 | arrays.range: 単一引数 | E-06 | ○ |
| C-109 | arrays.range: 2引数 | E-06 | ○ |
| C-110 | arrays.shuffle | E-06 | ○ |
| C-111 | arrays.top | E-06 | ○ |
| C-112 | arrays.quickSelect: 正常 | E-06 | ○ |
| C-113 | arrays.quickSelect: エラー | E-06 | ○ |
| C-114 | ArrayQueue.dequeue | E-06 | ○ |
| C-115 | ArrayQueue.peek | E-06 | ○ |
| C-116 | ArrayQueue.takeWhile | E-06 | ○ |

### その他ユーティリティ関連 (C-117 〜 C-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | isUriComponents: true | E-01 | ○ |
| C-118 | isUriComponents: false | E-01 | ○ |
| C-119 | dispose: 単一 | E-02 | ○ |
| C-120 | dispose: 配列 | E-02 | ○ |
| C-121 | dispose: エラー耐性 | E-02 | ○ |
| C-122 | toDisposable: 変換 | E-02 | ○ |
| C-123 | toDisposable: 冪等性 | E-02 | ○ |
| C-124 | combinedDisposable | E-02 | ○ |
| C-125 | isDisposable: true | E-02 | ○ |
| C-126 | isDisposable: false | E-02 | ○ |
| C-127 | RefCountedDisposable | E-02 | ○ |
| C-128 | RunOnceScheduler.schedule | E-05 | ○ |
| C-129 | RunOnceScheduler.cancel | E-05 | ○ |
| C-130 | RunOnceScheduler.flush | E-05 | ○ |
| C-131 | TimeoutTimer.setIfNotSet | E-05 | ○ |
| C-132 | TimeoutTimer.setIfNotSet: 重複防止 | E-05 | ○ |
| C-133 | TimeoutTimer.cancelAndSet | E-05 | ○ |
| C-134 | IntervalTimer.cancelAndSet | E-05 | ○ |
| C-135 | ThrottledWorker.work: チャンク処理 | E-05 | △ |
| C-136 | ThrottledWorker.work: バッファ上限 | E-05 | △ |
| C-137 | AsyncIterableObject.toPromise | E-05 | ○ |
| C-138 | AsyncIterableObject.map | E-05 | ○ |
| C-139 | AsyncIterableObject.filter | E-05 | ○ |
| C-140 | Relay.input setter: 転送 | E-03 | △ |
| C-141 | Relay.input setter: 入力切替 | E-03 | △ |
| C-142 | EventMultiplexer.add | E-03 | △ |
| C-143 | EventBufferer.bufferEvents | E-03 | ○ |
| C-144 | ValueWithChangeEvent.value setter: 発火 | E-03 | ○ |
| C-145 | ValueWithChangeEvent.value setter: 同一値 | E-03 | ○ |
| C-146 | StatefulPromise.requireValue: 解決後 | E-05 | ○ |
| C-147 | StatefulPromise.requireValue: 未解決 | E-05 | ○ |
| C-148 | IntervalCounter.increment: カウント | E-05 | ○ |
| C-149 | IntervalCounter.increment: リセット | E-05 | ○ |
| C-150 | Sequencer.queue | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-135, C-136 ThrottledWorker**: async.tsに実装は存在するが、詳細なテスト観点（チャンクサイズ境界、バッファ上限の正確な計算方法）については実装の詳細な解析が必要
  - 候補：実装コードの詳細解析 / 既存テストケースの確認 / 開発者へのヒアリング
- **C-140, C-141 Relay**: event.tsにRelayクラスの実装は存在するが、入力切替時の動作詳細の確認が必要
  - 候補：event.tsのRelayクラス詳細確認 / 既存テストケース確認
- **C-142 EventMultiplexer**: event.tsに実装は存在するが、イベントの結合動作の詳細確認が必要
  - 候補：event.tsのEventMultiplexerクラス詳細確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: URIクラス、Disposable関連、基本的なEmitter機能 - 十分な根拠あり
- **1 (中リスク)**: 非同期ユーティリティ（Throttler, Delayer等）- 実装は確認済みだが、タイミング依存のテストは環境に依存する可能性あり
- **2 (高リスク)**: ThrottledWorker, Relay, EventMultiplexer - 実装の詳細な動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] URIクラスのパース/変換テストケースが実際のVS Code使用パターンを網羅しているか確認
- [ ] Disposable関連のメモリリーク防止テストケースが十分か確認
- [ ] 非同期ユーティリティのタイムアウト値が適切か確認（テスト実行時間への影響）
- [ ] ThrottledWorkerのチャンクサイズ/バッファ上限の計算ロジックが正しいか確認
- [ ] event.tsのRelay, EventMultiplexer, EventBuffererの詳細動作を確認
- [ ] CancellationTokenの伝播テストが親子関係を正しくテストしているか確認
- [ ] 配列ユーティリティの境界値テスト（空配列、単一要素、大規模配列）が十分か確認
