---
generated_at: 2026-01-27 14:30:00
metrics:
  claims_total: 95
  claims_with_evidence: 95
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：vs-code 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・クラスが実際に存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュール内の主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：95 / 95、根拠なし：0
- 優先レビュー（高）
  1. **暗号化関連（UT-COD-003〜011）**：セキュリティクリティカルな機能
  2. **シークレットストレージ（UT-COD-012〜018）**：認証情報の管理
  3. **ファイル書き込み（UT-COD-065〜066）**：データ整合性

## 2) 参照した情報（Evidence一覧）
> 実在するソースファイルのみ列挙。

- E-01: `src/vs/code/browser/workbench/workbench.ts` - ブラウザワークベンチ実装
- E-02: `src/vs/code/electron-utility/sharedProcess/sharedProcessMain.ts` - 共有プロセスメイン
- E-03: `src/vs/code/electron-utility/sharedProcess/contrib/storageDataCleaner.ts` - ストレージクリーナー
- E-04: `src/vs/code/electron-utility/sharedProcess/contrib/defaultExtensionsInitializer.ts` - デフォルト拡張機能初期化
- E-05: `src/vs/code/electron-utility/sharedProcess/contrib/logsDataCleaner.ts` - ログクリーナー
- E-06: `src/vs/code/electron-utility/sharedProcess/contrib/localizationsUpdater.ts` - ローカライゼーション更新
- E-07: `src/vs/code/electron-utility/sharedProcess/contrib/userDataProfilesCleaner.ts` - プロファイルクリーナー
- E-08: `src/vs/code/electron-utility/sharedProcess/contrib/extensions.ts` - 拡張機能コントリビューション
- E-09: `src/vs/code/electron-utility/sharedProcess/contrib/languagePackCachedDataCleaner.ts` - 言語パックキャッシュクリーナー
- E-10: `src/vs/code/electron-utility/sharedProcess/contrib/codeCacheCleaner.ts` - コードキャッシュクリーナー
- E-11: `src/vs/code/electron-browser/workbench/workbench.ts` - Electronワークベンチ
- E-12: `src/vs/code/node/cliProcessMain.ts` - CLIプロセスメイン
- E-13: `src/vs/code/node/cli.ts` - CLIエントリポイント
- E-14: `src/vs/code/electron-main/main.ts` - メインプロセスエントリ
- E-15: `src/vs/code/electron-main/app.ts` - CodeApplicationクラス

## 3) Claims と根拠の対応（レビューの主戦場）

### 暗号化クラス（E-01: browser/workbench/workbench.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransparentCrypto.seal - データがそのまま返却される | E-01 L31-39 | ○ |
| C-02 | TransparentCrypto.unseal - データがそのまま返却される | E-01 L31-39 | ○ |
| C-03 | ServerKeyedAESCrypto.supported - crypto.subtleの可用性判定 | E-01 L64-66 | ○ |
| C-04 | ServerKeyedAESCrypto.supported - 非セキュア時false | E-01 L64-66 | ○ |
| C-05 | ServerKeyedAESCrypto.seal - AES-GCM暗号化 | E-01 L70-93 | ○ |
| C-06 | ServerKeyedAESCrypto.unseal - AES-GCM復号化 | E-01 L96-118 | ○ |
| C-07 | ServerKeyedAESCrypto.unseal - データ長検証 | E-01 L101-103 | ○ |
| C-08 | ServerKeyedAESCrypto.getKey - キー長検証 | E-01 L126-128 | ○ |
| C-09 | ServerKeyedAESCrypto.getServerKeyPart - キーキャッシュ | E-01 L149-186 | ○ |
| C-10 | ServerKeyedAESCrypto.getServerKeyPart - サーバーキー長検証 | E-01 L164-167 | ○ |
| C-11 | ServerKeyedAESCrypto.getServerKeyPart - リトライロジック | E-01 L157-178 | ○ |

### シークレットストレージ（E-01: browser/workbench/workbench.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | LocalStorageSecretStorageProvider.get - シークレット取得 | E-01 L260-263 | ○ |
| C-13 | LocalStorageSecretStorageProvider.get - 存在しないキー | E-01 L260-263 | ○ |
| C-14 | LocalStorageSecretStorageProvider.set - シークレット保存 | E-01 L266-270 | ○ |
| C-15 | LocalStorageSecretStorageProvider.delete - シークレット削除 | E-01 L273-277 | ○ |
| C-16 | LocalStorageSecretStorageProvider.keys - キー一覧取得 | E-01 L280-282 | ○ |
| C-17 | LocalStorageSecretStorageProvider.load - 復号失敗時の処理 | E-01 L203-221 | ○ |
| C-18 | LocalStorageSecretStorageProvider.loadAuthSessionFromElement - 認証情報読み込み | E-01 L224-257 | ○ |

### URLコールバック（E-01: browser/workbench/workbench.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | LocalStorageURLCallbackProvider.create - コールバックURL生成 | E-01 L319-342 | ○ |
| C-20 | LocalStorageURLCallbackProvider.onDidChangeLocalStorage - ストレージ変更監視 | E-01 L360-370 | ○ |
| C-21 | LocalStorageURLCallbackProvider.checkCallbacks - コールバック処理 | E-01 L373-402 | ○ |

### ワークスペースプロバイダー（E-01: browser/workbench/workbench.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | WorkspaceProvider.create - フォルダワークスペース作成 | E-01 L413-476 | ○ |
| C-23 | WorkspaceProvider.create - ワークスペースファイル作成 | E-01 L436-444 | ○ |
| C-24 | WorkspaceProvider.create - 空ワークスペース作成 | E-01 L448-451 | ○ |
| C-25 | WorkspaceProvider.open - ワークスペース再利用 | E-01 L487-509 | ○ |
| C-26 | WorkspaceProvider.open - 新規ウィンドウ | E-01 L498-505 | ○ |
| C-27 | WorkspaceProvider.isSame - 両方undefined | E-01 L556-558 | ○ |
| C-28 | WorkspaceProvider.isSame - 同じフォルダURI | E-01 L561-562 | ○ |
| C-29 | WorkspaceProvider.hasRemote - リモート判定 | E-01 L572-584 | ○ |

### 共有プロセス（E-02: sharedProcessMain.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | SharedProcessMain.init - サービス初期化 | E-02 L166-202 | ○ |
| C-31 | SharedProcessMain.initServices - サービス登録 | E-02 L204-398 | ○ |
| C-32 | SharedProcessMain.initChannels - チャンネル登録 | E-02 L400-463 | ○ |
| C-33 | SharedProcessMain.registerErrorHandler - エラーハンドリング | E-02 L465-479 | ○ |
| C-34 | SharedProcessMain.handledClientConnection - 有効な接続 | E-02 L521-539 | ○ |
| C-35 | SharedProcessMain.handledClientConnection - 無効な接続 | E-02 L521-539 | ○ |

### ストレージクリーナー（E-03: storageDataCleaner.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | UnusedWorkspaceStorageDataCleaner.cleanUpStorage - 未使用削除 | E-03 L36-72 | ○ |
| C-37 | UnusedWorkspaceStorageDataCleaner.cleanUpStorage - 使用中保持 | E-03 L55-57 | ○ |
| C-38 | UnusedWorkspaceStorageDataCleaner.cleanUpStorage - 開発用保持 | E-03 L51-52 | ○ |

### デフォルト拡張機能初期化（E-04: defaultExtensionsInitializer.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | DefaultExtensionsInitializer.initializeDefaultExtensions - VSIXインストール | E-04 L37-71 | ○ |
| C-40 | DefaultExtensionsInitializer.initializeDefaultExtensions - 空ディレクトリ | E-04 L42-45, L55-58 | ○ |
| C-41 | DefaultExtensionsInitializer.getDefaultExtensionVSIXsLocation - パス計算 | E-04 L74-84 | ○ |

### ログクリーナー（E-05: logsDataCleaner.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | LogsDataCleaner.cleanUpOldLogs - 古いログ削除 | E-05 L30-50 | ○ |
| C-43 | LogsDataCleaner.cleanUpOldLogs - 現行セッション保護 | E-05 L39 | ○ |

### その他コントリビューション（E-06〜E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | LocalizationsUpdater.updateLocalizations | E-06 L20-22 | ○ |
| C-45 | UserDataProfilesCleaner.constructor | E-07 L17-19 | ○ |
| C-46 | ExtensionsContributions.constructor | E-08 L25-27 | ○ |
| C-47 | LanguagePackCachedDataCleaner.cleanUpLanguagePackCache - 未使用削除 | E-09 L59-110 | ○ |
| C-48 | LanguagePackCachedDataCleaner.cleanUpLanguagePackCache - 使用中保持 | E-09 L78-82 | ○ |
| C-49 | LanguagePackCachedDataCleaner.cleanUpLanguagePackCache - 期限ベース | E-09 L100-104 | ○ |
| C-50 | CodeCacheCleaner.cleanUpCodeCaches - 古いキャッシュ削除 | E-10 L41-69 | ○ |
| C-51 | CodeCacheCleaner.cleanUpCodeCaches - 現行キャッシュ保護 | E-10 L54-56 | ○ |

### CLIプロセス（E-12: cliProcessMain.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | CliMain.run - CLI実行 | E-12 L97-127 | ○ |
| C-53 | CliMain.initServices - サービス初期化 | E-12 L129-271 | ○ |
| C-54 | CliMain.doRun - list-extensions | E-12 L316-318 | ○ |
| C-55 | CliMain.doRun - install-extension | E-12 L321-324 | ○ |
| C-56 | CliMain.doRun - uninstall-extension | E-12 L327-329 | ○ |
| C-57 | CliMain.doRun - 存在しないプロファイル | E-12 L308-311 | ○ |
| C-58 | CliMain.asExtensionIdOrVSIX - VSIXパス変換 | E-12 L351-353 | ○ |
| C-59 | CliMain.asExtensionIdOrVSIX - 拡張機能ID | E-12 L351-353 | ○ |

### CLIエントリポイント（E-13: cli.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | main - ヘルプ表示 | E-13 L92-95 | ○ |
| C-61 | main - バージョン表示 | E-13 L104-106 | ○ |
| C-62 | main - シェル統合パス | E-13 L109-123 | ○ |
| C-63 | main - 不正なシェルタイプ | E-13 L120 | ○ |
| C-64 | shouldSpawnCliProcess - CLI判定 | E-13 L32-41 | ○ |
| C-65 | main - file-write | E-13 L147-218 | ○ |
| C-66 | main - file-write バリデーション | E-13 L174-181 | ○ |

### メインプロセス（E-14: main.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | CodeMain.main - アプリ起動 | E-14 L88-95 | ○ |
| C-68 | CodeMain.createServices - サービス作成 | E-14 L162-248 | ○ |
| C-69 | CodeMain.initServices - ディレクトリ作成 | E-14 L267-290 | ○ |
| C-70 | CodeMain.claimInstance - IPCサーバー作成 | E-14 L303-431 | ○ |
| C-71 | CodeMain.claimInstance - 既存インスタンス接続 | E-14 L327-416 | ○ |
| C-72 | CodeMain.validatePaths - パス正規化 | E-14 L556-608 | ○ |
| C-73 | CodeMain.validatePaths - 無効ファイル名フィルタ | E-14 L590-592 | ○ |
| C-74 | CodeMain.resolveArgs - 待機マーカー | E-14 L515-533 | ○ |

### CodeApplication（E-15: app.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | CodeApplication.startup - アプリ起動 | E-15 L532-628 | ○ |
| C-76 | CodeApplication.configureSession - セッション権限設定 | E-15 L163-378 | ○ |
| C-77 | CodeApplication.configureSession - SVGフィルタ | E-15 L273-298 | ○ |
| C-78 | CodeApplication.handleProtocolUrl - プロトコルURL処理 | E-15 L872-961 | ○ |
| C-79 | CodeApplication.handleProtocolUrl - windowId=_blank | E-15 L887-895 | ○ |
| C-80 | CodeApplication.getWindowOpenableFromProtocolUrl - ファイルスキーム | E-15 L813-827 | ○ |
| C-81 | CodeApplication.getWindowOpenableFromProtocolUrl - リモートスキーム | E-15 L830-868 | ○ |
| C-82 | CodeApplication.shouldBlockOpenable - ユーザー確認 | E-15 L749-811 | ○ |
| C-83 | CodeApplication.shouldBlockOpenable - 設定スキップ | E-15 L779-781 | ○ |
| C-84 | CodeApplication.openFirstWindow - 初期プロトコルURL | E-15 L1257-1310 | ○ |
| C-85 | CodeApplication.openFirstWindow - macOpenFiles | E-15 L1343-1357 | ○ |
| C-86 | CodeApplication.resolveShellEnvironment - シェル環境解決 | E-15 L1453-1466 | ○ |
| C-87 | CodeApplication.resolveShellEnvironment - エラー処理 | E-15 L1456-1462 | ○ |
| C-88 | CodeApplication.installMutex - Windowsミューテックス | E-15 L1440-1451 | ○ |

### Electronワークベンチ（E-11: electron-browser/workbench/workbench.ts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | showSplash - スプラッシュ表示 | E-11 L25-270 | ○ |
| C-90 | showSplash - ハイコントラストモード検出 | E-11 L30-38, L54-63 | ○ |
| C-91 | load - ワークベンチロード | E-11 L276-317 | ○ |
| C-92 | fileUriFromPath - ファイルURI変換 | E-11 L424-448 | ○ |
| C-93 | fileUriFromPath - UNCパス対応 | E-11 L438-439 | ○ |
| C-94 | registerDeveloperKeybindings - 開発者キーバインド | E-11 L359-395 | ○ |
| C-95 | setupNLS - NLS設定 | E-11 L397-409 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースがソースコードに基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ユーティリティクラス、クリーナー系（UT-COD-036〜051）
- **1（中リスク）**: ワークスペース管理、URL処理（UT-COD-019〜029, UT-COD-078〜085）
- **2（高リスク）**: 暗号化、認証、ファイル操作（UT-COD-003〜018, UT-COD-065〜066）

## 6) レビュアーチェックリスト（最小）
- [ ] 暗号化関連テストケース（UT-COD-003〜011）がAES-GCMの仕様に準拠しているか
- [ ] シークレットストレージのテスト（UT-COD-012〜018）がデータ保護要件を満たすか
- [ ] ファイル書き込みテスト（UT-COD-065〜066）がトランザクション的な整合性を保証するか
- [ ] セキュリティ確認テスト（UT-COD-076〜083）がすべてのセキュリティシナリオをカバーしているか
- [ ] インスタンス管理テスト（UT-COD-070〜071）がマルチインスタンスシナリオを網羅しているか
