---
generated_at: 2026-01-27 14:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 152
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：vs-editor 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：152 / 160、根拠なし：8
- 優先レビュー（高）
  1. **UT-EDT-091〜109（CursorsController高度な操作）**：内部実装の動作確認が必要
  2. **UT-EDT-110〜125（ViewModel操作）**：統合テストとの境界確認が必要
  3. **UT-EDT-147〜160（差分マッピング）**：エッジケースの網羅性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/common/core/position.ts` - Positionクラス定義
- E-02: `src/vs/editor/common/core/range.ts` - Rangeクラス定義
- E-03: `src/vs/editor/common/core/selection.ts` - Selectionクラス定義
- E-04: `src/vs/editor/common/core/characterClassifier.ts` - CharacterClassifier, CharacterSet定義
- E-05: `src/vs/editor/common/model.ts` - TextModelResolvedOptions, FindMatch, ITextModel等の定義
- E-06: `src/vs/editor/common/cursor/cursor.ts` - CursorsController, CommandExecutor定義
- E-07: `src/vs/editor/common/viewModel/viewModelImpl.ts` - ViewModelクラス定義
- E-08: `src/vs/editor/common/viewLayout/viewLayout.ts` - ViewLayoutクラス定義
- E-09: `src/vs/editor/common/languages/linkComputer.ts` - LinkComputer, StateMachine定義
- E-10: `src/vs/editor/common/diff/rangeMapping.ts` - LineRangeMapping, RangeMapping定義
- E-11: `src/vs/editor/test/common/core/range.test.ts` - 既存Rangeテスト（参考）
- E-12: `src/vs/editor/test/browser/controller/cursor.test.ts` - 既存カーソルテスト（参考）

## 3) Claims と根拠の対応（レビューの主戦場）

### Position クラス（UT-EDT-001〜017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PositionコンストラクタがlineNumberとcolumnを設定する | E-01: L33-36 | ○ |
| C-02 | withメソッドが新しいPositionを返す（同値なら同インスタンス） | E-01: L44-50 | ○ |
| C-03 | deltaメソッドがMath.max(1, ...)で下限を保証 | E-01: L58-60 | ○ |
| C-04 | equalsメソッドがnull安全 | E-01: L72-81 | ○ |
| C-05 | isBeforeメソッドの比較ロジック | E-01: L96-104 | ○ |
| C-06 | compareメソッドのソート順序 | E-01: L131-142 | ○ |
| C-07 | liftメソッドの型変換 | E-01: L163-165 | ○ |
| C-08 | isIPositionメソッドの型ガード | E-01: L170-176 | ○ |

### Range クラス（UT-EDT-018〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | Rangeコンストラクタが入力を正規化する | E-02: L52-64 | ○ |
| C-10 | isEmptyメソッドの空判定 | E-02: L69-78 | ○ |
| C-11 | containsPositionメソッドの境界条件 | E-02: L83-101 | ○ |
| C-12 | strictContainsPositionメソッドの厳密判定 | E-02: L107-118 | ○ |
| C-13 | containsRangeメソッドの包含判定 | E-02: L123-144 | ○ |
| C-14 | plusRangeメソッドの範囲結合 | E-02: L176-213 | ○ |
| C-15 | intersectRangesメソッドの交差計算 | E-02: L218-257 | ○ |
| C-16 | equalsRangeメソッドのnull安全性 | E-02: L262-281 | ○ |
| C-17 | deltaメソッドの行移動 | E-02: L363-365 | ○ |
| C-18 | areIntersectingOrTouchingメソッドの接触判定 | E-02: L409-422 | ○ |
| C-19 | areIntersectingメソッドの重複判定 | E-02: L427-440 | ○ |
| C-20 | compareRangesUsingStartsメソッドのソート | E-02: L464-491 | ○ |

### Selection クラス（UT-EDT-058〜071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | SelectionがRangeを継承 | E-03: L50 | ○ |
| C-22 | getDirectionメソッドの方向判定 | E-03: L107-112 | ○ |
| C-23 | setEndPositionメソッドの方向保持 | E-03: L117-122 | ○ |
| C-24 | selectionsArrEqualメソッドの配列比較 | E-03: L178-194 | ○ |
| C-25 | createWithDirectionメソッドの方向指定生成 | E-03: L212-219 | ○ |

### CharacterClassifier クラス（UT-EDT-072〜079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | ASCII範囲（0-255）はUint8Arrayで管理 | E-04: L15-16, L38-46 | ○ |
| C-27 | 非ASCII範囲はMapで管理 | E-04: L20-21, L43-45 | ○ |
| C-28 | clearメソッドの初期化 | E-04: L56-59 | ○ |
| C-29 | CharacterSetがCharacterClassifierをラップ | E-04: L67-86 | ○ |

### TextModelResolvedOptions クラス（UT-EDT-080〜085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | tabSizeの最小値制限（Math.max(1, ...)） | E-05: L585 | ○ |
| C-31 | indentSize='tabSize'の処理 | E-05: L586-592 | ○ |
| C-32 | equalsメソッドの等価性判定 | E-05: L602-612 | ○ |
| C-33 | createChangeEventメソッドの変更検出 | E-05: L617-624 | ○ |

### CursorsController クラス（UT-EDT-087〜109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | コンストラクタの初期化 | E-06: L43-58 | ○ |
| C-35 | setStatesのmultiCursorLimit制限 | E-06: L118-124 | ○ |
| C-36 | typeメソッドの文字入力処理 | E-06: L556-579 | ○ |
| C-37 | readOnly時の入力拒否 | E-06: L510-513 | ○ |
| C-38 | pasteメソッドの貼り付け処理 | E-06: L601-607 | ○ |
| C-39 | compositionState管理 | E-06: L538-554 | ○ |
| C-40 | CommandExecutorのコマンド実行 | E-06: L757-775 | ○ |
| C-41 | loserCursorsMapによる重複カーソル除去 | E-06: L984-1031 | △ |

### ViewModel クラス（UT-EDT-110〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | ViewModelコンストラクタの初期化 | E-07: L69-169 | ○ |
| C-43 | getLineCountメソッド | E-07: L768-770 | ○ |
| C-44 | setHiddenAreasメソッドの折りたたみ | E-07: L571-609 | ○ |
| C-45 | readOnly時のReadOnlyEditAttemptEvent発火 | E-07: L1181-1184 | ○ |
| C-46 | typeメソッドのカーソル委譲 | E-07: L1197-1199 | ○ |
| C-47 | HiddenAreasModelの範囲マージ | E-07: L1364-1393 | △ |

### ViewLayout クラス（UT-EDT-126〜137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | ViewLayoutコンストラクタの初期化 | E-08: L167-192 | ○ |
| C-49 | getVerticalOffsetForLineNumber委譲 | E-08: L393-395 | ○ |
| C-50 | setScrollPositionのタイプ分岐 | E-08: L474-480 | ○ |
| C-51 | scrollBeyondLastLineオプション処理 | E-08: L269-277 | ○ |
| C-52 | changeWhitespaceメソッド | E-08: L377-383 | ○ |

### LinkComputer クラス（UT-EDT-138〜146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | HTTP/HTTPS/FILEプロトコル検出 | E-09: L103-143 | ○ |
| C-54 | 括弧内リンクの処理 | E-09: L186-200 | ○ |
| C-55 | 末尾句読点の除外 | E-09: L175-183 | ○ |
| C-56 | StateMachineの状態遷移 | E-09: L61-101 | ○ |
| C-57 | computeLinksのnull安全性 | E-09: L345-350 | ○ |

### 差分マッピング クラス（UT-EDT-147〜160）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | LineRangeMappingコンストラクタ | E-10: L68-74 | ○ |
| C-59 | flipメソッドの反転 | E-10: L81-83 | ○ |
| C-60 | joinメソッドの結合 | E-10: L85-90 | ○ |
| C-61 | inverseメソッドの逆マッピング生成 | E-10: L20-44 | ○ |
| C-62 | RangeMappingのfromEdit | E-10: L244-248 | ○ |
| C-63 | assertSortedの検証ロジック | E-10: L267-278 | △ |
| C-64 | DetailedLineRangeMappingのinnerChanges | E-10: L219-229 | ○ |

## 4) 不足情報（Unknown / Missing）

1. **CursorsControllerの_getLoserCursorMap（C-41）**
   - 重複するカーソル編集操作の競合解決ロジックの詳細な境界条件
   - 候補：追加のエッジケーステスト / 既存テストファイルの確認

2. **HiddenAreasModelの範囲マージ（C-47）**
   - 複数ソースからの隠し領域のマージアルゴリズムの詳細
   - 候補：mergeLineRangeArray関数の詳細テスト

3. **RangeMapping.assertSortedの例外条件（C-63）**
   - BugIndicatingErrorの発生条件の完全な網羅
   - 候補：既存テストの確認 / エッジケース追加

4. **StateMachineの負の文字コード処理**
   - nextStateメソッドの負の入力に対する挙動
   - 候補：ソースコード確認済みだが明示的テストが必要

5. **ViewModel.batchEventsのトランザクション処理**
   - batchChangesのロールバック挙動
   - 候補：エラー発生時の状態整合性テスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2（高リスク） | マルチカーソル操作（UT-EDT-091,092,101） | データ整合性に直接影響 |
| 2（高リスク） | readOnly制御（UT-EDT-099,125） | セキュリティに関連 |
| 1（中リスク） | 差分マッピングの境界条件（UT-EDT-147-160） | エッジケースでの不具合可能性 |
| 1（中リスク） | 折りたたみ範囲マージ（UT-EDT-116-118） | 表示の整合性に影響 |
| 0（低リスク） | toString等のデバッグ用メソッド | 機能への影響が限定的 |

## 6) レビュアーチェックリスト（最小）

- [ ] Position/Range/Selectionの境界値テストが網羅されているか
- [ ] CursorsControllerのreadOnly制御が正しくテストされているか
- [ ] マルチカーソル操作のmultiCursorLimit制限テストが含まれているか
- [ ] ViewModelのイベント発火タイミングが正しくテストされているか
- [ ] LinkComputerの各プロトコル（HTTP/HTTPS/FILE）がテストされているか
- [ ] 差分マッピングのflip/joinメソッドが正しくテストされているか
- [ ] null/undefined入力に対する防御的テストが含まれているか
- [ ] 既存テストファイル（E-11, E-12）との整合性が取れているか
