---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート: vs-platform 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **UT-PLT-097**: installResourceFilterの戻り値仕様
  2. **UT-PLT-113**: 既存ロガー返却の挙動詳細
  3. **UT-PLT-130**: correlationId関連の内部実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/instantiation/common/instantiationService.ts` - InstantiationServiceクラス実装
- E-02: `src/vs/platform/instantiation/common/graph.ts` - Graphクラス実装
- E-03: `src/vs/platform/configuration/common/configuration.ts` - 設定サービスインターフェース・ユーティリティ関数
- E-04: `src/vs/platform/storage/common/storage.ts` - ストレージサービス実装
- E-05: `src/vs/platform/keybinding/common/keybindingResolver.ts` - キーバインディングリゾルバー実装
- E-06: `src/vs/platform/contextkey/common/contextkey.ts` - コンテキストキー式・パーサー実装
- E-07: `src/vs/platform/commands/common/commands.ts` - コマンドレジストリ実装
- E-08: `src/vs/platform/markers/common/markerService.ts` - マーカーサービス実装
- E-09: `src/vs/platform/log/common/log.ts` - ログサービス実装
- E-10: `src/vs/platform/files/common/files.ts` - ファイルサービスインターフェース・ユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InstantiationService.createInstanceがSyncDescriptorからインスタンスを生成 | E-01 (line 116-132) | ○ |
| C-02 | createInstanceでコンストラクタ引数が渡される | E-01 (line 134-163) | ○ |
| C-03 | dispose後のcreateInstanceがエラー | E-01 (line 67-71, 119) | ○ |
| C-04 | createChildで子サービスが生成される | E-01 (line 73-87) | ○ |
| C-05 | invokeFunctionでServicesAccessorが利用可能 | E-01 (line 89-114) | ○ |
| C-06 | 関数実行後のaccessor.getがエラー | E-01 (line 98-100) | ○ |
| C-07 | disposeで作成サービスが破棄される | E-01 (line 50-65) | ○ |
| C-08 | 循環依存でCyclicDependencyError | E-01 (line 21-26, 231-233, 260-261) | ○ |
| C-09 | Graph.insertEdgeでエッジ追加 | E-02 (line 36-42) | ○ |
| C-10 | Graph.rootsでルートノード取得 | E-02 (line 26-34) | ○ |
| C-11 | Graph.removeNodeでノード削除 | E-02 (line 44-51) | ○ |
| C-12 | Graph.findCycleSlowで循環検出 | E-02 (line 86-110) | ○ |
| C-13 | 循環なしでundefined返却 | E-02 (line 94) | ○ |
| C-14 | 空グラフでisEmptyがtrue | E-02 (line 69-71) | ○ |
| C-15 | ノードありでisEmptyがfalse | E-02 (line 69-71) | ○ |
| C-16 | ConfigurationService.getValueで設定取得 | E-03 (line 167-170) | ○ |
| C-17 | overrides指定でオーバーライド値取得 | E-03 (line 169-170) | ○ |
| C-18 | 存在しないセクションでundefined | E-03 (line 319-334) | ○ |
| C-19 | updateValueで設定更新 | E-03 (line 190-193) | ○ |
| C-20 | ConfigurationTargetを指定して更新 | E-03 (line 191-193) | ○ |
| C-21 | inspectで各スコープ値検査 | E-03 (line 195) | ○ |
| C-22 | reloadConfigurationで再読み込み | E-03 (line 197) | ○ |
| C-23 | toValuesTreeでツリー変換 | E-03 (line 239-247) | ○ |
| C-24 | addToValueTreeで競合検出 | E-03 (line 249-283) | ○ |
| C-25 | removeFromValueTreeで値削除 | E-03 (line 285-312) | ○ |
| C-26 | getConfigurationValueでネスト値取得 | E-03 (line 317-335) | ○ |
| C-27 | getConfigurationValueでデフォルト値 | E-03 (line 318-319) | ○ |
| C-28 | mergeでオブジェクトマージ | E-03 (line 337-351) | ○ |
| C-29 | merge overwrite=trueで上書き | E-03 (line 343-344) | ○ |
| C-30 | ConfigurationTargetToStringで変換 | E-03 (line 50-61) | ○ |
| C-31 | AbstractStorageService.getで文字列取得 | E-04 (line 426-429) | ○ |
| C-32 | getでfallbackValue返却 | E-04 (line 428-429) | ○ |
| C-33 | getBooleanでboolean取得 | E-04 (line 432-435) | ○ |
| C-34 | getNumberで数値取得 | E-04 (line 438-441) | ○ |
| C-35 | getObjectでオブジェクト取得 | E-04 (line 444-448) | ○ |
| C-36 | storeで値保存 | E-04 (line 458-475) | ○ |
| C-37 | null保存でキー削除 | E-04 (line 461-464) | ○ |
| C-38 | storeAllで一括保存 | E-04 (line 450-456) | ○ |
| C-39 | removeでキー削除 | E-04 (line 477-488) | ○ |
| C-40 | keysでキー一覧取得 | E-04 (line 506-518) | ○ |
| C-41 | isNewで新規判定 | E-04 (line 584-586) | ○ |
| C-42 | flushで状態フラッシュ | E-04 (line 588-618) | ○ |
| C-43 | InMemoryStorageService.getStorage | E-04 (line 721-730) | ○ |
| C-44 | loadKeyTargetsでキーターゲット読み込み | E-04 (line 302-313) | ○ |
| C-45 | 不正JSONで空オブジェクト | E-04 (line 305-309) | ○ |
| C-46 | KeybindingResolver初期化 | E-05 (line 50-89) | ○ |
| C-47 | handleRemovalsで削除ルール処理 | E-05 (line 117-168) | ○ |
| C-48 | resolveでコマンド解決 | E-05 (line 313-371) | ○ |
| C-49 | マルチコードでMoreChordsNeeded | E-05 (line 362-365) | ○ |
| C-50 | 未登録キーでNoMatchingKb | E-05 (line 320-324) | ○ |
| C-51 | lookupKeybindingsで逆引き検索 | E-05 (line 269-282) | ○ |
| C-52 | lookupPrimaryKeybindingでプライマリ取得 | E-05 (line 284-305) | ○ |
| C-53 | whenIsEntirelyIncludedで条件包含判定 | E-05 (line 246-255) | ○ |
| C-54 | getDefaultBoundCommandsでデフォルトコマンド取得 | E-05 (line 257-259) | ○ |
| C-55 | ContextKeyExpr.deserializeでパース | E-06 (line 628-635) | ○ |
| C-56 | 複合式パース | E-06 (line 633-634) | ○ |
| C-57 | null/undefinedでundefined | E-06 (line 629-631) | ○ |
| C-58 | ContextKeyFalseExpr.evaluateでfalse | E-06 (line 703-705) | ○ |
| C-59 | ContextKeyTrueExpr.evaluateでtrue | E-06 (line 744-746) | ○ |
| C-60 | ContextKeyDefinedExpr.evaluateでキー存在チェック | E-06 (line 804-806) | ○ |
| C-61 | キー不在でfalse | E-06 (line 804-806) | ○ |
| C-62 | ContextKeyEqualsExpr.evaluateで等価チェック | E-06 (line 874-878) | ○ |
| C-63 | 緩い等価比較 | E-06 (line 876-877) | ○ |
| C-64 | ContextKeyNotEqualsExpr.evaluate | E-06 (line 1074-1078) | ○ |
| C-65 | ContextKeyAndExpr.evaluateで全式チェック | E-06 (line 1633-1640) | ○ |
| C-66 | And式でいずれかfalseならfalse | E-06 (line 1635-1637) | ○ |
| C-67 | ContextKeyOrExpr.evaluateでいずれかtrue | E-06 (line 1832-1839) | ○ |
| C-68 | Or式で全falseならfalse | E-06 (line 1838) | ○ |
| C-69 | ContextKeyRegexExpr.evaluateで正規表現マッチ | E-06 (line 1465-1468) | ○ |
| C-70 | ContextKeyInExpr.evaluateで配列包含チェック | E-06 (line 933-947) | ○ |
| C-71 | ContextKeyGreaterExpr.evaluateで大小比較 | E-06 (line 1209-1214) | ○ |
| C-72 | ContextKeySmallerExpr.evaluate | E-06 (line 1328-1333) | ○ |
| C-73 | Parser.parseで単純式パース | E-06 (line 204-232) | ○ |
| C-74 | 比較式パース | E-06 (line 305-498) | ○ |
| C-75 | 否定式パース | E-06 (line 260-283) | ○ |
| C-76 | 空文字列でエラー | E-06 (line 206-209) | ○ |
| C-77 | 構文エラーでundefined | E-06 (line 226-231) | ○ |
| C-78 | impliesでfalse前提 | E-06 (line 2098-2101) | ○ |
| C-79 | impliesでtrue結論 | E-06 (line 2098-2101) | ○ |
| C-80 | CommandsRegistry.registerCommandで登録 | E-07 (line 74-123) | ○ |
| C-81 | ICommandオブジェクト形式登録 | E-07 (line 80-84) | ○ |
| C-82 | 空IDでエラー | E-07 (line 76-78) | ○ |
| C-83 | handlerなしでエラー | E-07 (line 81-83) | ○ |
| C-84 | getCommandで取得 | E-07 (line 129-135) | ○ |
| C-85 | 未登録でundefined | E-07 (line 131-132) | ○ |
| C-86 | getCommandsで全取得 | E-07 (line 137-146) | ○ |
| C-87 | registerCommandAliasでエイリアス | E-07 (line 125-127) | ○ |
| C-88 | MarkerService.changeOneでマーカー追加 | E-08 (line 179-199) | ○ |
| C-89 | 空配列でマーカー削除 | E-08 (line 181-186) | ○ |
| C-90 | changeAllで全置換 | E-08 (line 266-310) | ○ |
| C-91 | removeでリソース指定削除 | E-08 (line 173-177) | ○ |
| C-92 | readでマーカー読み取り | E-08 (line 332-397) | ○ |
| C-93 | owner/resource絞り込み | E-08 (line 340-366) | ○ |
| C-94 | severitiesフィルター | E-08 (line 399-401) | ○ |
| C-95 | take制限 | E-08 (line 336-338) | ○ |
| C-96 | getStatisticsで統計取得 | E-08 (line 169-171) | ○ |
| C-97 | installResourceFilter | E-08 (line 202-226) | △ |
| C-98 | _toMarkerで変換 | E-08 (line 228-264) | ○ |
| C-99 | messageなしでundefined | E-08 (line 238-240) | ○ |
| C-100 | 行番号正規化 | E-08 (line 243-246) | ○ |
| C-101 | AbstractLogger.setLevelでレベル設定 | E-09 (line 262-267) | ○ |
| C-102 | レベル変更イベント | E-09 (line 265) | ○ |
| C-103 | checkLogLevelでレベルチェック | E-09 (line 273-275) | ○ |
| C-104 | レベル未満で拒否 | E-09 (line 60-62) | ○ |
| C-105 | ConsoleLogger.trace | E-09 (line 417-424) | ○ |
| C-106 | ConsoleLogger.debug | E-09 (line 426-433) | ○ |
| C-107 | ConsoleLogger.info | E-09 (line 435-442) | ○ |
| C-108 | ConsoleLogger.warn | E-09 (line 447-455) | ○ |
| C-109 | ConsoleLogger.error | E-09 (line 457-465) | ○ |
| C-110 | MultiplexLogger.trace転送 | E-09 (line 539-542) | ○ |
| C-111 | MultiplexLogger.setLevel全設定 | E-09 (line 532-537) | ○ |
| C-112 | AbstractLoggerService.createLogger | E-09 (line 624-649) | ○ |
| C-113 | 既存ロガー返却 | E-09 (line 627) | △ |
| C-114 | setLogLevelでデフォルト設定 | E-09 (line 655-677) | ○ |
| C-115 | 個別レベル設定 | E-09 (line 658-667) | ○ |
| C-116 | registerLoggerで登録 | E-09 (line 696-706) | ○ |
| C-117 | deregisterLoggerで登録解除 | E-09 (line 708-718) | ○ |
| C-118 | getRegisteredLoggersで一覧取得 | E-09 (line 720-724) | ○ |
| C-119 | NullLogger.traceで例外なし | E-09 (line 743) | ○ |
| C-120 | canLogでログ可能判定 | E-09 (line 60-62) | ○ |
| C-121 | LogLevel.Offで常にfalse | E-09 (line 61) | ○ |
| C-122 | parseLogLevelで変換 | E-09 (line 801-818) | ○ |
| C-123 | 不正レベルでundefined | E-09 (line 817) | ○ |
| C-124 | FileChangesEvent.containsで包含チェック | E-10 (line 1073-1075) | ○ |
| C-125 | 親フォルダ削除検出 | E-10 (line 1115-1117) | ○ |
| C-126 | affectsで子リソース影響検出 | E-10 (line 1081-1083) | ○ |
| C-127 | gotAddedで追加判定 | E-10 (line 1131-1133) | ○ |
| C-128 | gotDeletedで削除判定 | E-10 (line 1137-1139) | ○ |
| C-129 | gotUpdatedで更新判定 | E-10 (line 1145-1147) | ○ |
| C-130 | correlatesで相関ID判定 | E-10 (line 1158-1160) | △ |
| C-131 | FileOperationError作成 | E-10 (line 1453-1461) | ○ |
| C-132 | FileSystemProviderError.create | E-10 (line 833-838) | ○ |
| C-133 | toFileSystemProviderErrorCode | E-10 (line 863-894) | ○ |
| C-134 | toFileOperationResult | E-10 (line 896-922) | ○ |
| C-135 | etag生成 | E-10 (line 1568-1576) | ○ |
| C-136 | etag境界値 | E-10 (line 1571-1573) | ○ |
| C-137 | ByteSize.formatSize | E-10 (line 1603-1625) | ○ |
| C-138 | 0バイトフォーマット | E-10 (line 1608-1609) | ○ |
| C-139 | isParentで親パス判定 | E-10 (line 1200-1218) | ○ |
| C-140 | 同一パスでfalse | E-10 (line 1201-1203) | ○ |
| C-141 | hasReadWriteCapability | E-10 (line 713-715) | ○ |
| C-142 | hasFileFolderCopyCapability | E-10 (line 725-727) | ○ |
| C-143 | hasFileCloneCapability | E-10 (line 733-735) | ○ |
| C-144 | hasReadonlyCapability | E-10 (line 809-811) | ○ |
| C-145 | isConfigurationOverrides型ガード | E-03 (line 16-22) | ○ |
| C-146 | 無効オブジェクトでfalse | E-03 (line 16-22) | ○ |
| C-147 | getConfigValueInTarget | E-03 (line 109-130) | ○ |
| C-148 | isConfigured判定 | E-03 (line 132-139) | ○ |
| C-149 | 未設定判定 | E-03 (line 132-139) | ○ |
| C-150 | RawContextKey.bindTo | E-06 (line 2990-2992) | ○ |

## 4) 不足情報（Unknown / Missing）
- installResourceFilter (C-97): 内部実装の詳細が限定的、フィルター解除時の挙動確認が必要
  - 候補：テストファイル / 実装詳細レビュー / ドキュメント
- 既存ロガー返却 (C-113): 既存チェックのタイミングと条件の詳細確認が必要
  - 候補：AbstractLoggerServiceのテストファイル
- correlationId (C-130): 相関ID管理の内部状態遷移の詳細確認が必要
  - 候補：FileChangesEventのテストファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接導出可能
- 1: 中リスク - InstantiationServiceの循環依存検出（実際のプロジェクトでの発生パターン確認推奨）
- 1: 中リスク - キーバインディング解決のマルチコード処理（複雑な入力シーケンスの網羅性）
- 0: 低リスク - ログレベル関連のテストケース

## 6) レビュアーチェックリスト（最小）
- [ ] InstantiationServiceの循環依存検出テストケースが実際のエッジケースをカバーしているか確認
- [ ] KeybindingResolverのマルチコード処理テストが十分な入力パターンを網羅しているか確認
- [ ] ContextKeyExpression評価のネストした複合式テストの妥当性確認
- [ ] FileChangesEventのcorrelationId関連テストの追加検討
- [ ] MarkerServiceのフィルター機能テストの完全性確認
- [ ] AbstractLoggerServiceの既存ロガー返却ロジックの詳細確認
