---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：vs-server 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-SVR-113, UT-SVR-114 (cleanupOlderLogs)**: 削除対象数の閾値「10」の根拠がソースコードのマジックナンバーのみ
  2. **UT-SVR-132 (SHUTDOWN_TIMEOUT)**: 5分タイムアウトの設計根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/server/node/serverConnectionToken.ts` - 接続トークンの検証ロジック
- E-02: `src/vs/server/node/serverEnvironmentService.ts` - サーバー環境設定サービス
- E-03: `src/vs/server/node/extensionHostStatusService.ts` - 拡張ホストステータス管理
- E-04: `src/vs/server/node/remoteExtensionManagement.ts` - ManagementConnection実装
- E-05: `src/vs/server/node/extensionHostConnection.ts` - ExtensionHostConnection実装
- E-06: `src/vs/server/node/webClientServer.ts` - WebクライアントサーバーHTTPハンドラ
- E-07: `src/vs/server/node/remoteExtensionsScanner.ts` - 拡張機能スキャナーサービス
- E-08: `src/vs/server/node/extensionsScannerService.ts` - 拡張機能スキャナー
- E-09: `src/vs/server/node/remoteAgentEnvironmentImpl.ts` - リモートエージェント環境チャネル
- E-10: `src/vs/server/node/remoteTerminalChannel.ts` - リモートターミナルチャネル
- E-11: `src/vs/server/node/remoteFileSystemProviderServer.ts` - ファイルシステムプロバイダー
- E-12: `src/vs/server/node/remoteLanguagePacks.ts` - 言語パック設定
- E-13: `src/vs/server/node/serverServices.ts` - サーバーサービス初期化
- E-14: `src/vs/server/node/remoteExtensionHostAgentServer.ts` - リモート拡張ホストエージェントサーバー
- E-15: `src/vs/server/node/remoteExtensionHostAgentCli.ts` - CLIエントリポイント
- E-16: `src/vs/server/node/server.cli.ts` - サーバーCLIツール
- E-17: `src/vs/server/node/server.main.ts` - サーバーメインエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NoneServerConnectionToken.validateは常にtrueを返す | E-01 (L27-29) | ○ |
| C-02 | MandatoryServerConnectionToken.validateはトークン一致を検証 | E-01 (L38-40) | ○ |
| C-03 | parseServerConnectionTokenは矛盾オプションを検出 | E-01 (L56-59) | ○ |
| C-04 | parseServerConnectionTokenはトークン形式を検証 | E-01 (L75-77, L83-84) | ○ |
| C-05 | determineServerConnectionTokenはトークンを永続化 | E-01 (L93-121) | ○ |
| C-06 | requestHasValidConnectionTokenはクエリ/Cookieを検証 | E-01 (L123-132) | ○ |
| C-07 | ServerEnvironmentService.reconnectionGraceTimeは秒をmsに変換 | E-02 (L253-270) | ○ |
| C-08 | parseGraceTimeは無効値でフォールバック | E-02 (L259-262, L264-267) | ○ |
| C-09 | ExtensionHostStatusServiceはMapで終了情報を管理 | E-03 (L18-30) | ○ |
| C-10 | ManagementConnectionは再接続タイマーを管理 | E-04 (L35-124) | ○ |
| C-11 | ManagementConnection.acceptReconnectionはタイマーをキャンセル | E-04 (L116-123) | ○ |
| C-12 | ExtensionHostConnectionは子プロセスを起動 | E-05 (L240-328) | ○ |
| C-13 | buildUserEnvironmentはPATHにremote-cliを追加 | E-05 (L51-60) | ○ |
| C-14 | ConnectionData.toIExtHostSocketMessageはソケット種別で分岐 | E-05 (L83-107) | ○ |
| C-15 | serveErrorはtext/plainでエラーを返す | E-06 (L43-46) | ○ |
| C-16 | serveFileはETag検証で304を返す | E-06 (L58-65) | ○ |
| C-17 | WebClientServer.handleはパスに基づきルーティング | E-06 (L123-147) | ○ |
| C-18 | WebClientServer._handleStaticはパストラバーサルを防止 | E-06 (L158-161) | ○ |
| C-19 | WebClientServer._handleRootはクエリトークンをCookie化 | E-06 (L250-275) | ○ |
| C-20 | WebClientServer._getScriptCspHashesはSHA256を計算 | E-06 (L458-475) | ○ |
| C-21 | RemoteExtensionsScannerService.scanExtensionsは拡張機能をスキャン | E-07 (L110-132) | ○ |
| C-22 | RemoteExtensionsScannerService._massageWhenConditionsはresourceSchemeを変換 | E-07 (L214-325) | ○ |
| C-23 | RemoteExtensionsScannerChannel.callはURI変換を行う | E-07 (L336-358) | ○ |
| C-24 | ExtensionsScannerService.getTranslationsは翻訳ファイルを読み込む | E-08 (L39-48) | ○ |
| C-25 | RemoteAgentEnvironmentChannel.callは環境データを返す | E-09 (L39-91) | ○ |
| C-26 | RemoteAgentEnvironmentChannel._getEnvironmentDataはglibcを検出 | E-09 (L101-109) | ○ |
| C-27 | RemoteTerminalChannel.callはptyHostServiceに委譲 | E-10 (L113-169) | ○ |
| C-28 | RemoteTerminalChannel._createProcessはターミナルを作成 | E-10 (L192-276) | ○ |
| C-29 | CustomVariableResolverは変数を解決 | E-10 (L37-87) | ○ |
| C-30 | RemoteAgentFileSystemProviderChannel.transformIncomingはvscode-resourceを処理 | E-11 (L44-51) | ○ |
| C-31 | SessionFileWatcher.getRecursiveWatcherOptionsはポーリング設定を解析 | E-11 (L75-87) | ○ |
| C-32 | getNLSConfigurationはNLS設定をキャッシュ | E-12 (L17-39) | ○ |
| C-33 | SocketServer.acceptConnectionはイベントを発火 | E-13 (L283-296) | ○ |
| C-34 | ServerLoggerはログレベルに応じて出力 | E-13 (L298-360) | ○ |
| C-35 | cleanupOlderLogsは10個を超えるログを削除 | E-13 (L377-386) | △ |
| C-36 | RemoteExtensionHostAgentServer.handleRequestはGET以外を拒否 | E-14 (L110-112) | ○ |
| C-37 | RemoteExtensionHostAgentServer.handleRequestは認証を検証 | E-14 (L147-149) | ○ |
| C-38 | RemoteExtensionHostAgentServer._handleWebSocketConnectionは認証フロー | E-14 (L261-385) | ○ |
| C-39 | RemoteExtensionHostAgentServer._handleConnectionTypeは接続種別で分岐 | E-14 (L387-496) | ○ |
| C-40 | RemoteExtensionHostAgentServer._updateWithFreeDebugPortは空きポート検索 | E-14 (L539-551) | ○ |
| C-41 | RemoteExtensionHostAgentServer._waitThenShutdownは5分後にシャットダウン | E-14 (L568-582) | △ |
| C-42 | WebEndpointOriginCheckerはオリジンを正規表現で検証 | E-14 (L834-874) | ○ |
| C-43 | createServerはサーバーを初期化 | E-14 (L639-832) | ○ |
| C-44 | CliMain.runは拡張機能管理CLIを実行 | E-15 (L57-92) | ○ |
| C-45 | CliMain.doRunは各コマンドを処理 | E-15 (L148-175) | ○ |
| C-46 | run関数はhelp/versionオプションを処理 | E-15 (L186-208) | ○ |
| C-47 | main関数はパイプ/コマンド経由で処理 | E-16 (L92-373) | ○ |
| C-48 | main関数はlocate-shell-integration-pathを処理 | E-16 (L140-155) | ○ |

## 4) 不足情報（Unknown / Missing）
- **SHUTDOWN_TIMEOUT = 5 * 60 * 1000 (5分)**: このタイムアウト値の設計根拠がソースコード内のコメントにない。製品要件または運用経験に基づく値と思われるが、明確な根拠文書が不明
  - 候補：製品仕様書 / 運用要件定義 / パフォーマンステスト結果
- **cleanupOlderLogsの「10個」閾値**: 9個を超えるログを削除する理由がソースコード内に明記されていない
  - 候補：ディスク容量制限 / 運用ポリシー文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証トークン検証（UT-SVR-001〜016）: ソースコードと完全に対応
- 0: 低リスク - 環境変数構築（UT-SVR-041〜049）: 実装ロジックと一致
- 1: 中リスク - シャットダウンタイムアウト（UT-SVR-132〜134）: タイムアウト値の妥当性確認が必要
- 0: 低リスク - WebSocket認証フロー（UT-SVR-120〜129）: セキュリティクリティカルだが実装と整合
- 0: 低リスク - 拡張機能スキャン（UT-SVR-070〜080）: 実装ロジックと一致

## 6) レビュアーチェックリスト（最小）
- [ ] UT-SVR-001〜016: 認証トークン検証テストケースがセキュリティ要件を満たしているか
- [ ] UT-SVR-060: パストラバーサル防止テストケースが十分か（追加パターン検討）
- [ ] UT-SVR-118, UT-SVR-122: 認証失敗時のレスポンスがセキュリティベストプラクティスに従っているか
- [ ] UT-SVR-132〜134: シャットダウンタイムアウト値（5分）が運用要件と整合しているか
- [ ] UT-SVR-113〜114: ログ保持数（10個）が運用ポリシーと整合しているか
- [ ] 全テストケースのテストID採番（UT-SVR-xxx）が重複していないか
- [ ] 優先度「高」のテストケースが重要なビジネスロジック・セキュリティ機能をカバーしているか
