---
generated_at: 2026-01-27 13:45:00
metrics:
  claims_total: 115
  claims_with_evidence: 108
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート：vs-workbench 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実際のコード実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：108 / 115、根拠なし：7
- 優先レビュー（高）
  1. **UT-WKB-008, 009（toggleZenMode）**：Zenモード関連の詳細実装確認が必要
  2. **UT-WKB-083, 084（EditorInput.matches）**：matchesメソッドの実装詳細確認
  3. **UT-WKB-104-106（WorkbenchContributionsRegistry）**：動的登録の振る舞い確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/browser/layout.ts` - Layoutクラス、Part管理、コンテナ操作
- E-02: `src/vs/workbench/browser/workbench.ts` - Workbenchクラス、起動シーケンス、エラーハンドリング
- E-03: `src/vs/workbench/browser/part.ts` - Part、PartLayout、MultiWindowPartsクラス
- E-04: `src/vs/workbench/browser/composite.ts` - Composite、CompositeRegistry
- E-05: `src/vs/workbench/common/memento.ts` - Memento、ScopedMementoクラス
- E-06: `src/vs/workbench/common/notifications.ts` - NotificationsModel、NotificationViewItem、NotificationHandle
- E-07: `src/vs/workbench/common/editor.ts` - EditorInput関連インターフェース
- E-08: `src/vs/workbench/common/editor/editorInput.ts` - EditorInputクラス
- E-09: `src/vs/workbench/common/editor/editorGroupModel.ts` - EditorGroupModelクラス
- E-10: `src/vs/workbench/common/views.ts` - ViewContainersRegistry、ViewContainerLocation
- E-11: `src/vs/workbench/common/contributions.ts` - WorkbenchContributionsRegistry
- E-12: `src/vs/workbench/services/editor/common/editorService.ts` - IEditorService、PreferredGroup
- E-13: `src/vs/workbench/services/editor/common/editorGroupsService.ts` - IEditorGroupsService
- E-14: `src/vs/workbench/services/lifecycle/common/lifecycle.ts` - ILifecycleService、StartupKind

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Layout.getContainerFromDocumentの正常系テスト | E-01 (line 198-204) | ○ |
| C-02 | Layout.getContainerFromDocumentの補助ウィンドウテスト | E-01 (line 202-204) | ○ |
| C-03 | Layout.activeContainerのテスト | E-01 (line 188) | ○ |
| C-04 | Layout.mainContainerDimensionのテスト | E-01 (line 212-213) | ○ |
| C-05 | Layout.computeContainerOffsetのテスト | E-01 (line 235-258) | ○ |
| C-06 | Layout.computeContainerOffsetの境界値テスト | E-01 (line 239-248) | ○ |
| C-07 | Layout.isVisibleのテスト | E-01 | ○ |
| C-08 | Layout.toggleZenModeのテスト | E-01 | △ |
| C-09 | Layout.toggleZenModeの復帰テスト | E-01 | △ |
| C-10 | Layout.onFullscreenChangedのテスト | E-01 (line 482-499) | ○ |
| C-11 | Layout.onFullscreenChangedのフィルタテスト | E-01 (line 483-485) | ○ |
| C-12 | Workbench.startupのテスト | E-02 (line 126-185) | ○ |
| C-13 | Workbench.handleUnexpectedErrorのテスト | E-02 (line 108-124) | ○ |
| C-14 | Workbench.handleUnexpectedErrorの重複抑制テスト | E-02 (line 114-117) | ○ |
| C-15 | Workbench.handleUnexpectedErrorの空メッセージテスト | E-02 (line 110-112) | ○ |
| C-16 | Part.createのテスト | E-03 (line 77-85) | ○ |
| C-17 | Part.getContainerのテスト | E-03 (line 90-92) | ○ |
| C-18 | Part.setHeaderAreaのテスト | E-03 (line 108-124) | ○ |
| C-19 | Part.setHeaderAreaの重複エラーテスト | E-03 (line 109-111) | ○ |
| C-20 | Part.setFooterAreaのテスト | E-03 (line 126-142) | ○ |
| C-21 | Part.setFooterAreaの重複エラーテスト | E-03 (line 127-129) | ○ |
| C-22 | Part.removeHeaderAreaのテスト | E-03 (line 144-151) | ○ |
| C-23 | Part.removeFooterAreaのテスト | E-03 (line 153-160) | ○ |
| C-24 | Part.layoutのテスト | E-03 (line 188-191) | ○ |
| C-25 | Part.setVisibleのテスト | E-03 (line 193-195) | ○ |
| C-26 | PartLayout.layoutのテスト | E-03 (line 213-252) | ○ |
| C-27 | PartLayout.layoutのタイトルなしテスト | E-03 (line 217-221) | ○ |
| C-28 | PartLayout.layoutのヘッダー・フッター複合テスト | E-03 (line 223-237, 245) | ○ |
| C-29 | MultiWindowParts.registerPartのテスト | E-03 (line 275-278) | ○ |
| C-30 | MultiWindowParts.registerPartのDisposableテスト | E-03 (line 278) | ○ |
| C-31 | MultiWindowParts.getPartのテスト | E-03 (line 285-287) | ○ |
| C-32 | MultiWindowParts.activePartのテスト | E-03 (line 301-303) | ○ |
| C-33 | Composite.hasFocusのテスト | E-04 (line 57-59) | ○ |
| C-34 | Composite.setVisibleのテスト | E-04 (line 132-136) | ○ |
| C-35 | Composite.setVisibleの冪等性テスト | E-04 (line 133) | ○ |
| C-36 | Composite.getActionRunnerのテスト | E-04 (line 207-213) | ○ |
| C-37 | Composite.getActionRunnerのキャッシュテスト | E-04 (line 208-209) | ○ |
| C-38 | CompositeRegistry.registerCompositeのテスト | E-04 (line 269-276) | ○ |
| C-39 | CompositeRegistry.registerCompositeの重複テスト | E-04 (line 270-272) | ○ |
| C-40 | CompositeRegistry.deregisterCompositeのテスト | E-04 (line 278-286) | ○ |
| C-41 | CompositeRegistry.getCompositeのテスト | E-04 (line 288-290) | ○ |
| C-42 | CompositeRegistry.getCompositeの異常系テスト | E-04 (line 296-298) | ○ |
| C-43 | Memento.getMementoのワークスペーステスト | E-05 (line 26-36) | ○ |
| C-44 | Memento.getMementoのプロファイルテスト | E-05 (line 38-46) | ○ |
| C-45 | Memento.getMementoのアプリケーションテスト | E-05 (line 48-56) | ○ |
| C-46 | Memento.saveMementoのテスト | E-05 (line 64-68) | ○ |
| C-47 | Memento.reloadMementoのテスト | E-05 (line 70-85) | ○ |
| C-48 | Memento.clearのテスト | E-05 (line 87-99) | ○ |
| C-49 | ScopedMemento.doLoadのテスト | E-05 (line 110-122) | ○ |
| C-50 | ScopedMemento.doLoadのエラー処理テスト | E-05 (line 113-121) | ○ |
| C-51 | ScopedMemento.saveのテスト | E-05 (line 139-145) | ○ |
| C-52 | ScopedMemento.saveの空オブジェクトテスト | E-05 (line 140-144) | ○ |
| C-53 | NotificationsModel.addNotificationのテスト | E-06 (line 214-232) | ○ |
| C-54 | NotificationsModel.addNotificationの重複テスト | E-06 (line 220-222) | ○ |
| C-55 | NotificationsModel.addNotificationのメッセージなしテスト | E-06 (line 215-217) | ○ |
| C-56 | NotificationsModel.setFilterのグローバルテスト | E-06 (line 193-212) | ○ |
| C-57 | NotificationsModel.setFilterのソーステスト | E-06 (line 201-204) | ○ |
| C-58 | NotificationsModel.setFilterの変更なしテスト | E-06 (line 206-211) | ○ |
| C-59 | NotificationsModel.showStatusMessageのテスト | E-06 (line 278-295) | ○ |
| C-60 | NotificationsModel.showStatusMessageのcloseテスト | E-06 (line 288-294) | ○ |
| C-61 | NotificationHandle.updateSeverityのテスト | E-06 (line 145-147) | ○ |
| C-62 | NotificationHandle.updateMessageのテスト | E-06 (line 149-151) | ○ |
| C-63 | NotificationHandle.updateActionsのテスト | E-06 (line 153-155) | ○ |
| C-64 | NotificationHandle.closeのテスト | E-06 (line 157-161) | ○ |
| C-65 | NotificationViewItem.createのテスト | E-06 (line 469-499) | ○ |
| C-66 | NotificationViewItem.createのメッセージなしテスト | E-06 (line 470-471) | ○ |
| C-67 | NotificationViewItem.createのキャンセルエラーテスト | E-06 (line 470) | ○ |
| C-68 | NotificationViewItem.expandのテスト | E-06 (line 319) | ○ |
| C-69 | NotificationViewItem.collapseのテスト | E-06 (line 320) | ○ |
| C-70 | NotificationViewItem.toggleのテスト | E-06 (line 321) | ○ |
| C-71 | NotificationViewItemProgress.infiniteのテスト | E-06 (line 378-390) | ○ |
| C-72 | NotificationViewItemProgress.infiniteの冪等性テスト | E-06 (line 379-381) | ○ |
| C-73 | NotificationViewItemProgress.doneのテスト | E-06 (line 392-404) | ○ |
| C-74 | NotificationViewItemProgress.totalのテスト | E-06 (line 406-417) | ○ |
| C-75 | NotificationViewItemProgress.workedのテスト | E-06 (line 419-430) | ○ |
| C-76 | NotificationViewItemProgress.workedの累積テスト | E-06 (line 420-424) | ○ |
| C-77 | EditorInput.hasCapabilityの正常系テスト | E-08 (line 135-141) | ○ |
| C-78 | EditorInput.hasCapabilityの異常系テスト | E-08 (line 135-141) | ○ |
| C-79 | EditorInput.hasCapabilityのNoneテスト | E-08 (line 136-138) | ○ |
| C-80 | EditorInput.isReadonlyのテスト | E-08 (line 143-145) | ○ |
| C-81 | EditorInput.getNameのテスト | E-08 (line 150-152) | ○ |
| C-82 | EditorInput.getTitleのテスト | E-08 (line 164-166) | ○ |
| C-83 | EditorInput.matchesの同一入力テスト | E-08 | △ |
| C-84 | EditorInput.matchesの異なる入力テスト | E-08 | △ |
| C-85 | EditorGroupModel.openEditorのテスト | E-09 (line 178) | ○ |
| C-86 | EditorGroupModel.openEditorの新規テスト | E-09 (line 33-36) | ○ |
| C-87 | EditorGroupModel.openEditorの既存テスト | E-09 (line 33-36) | ○ |
| C-88 | EditorGroupModel.closeEditorのテスト | E-09 (line 179) | ○ |
| C-89 | EditorGroupModel.closeEditorの異常系テスト | E-09 | ○ |
| C-90 | EditorGroupModel.moveEditorのテスト | E-09 (line 180) | ○ |
| C-91 | EditorGroupModel.setActiveのテスト | E-09 (line 181) | ○ |
| C-92 | EditorGroupModel.getEditorsのテスト | E-09 (line 163) | ○ |
| C-93 | EditorGroupModel.indexOfのテスト | E-09 (line 165) | ○ |
| C-94 | EditorGroupModel.indexOfの異常系テスト | E-09 | ○ |
| C-95 | EditorGroupModel.isPinnedのテスト | E-09 (line 167) | ○ |
| C-96 | EditorGroupModel.isStickyのテスト | E-09 (line 168) | ○ |
| C-97 | ViewContainersRegistryImpl.registerViewContainerのテスト | E-10 (line 152) | ○ |
| C-98 | ViewContainersRegistryImpl.registerViewContainerの重複テスト | E-10 | ○ |
| C-99 | ViewContainersRegistryImpl.deregisterViewContainerのテスト | E-10 (line 158) | ○ |
| C-100 | ViewContainersRegistryImpl.getViewContainersのテスト | E-10 (line 170) | ○ |
| C-101 | ViewContainerLocationToStringのSidebarテスト | E-10 (line 47-53) | ○ |
| C-102 | ViewContainerLocationToStringのPanelテスト | E-10 (line 47-53) | ○ |
| C-103 | ViewContainerLocationToStringのAuxiliaryBarテスト | E-10 (line 47-53) | ○ |
| C-104 | WorkbenchContributionsRegistry.registerWorkbenchContribution2のテスト | E-11 (line 167-200) | ○ |
| C-105 | WorkbenchContributionsRegistry.registerWorkbenchContribution2の重複テスト | E-11 (line 197-199) | △ |
| C-106 | WorkbenchContributionsRegistry.startのテスト | E-11 (line 121) | △ |
| C-107 | toWorkbenchPhaseのRestoredテスト | E-11 (line 87-94) | ○ |
| C-108 | toWorkbenchPhaseのEventuallyテスト | E-11 (line 87-94) | ○ |
| C-109 | toLifecyclePhaseのBlockStartupテスト | E-11 (line 96-107) | ○ |
| C-110 | isPreferredGroupの数値テスト | E-12 (line 39-43) | ○ |
| C-111 | isPreferredGroupのIEditorGroupテスト | E-12 (line 39-43) | ○ |
| C-112 | isEditorReplacementのテスト | E-13 (line 141-145) | ○ |
| C-113 | StartupKindToStringのNewWindowテスト | E-14 (line 180-186) | ○ |
| C-114 | StartupKindToStringのReloadedWindowテスト | E-14 (line 180-186) | ○ |
| C-115 | StartupKindToStringのReopenedWindowテスト | E-14 (line 180-186) | ○ |

## 4) 不足情報（Unknown / Missing）
- **toggleZenMode（UT-WKB-008, 009）**：Zenモードの詳細実装がlayout.tsの後半部分にあり、完全な動作確認には追加調査が必要
  - 候補：layout.ts全体の精査 / 既存テストファイルの確認
- **EditorInput.matches（UT-WKB-083, 084）**：matchesメソッドの詳細実装はAbstractEditorInputクラスにある可能性
  - 候補：AbstractEditorInputの確認 / エディタ関連テストの参照
- **WorkbenchContributionsRegistry動的登録（UT-WKB-105, 106）**：実行時の振る舞いは静的解析だけでは確認困難
  - 候補：contributions.test.tsの確認 / 実行時テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：ユーティリティ関数（toWorkbenchPhase, toLifecyclePhase, StartupKindToString等）
- **1（中リスク）**：UIコンポーネント（Part, Composite, Notification）のテストケース
- **2（高リスク）**：
  - エディタ管理（EditorGroupModel.openEditor, closeEditor）：データ整合性に直結
  - レイアウト管理（Layout.computeContainerOffset）：UI表示に影響
  - 状態永続化（Memento系）：データ損失の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-WKB-001〜015、UT-WKB-085〜096）の期待結果が実装と一致しているか
- [ ] EditorInput.matchesの実装詳細を確認し、テストケースの妥当性を検証
- [ ] toggleZenModeの完全な動作フローを確認
- [ ] 境界値テストケースのカバレッジが十分か（特に空配列、null、undefined）
- [ ] 既存のテストファイル（src/vs/workbench/test/）との整合性確認
