---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 46
  claims_with_evidence: 46
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：46 / 46、根拠なし：0
- 優先レビュー（高）
  1. **UAT-003、UAT-007**: スキップ中のテストケースのため、実際の動作確認が必要
  2. **UAT-031〜033**: ノートブック機能テスト（スキップ中）
  3. **UAT-043〜046**: アクセシビリティテスト（スキップ中）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/smoke/src/areas/preferences/preferences.test.ts`
- E-02: `test/smoke/src/areas/search/search.test.ts`
- E-03: `test/smoke/src/areas/workbench/data-loss.test.ts`
- E-04: `test/smoke/src/areas/languages/languages.test.ts`
- E-05: `test/smoke/src/areas/statusbar/statusbar.test.ts`
- E-06: `test/smoke/src/areas/terminal/terminal-tabs.test.ts`
- E-07: `test/smoke/src/areas/terminal/terminal-input.test.ts`
- E-08: `test/smoke/src/areas/terminal/terminal-persistence.test.ts`
- E-09: `test/smoke/src/areas/extensions/extensions.test.ts`
- E-10: `test/smoke/src/areas/notebook/notebook.test.ts`
- E-11: `test/smoke/src/areas/task/task-quick-pick.test.ts`
- E-12: `test/smoke/src/areas/multiroot/multiroot.test.ts`
- E-13: `test/smoke/src/areas/workbench/localization.test.ts`
- E-14: `test/smoke/src/areas/workbench/launch.test.ts`
- E-15: `test/smoke/src/areas/chat/chat.test.ts`
- E-16: `test/smoke/src/areas/accessibility/accessibility.test.ts`
- E-17: `package.json`（プロジェクト構成情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: エディタ行番号設定の変更とリアルタイム反映確認 | E-01 | ○ |
| C-02 | UAT-002: 設定変更時の変更インジケーター表示確認 | E-01 | ○ |
| C-03 | UAT-003: カスタムキーバインドの設定と動作確認 | E-01 | ○ |
| C-04 | UAT-004: ワークスペース内テキスト検索と結果件数確認 | E-02 | ○ |
| C-05 | UAT-005: ファイルタイプフィルター検索 | E-02 | ○ |
| C-06 | UAT-006: 検索結果の個別削除 | E-02 | ○ |
| C-07 | UAT-007: テキスト置換機能の動作確認 | E-02 | ○ |
| C-08 | UAT-008: ファイルクイックオープンの検索精度確認 | E-02 | ○ |
| C-09 | UAT-009: ファジーマッチング検索の動作確認 | E-02 | ○ |
| C-10 | UAT-010: 再起動後のエディタタブ復元確認 | E-03 | ○ |
| C-11 | UAT-011: ファイル編集と保存後の内容確認 | E-03 | ○ |
| C-12 | UAT-012: 未保存ファイルのホットエグジット動作確認 | E-03 | ○ |
| C-13 | UAT-013: シャットダウン時の自動保存動作確認 | E-03 | ○ |
| C-14 | UAT-014: JavaScriptファイルのクイックアウトライン表示 | E-04 | ○ |
| C-15 | UAT-015: CSSファイルのクイックアウトライン表示 | E-04 | ○ |
| C-16 | UAT-016: CSSリント警告の検出と表示 | E-04 | ○ |
| C-17 | UAT-017: CSSリント設定変更によるエラー検出 | E-04 | ○ |
| C-18 | UAT-018: デフォルトステータスバー要素の表示確認 | E-05 | ○ |
| C-19 | UAT-019: ステータスバー要素クリックによるクイック入力表示 | E-05 | ○ |
| C-20 | UAT-020: 問題ステータスクリックによる問題ビュー表示 | E-05 | ○ |
| C-21 | UAT-021: 改行コード変更のステータスバー反映確認 | E-05 | ○ |
| C-22 | UAT-022: 新規ターミナル作成とタブ表示 | E-06 | ○ |
| C-23 | UAT-023: ターミナルタブの名前変更 | E-06 | ○ |
| C-24 | UAT-024: ターミナル分割機能の動作確認 | E-06 | ○ |
| C-25 | UAT-025: ターミナル結合機能の動作確認 | E-06 | ○ |
| C-26 | UAT-026: ターミナル分離機能の動作確認 | E-06 | ○ |
| C-27 | UAT-027: ターミナルのエディタエリア移動 | E-06 | ○ |
| C-28 | UAT-028: ターミナル自動返信機能の動作確認 | E-07 | ○ |
| C-29 | UAT-029: ターミナルデタッチ・アタッチ機能 | E-08 | ○ |
| C-30 | UAT-030: 拡張機能のインストールと有効化確認 | E-09 | ○ |
| C-31 | UAT-031: コードセルの挿入と編集 | E-10 | ○ |
| C-32 | UAT-032: マークダウンセルの挿入と編集 | E-10 | ○ |
| C-33 | UAT-033: セル削除時のフォーカス移動 | E-10 | ○ |
| C-34 | UAT-034: タスクの表示/非表示設定確認 | E-11 | ○ |
| C-35 | UAT-035: 通常タスクの表示確認 | E-11 | ○ |
| C-36 | UAT-036: マルチルートワークスペースでの全フォルダ検索 | E-12 | ○ |
| C-37 | UAT-037: ワークスペース名のタイトル表示確認 | E-12 | ○ |
| C-38 | UAT-038: ドイツ語ロケールでのUI表示確認 | E-13 | ○ |
| C-39 | UAT-039: 非ASCII文字を含むパスからの起動確認 | E-14 | ○ |
| C-40 | UAT-040: Stable版からInsiders版へのエディタ復元 | E-03 | ○ |
| C-41 | UAT-041: Stable版からInsiders版へのホットエグジット復元 | E-03 | ○ |
| C-42 | UAT-042: AI機能無効化の確認 | E-15 | ○ |
| C-43 | UAT-043: アクティビティバーのアクセシビリティ検証 | E-16 | ○ |
| C-44 | UAT-044: サイドバーのアクセシビリティ検証 | E-16 | ○ |
| C-45 | UAT-045: ステータスバーのアクセシビリティ検証 | E-16 | ○ |
| C-46 | UAT-046: チャットパネルのアクセシビリティ検証 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースがスモークテストコードに基づいて抽出されています
  - 候補：実際のユーザーストーリードキュメント / 製品要件定義書 / ユーザビリティテスト計画書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコード内のスモークテストに対応
- **注意点**:
  - スキップ中のテスト（it.skip）が多数存在（UAT-003, UAT-007, UAT-031〜033, UAT-043〜046）
  - プラットフォーム依存のスキップ（Linux/Windows）が一部のターミナルテストに存在
  - ノートブックテストはカーネル不在のためスキップ状態

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテスト手順が実際のスモークテストコードと整合しているか確認
- [ ] スキップ中のテストケースの取り扱い方針を決定（除外 or 将来対応として残す）
- [ ] ユーザーロール「一般ユーザー」以外のロール（管理者、ゲストなど）の追加検討
- [ ] 優先度の妥当性確認（高/中/低の基準が適切か）
- [ ] プラットフォーム固有のテストケース追加検討（macOS/Windows/Linux）
- [ ] セキュリティ観点のテストケース追加検討
- [ ] パフォーマンス観点のテストケース追加検討
