---
generated_at: 2026-01-27 11:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` - Issue Reporterのモデルクラス
- E-02: `src/vs/workbench/contrib/issue/common/issue.ts` - Issue関連の型定義・インターフェース
- E-03: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - パフォーマンスビューエディタ
- E-04: `src/vs/workbench/contrib/chat/browser/actions/chatImportExport.ts` - チャットエクスポート/インポート機能
- E-05: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - テスト結果ストレージ
- E-06: `src/vs/workbench/contrib/testing/common/testResult.ts` - テスト結果モデル
- E-07: `src/vs/workbench/services/userDataProfile/browser/userDataProfileImportExportService.ts` - プロファイルエクスポート/インポート
- E-08: `src/vs/workbench/contrib/output/browser/outputServices.ts` - 出力サービス
- E-09: `src/vs/workbench/contrib/logs/electron-browser/logsActions.ts` - ログアクション
- E-10: `src/main.ts` - メインエントリポイント（configureCrashReporter関数）
- E-11: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - ノートブックセル出力アクション
- E-12: `src/vs/workbench/services/extensionManagement/browser/extensionBisect.ts` - 拡張機能Bisectサービス
- E-13: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - Markdownレンダラー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Issue Reporterはバグ報告、パフォーマンス問題、機能リクエストをGitHubに送信するレポートを生成する | E-01, E-02 | ○ |
| C-02 | Startup Performance ReportはVS Codeの起動パフォーマンスをMarkdown形式で表示する | E-03 | ○ |
| C-03 | Chat Session ExportはAIチャットセッションをJSON形式でエクスポート/インポートする | E-04 | ○ |
| C-04 | Test Results Storageはテスト実行結果をJSON形式で保存・読み込みする | E-05, E-06 | ○ |
| C-05 | User Data Profile Export/Importはユーザープロファイルをエクスポート/インポートする | E-07 | ○ |
| C-06 | Log Outputはアプリケーションログを出力しログレベルでフィルタリング可能 | E-08, E-09 | ○ |
| C-07 | Crash Reporterはクラッシュダンプを指定ディレクトリに保存する | E-10 | ○ |
| C-08 | Notebook Cell Output Copyはノートブックセルの実行結果をクリップボードにコピーする | E-11 | ○ |
| C-09 | Extension Bisect Reportは拡張機能の問題を二分探索法で特定する | E-12 | ○ |
| C-10 | Markdown Document RendererはMarkdownをHTMLにレンダリングする | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本レポートに根拠なしの項目はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠があり、信頼度は高い
- 注意点: VS Codeは大規模なコードベースであり、帳票機能として分類されるものの範囲は解釈による部分がある。PDF出力やExcel出力などの伝統的な帳票機能は存在しないが、レポート生成・データエクスポート機能を帳票として分類している。

## 6) レビュアーチェックリスト（最小）
- [ ] Issue Reporterの出力形式（Markdown）が正確に記載されているか確認
- [ ] Startup Performance Reportのセクション一覧が網羅的か確認
- [ ] Chat Session Exportのフォーマット（JSON）が実際のコードと一致するか確認
- [ ] Test Results Storageの保存先（ワークスペースストレージ）が正確か確認
- [ ] User Data Profile Export/Importの対象リソースが網羅的か確認
- [ ] Log Outputのログレベル一覧が正確か確認
- [ ] Crash Reporterの設定方法（crash-reporter-directory）が正確か確認
- [ ] Notebook Cell Output Copyの対応MIMEタイプが網羅的か確認
- [ ] Extension Bisect Reportの診断プロセスが正確に説明されているか確認
- [ ] Markdown Document Rendererのサポート機能が網羅的か確認
