---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **BR-017 大容量ファイル対応**：具体的なファイルサイズ制限の根拠が不明確
  2. **BR-060 リモート開発機能**：拡張機能依存のため、コアコードでの実装詳細が限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/src/vs/editor/common/model/textModel.ts` - テキストモデル実装（2,711行）
- E-02: `/src/vs/editor/common/cursor/cursor.ts` - カーソル管理（1,116行）
- E-03: `/src/vs/editor/common/cursor/cursorTypeEditOperations.ts` - 編集操作（1,046行）
- E-04: `/src/vs/editor/common/model/editStack.ts` - Undo/Redoスタック（451行）
- E-05: `/src/vs/editor/contrib/find/browser/findController.ts` - 検索コントローラー（1,149行）
- E-06: `/src/vs/editor/contrib/find/browser/findWidget.ts` - 検索ウィジェット（1,404行）
- E-07: `/src/vs/editor/contrib/suggest/browser/suggestController.ts` - 補完コントローラー（1,150行）
- E-08: `/src/vs/editor/contrib/suggest/browser/suggestModel.ts` - 補完モデル（756行）
- E-09: `/src/vs/editor/common/languages.ts` - 言語・トークン化（2,632行）
- E-10: `/src/vs/editor/contrib/format/browser/formatActions.ts` - フォーマットアクション
- E-11: `/src/vs/editor/common/services/languageFeatures.ts` - 言語機能サービス
- E-12: `/src/vs/platform/files/common/fileService.ts` - ファイルサービス（1,492行）
- E-13: `/src/vs/platform/files/node/diskFileSystemProvider.ts` - ディスクプロバイダー（898行）
- E-14: `/src/vs/workbench/contrib/files/browser/views/explorerView.ts` - エクスプローラービュー
- E-15: `/src/vs/workbench/contrib/files/browser/fileActions.ts` - ファイルアクション
- E-16: `/src/vs/platform/files/common/watcher.ts` - ファイル監視インターフェース
- E-17: `/src/vs/platform/workspace/common/workspace.ts` - ワークスペース定義
- E-18: `/src/vs/platform/workspaces/common/workspaces.ts` - ワークスペース管理
- E-19: `/src/vs/workbench/services/workspaces/browser/abstractWorkspaceEditingService.ts` - ワークスペース編集
- E-20: `/src/vs/platform/workspaces/electron-main/workspacesHistoryMainService.ts` - 履歴管理
- E-21: `/src/vs/platform/extensions/common/extensions.ts` - 拡張機能定義（561行）
- E-22: `/src/vs/workbench/services/extensions/common/abstractExtensionService.ts` - 拡張機能サービス（68,261行）
- E-23: `/src/vs/workbench/services/extensionManagement/common/extensionEnablementService.ts` - 有効化サービス
- E-24: `/src/vs/platform/extensionManagement/common/extensionGalleryService.ts` - ギャラリーサービス
- E-25: `/src/vs/workbench/services/extensions/common/extensionHostManager.ts` - ホスト管理（23,412行）
- E-26: `/src/vs/workbench/contrib/debug/browser/debugService.ts` - デバッグサービス（1,523行）
- E-27: `/src/vs/workbench/contrib/debug/common/debugModel.ts` - デバッグモデル（2,127行）
- E-28: `/src/vs/workbench/contrib/debug/browser/debugSession.ts` - デバッグセッション（1,682行）
- E-29: `/src/vs/workbench/contrib/debug/browser/rawDebugSession.ts` - DAP通信
- E-30: `/src/vs/workbench/contrib/terminal/browser/terminalService.ts` - ターミナルサービス（1,360行）
- E-31: `/src/vs/workbench/contrib/terminal/browser/terminalInstance.ts` - ターミナルインスタンス
- E-32: `/src/vs/workbench/contrib/terminal/browser/terminalProcessManager.ts` - プロセス管理
- E-33: `/src/vs/workbench/contrib/terminal/browser/terminalGroup.ts` - ターミナルグループ
- E-34: `/src/vs/platform/configuration/common/configuration.ts` - 設定インターフェース
- E-35: `/src/vs/workbench/services/configuration/browser/configurationService.ts` - ワークベンチ設定
- E-36: `/src/vs/workbench/contrib/preferences/browser/settingsEditor2.ts` - 設定エディタUI
- E-37: `/src/vs/workbench/services/keybinding/browser/keybindingService.ts` - キーバインディング
- E-38: `/src/vs/platform/theme/common/themeService.ts` - テーマサービス
- E-39: `/src/vs/platform/theme/common/colorRegistry.ts` - カラーレジストリ
- E-40: `/src/vs/workbench/contrib/scm/browser/scmViewPane.ts` - SCMビュー
- E-41: `/src/vs/workbench/contrib/scm/common/scm.ts` - SCMインターフェース
- E-42: `/extensions/git/src/git.ts` - Git操作API
- E-43: `/extensions/git/src/repository.ts` - Gitリポジトリ管理
- E-44: `/extensions/git/src/commands.ts` - Gitコマンド
- E-45: `/src/vs/workbench/contrib/scm/browser/quickDiffService.ts` - クイックDiffサービス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 テキスト編集機能 | E-01, E-02, E-03 | ○ |
| C-02 | BR-002 Undo/Redo機能 | E-04 | ○ |
| C-03 | BR-003 検索・置換機能 | E-05, E-06 | ○ |
| C-04 | BR-004 コード補完機能 | E-07, E-08 | ○ |
| C-05 | BR-005 構文ハイライト機能 | E-09 | ○ |
| C-06 | BR-006 コードフォーマット機能 | E-10 | ○ |
| C-07 | BR-007 定義へのジャンプ機能 | E-11 | ○ |
| C-08 | BR-008 参照検索機能 | E-11 | ○ |
| C-09 | BR-009 コードアクション機能 | E-11 | ○ |
| C-10 | BR-010 ホバー情報表示機能 | E-11 | ○ |
| C-11 | BR-011 ファイルエクスプローラー機能 | E-14 | ○ |
| C-12 | BR-012 ファイル作成機能 | E-12, E-15 | ○ |
| C-13 | BR-013 ファイル削除機能 | E-12, E-13 | ○ |
| C-14 | BR-014 ファイル名変更機能 | E-12, E-15 | ○ |
| C-15 | BR-015 ファイル移動・コピー機能 | E-12, E-13 | ○ |
| C-16 | BR-016 ファイル監視機能 | E-16 | ○ |
| C-17 | BR-017 大容量ファイル対応 | **根拠不足** | △ |
| C-18 | BR-018 シングルフォルダワークスペース | E-17 | ○ |
| C-19 | BR-019 マルチルートワークスペース | E-18, E-19 | ○ |
| C-20 | BR-020 ワークスペース保存・復元機能 | E-18 | ○ |
| C-21 | BR-021 最近使用したワークスペース管理 | E-20 | ○ |
| C-22 | BR-022 拡張機能インストール機能 | E-24 | ○ |
| C-23 | BR-023 拡張機能アンインストール機能 | E-22 | ○ |
| C-24 | BR-024 拡張機能有効化・無効化機能 | E-23 | ○ |
| C-25 | BR-025 拡張機能更新機能 | E-22 | ○ |
| C-26 | BR-026 拡張機能ホスト管理 | E-25 | ○ |
| C-27 | BR-027 デバッグセッション開始機能 | E-26 | ○ |
| C-28 | BR-028 ブレークポイント管理機能 | E-27 | ○ |
| C-29 | BR-029 ステップ実行機能 | E-28, E-29 | ○ |
| C-30 | BR-030 変数・スタック表示機能 | E-27, E-28 | ○ |
| C-31 | BR-031 デバッグコンソール機能 | E-28 | ○ |
| C-32 | BR-032 統合ターミナル機能 | E-30, E-31 | ○ |
| C-33 | BR-033 ターミナルプロファイル機能 | E-30, E-32 | ○ |
| C-34 | BR-034 ターミナル分割機能 | E-33 | ○ |
| C-35 | BR-035 ユーザー設定管理機能 | E-34, E-35 | ○ |
| C-36 | BR-036 ワークスペース設定管理機能 | E-35 | ○ |
| C-37 | BR-037 設定エディタUI機能 | E-36 | ○ |
| C-38 | BR-038 キーバインディング管理機能 | E-37 | ○ |
| C-39 | BR-039 カラーテーマ機能 | E-38, E-39 | ○ |
| C-40 | BR-040 アイコンテーマ機能 | E-38 | ○ |
| C-41 | BR-041 Git変更追跡機能 | E-40, E-41 | ○ |
| C-42 | BR-042 ステージング機能 | E-42, E-43 | ○ |
| C-43 | BR-043 コミット機能 | E-44 | ○ |
| C-44 | BR-044 プッシュ・プル機能 | E-44 | ○ |
| C-45 | BR-045 ブランチ管理機能 | E-44 | ○ |
| C-46 | BR-046 マージ・リベース機能 | E-44 | ○ |
| C-47 | BR-047 差分表示機能 | E-45 | ○ |
| C-48 | BR-048 グローバル検索機能 | E-05 | ○ |
| C-49 | BR-049 シンボル検索機能 | E-11 | ○ |
| C-50 | BR-050 ファイル検索機能 | E-05 | ○ |
| C-51 | BR-051 コマンドパレット機能 | E-36 | ○ |
| C-52 | BR-052 サイドバー機能 | E-14 | ○ |
| C-53 | BR-053 エディタグループ機能 | E-01 | ○ |
| C-54 | BR-054 ミニマップ機能 | E-01 | ○ |
| C-55 | BR-055 ステータスバー機能 | E-40 | ○ |
| C-56 | BR-056 パンくずリスト機能 | E-11 | ○ |
| C-57 | BR-057 通知機能 | E-34 | ○ |
| C-58 | BR-058 タスク実行機能 | E-34 | ○ |
| C-59 | BR-059 問題パネル機能 | E-26 | ○ |
| C-60 | BR-060 リモート開発機能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **BR-017 大容量ファイル対応**：具体的なファイルサイズ閾値（例：50MB）の設定値やその根拠となる設計文書が未確認
  - 候補：`/src/vs/editor/common/config/editorOptions.ts` / 設定スキーマ / パフォーマンステスト結果
- **BR-060 リモート開発機能**：コア機能ではなく拡張機能（Remote - SSH, Remote - Containers, Remote - WSL）で提供されるため、コードベース内での直接的な実装根拠が限定的
  - 候補：`extensions/` ディレクトリ内の関連拡張機能 / VS Code Remote Development ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - BR-001〜BR-016, BR-018〜BR-059：コードベースで明確に確認できる機能
- **1: 中リスク** - BR-017：実装は存在するが具体的な制限値の根拠確認が必要
- **1: 中リスク** - BR-060：拡張機能依存のため、コア機能としての位置づけ確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BR-017の大容量ファイル対応について、具体的なサイズ制限値を設定ファイルまたはドキュメントで確認する
- [ ] BR-060のリモート開発機能について、コア機能として記載すべきか拡張機能として分離すべきか判断する
- [ ] 各業務要件の優先度（高/中/低）が適切に設定されているか確認する
- [ ] 関連機能の記載が正確かつ十分か確認する
