---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **No.61 MCP（Model Context Protocol）対応**：新機能のため詳細確認推奨
  2. **No.100 2026テーマ**：新規追加テーマのため確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/` ディレクトリ構造
- E-02: `src/vs/editor/contrib/` ディレクトリ内の各機能モジュール
- E-03: `src/vs/workbench/contrib/` ディレクトリ内の各機能モジュール
- E-04: `src/vs/platform/` ディレクトリ内のプラットフォーム機能
- E-05: `extensions/` ディレクトリ内の各拡張機能
- E-06: `package.json` プロジェクト設定ファイル
- E-07: `README.md` プロジェクト説明ドキュメント
- E-08: `product.json` 製品設定ファイル
- E-09: `extensions/git/package.json` Git拡張機能設定
- E-10: `extensions/typescript-language-features/package.json` TypeScript拡張機能設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コード編集機能 | E-01 | ○ |
| C-02 | シンタックスハイライト | E-06（vscode-textmate依存） | ○ |
| C-03 | コード補完（IntelliSense） | E-02 | ○ |
| C-04 | 括弧マッチング | E-02 | ○ |
| C-05 | コードフォールディング | E-02 | ○ |
| C-06 | 検索・置換 | E-02 | ○ |
| C-07 | マルチカーソル | E-02 | ○ |
| C-08 | コードスニペット | E-02 | ○ |
| C-09 | コードアクション | E-02 | ○ |
| C-10 | ホバー情報 | E-02 | ○ |
| C-11 | 定義へ移動 | E-02 | ○ |
| C-12 | 参照検索 | E-05 | ○ |
| C-13 | リネーム | E-02 | ○ |
| C-14 | コードレンズ | E-02 | ○ |
| C-15 | インレイヒント | E-02 | ○ |
| C-16 | カラーピッカー | E-02 | ○ |
| C-17 | インデントガイド | E-01 | ○ |
| C-18 | 行番号表示 | E-01 | ○ |
| C-19 | ミニマップ | E-01 | ○ |
| C-20 | スティッキースクロール | E-02 | ○ |
| C-21 | エクスプローラー | E-03 | ○ |
| C-22 | 検索 | E-03 | ○ |
| C-23 | ソース管理 | E-03 | ○ |
| C-24 | デバッグ | E-03 | ○ |
| C-25 | 拡張機能 | E-03 | ○ |
| C-26 | ターミナル | E-03 | ○ |
| C-27 | アウトライン | E-03 | ○ |
| C-28 | 問題パネル | E-03 | ○ |
| C-29 | 出力パネル | E-03 | ○ |
| C-30 | タイムライン | E-03 | ○ |
| C-31 | コマンドパレット | E-03 | ○ |
| C-32 | 設定エディタ | E-03 | ○ |
| C-33 | キーバインディング | E-03 | ○ |
| C-34 | テーマ | E-03 | ○ |
| C-35 | ノートブック | E-03 | ○ |
| C-36 | チャット | E-03 | ○ |
| C-37 | インラインチャット | E-03 | ○ |
| C-38 | マージエディタ | E-03 | ○ |
| C-39 | 差分エディタ | E-03 | ○ |
| C-40 | タスク | E-03 | ○ |
| C-41 | テスト | E-03 | ○ |
| C-42 | Webビュー | E-03 | ○ |
| C-43 | コメント | E-03 | ○ |
| C-44 | ローカル履歴 | E-03 | ○ |
| C-45 | リモート接続 | E-03 | ○ |
| C-46 | ファイルシステム | E-04 | ○ |
| C-47 | 設定管理 | E-04 | ○ |
| C-48 | コンテキストキー | E-04 | ○ |
| C-49 | キーボードレイアウト | E-04 | ○ |
| C-50 | ストレージ | E-04 | ○ |
| C-51 | ログ | E-04 | ○ |
| C-52 | テレメトリ | E-04 | ○ |
| C-53 | 通知 | E-04 | ○ |
| C-54 | ダイアログ | E-04 | ○ |
| C-55 | クイック入力 | E-04 | ○ |
| C-56 | ウィンドウ管理 | E-04 | ○ |
| C-57 | メニュー | E-04 | ○ |
| C-58 | プロセス | E-04 | ○ |
| C-59 | シークレット | E-04 | ○ |
| C-60 | 更新管理 | E-04 | ○ |
| C-61 | MCP対応 | E-04（ディレクトリ存在確認） | △ |
| C-62 | 拡張機能ホスト | E-03 | ○ |
| C-63 | 拡張機能管理 | E-04 | ○ |
| C-64 | 言語機能API | E-03 | ○ |
| C-65 | デバッグAPI | E-03 | ○ |
| C-66 | WebviewAPI | E-03 | ○ |
| C-67 | JavaScript/TypeScript言語機能 | E-10 | ○ |
| C-68 | JSON言語機能 | E-05 | ○ |
| C-69 | HTML言語機能 | E-05 | ○ |
| C-70 | CSS言語機能 | E-05 | ○ |
| C-71 | Markdown言語機能 | E-05 | ○ |
| C-72 | PHP言語機能 | E-05 | ○ |
| C-73 | Emmet機能 | E-05 | ○ |
| C-74 | Git統合 | E-09 | ○ |
| C-75 | GitHub統合 | E-05 | ○ |
| C-76 | GitHub認証 | E-05 | ○ |
| C-77 | Microsoft認証 | E-05 | ○ |
| C-78 | タスク自動検出（npm） | E-05 | ○ |
| C-79 | タスク自動検出（Gulp） | E-05 | ○ |
| C-80 | タスク自動検出（Grunt） | E-05 | ○ |
| C-81 | タスク自動検出（Jake） | E-05 | ○ |
| C-82 | デバッグ自動起動 | E-05 | ○ |
| C-83 | デバッグ自動アタッチ | E-05 | ○ |
| C-84 | 設定編集補完 | E-05 | ○ |
| C-85 | 拡張機能開発支援 | E-05 | ○ |
| C-86 | ノートブックレンダラー | E-05 | ○ |
| C-87 | メディアプレビュー | E-05 | ○ |
| C-88 | シンプルブラウザ | E-05 | ○ |
| C-89 | マージコンフリクト | E-05 | ○ |
| C-90 | 参照ビュー | E-05 | ○ |
| C-91 | IPYNBサポート | E-05 | ○ |
| C-92 | ターミナル補完 | E-05 | ○ |
| C-93 | Markdown数式 | E-05 | ○ |
| C-94 | トンネル転送 | E-05 | ○ |
| C-95 | Dark+テーマ | E-05 | ○ |
| C-96 | Monokaiテーマ | E-05 | ○ |
| C-97 | Solarizedテーマ | E-05 | ○ |
| C-98 | Abyssテーマ | E-05 | ○ |
| C-99 | Setiアイコンテーマ | E-05 | ○ |
| C-100 | 2026テーマ | E-05（ディレクトリ存在確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **MCP（Model Context Protocol）対応**：新しい機能であり、詳細なドキュメントが不足。ディレクトリ `src/vs/platform/mcp` の存在は確認したが、具体的な実装内容の詳細確認が推奨される。
  - 候補：公式ドキュメント / リリースノート / ソースコードコメント
- **2026テーマ**：theme-2026ディレクトリの存在は確認したが、新規追加テーマのため詳細な機能説明が必要。
  - 候補：テーマ設定ファイル / パッケージ説明

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：エディタ機能（No.1-20）、ワークベンチ機能（No.21-45）、プラットフォーム機能（No.46-60）、言語サポート（No.67-73）、テーマ（No.95-99）
  - 理由：対応するソースコードディレクトリ・ファイルが明確に存在し、VS Codeの既知の機能である
- **1（中リスク）**：拡張機能API（No.62-66）、バージョン管理（No.74-77）、開発支援（No.78-85）、UI機能（No.86-94）
  - 理由：拡張機能ベースの機能であり、バージョンによって仕様が変更される可能性がある
- **2（高リスク）**：MCP対応（No.61）、2026テーマ（No.100）
  - 理由：新機能または新規追加項目であり、詳細な根拠資料が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] エディタ機能（No.1-20）が `src/vs/editor/contrib/` 配下のディレクトリと対応しているか確認
- [ ] ワークベンチ機能（No.21-45）が `src/vs/workbench/contrib/` 配下のディレクトリと対応しているか確認
- [ ] プラットフォーム機能（No.46-61）が `src/vs/platform/` 配下のディレクトリと対応しているか確認
- [ ] 言語サポート・拡張機能（No.67-100）が `extensions/` 配下のディレクトリと対応しているか確認
- [ ] MCP対応（No.61）の実装状況と機能詳細を確認
- [ ] 2026テーマ（No.100）の実装内容を確認
- [ ] 機能名と説明が実際の実装内容と一致しているか確認
- [ ] 漏れている主要機能がないか確認
