# 機能設計書 1-コード編集

## 概要

本ドキュメントは、VS Codeエディタにおけるコード編集機能（カット、コピー、ペースト、Undo/Redo）の設計仕様を記載する。

### 本機能の処理概要

コード編集機能は、VS Codeエディタの最も基本的かつ中心的な機能であり、テキストファイルの編集操作全般を担う。

**業務上の目的・背景**：ソフトウェア開発において、ソースコードの編集は最も頻繁に行われる作業である。効率的で正確なテキスト編集機能を提供することで、開発者の生産性を最大化し、コーディングミスを最小化することが本機能の目的である。また、Undo/Redo機能により、誤った編集を即座に取り消すことができ、安全な開発環境を実現する。

**機能の利用シーン**：日常的なコーディング作業において、ソースコードの作成・修正・削除を行う際に使用される。具体的には、新規コードの入力、既存コードのコピー＆ペーストによる再利用、不要なコードの削除、誤操作時のUndo/Redo操作などが含まれる。

**主要な処理内容**：
1. テキスト入力処理 - キーボードからの文字入力を受け付け、カーソル位置にテキストを挿入する
2. 選択範囲の管理 - マウスまたはキーボードによるテキスト選択状態の管理
3. カット操作 - 選択範囲のテキストを削除し、クリップボードにコピーする
4. コピー操作 - 選択範囲のテキストをクリップボードにコピーする
5. ペースト操作 - クリップボードの内容をカーソル位置に挿入する
6. Undo操作 - 直前の編集操作を取り消す
7. Redo操作 - Undoで取り消した操作を再実行する

**関連システム・外部連携**：OSのクリップボードシステムと連携し、他のアプリケーションとのテキストの受け渡しを可能にする。

**権限による制御**：読み取り専用モードでは編集操作が無効化される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | エディタグループ | 主画面 | タブでの複数ファイル管理、分割編集機能 |
| 10 | エディタペイン | 主画面 | 個々のエディタコンテンツ表示の抽象基底 |
| 11 | テキストエディタ | 主画面 | テキストファイルの編集（カット、コピー、ペースト、Undo/Redo） |
| 12 | 差分エディタ | 補助画面 | 差分ファイルの編集機能 |

## 機能種別

CRUD操作 / テキスト編集処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| text | string | Yes | 入力/ペーストするテキスト | 単一行・複数行対応 |
| range | IRange | No | 編集対象の範囲 | 有効な行番号・列番号 |
| position | IPosition | No | カーソル位置 | 有効な行番号・列番号 |
| forceMoveMarkers | boolean | No | マーカーを強制移動するか | true/false |

### 入力データソース

- キーボード入力
- クリップボード（ペースト操作時）
- ドラッグ＆ドロップ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| editedText | string | 編集後のテキスト内容 |
| cursorPosition | IPosition | 編集後のカーソル位置 |
| selection | ISelection | 編集後の選択範囲 |

### 出力先

- エディタ画面（TextModel）
- クリップボード（カット・コピー操作時）

## 処理フロー

### 処理シーケンス

```
1. 編集操作の受付
   └─ キーボードイベント、コマンド、APIからの編集要求を受け付ける
2. 編集操作の検証
   └─ 読み取り専用チェック、範囲の妥当性検証
3. カーソル状態の保存
   └─ Undo用にカーソル状態をスタックに保存
4. 編集操作の実行
   └─ TextModelに対して編集操作を適用
5. カーソル状態の更新
   └─ 編集結果に基づきカーソル位置を更新
6. ビューの更新通知
   └─ ViewModelにイベントを発行し画面を再描画
```

### フローチャート

```mermaid
flowchart TD
    A[編集操作の受付] --> B{読み取り専用?}
    B -->|Yes| C[操作を拒否]
    B -->|No| D[Undoスタックに状態保存]
    D --> E[EditOperationの作成]
    E --> F[TextModelに適用]
    F --> G[カーソル位置の更新]
    G --> H[ビューイベント発行]
    H --> I[画面再描画]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 読み取り専用チェック | 読み取り専用モードでは編集操作を無効化 | 全ての編集操作 |
| BR-002 | 自動括弧閉じ | 開き括弧入力時に自動で閉じ括弧を挿入 | 括弧文字入力時 |
| BR-003 | オートインデント | 改行時に前行のインデントを自動継続 | Enter押下時 |
| BR-004 | マルチカーソル制限 | 同時編集可能なカーソル数に上限を設定 | マルチカーソル操作時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。テキストデータはメモリ上のTextModelで管理される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| READONLY | 警告 | 読み取り専用ファイルへの編集試行 | 操作を無視し、通知を表示 |
| INVALID_RANGE | エラー | 無効な範囲指定 | 操作をスキップ |
| MEMORY_LIMIT | エラー | 大規模ファイルでのメモリ不足 | 仮想化スクロールで対応 |

### リトライ仕様

特になし

## トランザクション仕様

編集操作はアトミックに実行される。複数の編集を一つのUndoグループとしてまとめることが可能（pushStackElement）。

## パフォーマンス要件

- 単一文字入力: 16ms以内（60FPS維持）
- ペースト操作（10,000行）: 1秒以内
- Undo/Redo: 100ms以内

## セキュリティ考慮事項

- クリップボード操作は適切なユーザー権限の下で実行
- ペースト内容のサニタイズ（悪意のある制御文字の除去）

## 備考

VS Codeのコード編集機能はMonaco Editorをベースとしており、ブラウザ版でも同等の機能を提供する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、編集操作の基本となるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | position.ts | `src/vs/editor/common/core/position.ts` | カーソル位置を表すPositionクラス |
| 1-2 | range.ts | `src/vs/editor/common/core/range.ts` | テキスト範囲を表すRangeクラス |
| 1-3 | selection.ts | `src/vs/editor/common/core/selection.ts` | 選択範囲を表すSelectionクラス |
| 1-4 | editOperation.ts | `src/vs/editor/common/core/editOperation.ts` | 編集操作を表すEditOperationクラス |

**読解のコツ**: Position、Range、SelectionはVS Codeエディタ全体で使用される基本型である。Position(lineNumber, column)の形式で行と列を1始まりで表現する。

#### Step 2: エントリーポイントを理解する

編集操作の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editorCommon.ts | `src/vs/editor/common/editorCommon.ts` | IEditorインターフェース、Handler列挙型の定義 |
| 2-2 | cursor.ts | `src/vs/editor/common/cursor/cursor.ts` | CursorsControllerクラス - 編集操作の中心 |

**主要処理フロー**:
1. **556-579行目**: `type()`メソッド - テキスト入力処理のエントリーポイント
2. **601-607行目**: `paste()`メソッド - ペースト操作のエントリーポイント
3. **609-614行目**: `cut()`メソッド - カット操作のエントリーポイント

#### Step 3: モデル層を理解する

テキストデータを保持するTextModelの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | model.ts | `src/vs/editor/common/model.ts` | ITextModelインターフェース定義 |
| 3-2 | textModelEvents.ts | `src/vs/editor/common/textModelEvents.ts` | モデル変更イベントの定義 |

**主要処理フロー**:
- **492-500行目（model.ts）**: ISingleEditOperationIdentifier - 編集操作の識別子

#### Step 4: コマンド実行層を理解する

編集コマンドの実行メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cursorTypeOperations.ts | `src/vs/editor/common/cursor/cursorTypeOperations.ts` | 文字入力の詳細ロジック |
| 4-2 | cursorDeleteOperations.ts | `src/vs/editor/common/cursor/cursorDeleteOperations.ts` | 削除操作の詳細ロジック |

### プログラム呼び出し階層図

```
IEditor.trigger()
    │
    ├─ CursorsController.type()
    │      ├─ TypeOperations.typeWithInterceptors()
    │      └─ CommandExecutor.executeCommands()
    │             └─ ITextModel.pushEditOperations()
    │
    ├─ CursorsController.paste()
    │      └─ TypeOperations.paste()
    │             └─ ITextModel.pushEditOperations()
    │
    ├─ CursorsController.cut()
    │      └─ DeleteOperations.cut()
    │             └─ ITextModel.pushEditOperations()
    │
    └─ ITextModel.undo() / ITextModel.redo()
           └─ UndoRedoService
```

### データフロー図

```
[入力]               [処理]                    [出力]

キーボード入力 ──▶ CursorsController.type() ──▶ TextModel更新
                        │
クリップボード ──▶ CursorsController.paste() ──▶ カーソル位置更新
                        │
メニュー/ショートカット ──▶ CursorsController.cut() ──▶ ViewModelイベント発行
                        │                           │
                        └─────── CommandExecutor ────┘
                                     │
                                     ▼
                               ビュー再描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editorCommon.ts | `src/vs/editor/common/editorCommon.ts` | ソース | エディタ共通インターフェース定義 |
| cursor.ts | `src/vs/editor/common/cursor/cursor.ts` | ソース | カーソル操作コントローラ |
| cursorTypeOperations.ts | `src/vs/editor/common/cursor/cursorTypeOperations.ts` | ソース | 文字入力操作ロジック |
| cursorDeleteOperations.ts | `src/vs/editor/common/cursor/cursorDeleteOperations.ts` | ソース | 削除操作ロジック |
| cursorMoveOperations.ts | `src/vs/editor/common/cursor/cursorMoveOperations.ts` | ソース | カーソル移動ロジック |
| model.ts | `src/vs/editor/common/model.ts` | ソース | テキストモデルインターフェース |
| editOperation.ts | `src/vs/editor/common/core/editOperation.ts` | ソース | 編集操作ヘルパー |
| position.ts | `src/vs/editor/common/core/position.ts` | ソース | 位置データ構造 |
| range.ts | `src/vs/editor/common/core/range.ts` | ソース | 範囲データ構造 |
| selection.ts | `src/vs/editor/common/core/selection.ts` | ソース | 選択範囲データ構造 |
