# 機能設計書 10-ホバー情報

## 概要

本ドキュメントは、VS Codeエディタにおけるホバー情報機能の設計仕様を記載する。マウスオーバー時のドキュメント、型情報の表示を実現する。

### 本機能の処理概要

ホバー情報機能は、エディタ上のシンボル（変数、関数、クラス等）にマウスカーソルを置いた際に、そのシンボルに関する情報（型、ドキュメント、定義など）をツールチップとして表示する機能である。

**業務上の目的・背景**：ソフトウェア開発において、コードを読む際にシンボルの型情報やドキュメントを確認することは頻繁に発生する。ホバー情報機能により、コードから目を離すことなく必要な情報を即座に確認でき、開発効率と理解度を向上させる。

**機能の利用シーン**：
- 変数の型を確認する
- 関数のシグネチャとドキュメントを確認する
- クラスやインターフェースの定義を確認する
- エラーや警告の詳細情報を確認する

**主要な処理内容**：
1. マウス位置監視 - マウス移動イベントを監視
2. ホバー判定 - ホバー対象位置かどうかを判定
3. プロバイダ問い合わせ - HoverProviderにホバー情報を要求
4. コンテンツ構築 - 複数プロバイダからの情報をマージ
5. ホバーウィジェット表示 - 情報をツールチップとして表示

**関連システム・外部連携**：Language Server Protocol経由で言語サーバーからホバー情報を取得。診断情報と連携してエラー詳細を表示。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | テキストエディタ | 主画面 | マウスオーバー時のドキュメント、型情報の表示 |

## 機能種別

情報表示 / ツールチップ / ウィジェット

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| enabled | 'on' / 'off' / 'onKeyboardModifier' | No | ホバー有効設定 | 設定値 |
| sticky | boolean | No | スティッキーモード | true/false |
| hidingDelay | number | No | 非表示までの遅延（ms） | 0以上 |

### 入力データソース

- マウス移動イベント
- キーボードイベント（修飾キー）
- HoverProvider（言語サーバー）
- 診断情報（マーカー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| contents | MarkdownString[] | ホバーコンテンツ |
| range | Range | ホバー対象範囲 |

### 出力先

- ContentHoverWidget（ホバーツールチップ）

## 処理フロー

### 処理シーケンス

```
1. マウス移動検知
   └─ onMouseMoveイベントをリッスン
2. ホバー設定確認
   └─ enabledがonまたはonKeyboardModifier確認
3. スケジューラ実行
   └─ RunOnceSchedulerで遅延実行
4. ホバーターゲット判定
   └─ マウス位置からシンボルを特定
5. プロバイダ問い合わせ
   └─ HoverProviderにホバー情報を要求
6. コンテンツ構築
   └─ MarkdownString形式でコンテンツを構築
7. ホバーウィジェット表示
   └─ ContentHoverWidgetWrapperでツールチップ表示
```

### フローチャート

```mermaid
flowchart TD
    A[マウス移動] --> B{enabled設定}
    B -->|off| C[処理スキップ]
    B -->|onKeyboardModifier| D{修飾キー押下?}
    B -->|on| E[スケジューラ開始]
    D -->|No| C
    D -->|Yes| E
    E --> F[reactToEditorMouseMove]
    F --> G{ホバーターゲット?}
    G -->|Yes| H[HoverProvider問い合わせ]
    G -->|No| I[ホバー非表示]
    H --> J[コンテンツ構築]
    J --> K[ContentHoverWidget表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | キーボード修飾子モード | onKeyboardModifierで修飾キー押下時のみホバー表示 | 設定有効時 |
| BR-002 | スティッキーモード | stickyでマウスがホバーから離れても表示継続 | オプション有効時 |
| BR-003 | 非表示遅延 | hidingDelayで非表示までの遅延時間を設定 | スティッキー時 |
| BR-004 | コンテキストメニュー中断 | コンテキストメニュー表示中はホバー無効 | メニュー表示中 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NO_HOVER | 情報 | ホバー情報がない | ツールチップ非表示 |
| PROVIDER_ERROR | 警告 | プロバイダエラー | 該当プロバイダをスキップ |

### リトライ仕様

特になし

## トランザクション仕様

特になし（読み取り専用処理）

## パフォーマンス要件

- ホバー表示: 300ms以内
- コンテンツ取得: 非同期実行

## セキュリティ考慮事項

- MarkdownコンテンツのXSSサニタイズ

## 備考

ホバー情報はLSP標準機能であり、多くの言語サーバーがサポート。Markdownによるリッチなフォーマットをサポート。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ホバーの設定とタイプを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hoverTypes.ts | `src/vs/editor/contrib/hover/browser/hoverTypes.ts` | ホバータイプ定義 |
| 1-2 | contentHoverTypes.ts | `src/vs/editor/contrib/hover/browser/contentHoverTypes.ts` | コンテンツホバータイプ |

#### Step 2: エントリーポイントを理解する

コントローラの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | contentHoverController.ts | `src/vs/editor/contrib/hover/browser/contentHoverController.ts` | ContentHoverController |

**主要処理フロー**:
1. **39-44行目**: ContentHoverController定義、ID登録
2. **33-37行目**: IHoverSettings型定義
3. **94-112行目**: _hookListeners() - イベントリスナー登録
4. **67-73行目**: スケジューラ初期化

#### Step 3: ウィジェット層を理解する

ホバーウィジェットの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contentHoverWidgetWrapper.ts | `src/vs/editor/contrib/hover/browser/contentHoverWidgetWrapper.ts` | ContentHoverWidgetWrapper |
| 3-2 | contentHoverWidget.ts | `src/vs/editor/contrib/hover/browser/contentHoverWidget.ts` | ContentHoverWidget |

#### Step 4: コンテンツ生成を理解する

ホバーコンテンツの生成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | markdownHoverParticipant.ts | `src/vs/editor/contrib/hover/browser/markdownHoverParticipant.ts` | Markdownホバー |
| 4-2 | markerHoverParticipant.ts | `src/vs/editor/contrib/hover/browser/markerHoverParticipant.ts` | 診断ホバー |

### プログラム呼び出し階層図

```
ContentHoverController
    │
    ├─ onMouseMove
    │      └─ _reactToEditorMouseMoveRunner.schedule()
    │
    ├─ _reactToEditorMouseMove()
    │      ├─ shouldShowHover() - ホバー表示判定
    │      └─ startShowingOrUpdateHover()
    │
    ├─ ContentHoverWidgetWrapper
    │      ├─ startShowingAtRange() - ホバー表示開始
    │      └─ ContentHoverComputer.computeAsync() - コンテンツ計算
    │
    └─ HoverParticipant[]
           ├─ MarkdownHoverParticipant
           └─ MarkerHoverParticipant
```

### データフロー図

```
[入力]               [処理]                    [出力]

マウス位置 ──▶ ContentHoverController ──▶ ホバー表示判定
                        │
                        ▼
HoverProvider ──▶ ContentHoverComputer ──▶ ホバーコンテンツ
                        │
                        ▼
ホバーコンテンツ ──▶ ContentHoverWidgetWrapper ──▶ ツールチップ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| contentHoverController.ts | `src/vs/editor/contrib/hover/browser/contentHoverController.ts` | ソース | ホバーコントローラ |
| contentHoverWidgetWrapper.ts | `src/vs/editor/contrib/hover/browser/contentHoverWidgetWrapper.ts` | ソース | ウィジェットラッパー |
| contentHoverWidget.ts | `src/vs/editor/contrib/hover/browser/contentHoverWidget.ts` | ソース | ホバーウィジェット |
| contentHoverComputer.ts | `src/vs/editor/contrib/hover/browser/contentHoverComputer.ts` | ソース | コンテンツ計算 |
| markdownHoverParticipant.ts | `src/vs/editor/contrib/hover/browser/markdownHoverParticipant.ts` | ソース | Markdownホバー参加者 |
| markerHoverParticipant.ts | `src/vs/editor/contrib/hover/browser/markerHoverParticipant.ts` | ソース | 診断ホバー参加者 |
| hoverOperation.ts | `src/vs/editor/contrib/hover/browser/hoverOperation.ts` | ソース | ホバー操作 |
| hoverUtils.ts | `src/vs/editor/contrib/hover/browser/hoverUtils.ts` | ソース | ユーティリティ関数 |
