# 機能設計書 100-2026テーマ

## 概要

本ドキュメントは、VS Code拡張機能「theme-2026」の2026 Themesカラーテーマに関する設計仕様を記載する。

### 本機能の処理概要

2026年に向けたモダンでミニマルなデザインのライト/ダークテーマを提供する機能。一貫したニュートラルパレットとアクセシブルな色コントラストを特徴とし、現代的なUIデザインのトレンドを反映した新世代のテーマ。

**業務上の目的・背景**：VS Codeのデフォルトテーマをモダナイズし、2026年以降の標準テーマとなることを目指して開発された実験的なテーマ。フラットデザインの原則に基づき、視覚的なノイズを最小限に抑えながら、アクセシビリティ基準（WCAG）を満たすコントラスト比を確保している。

**機能の利用シーン**：
- モダンで洗練されたUIを好むユーザー
- アクセシビリティを重視する開発環境
- ミニマルなデザインを求める場合
- 新しいVS Codeの外観を試したいユーザー

**主要な処理内容**：
1. モダンなニュートラルカラーパレットの適用
2. ライト/ダーク両バリアントの提供
3. アクセシブルな色コントラストの確保
4. 実験的なCSS APIの活用
5. セマンティックハイライトのサポート

**関連システム・外部連携**：VS Codeテーマエンジン、CSS API（実験的）。

**権限による制御**：特別な権限制御はなし。enabledApiProposals: ["css"]を使用。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | シンタックスハイライト適用 |
| - | ワークベンチ全体 | 主画面 | UIカラー適用 |
| - | 設定 > テーマ | 参照画面 | テーマ選択 |

## 機能種別

UI/UXデザイン / 視覚的カスタマイズ / 実験的機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | テーマ選択のみで入力パラメータなし | - |

### 入力データソース

VS Code設定 workbench.colorTheme

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| colors | object | ワークベンチUIカラー定義 |
| tokenColors | array | TextMateスコープカラー定義 |
| semanticTokenColors | object | セマンティックトークンカラー定義 |

### 出力先

VS Codeレンダリングエンジン

## 処理フロー

### 処理シーケンス

```
1. テーマ選択
   └─ ユーザーが2026 Light/Darkを選択
2. テーマファイル読み込み
   └─ 2026-light.json または 2026-dark.jsonの読み込み
3. ベーステーマ適用
   └─ vs（ライト）またはvs-dark（ダーク）UIテーマの適用
4. カラー定義適用
   └─ colors, tokenColors, semanticTokenColorsの適用
5. CSS適用（実験的）
   └─ styles.cssの適用
6. レンダリング
   └─ エディタ・UI全体の再描画
```

### フローチャート

```mermaid
flowchart TD
    A[テーマ選択: 2026] --> B{Light/Dark?}
    B -->|Light| C[2026-light.json読み込み]
    B -->|Dark| D[2026-dark.json読み込み]
    C --> E[vs UIテーマ適用]
    D --> F[vs-dark UIテーマ適用]
    E --> G[2026配色適用]
    F --> G
    G --> H[CSS適用]
    H --> I[UI再描画]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-1 | 実験的テーマ | experimentalラベル付き | 常時 |
| BR-100-2 | CSS API使用 | enabledApiProposals: ["css"] | 常時 |
| BR-100-3 | セマンティックハイライト有効 | semanticHighlighting: true | 常時 |
| BR-100-4 | ニュートラルパレット | 一貫したグレースケールベース | 常時 |

### 計算ロジック

該当なし（静的定義）

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | テーマファイル破損 | JSONパースエラー | フォールバックテーマ適用 |
| - | CSS API未対応 | 古いVS Codeバージョン | CSSなしで動作 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

テーマ適用は即座（100ms以内）に完了すること。

## セキュリティ考慮事項

テーマファイルはJSONのみで実行コードを含まないため、セキュリティリスクは低い。

## 備考

2026テーマは実験的なテーマであり、将来のVS Codeのデフォルトテーマとなる可能性がある。CSS APIは提案段階のAPI。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テーマ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.json | `extensions/theme-2026/package.json` | テーマ登録、CSS API有効化 |
| 1-2 | 2026-dark.json | `extensions/theme-2026/themes/2026-dark.json` | ダークテーマ本体 |
| 1-3 | 2026-light.json | `extensions/theme-2026/themes/2026-light.json` | ライトテーマ本体 |

**読解のコツ**: `enabledApiProposals: ["css"]`で実験的CSS APIを使用。

#### Step 2: 2026配色を理解する

**2026 Dark配色の特徴**:
- 背景: #121416（非常に暗いグレー）
- 前景: #BBBEBF（明るいグレー）
- アクセント: #498FAE（ティールブルー）
- コメント: #6A9955（グリーン）
- キーワード: #569cd6（ブルー）
- 文字列: #ce9178（オレンジ）
- 関数: #DCDCAA（イエロー）
- 型: #4EC9B0（シアン）

**2026カラーパレットの特徴**:
- 一貫したニュートラルグレー
- アクセントカラーにティールブルー
- アクセシブルなコントラスト比

#### Step 3: CSS拡張を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | styles.css | `extensions/theme-2026/themes/styles.css` | 追加CSS定義 |

### プログラム呼び出し階層図

```
package.json (テーマ登録)
    │
    ├─ themes/2026-dark.json
    │      │
    │      ├─ name: "2026 Dark"
    │      ├─ type: "dark"
    │      │
    │      ├─ colors (233項目)
    │      │      ├─ editor.background: #121416
    │      │      ├─ editor.foreground: #BBBEBF
    │      │      ├─ button.background: #498FAE
    │      │      └─ ...
    │      │
    │      ├─ tokenColors
    │      │      ├─ comment: #6A9955
    │      │      ├─ keyword: #569cd6
    │      │      ├─ string: #ce9178
    │      │      └─ ...
    │      │
    │      └─ semanticTokenColors
    │             ├─ newOperator: #C586C0
    │             ├─ stringLiteral: #ce9178
    │             └─ ...
    │
    ├─ themes/2026-light.json
    │      └─ (同様の構造、ライト配色)
    │
    └─ themes/styles.css
           └─ 追加CSS定義
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テーマ選択 ───▶ テーマエンジン ───▶ UI描画
(2026 Dark/Light)    │
                     ├─ JSONパース
                     ├─ カラー値解決
                     ├─ CSS適用（実験的）
                     └─ CSS変数生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| package.json | `extensions/theme-2026/package.json` | 設定 | テーマ登録 |
| 2026-dark.json | `extensions/theme-2026/themes/2026-dark.json` | テーマ定義 | 2026 Darkテーマ |
| 2026-light.json | `extensions/theme-2026/themes/2026-light.json` | テーマ定義 | 2026 Lightテーマ |
| styles.css | `extensions/theme-2026/themes/styles.css` | スタイル | 追加CSS |
