# 機能設計書：定義へ移動（Go to Definition）

## 1. 機能概要

### 1.1 機能の目的
定義へ移動機能は、エディタ上でシンボル（変数、関数、クラス等）にカーソルを置いた状態で、そのシンボルが定義されている場所に素早くジャンプするための機能である。開発者がコードベースを効率的にナビゲーションし、シンボルの定義元を迅速に確認できるようにすることを目的とする。

### 1.2 機能の範囲
- シンボルの定義位置への移動
- 複数の定義候補がある場合のピーク表示
- Ctrl+クリックによるリンクスタイルのナビゲーション
- コマンドパレット経由での実行サポート

### 1.3 関連画面
- エディタメインビュー
- ピークビュー（PeekView）ウィジェット

## 2. 機能要件

### 2.1 ユーザーストーリー
- 開発者として、シンボル上でF12キーを押すことで、そのシンボルの定義元にジャンプしたい
- 開発者として、Ctrl+クリックでシンボルの定義元にジャンプしたい
- 開発者として、定義が複数ある場合はリストから選択したい

### 2.2 入力仕様
| 項目 | 説明 |
|------|------|
| カーソル位置 | エディタ内のPosition（行番号、列番号） |
| モデル | 現在開いているテキストモデル（ITextModel） |
| トリガー種別 | キーボード（F12）またはマウス（Ctrl+クリック） |

### 2.3 出力仕様
| 項目 | 説明 |
|------|------|
| 定義位置 | Location（URI、Range） |
| 複数定義 | LocationLink[]（複数定義がある場合） |
| エディタ状態 | 定義位置へのスクロール、カーソル移動 |

### 2.4 処理フロー

```mermaid
sequenceDiagram
    participant User
    participant Editor
    participant GoToCommand
    participant DefinitionProvider
    participant LanguageService

    User->>Editor: F12キー押下 / Ctrl+クリック
    Editor->>GoToCommand: goToDefinition実行
    GoToCommand->>DefinitionProvider: getDefinitionsAtPosition()
    DefinitionProvider->>LanguageService: provideDefinition()
    LanguageService-->>DefinitionProvider: Location[]
    DefinitionProvider-->>GoToCommand: ReferencesModel
    alt 単一定義
        GoToCommand->>Editor: 定義位置へジャンプ
    else 複数定義
        GoToCommand->>Editor: ピークビュー表示
    end
```

### 2.5 ビジネスルール
1. 定義が1つの場合は直接ジャンプする
2. 定義が複数ある場合はピークビューで候補を表示する
3. 定義が見つからない場合は何もしない（エラーメッセージ不要）
4. 言語拡張機能がDefinitionProviderを提供していない場合は機能が無効

## 3. 画面設計

### 3.1 画面レイアウト
定義へ移動機能自体は専用の画面を持たないが、複数定義がある場合にピークビューウィジェットを表示する。

### 3.2 画面要素
| 要素 | 説明 | 操作 |
|------|------|------|
| シンボルリンク | Ctrl+ホバー時にアンダーライン表示 | クリックで定義へ移動 |
| ピークビュー | 複数定義時の候補リスト | 選択で定義へ移動 |

## 4. データ設計

### 4.1 入力データ構造
```typescript
interface IPosition {
    lineNumber: number;  // 1-based
    column: number;      // 1-based
}

interface DefinitionRequest {
    model: ITextModel;
    position: IPosition;
    token: CancellationToken;
}
```

### 4.2 出力データ構造
```typescript
interface Location {
    uri: URI;
    range: IRange;
}

interface LocationLink {
    originSelectionRange?: IRange;
    targetUri: URI;
    targetRange: IRange;
    targetSelectionRange?: IRange;
}
```

## 5. コードリーディングガイド

### 5.1 推奨読解順序

1. **データ構造の理解**
   - `src/vs/editor/common/languages.ts` - Location、LocationLink等の型定義
   - `src/vs/editor/contrib/gotoSymbol/browser/referencesModel.ts` - ReferencesModelの実装

2. **エントリーポイント**
   - `src/vs/editor/contrib/gotoSymbol/browser/goToCommands.ts` - コマンド定義（**37-75行目**）
     - `DefinitionAction`クラスがF12キーの処理を担当

3. **プロバイダ層**
   - `src/vs/editor/contrib/gotoSymbol/browser/goToSymbol.ts` - 定義取得ロジック（**38-101行目**）
     - `getDefinitionsAtPosition()`関数が複数のDefinitionProviderを呼び出し

4. **リンクジェスチャ**
   - `src/vs/editor/contrib/gotoSymbol/browser/link/goToDefinitionAtPosition.ts` - Ctrl+クリック処理（**44-305行目**）
     - `GotoDefinitionAtPositionEditorContribution`クラスがマウスイベントを処理

### 5.2 プログラム呼び出し階層図

```
goToCommands.ts
  └── DefinitionAction.run()
        ├── goToSymbol.ts::getDefinitionsAtPosition()
        │     └── DefinitionProvider.provideDefinition()
        └── _openReference()
              ├── 単一定義 → エディタ.openCodeEditor()
              └── 複数定義 → referencesController.toggleWidget()
```

### 5.3 データフロー図

```
[User Input] → [GoToCommand] → [DefinitionProvider] → [Language Extension]
                    ↓
              [ReferencesModel]
                    ↓
            [Editor Navigation / PeekView]
```

### 5.4 読解のコツ
- `SymbolNavigationAction`が基底クラスで、定義・実装・型定義等の共通処理を提供
- `_getNoResultFoundMessage()`で定義が見つからない場合のメッセージを確認可能
- `openReferenceToSide`オプションで横に開くか同じエディタで開くかを制御

### 5.5 関連ファイル一覧

| パス | 種別 | 役割 |
|------|------|------|
| `src/vs/editor/contrib/gotoSymbol/browser/goToCommands.ts` | コマンド | Go to Definitionコマンド実装 |
| `src/vs/editor/contrib/gotoSymbol/browser/goToSymbol.ts` | サービス | 定義取得ロジック |
| `src/vs/editor/contrib/gotoSymbol/browser/referencesModel.ts` | モデル | 参照/定義データモデル |
| `src/vs/editor/contrib/gotoSymbol/browser/link/goToDefinitionAtPosition.ts` | コントリビューション | Ctrl+クリック処理 |
| `src/vs/editor/contrib/gotoSymbol/browser/link/clickLinkGesture.ts` | ユーティリティ | クリックジェスチャ検出 |
| `src/vs/editor/contrib/gotoSymbol/browser/peek/referencesController.ts` | コントローラ | ピークビュー制御 |
| `src/vs/editor/contrib/gotoSymbol/browser/peek/referencesWidget.ts` | ウィジェット | ピークビューUI |

## 6. 非機能要件

### 6.1 パフォーマンス
- 定義検索は非同期で実行し、UIをブロックしない
- CancellationTokenによるキャンセル対応

### 6.2 エラーハンドリング
- プロバイダがエラーを返した場合は無視して続行
- 全てのプロバイダが失敗した場合は何もしない

## 7. 設計上の考慮事項

### 7.1 拡張性
- Language Server Protocol (LSP)との互換性を考慮した設計
- 複数のDefinitionProviderを並列実行し、結果をマージ

### 7.2 依存関係
- `ILanguageFeaturesService`を通じてDefinitionProviderにアクセス
- エディタコアの`ICodeEditor`インターフェースに依存
