# 機能設計書：参照検索（Find All References）

## 1. 機能概要

### 1.1 機能の目的
参照検索機能は、シンボル（変数、関数、クラス等）がコードベース内のどこで使用されているかを検索し、一覧表示する機能である。開発者がシンボルの影響範囲を把握し、リファクタリングや影響分析を効率的に行えるようにすることを目的とする。

### 1.2 機能の範囲
- シンボルの全参照位置の検索
- 参照一覧のツリービュー表示
- 参照位置へのナビゲーション
- 参照のグルーピング（ファイル単位）

### 1.3 関連画面
- エディタメインビュー
- References View（サイドバー）
- ピークビュー（インライン表示）

## 2. 機能要件

### 2.1 ユーザーストーリー
- 開発者として、シンボル上でShift+F12を押すことで、全参照をピークビューで確認したい
- 開発者として、参照一覧をサイドバーで常時表示し、効率的にナビゲートしたい
- 開発者として、参照をファイル単位でグループ化して確認したい

### 2.2 入力仕様
| 項目 | 説明 |
|------|------|
| カーソル位置 | エディタ内のPosition（行番号、列番号） |
| モデル | 現在開いているテキストモデル（ITextModel） |
| includeDeclaration | 定義自体を結果に含めるかのフラグ |

### 2.3 出力仕様
| 項目 | 説明 |
|------|------|
| 参照一覧 | Location[]（参照位置のリスト） |
| グループ化結果 | ファイル単位でグループ化されたツリー構造 |
| プレビュー | 各参照位置のコンテキスト表示 |

### 2.4 処理フロー

```mermaid
sequenceDiagram
    participant User
    participant Editor
    participant ReferencesCommand
    participant ReferenceProvider
    participant ReferencesView

    User->>Editor: Shift+F12押下
    Editor->>ReferencesCommand: findReferences実行
    ReferencesCommand->>ReferenceProvider: provideReferences()
    ReferenceProvider-->>ReferencesCommand: Location[]
    ReferencesCommand->>ReferencesView: 参照データ表示
    ReferencesView->>User: ツリービュー/ピークビュー表示
    User->>ReferencesView: 参照選択
    ReferencesView->>Editor: 該当位置へジャンプ
```

### 2.5 ビジネスルール
1. 参照が見つからない場合はメッセージを表示
2. 参照はファイルパスでグループ化される
3. 現在のファイル内の参照は優先的に表示
4. 検索中はプログレスインジケータを表示

## 3. 画面設計

### 3.1 画面レイアウト
参照検索は2つの表示モードを持つ：
1. **ピークビュー**: エディタ内にインライン表示
2. **References View**: サイドバーにツリー形式で表示

### 3.2 画面要素
| 要素 | 説明 | 操作 |
|------|------|------|
| ファイルノード | 参照を含むファイル名 | クリックで展開/折りたたみ |
| 参照アイテム | 参照位置とコンテキスト | クリックで該当位置へ移動 |
| 検索バー | シンボル名の表示 | 読み取り専用 |

## 4. データ設計

### 4.1 入力データ構造
```typescript
interface ReferenceParams {
    model: ITextModel;
    position: IPosition;
    includeDeclaration: boolean;
    token: CancellationToken;
}
```

### 4.2 出力データ構造
```typescript
// references-view/src/references/model.ts
class FileItem {
    uri: URI;
    references: ReferenceItem[];
}

class ReferenceItem {
    location: Location;
    preview: DocumentHighlight;  // コンテキスト情報
}

class ReferencesModel {
    groups: FileItem[];
    total: number;
}
```

## 5. コードリーディングガイド

### 5.1 推奨読解順序

1. **拡張機能エントリーポイント**
   - `extensions/references-view/src/extension.ts` - 拡張機能の初期化（**18-51行目**）
     - `activate()`関数でReferencesTreeDataProviderを登録

2. **データモデル**
   - `extensions/references-view/src/references/model.ts` - 参照データモデル（**14-156行目**）
     - `ReferencesModel`クラスがファイル単位のグループ化を管理

3. **ツリービュー**
   - `extensions/references-view/src/references/tree.ts` - ツリービューの実装
     - TreeDataProviderインターフェースの実装

4. **コアの参照取得**
   - `src/vs/editor/contrib/gotoSymbol/browser/goToCommands.ts` - 参照検索コマンド
     - `ReferenceAction`クラスがShift+F12の処理を担当

### 5.2 プログラム呼び出し階層図

```
extension.ts
  └── activate()
        └── registerTreeDataProvider()
              └── ReferencesTreeDataProvider
                    ├── model.ts::ReferencesModel
                    │     ├── FileItem[]
                    │     └── ReferenceItem[]
                    └── tree.ts::TreeView
                          └── vscode.window.createTreeView()
```

### 5.3 データフロー図

```
[User Input: Shift+F12]
        ↓
[vscode.commands.executeCommand('references-view.findReferences')]
        ↓
[ReferenceProvider.provideReferences()]
        ↓
[ReferencesModel (グループ化)]
        ↓
[ReferencesTreeDataProvider (ツリー構築)]
        ↓
[TreeView / PeekView (表示)]
```

### 5.4 読解のコツ
- References Viewは組み込み拡張機能として実装されている
- `vscode` APIを使用したTreeView実装パターンを学ぶ良い例
- `model.ts`の`ReferencesModel.create()`で非同期にモデルを構築

### 5.5 関連ファイル一覧

| パス | 種別 | 役割 |
|------|------|------|
| `extensions/references-view/src/extension.ts` | エントリーポイント | 拡張機能の初期化 |
| `extensions/references-view/src/references/model.ts` | モデル | 参照データモデル |
| `extensions/references-view/src/references/tree.ts` | ビュー | ツリービュー実装 |
| `extensions/references-view/src/references/index.ts` | コントローラ | 参照検索制御 |
| `src/vs/editor/contrib/gotoSymbol/browser/goToCommands.ts` | コマンド | 参照検索コマンド |
| `src/vs/editor/contrib/gotoSymbol/browser/peek/referencesWidget.ts` | ウィジェット | ピークビューUI |

## 6. 非機能要件

### 6.1 パフォーマンス
- 大規模コードベースでの検索は非同期で実行
- 検索結果は段階的に表示（ストリーミング）
- キャッシュ機能により同一シンボルの再検索を高速化

### 6.2 エラーハンドリング
- ReferenceProviderが存在しない場合はエラーメッセージを表示
- タイムアウト時は部分的な結果を表示

## 7. 設計上の考慮事項

### 7.1 拡張性
- Language Server Protocol (LSP)のtextDocument/referencesに対応
- カスタムReferenceProviderの追加が可能

### 7.2 依存関係
- VS Code拡張機能API（vscode namespace）
- ILanguageFeaturesService（コア側）
- TreeDataProviderインターフェース
