# 機能設計書：リネーム（Rename Symbol）

## 1. 機能概要

### 1.1 機能の目的
リネーム機能は、シンボル（変数、関数、クラス等）の名前を一括で変更する機能である。コードベース全体で一貫性のある名前変更を行い、手動での名前変更によるエラーを防止することを目的とする。

### 1.2 機能の範囲
- シンボル名の一括変更
- 変更前のプレビュー表示
- 元に戻す（Undo）のサポート
- ファイルを跨いだ名前変更

### 1.3 関連画面
- エディタメインビュー
- リネーム入力ボックス
- 変更プレビューパネル

## 2. 機能要件

### 2.1 ユーザーストーリー
- 開発者として、F2キーでシンボル名を変更したい
- 開発者として、変更内容を事前にプレビューしたい
- 開発者として、変更をワンアクションで取り消したい

### 2.2 入力仕様
| 項目 | 説明 |
|------|------|
| カーソル位置 | エディタ内のPosition（行番号、列番号） |
| 新しい名前 | 変更後のシンボル名（文字列） |
| モデル | 現在開いているテキストモデル（ITextModel） |

### 2.3 出力仕様
| 項目 | 説明 |
|------|------|
| WorkspaceEdit | 変更するファイルと編集内容のリスト |
| プレビュー | 変更箇所のハイライト表示 |
| 適用結果 | 変更されたファイル数と参照数 |

### 2.4 処理フロー

```mermaid
sequenceDiagram
    participant User
    participant Editor
    participant RenameController
    participant RenameProvider
    participant WorkspaceEdit

    User->>Editor: F2キー押下
    Editor->>RenameController: rename()
    RenameController->>RenameProvider: prepareRename()
    RenameProvider-->>RenameController: 現在のシンボル名と範囲
    RenameController->>User: リネーム入力ボックス表示
    User->>RenameController: 新しい名前を入力
    RenameController->>RenameProvider: provideRenameEdits()
    RenameProvider-->>RenameController: WorkspaceEdit
    RenameController->>WorkspaceEdit: 変更適用
    WorkspaceEdit-->>Editor: ファイル更新
```

### 2.5 ビジネスルール
1. 新しい名前が空の場合はリネームを実行しない
2. 新しい名前が現在の名前と同じ場合はリネームを実行しない
3. 無効な識別子名の場合はエラーを表示
4. 複数ファイルにまたがる変更は一つのUndoグループとして扱う

## 3. 画面設計

### 3.1 画面レイアウト
リネーム入力ボックスはシンボル位置にインライン表示される。

### 3.2 画面要素
| 要素 | 説明 | 操作 |
|------|------|------|
| リネーム入力ボックス | 新しい名前を入力するテキストフィールド | 入力、Enter確定、Escキャンセル |
| プレビューハイライト | 変更される参照箇所のハイライト | 自動表示 |
| エラーメッセージ | 無効な名前の場合のエラー | 自動表示 |

## 4. データ設計

### 4.1 入力データ構造
```typescript
interface RenameParams {
    model: ITextModel;
    position: IPosition;
    newName: string;
    token: CancellationToken;
}

interface PrepareRenameResult {
    range: IRange;
    text: string;  // 現在のシンボル名
}
```

### 4.2 出力データ構造
```typescript
interface WorkspaceEdit {
    edits: ResourceEdit[];
}

interface ResourceTextEdit {
    resource: URI;
    textEdit: TextEdit;
    versionId?: number;
}

interface TextEdit {
    range: IRange;
    text: string;
}
```

## 5. コードリーディングガイド

### 5.1 推奨読解順序

1. **データ構造の理解**
   - `src/vs/editor/common/languages.ts` - WorkspaceEdit、RenameProvider等の型定義

2. **コントローラ層**
   - `src/vs/editor/contrib/rename/browser/rename.ts` - リネーム機能の実装（**72-392行目**）
     - `RenameController`クラスがリネーム処理全体を制御
     - **130-180行目**: `run()`メソッドでリネームフロー開始
     - **200-250行目**: 入力ボックスの表示と入力処理
     - **300-350行目**: WorkspaceEditの適用

3. **入力ウィジェット**
   - `src/vs/editor/contrib/rename/browser/renameWidget.ts` - リネーム入力UIの実装
     - `RenameWidget`クラスがインライン入力ボックスを管理

### 5.2 プログラム呼び出し階層図

```
rename.ts
  └── RenameController
        ├── prepareRename()
        │     └── RenameProvider.prepareRename()
        ├── RenameWidget.getInput()
        │     └── ユーザー入力待ち
        └── provideRenameEdits()
              └── RenameProvider.provideRenameEdits()
                    └── BulkEditService.apply()
```

### 5.3 データフロー図

```
[F2 Key Press]
      ↓
[prepareRename() - 現在のシンボル名取得]
      ↓
[RenameWidget - 入力ボックス表示]
      ↓
[provideRenameEdits() - 編集内容生成]
      ↓
[WorkspaceEdit - 変更適用]
      ↓
[UndoRedoService - 履歴登録]
```

### 5.4 読解のコツ
- `RenameController`は`IEditorContribution`を実装したエディタ貢献
- `prepareRename`は任意だが、リネーム可能かどうかの事前チェックに使用
- `BulkEditService`が複数ファイルにまたがる編集を一括適用
- `UndoRedoGroup`を使用して複数編集を1つのUndo操作にまとめる

### 5.5 関連ファイル一覧

| パス | 種別 | 役割 |
|------|------|------|
| `src/vs/editor/contrib/rename/browser/rename.ts` | コントローラ | リネーム機能の実装 |
| `src/vs/editor/contrib/rename/browser/renameWidget.ts` | ウィジェット | 入力ボックスUI |
| `src/vs/editor/common/languages.ts` | 型定義 | RenameProvider等の型 |
| `src/vs/workbench/services/bulkEdit/browser/bulkEditService.ts` | サービス | 一括編集サービス |
| `src/vs/platform/undoRedo/common/undoRedo.ts` | サービス | Undo/Redoサービス |

## 6. 非機能要件

### 6.1 パフォーマンス
- 大規模コードベースでも応答性を維持
- 非同期処理でUIをブロックしない
- プログレスインジケータの表示

### 6.2 エラーハンドリング
- 無効な識別子名の検出とエラーメッセージ表示
- 書き込み権限がないファイルの検出
- ネットワークエラー時のリトライ

## 7. 設計上の考慮事項

### 7.1 拡張性
- Language Server Protocol (LSP)のtextDocument/renameに対応
- カスタムRenameProviderの追加が可能

### 7.2 依存関係
- `ILanguageFeaturesService`を通じてRenameProviderにアクセス
- `IBulkEditService`で複数ファイルの一括編集
- `IUndoRedoService`でUndo/Redo管理
