# 機能設計書：コードレンズ（CodeLens）

## 1. 機能概要

### 1.1 機能の目的
コードレンズ機能は、エディタ内でコードの上部にインラインでアクション可能な情報を表示する機能である。参照数、テスト実行ボタン、Git履歴などのコンテキスト情報を表示し、開発者が追加のナビゲーションなしで情報にアクセスできるようにすることを目的とする。

### 1.2 機能の範囲
- コード上部へのインライン情報表示
- クリック可能なアクションリンク
- 言語拡張機能によるカスタムCodeLensの提供
- 遅延ロードとキャッシング

### 1.3 関連画面
- エディタメインビュー（コード行の上部）

## 2. 機能要件

### 2.1 ユーザーストーリー
- 開発者として、関数の上に参照数を表示して影響範囲を把握したい
- 開発者として、テストメソッドの上に「Run Test」ボタンを表示して素早くテストを実行したい
- 開発者として、Git Blameの情報をコード上で確認したい

### 2.2 入力仕様
| 項目 | 説明 |
|------|------|
| ドキュメント | 現在開いているテキストモデル（ITextModel） |
| 可視範囲 | ビューポート内の行範囲 |
| トリガー | スクロール、編集、フォーカス変更 |

### 2.3 出力仕様
| 項目 | 説明 |
|------|------|
| CodeLens[] | 表示位置とコマンドのリスト |
| デコレーション | エディタ上のインライン表示 |

### 2.4 処理フロー

```mermaid
sequenceDiagram
    participant Editor
    participant CodeLensController
    participant CodeLensProvider
    participant Decoration

    Editor->>CodeLensController: ドキュメント変更/スクロール
    CodeLensController->>CodeLensProvider: provideCodeLenses()
    CodeLensProvider-->>CodeLensController: CodeLens[]
    CodeLensController->>CodeLensController: CodeLens解決（resolveCodeLens）
    CodeLensController->>Decoration: デコレーション更新
    Decoration-->>Editor: インライン表示

    Note over Editor,Decoration: クリック時
    Editor->>CodeLensController: CodeLensクリック
    CodeLensController->>Editor: コマンド実行
```

### 2.5 ビジネスルール
1. 可視範囲外のCodeLensは遅延ロード
2. CodeLensの解決（resolve）は必要になるまで遅延
3. 編集時はCodeLensを一時的に非表示にして再計算
4. 複数のCodeLensProviderの結果をマージして表示

## 3. 画面設計

### 3.1 画面レイアウト
CodeLensはコード行の上部に小さなテキストとして表示される。

### 3.2 画面要素
| 要素 | 説明 | 操作 |
|------|------|------|
| CodeLensテキスト | 情報表示（例：「2 references」） | クリックでコマンド実行 |
| 区切り文字 | 複数CodeLens間の「|」 | 表示のみ |

## 4. データ設計

### 4.1 入力データ構造
```typescript
interface CodeLensProviderParams {
    model: ITextModel;
    token: CancellationToken;
}
```

### 4.2 出力データ構造
```typescript
interface CodeLens {
    range: IRange;           // 表示位置
    command?: Command;       // クリック時のコマンド
}

interface Command {
    id: string;              // コマンドID
    title: string;           // 表示テキスト
    tooltip?: string;        // ツールチップ
    arguments?: any[];       // コマンド引数
}
```

## 5. コードリーディングガイド

### 5.1 推奨読解順序

1. **データ構造の理解**
   - `src/vs/editor/common/languages.ts` - CodeLens、Command等の型定義

2. **コントローラ層**
   - `src/vs/editor/contrib/codelens/browser/codelensController.ts` - CodeLens機能の実装（**47-400行目**）
     - `CodeLensContribution`クラスがCodeLens処理全体を制御
     - **100-150行目**: `_scheduleUpdate()`でデバウンス付き更新
     - **180-250行目**: `_onModelChange()`でモデル変更時の処理
     - **280-350行目**: CodeLensの取得と解決

3. **ウィジェット層**
   - `src/vs/editor/contrib/codelens/browser/codelensWidget.ts` - CodeLens表示UIの実装
     - `CodeLensWidget`クラスがインライン表示を管理

### 5.2 プログラム呼び出し階層図

```
codelensController.ts
  └── CodeLensContribution
        ├── _scheduleUpdate()
        │     └── RunOnceScheduler
        ├── _getCodeLenses()
        │     └── CodeLensProvider.provideCodeLenses()
        ├── _resolveCodeLenses()
        │     └── CodeLensProvider.resolveCodeLens()
        └── _renderCodeLenses()
              └── codelensWidget.ts::CodeLensWidget
```

### 5.3 データフロー図

```
[Editor Event (scroll/edit)]
        ↓
[_scheduleUpdate() - デバウンス]
        ↓
[provideCodeLenses() - 複数プロバイダから取得]
        ↓
[CodeLens[] - マージ]
        ↓
[resolveCodeLens() - 遅延解決]
        ↓
[CodeLensWidget - レンダリング]
        ↓
[Editor Display]
```

### 5.4 読解のコツ
- `CodeLensContribution`は`IEditorContribution`を実装
- `RunOnceScheduler`でデバウンスを実現し、頻繁な更新を抑制
- `resolveCodeLens`は表示時に初めて呼び出される（遅延解決）
- `_lenses`配列でCodeLensの状態を管理

### 5.5 関連ファイル一覧

| パス | 種別 | 役割 |
|------|------|------|
| `src/vs/editor/contrib/codelens/browser/codelensController.ts` | コントローラ | CodeLens機能の実装 |
| `src/vs/editor/contrib/codelens/browser/codelensWidget.ts` | ウィジェット | CodeLens表示UI |
| `src/vs/editor/common/languages.ts` | 型定義 | CodeLens、Command等の型 |
| `src/vs/editor/common/services/languageFeatures.ts` | サービス | CodeLensProviderの登録 |

## 6. 非機能要件

### 6.1 パフォーマンス
- 可視範囲のみを処理して負荷を軽減
- デバウンスで更新頻度を制御
- 遅延解決でメモリ使用量を削減

### 6.2 エラーハンドリング
- プロバイダエラーは個別にキャッチして他のプロバイダに影響させない
- 解決エラー時はCodeLensを非表示にする

## 7. 設計上の考慮事項

### 7.1 拡張性
- Language Server Protocol (LSP)のtextDocument/codeLensに対応
- 複数のCodeLensProviderを同時にサポート

### 7.2 依存関係
- `ILanguageFeaturesService`を通じてCodeLensProviderにアクセス
- `ICommandService`でコマンド実行
- `IConfigurationService`で設定（有効/無効）を管理
