# 機能設計書：インレイヒント（Inlay Hints）

## 1. 機能概要

### 1.1 機能の目的
インレイヒント機能は、コード内にインラインで追加情報を表示する機能である。型推論結果、パラメータ名、関数の戻り値型などを表示し、コードの可読性と理解を向上させることを目的とする。

### 1.2 機能の範囲
- 型推論結果のインライン表示
- パラメータ名のインライン表示
- クリック可能なヒント（定義へ移動等）
- 表示/非表示の切り替え

### 1.3 関連画面
- エディタメインビュー（コード内インライン表示）

## 2. 機能要件

### 2.1 ユーザーストーリー
- 開発者として、変数の推論された型を確認したい
- 開発者として、関数呼び出し時のパラメータ名を確認したい
- 開発者として、ヒントをクリックして型定義にジャンプしたい

### 2.2 入力仕様
| 項目 | 説明 |
|------|------|
| ドキュメント | 現在開いているテキストモデル（ITextModel） |
| 可視範囲 | ビューポート内の行範囲 |
| 設定 | enabled、fontSize、fontFamily |

### 2.3 出力仕様
| 項目 | 説明 |
|------|------|
| InlayHint[] | 表示位置とテキストのリスト |
| デコレーション | エディタ上のインライン表示 |

### 2.4 処理フロー

```mermaid
sequenceDiagram
    participant Editor
    participant InlayHintsController
    participant InlayHintsProvider
    participant InlayHintsCache

    Editor->>InlayHintsController: ドキュメント変更/スクロール
    InlayHintsController->>InlayHintsCache: キャッシュ確認
    alt キャッシュあり
        InlayHintsCache-->>InlayHintsController: キャッシュデータ
    else キャッシュなし
        InlayHintsController->>InlayHintsProvider: provideInlayHints()
        InlayHintsProvider-->>InlayHintsController: InlayHint[]
        InlayHintsController->>InlayHintsCache: キャッシュ保存
    end
    InlayHintsController->>Editor: デコレーション更新
```

### 2.5 ビジネスルール
1. 設定で`editor.inlayHints.enabled`がoffの場合は表示しない
2. ヒントの種類（type、parameter）ごとに表示/非表示を制御可能
3. ヒントにはpadding（左右の余白）を設定可能
4. 最大表示数を制限してパフォーマンスを確保

## 3. 画面設計

### 3.1 画面レイアウト
インレイヒントはコード内の該当位置にインライン表示される。

### 3.2 画面要素
| 要素 | 説明 | 操作 |
|------|------|------|
| 型ヒント | 変数や関数の型情報 | クリックで型定義へ移動 |
| パラメータヒント | 引数名の表示 | 表示のみ |
| 背景色 | ヒント種別に応じた背景色 | 自動適用 |

## 4. データ設計

### 4.1 入力データ構造
```typescript
interface InlayHintParams {
    model: ITextModel;
    range: IRange;
    token: CancellationToken;
}
```

### 4.2 出力データ構造
```typescript
interface InlayHint {
    position: IPosition;        // 表示位置
    label: string | InlayHintLabelPart[];  // ラベル
    kind?: InlayHintKind;       // Type or Parameter
    paddingLeft?: boolean;      // 左余白
    paddingRight?: boolean;     // 右余白
    tooltip?: string;           // ツールチップ
    textEdits?: TextEdit[];     // ダブルクリック時の編集
}

interface InlayHintLabelPart {
    label: string;
    command?: Command;          // クリック時のコマンド
    location?: Location;        // クリック時のジャンプ先
}

enum InlayHintKind {
    Type = 1,
    Parameter = 2
}
```

## 5. コードリーディングガイド

### 5.1 推奨読解順序

1. **データ構造の理解**
   - `src/vs/editor/common/languages.ts` - InlayHint、InlayHintKind等の型定義

2. **コントローラ層**
   - `src/vs/editor/contrib/inlayHints/browser/inlayHintsController.ts` - インレイヒント機能の実装（**129-815行目**）
     - `InlayHintsController`クラスがインレイヒント処理全体を制御
     - **43-66行目**: `InlayHintsCache`でキャッシュ管理
     - **150-169行目**: コンストラクタでイベントハンドラ登録
     - **179-312行目**: `_update()`メソッドで更新処理
     - **314-368行目**: `_installLinkGesture()`でクリック処理

3. **ヒント取得**
   - `src/vs/editor/contrib/inlayHints/browser/inlayHints.ts` - ヒント取得ロジック
     - `InlayHintsFragments.create()`で複数プロバイダから取得

### 5.2 プログラム呼び出し階層図

```
inlayHintsController.ts
  └── InlayHintsController
        ├── _update()
        │     ├── InlayHintsCache.get()
        │     └── InlayHintsFragments.create()
        │           └── InlayHintsProvider.provideInlayHints()
        ├── _updateHintsDecorators()
        │     └── エディタデコレーション更新
        └── _installLinkGesture()
              └── ClickLinkGesture
                    └── goToDefinitionWithLocation()
```

### 5.3 データフロー図

```
[Editor Event (scroll/edit)]
        ↓
[_update() - スケジューラ]
        ↓
[InlayHintsCache - キャッシュ確認]
        ↓
[InlayHintsFragments.create() - プロバイダ呼び出し]
        ↓
[InlayHint[] - 取得結果]
        ↓
[_updateHintsDecorators() - デコレーション生成]
        ↓
[Editor Display - InjectedText表示]
```

### 5.4 読解のコツ
- `InlayHintsController`は`IEditorContribution`を実装
- `LRUCache`を使用してヒントをキャッシュ（最大50エントリ）
- `RenderMode`で表示/非表示を制御（Normal/Invisible）
- デコレーションは`InjectedTextOptions`を使用してテキスト内に挿入
- `ClickLinkGesture`でCtrl+クリックを検出して定義へ移動

### 5.5 関連ファイル一覧

| パス | 種別 | 役割 |
|------|------|------|
| `src/vs/editor/contrib/inlayHints/browser/inlayHintsController.ts` | コントローラ | インレイヒント機能の実装 |
| `src/vs/editor/contrib/inlayHints/browser/inlayHints.ts` | サービス | ヒント取得ロジック |
| `src/vs/editor/contrib/inlayHints/browser/inlayHintsLocations.ts` | ユーティリティ | ジャンプ処理 |
| `src/vs/editor/common/languages.ts` | 型定義 | InlayHint等の型 |
| `src/vs/editor/contrib/gotoSymbol/browser/link/clickLinkGesture.ts` | ユーティリティ | クリックジェスチャ検出 |

## 6. 非機能要件

### 6.1 パフォーマンス
- 可視範囲+30行のバッファで先読み
- LRUキャッシュで重複取得を防止
- 最大1500デコレーションの制限
- デバウンスで更新頻度を制御

### 6.2 エラーハンドリング
- プロバイダエラーは個別にキャッチ
- キャンセル時は部分結果を破棄

## 7. 設計上の考慮事項

### 7.1 拡張性
- Language Server Protocol (LSP)のtextDocument/inlayHintに対応
- カスタムInlayHintsProviderの追加が可能

### 7.2 依存関係
- `ILanguageFeaturesService`を通じてInlayHintsProviderにアクセス
- `ICommandService`でクリック時のコマンド実行
- `DynamicCssRules`で動的スタイル生成
